/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteData;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClientRendererJ3D;
import visad.cluster.RemoteClientFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeField;
import visad.cluster.RemoteNodeFieldImpl;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.data.vis5d.Vis5DForm;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.ss.SSCellData;

public class TestSSCluster
extends FancySSCell
implements ActionListener {
    private RemoteDataReferenceImpl remote_ref = null;
    int[] res = new int[]{1, 1, 1, 1};

    public TestSSCluster(String name, Frame parent) throws VisADException, RemoteException {
        super(name, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addData(int id, Data data, ConstantMap[] cmaps, String source, int type, boolean notify) throws VisADException, RemoteException {
        SSCellData cellData;
        DataReferenceImpl ref = new DataReferenceImpl(this.Name);
        if (data instanceof RemoteData) {
            this.remote_ref = new RemoteDataReferenceImpl(ref);
            this.remote_ref.setData(data);
        } else {
            ref.setData(data);
        }
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.addReferenceImpl(id, ref, cmaps, source, type, notify, true);
        }
        return cellData.getVariableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSCellData addReferenceImpl(int id, DataReferenceImpl ref, ConstantMap[] cmaps, String source, int type, boolean notify, boolean checkErrors) throws VisADException, RemoteException {
        if (id == 0) {
            id = this.getFirstFreeId();
        }
        if (ref == null) {
            ref = new DataReferenceImpl(this.Name);
        }
        SSCellData cellData = new SSCellData(id, this, ref, cmaps, source, type, checkErrors);
        this.CellData.add(cellData);
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.addReference(ref, cmaps);
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteRef = cellData.getRemoteReference();
                int len = this.Servers.size();
                int i = 0;
                while (i < len) {
                    RemoteServerImpl rs = (RemoteServerImpl)this.Servers.elementAt(i);
                    rs.addDataReference(remoteRef);
                    ++i;
                }
            }
        }
        return cellData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaps(ScalarMap[] maps) throws VisADException, RemoteException {
        if (maps == null) {
            return;
        }
        VisADException vexc = null;
        RemoteException rexc = null;
        if (!this.IsRemote) {
            int i;
            ConstantMap[][] cmaps;
            DataReference[] dr;
            Vector vector = this.CellData;
            synchronized (vector) {
                int len = this.CellData.size();
                dr = new DataReference[len];
                cmaps = new ConstantMap[len][];
                i = 0;
                while (i < len) {
                    SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                    dr[i] = cellData.getReference();
                    cmaps[i] = cellData.getConstantMaps();
                    ++i;
                }
            }
            String save = this.getPartialSaveString();
            this.VDisplay.disableAction();
            this.clearMaps();
            i = 0;
            while (i < maps.length) {
                if (maps[i] != null) {
                    try {
                        this.VDisplay.addMap(maps[i]);
                    }
                    catch (VisADException exc) {
                        vexc = exc;
                    }
                    catch (RemoteException exc) {
                        rexc = exc;
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dr.length) {
                boolean ok;
                block21: {
                    ok = false;
                    Data data = dr[i2].getData();
                    if (data != null && BasicSSCell.Possible3D) {
                        MathType type = data.getType();
                        try {
                            ok = ImageRendererJ3D.isRendererUsable(type, maps);
                        }
                        catch (VisADException exc) {
                            if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) break block21;
                            exc.printStackTrace();
                        }
                    }
                }
                if (ok && this.Dim != 2) {
                    this.VDisplay.addReferences((DataRenderer)new ImageRendererJ3D(), dr[i2], cmaps[i2]);
                } else if (this.remote_ref == null) {
                    this.VDisplay.addReference(dr[i2], cmaps[i2]);
                } else {
                    this.RemoteVDisplay.addReference(this.remote_ref, cmaps[i2]);
                }
                ++i2;
            }
            this.VDisplay.enableAction();
            this.setPartialSaveString(save, true);
        }
        this.HasMappings = true;
        if (vexc != null) {
            throw vexc;
        }
        if (rexc != null) {
            throw rexc;
        }
    }

    public synchronized boolean constructDisplay() {
        boolean success = true;
        DisplayImpl newDisplay = this.VDisplay;
        RemoteDisplay rmtDisplay = this.RemoteVDisplay;
        if (this.IsSlave) {
            try {
                newDisplay = new DisplayImplJ2D("DUMMY");
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
            catch (RemoteException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
        } else if (!BasicSSCell.CanDo3D && this.Dim != 2) {
            success = false;
        } else {
            try {
                TwoDDisplayRendererJ3D tdr;
                if (this.IsRemote) {
                    if (this.Dim == 1) {
                        newDisplay = new DisplayImplJ3D(rmtDisplay);
                    } else if (this.Dim == 2) {
                        newDisplay = new DisplayImplJ2D(rmtDisplay);
                    } else {
                        tdr = new TwoDDisplayRendererJ3D();
                        newDisplay = new DisplayImplJ3D(rmtDisplay, (DisplayRendererJ3D)tdr);
                    }
                } else {
                    if (this.Dim == 1) {
                        ClientDisplayRendererJ3D cdr = new ClientDisplayRendererJ3D(100000L);
                        newDisplay = new DisplayImplJ3D(this.Name, (DisplayRendererJ3D)cdr);
                    } else if (this.Dim == 2) {
                        newDisplay = new DisplayImplJ2D(this.Name);
                    } else {
                        tdr = new TwoDDisplayRendererJ3D();
                        newDisplay = new DisplayImplJ3D(this.Name, (DisplayRendererJ3D)tdr);
                    }
                    rmtDisplay = new RemoteDisplayImpl(newDisplay);
                }
            }
            catch (NoClassDefFoundError err) {
                if (BasicSSCell.DEBUG) {
                    err.printStackTrace();
                }
                success = false;
            }
            catch (UnsatisfiedLinkError err) {
                if (BasicSSCell.DEBUG) {
                    err.printStackTrace();
                }
                success = false;
            }
            catch (Exception exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
        }
        if (success) {
            block32: {
                if (this.VDisplay != null) {
                    try {
                        this.VDisplay.destroy();
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!BasicSSCell.DEBUG) break block32;
                        exc.printStackTrace();
                    }
                }
            }
            this.VDisplay = newDisplay;
            this.RemoteVDisplay = rmtDisplay;
        }
        return success;
    }

    public static void main(String[] args) throws RemoteException, VisADException, IOException {
        int node_divide = 2;
        int number_of_nodes = node_divide * node_divide;
        RemoteNodeField[] node_v5ds = new RemoteNodeField[number_of_nodes];
        if (args == null || args.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestSSCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e2) {
            System.out.println("usage: 'java visad.cluster.TestSSCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        if (id < 0 || id > number_of_nodes) {
            System.out.println("usage: 'java visad.cluster.TestSSCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        boolean client = id == 0;
        Vis5DForm v5d_form = new Vis5DForm();
        FieldImpl v5d = (FieldImpl)v5d_form.open(args[1]);
        if (v5d == null) {
            System.out.println("cannot open " + args[1]);
            return;
        }
        FunctionType v5d_type = (FunctionType)v5d.getType();
        Set time_set = v5d.getDomainSet();
        int time_length = time_set.getLength();
        MathType v5d_range_type = v5d_type.getRange();
        DataImpl v5d_range0 = (DataImpl)v5d.getSample(0);
        FunctionType grid_type = null;
        FunctionType grid_type2 = null;
        FlatField grid0 = null;
        if (v5d_range_type instanceof FunctionType) {
            grid_type = (FunctionType)v5d_range_type;
            grid_type2 = null;
            grid0 = (FlatField)v5d_range0;
        } else {
            grid_type = (FunctionType)((TupleType)v5d_range_type).getComponent(0);
            grid_type2 = (FunctionType)((TupleType)v5d_range_type).getComponent(1);
            grid0 = (FlatField)((Tuple)v5d_range0).getComponent(0);
        }
        Gridded3DSet domain_set = (Gridded3DSet)grid0.getDomainSet();
        Gridded3DSet ps = TestSSCluster.makePS(domain_set, node_divide);
        if (!client) {
            System.out.println("v5d_type = " + v5d_type);
            RealTupleType domain_type = grid_type.getDomain();
            RealTupleType time_tuple = v5d_type.getDomain();
            RealType time = (RealType)time_tuple.getComponent(0);
            RealType x = (RealType)domain_type.getComponent(0);
            RealType y = (RealType)domain_type.getComponent(1);
            RealType z = (RealType)domain_type.getComponent(2);
            RealType val = (RealType)grid_type.getRange();
            RealType val2 = grid_type2 == null ? null : (RealType)grid_type2.getRange();
            float[][] samples = domain_set.getSamples(false);
            int x_len = domain_set.getLength(0);
            int y_len = domain_set.getLength(1);
            int z_len = domain_set.getLength(2);
            int len = domain_set.getLength();
            Gridded3DSet[] subsets = new Gridded3DSet[number_of_nodes];
            int k = id - 1;
            int ik = k % node_divide;
            int ig = ik * x_len / node_divide;
            int igp = (ik + 1) * x_len / node_divide;
            if (ik == node_divide - 1) {
                igp = x_len;
            }
            int jk = k / node_divide;
            int jg = jk * y_len / node_divide;
            int jgp = (jk + 1) * y_len / node_divide;
            if (jk == node_divide - 1) {
                jgp = y_len;
            }
            int sub_x_len = igp - ig;
            int sub_y_len = jgp - jg;
            int sub_len = sub_x_len * sub_y_len * z_len;
            float[][] sub_samples = new float[3][sub_len];
            int i = 0;
            while (i < sub_x_len) {
                int j = 0;
                while (j < sub_y_len) {
                    int m = 0;
                    while (m < z_len) {
                        int a2 = i + sub_x_len * (j + sub_y_len * m);
                        int b2 = i + ig + x_len * (j + jg + y_len * m);
                        sub_samples[0][a2] = samples[0][b2];
                        sub_samples[1][a2] = samples[1][b2];
                        sub_samples[2][a2] = samples[2][b2];
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
            subsets[k] = new Gridded3DSet((MathType)domain_type, sub_samples, sub_x_len, sub_y_len, z_len, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
            Data[] subgrids = new RemoteNodeDataImpl[time_length];
            int i2 = 0;
            while (i2 < time_length) {
                DataImpl v5d_sample = (DataImpl)v5d.getSample(i2);
                if (v5d_sample instanceof FlatField) {
                    FlatField grid = (FlatField)v5d_sample;
                    FlatField subgrid = (FlatField)grid.resample(subsets[k]);
                    subgrids[i2] = new RemoteNodePartitionedFieldImpl(subgrid);
                } else {
                    Tuple v5d_tuple = (Tuple)v5d_sample;
                    int ngrids = v5d_tuple.getDimension();
                    RemoteNodeDataImpl[] subsubgrids = new RemoteNodeDataImpl[ngrids];
                    Field[] combinegrids = new FlatField[ngrids];
                    int j = 0;
                    while (j < ngrids) {
                        FlatField grid = (FlatField)v5d_tuple.getComponent(j);
                        combinegrids[j] = (FlatField)grid.resample(subsets[k]);
                        ++j;
                    }
                    FlatField subgrid = (FlatField)FieldImpl.combine(combinegrids);
                    subgrids[i2] = new RemoteNodePartitionedFieldImpl(subgrid);
                }
                ++i2;
            }
            FunctionType new_v5d_type = new FunctionType(time_tuple, subgrids[0].getType());
            node_v5ds[k] = new RemoteNodeFieldImpl(new_v5d_type, time_set);
            node_v5ds[k].setSamples(subgrids, false);
            int kk = id - 1;
            String url = "///TestVis5DCluster" + kk;
            try {
                Naming.rebind(url, node_v5ds[kk]);
            }
            catch (Exception e3) {
                System.out.println("rebind " + kk + " " + e3);
                return;
            }
            DisplayImplJ2D display = new DisplayImplJ2D("dummy");
            System.out.println("data ready as " + new_v5d_type);
            return;
        }
        int k = 0;
        while (k < number_of_nodes) {
            String url = "///TestVis5DCluster" + k;
            try {
                node_v5ds[k] = (RemoteNodeField)Naming.lookup(url);
            }
            catch (Exception e4) {
                System.out.println("lookup " + k + " " + e4);
                return;
            }
            ++k;
        }
        v5d_type = (FunctionType)node_v5ds[0].getType();
        System.out.println("data type = " + v5d_type);
        time_set = node_v5ds[0].getDomainSet();
        RemoteClientFieldImpl client_v5d = new RemoteClientFieldImpl(v5d_type, time_set);
        RemoteClusterData[] table = new RemoteClusterData[number_of_nodes + 1];
        int i = 0;
        while (i < number_of_nodes) {
            table[i] = node_v5ds[i];
            ++i;
        }
        table[number_of_nodes] = client_v5d;
        int i3 = 0;
        while (i3 < table.length) {
            table[i3].setupClusterData(ps, table);
            ++i3;
        }
        JFrame frame = new JFrame("test ClientRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        TestSSCluster ss = new TestSSCluster("TestSSCluster", frame);
        ss.addData(client_v5d);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        frame.getContentPane().add(panel);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        JButton maps = new JButton("Maps");
        maps.addActionListener(ss);
        maps.setActionCommand("map");
        bpanel.add(maps);
        JButton show = new JButton("Widgets");
        show.addActionListener(ss);
        show.setActionCommand("widgets");
        bpanel.add(show);
        JButton res1 = new JButton("Res 1");
        res1.addActionListener(ss);
        res1.setActionCommand("res1");
        bpanel.add(res1);
        JButton res2 = new JButton("Res 2");
        res2.addActionListener(ss);
        res2.setActionCommand("res2");
        bpanel.add(res2);
        JButton res3 = new JButton("Res 3");
        res3.addActionListener(ss);
        res3.setActionCommand("res3");
        bpanel.add(res3);
        JButton res4 = new JButton("Res 4");
        res4.addActionListener(ss);
        res4.setActionCommand("res4");
        bpanel.add(res4);
        panel.add(ss);
        panel.add(bpanel);
        frame.setSize(600, 600);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        if (cmd.equals("map")) {
            this.hideWidgetFrame();
            this.addMapDialog();
        } else if (cmd.equals("widgets")) {
            this.showWidgetFrame();
        } else if (cmd.equals("res1")) {
            this.flipRes(0);
        } else if (cmd.equals("res2")) {
            this.flipRes(1);
        } else if (cmd.equals("res3")) {
            this.flipRes(2);
        } else if (cmd.equals("res4")) {
            this.flipRes(3);
        }
    }

    private void flipRes(int k) {
        this.res[k] = 5 - this.res[k];
        DisplayImpl display = this.getDisplay();
        Vector renderers = display.getRendererVector();
        int i = 0;
        while (i < renderers.size()) {
            DataRenderer renderer = (DataRenderer)renderers.elementAt(i);
            if (renderer instanceof ClientRendererJ3D) {
                ((ClientRendererJ3D)renderer).setResolutions(this.res);
            }
            ++i;
        }
        display.reDisplayAll();
    }

    private static Gridded3DSet makePS(Gridded3DSet domain_set, int node_divide) throws VisADException {
        int number_of_nodes = node_divide * node_divide;
        int x_len = domain_set.getLength(0);
        int y_len = domain_set.getLength(1);
        int z_len = domain_set.getLength(2);
        int len = domain_set.getLength();
        float[][] samples = domain_set.getSamples(false);
        float[][] ps_samples = new float[3][number_of_nodes];
        int i = 0;
        while (i < node_divide) {
            int ie = i * (x_len - 1) / (node_divide - 1);
            int j = 0;
            while (j < node_divide) {
                int je = j * (y_len - 1) / (node_divide - 1);
                int k = i + node_divide * j;
                int ke = ie + x_len * (je + y_len * (z_len / 2));
                ps_samples[0][k] = samples[0][ke];
                ps_samples[1][k] = samples[1][ke];
                ps_samples[2][k] = samples[2][ke];
                ++j;
            }
            ++i;
        }
        Gridded3DSet ps = new Gridded3DSet(domain_set.getType(), ps_samples, node_divide, node_divide, 1, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
        return ps;
    }
}

