/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.RemoteClientFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeField;
import visad.cluster.RemoteNodeFieldImpl;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.data.vis5d.Vis5DForm;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;

public class TestVis5DCluster {
    public static void main(String[] args) throws RemoteException, VisADException, IOException {
        int node_divide = 2;
        int number_of_nodes = node_divide * node_divide;
        RemoteNodeField[] node_v5ds = new RemoteNodeField[number_of_nodes];
        if (args == null || args.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestVis5DCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e2) {
            System.out.println("usage: 'java visad.cluster.TestVis5DCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        if (id < 0 || id > number_of_nodes) {
            System.out.println("usage: 'java visad.cluster.TestVis5DCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        boolean client = id == 0;
        Vis5DForm v5d_form = new Vis5DForm();
        FieldImpl v5d = (FieldImpl)v5d_form.open(args[1]);
        if (v5d == null) {
            System.out.println("cannot open " + args[1]);
            return;
        }
        FunctionType v5d_type = (FunctionType)v5d.getType();
        Set time_set = v5d.getDomainSet();
        int time_length = time_set.getLength();
        MathType v5d_range_type = v5d_type.getRange();
        DataImpl v5d_range0 = (DataImpl)v5d.getSample(0);
        FunctionType grid_type = null;
        FunctionType grid_type2 = null;
        FlatField grid0 = null;
        if (v5d_range_type instanceof FunctionType) {
            grid_type = (FunctionType)v5d_range_type;
            grid_type2 = null;
            grid0 = (FlatField)v5d_range0;
        } else {
            grid_type = (FunctionType)((TupleType)v5d_range_type).getComponent(0);
            grid_type2 = (FunctionType)((TupleType)v5d_range_type).getComponent(1);
            grid0 = (FlatField)((Tuple)v5d_range0).getComponent(0);
        }
        Gridded3DSet domain_set = (Gridded3DSet)grid0.getDomainSet();
        Gridded3DSet ps = TestVis5DCluster.makePS(domain_set, node_divide);
        if (!client) {
            System.out.println("v5d_type = " + v5d_type);
            RealTupleType domain_type = grid_type.getDomain();
            RealTupleType time_tuple = v5d_type.getDomain();
            RealType time = (RealType)time_tuple.getComponent(0);
            RealType x = (RealType)domain_type.getComponent(0);
            RealType y = (RealType)domain_type.getComponent(1);
            RealType z = (RealType)domain_type.getComponent(2);
            RealType val = (RealType)grid_type.getRange();
            RealType val2 = grid_type2 == null ? null : (RealType)grid_type2.getRange();
            float[][] samples = domain_set.getSamples(false);
            int x_len = domain_set.getLength(0);
            int y_len = domain_set.getLength(1);
            int z_len = domain_set.getLength(2);
            int len = domain_set.getLength();
            Gridded3DSet[] subsets = new Gridded3DSet[number_of_nodes];
            int k = id - 1;
            int ik = k % node_divide;
            int ig = ik * x_len / node_divide;
            int igp = (ik + 1) * x_len / node_divide;
            if (ik == node_divide - 1) {
                igp = x_len;
            }
            int jk = k / node_divide;
            int jg = jk * y_len / node_divide;
            int jgp = (jk + 1) * y_len / node_divide;
            if (jk == node_divide - 1) {
                jgp = y_len;
            }
            int sub_x_len = igp - ig;
            int sub_y_len = jgp - jg;
            int sub_len = sub_x_len * sub_y_len * z_len;
            float[][] sub_samples = new float[3][sub_len];
            int i = 0;
            while (i < sub_x_len) {
                int j = 0;
                while (j < sub_y_len) {
                    int m = 0;
                    while (m < z_len) {
                        int a2 = i + sub_x_len * (j + sub_y_len * m);
                        int b2 = i + ig + x_len * (j + jg + y_len * m);
                        sub_samples[0][a2] = samples[0][b2];
                        sub_samples[1][a2] = samples[1][b2];
                        sub_samples[2][a2] = samples[2][b2];
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
            subsets[k] = new Gridded3DSet((MathType)domain_type, sub_samples, sub_x_len, sub_y_len, z_len, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
            Data[] subgrids = new RemoteNodeDataImpl[time_length];
            int i2 = 0;
            while (i2 < time_length) {
                DataImpl v5d_sample = (DataImpl)v5d.getSample(i2);
                if (v5d_sample instanceof FlatField) {
                    FlatField grid = (FlatField)v5d_sample;
                    FlatField subgrid = (FlatField)grid.resample(subsets[k]);
                    subgrids[i2] = new RemoteNodePartitionedFieldImpl(subgrid);
                } else {
                    Tuple v5d_tuple = (Tuple)v5d_sample;
                    int ngrids = v5d_tuple.getDimension();
                    RemoteNodeDataImpl[] subsubgrids = new RemoteNodeDataImpl[ngrids];
                    Field[] combinegrids = new FlatField[ngrids];
                    int j = 0;
                    while (j < ngrids) {
                        FlatField grid = (FlatField)v5d_tuple.getComponent(j);
                        combinegrids[j] = (FlatField)grid.resample(subsets[k]);
                        ++j;
                    }
                    FlatField subgrid = (FlatField)FieldImpl.combine(combinegrids);
                    subgrids[i2] = new RemoteNodePartitionedFieldImpl(subgrid);
                }
                ++i2;
            }
            FunctionType new_v5d_type = new FunctionType(time_tuple, subgrids[0].getType());
            node_v5ds[k] = new RemoteNodeFieldImpl(new_v5d_type, time_set);
            node_v5ds[k].setSamples(subgrids, false);
            int kk = id - 1;
            String url = "///TestVis5DCluster" + kk;
            try {
                Naming.rebind(url, node_v5ds[kk]);
            }
            catch (Exception e3) {
                System.out.println("rebind " + kk + " " + e3);
                return;
            }
            DisplayImplJ2D display = new DisplayImplJ2D("dummy");
            System.out.println("data ready as " + new_v5d_type);
            return;
        }
        int k = 0;
        while (k < number_of_nodes) {
            String url = "///TestVis5DCluster" + k;
            try {
                node_v5ds[k] = (RemoteNodeField)Naming.lookup(url);
            }
            catch (Exception e4) {
                System.out.println("lookup " + k + " " + e4);
                return;
            }
            ++k;
        }
        v5d_type = (FunctionType)node_v5ds[0].getType();
        System.out.println("data type = " + v5d_type);
        time_set = node_v5ds[0].getDomainSet();
        RemoteClientFieldImpl client_v5d = new RemoteClientFieldImpl(v5d_type, time_set);
        RemoteClusterData[] table = new RemoteClusterData[number_of_nodes + 1];
        int i = 0;
        while (i < number_of_nodes) {
            table[i] = node_v5ds[i];
            ++i;
        }
        table[number_of_nodes] = client_v5d;
        int i3 = 0;
        while (i3 < table.length) {
            table[i3].setupClusterData(ps, table);
            ++i3;
        }
        DisplayImplJ3D display = new DisplayImplJ3D("main_display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D(100000L));
        grid_type = (FunctionType)v5d_type.getRange();
        RealTupleType domain_type = grid_type.getDomain();
        RealTupleType time_tuple = v5d_type.getDomain();
        RealType time = (RealType)time_tuple.getComponent(0);
        RealType x = (RealType)domain_type.getComponent(0);
        RealType y = (RealType)domain_type.getComponent(1);
        RealType z = (RealType)domain_type.getComponent(2);
        RealTupleType val_tuple = (RealTupleType)grid_type.getRange();
        int nvals = val_tuple.getDimension();
        RealType[] vals = new RealType[nvals];
        int i4 = 0;
        while (i4 < nvals) {
            vals[i4] = (RealType)val_tuple.getComponent(i4);
            ++i4;
        }
        ScalarMap animation_map = new ScalarMap(time, Display.Animation);
        display.addMap(animation_map);
        display.addMap(new ScalarMap(x, Display.XAxis));
        display.addMap(new ScalarMap(y, Display.YAxis));
        display.addMap(new ScalarMap(z, Display.ZAxis));
        ScalarMap[] contour_maps = new ScalarMap[nvals];
        int i5 = 0;
        while (i5 < nvals) {
            contour_maps[i5] = new ScalarMap(vals[i5], Display.IsoContour);
            display.addMap(contour_maps[i5]);
            ++i5;
        }
        DataReferenceImpl ref = new DataReferenceImpl("image");
        RemoteDataReferenceImpl remote_ref = new RemoteDataReferenceImpl(ref);
        remote_ref.setData(client_v5d);
        RemoteDisplayImpl remote_display = new RemoteDisplayImpl(display);
        remote_display.addReference(remote_ref);
        JFrame frame = new JFrame("test ClientRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        frame.getContentPane().add(panel);
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new BoxLayout(lpanel, 1));
        JPanel rpanel = new JPanel();
        rpanel.setLayout(new BoxLayout(rpanel, 1));
        rpanel.add(display.getComponent());
        AnimationWidget awidget = new AnimationWidget(animation_map);
        awidget.setMaximumSize(new Dimension(400, 400));
        lpanel.add(new AnimationWidget(animation_map));
        int i6 = 0;
        while (i6 < nvals) {
            ContourWidget cwidget = new ContourWidget(contour_maps[i6]);
            cwidget.setMaximumSize(new Dimension(400, 200));
            lpanel.add(new ContourWidget(contour_maps[i6]));
            ++i6;
        }
        lpanel.setMaximumSize(new Dimension(400, 600));
        panel.add(lpanel);
        panel.add(rpanel);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    private static Gridded3DSet makePS(Gridded3DSet domain_set, int node_divide) throws VisADException {
        int number_of_nodes = node_divide * node_divide;
        int x_len = domain_set.getLength(0);
        int y_len = domain_set.getLength(1);
        int z_len = domain_set.getLength(2);
        int len = domain_set.getLength();
        float[][] samples = domain_set.getSamples(false);
        float[][] ps_samples = new float[3][number_of_nodes];
        int i = 0;
        while (i < node_divide) {
            int ie = i * (x_len - 1) / (node_divide - 1);
            int j = 0;
            while (j < node_divide) {
                int je = j * (y_len - 1) / (node_divide - 1);
                int k = i + node_divide * j;
                int ke = ie + x_len * (je + y_len * (z_len / 2));
                ps_samples[0][k] = samples[0][ke];
                ps_samples[1][k] = samples[1][ke];
                ps_samples[2][k] = samples[2][ke];
                ++j;
            }
            ++i;
        }
        Gridded3DSet ps = new Gridded3DSet(domain_set.getType(), ps_samples, node_divide, node_divide, 1, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
        return ps;
    }
}

