/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataShadow;
import visad.Field;
import visad.FlatField;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.FileAccessor;

public class FileFlatField
extends FlatField {
    private static final int MAX_FILE_FLAT_FIELDS = 10;
    private static transient FlatField[] adaptedFlatFields = new FlatField[10];
    private static transient boolean[] adaptedFlatFieldDirty = new boolean[10];
    private static transient FileFlatField[] adaptedFlatFieldOwner = new FileFlatField[10];
    private static transient long[] adaptedFlatFieldSizes = new long[10];
    private static transient long[] adaptedFlatFieldTimes = new long[10];
    private transient int adaptedFlatFieldIndex;
    transient FileAccessor fileAccessor;
    private transient CacheStrategy cacheStrategy;

    public FileFlatField(FileAccessor accessor, CacheStrategy strategy) throws VisADException {
        super(accessor.getFunctionType(), FileFlatField.getNullDomainSet(accessor.getFunctionType().getDomain()));
        this.fileAccessor = accessor;
        this.cacheStrategy = strategy;
        this.adaptedFlatFieldIndex = 0;
    }

    private static Set getNullDomainSet(RealTupleType type) throws VisADException {
        int n = type.getDimension();
        double[] values = new double[n];
        int i = 0;
        while (i < n) {
            values[i] = 0.0;
            ++i;
        }
        try {
            RealTuple tuple = new RealTuple(type, values);
            return new SingletonSet(tuple);
        }
        catch (RemoteException e2) {
            throw new VisADError("FileFlatField.getNullDomainSet: " + e2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlatField getAdaptedFlatField() {
        if (adaptedFlatFieldOwner == null) {
            return null;
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (adaptedFlatFields) {
            int ii = 0;
            while (ii < 10) {
                if (this == adaptedFlatFieldOwner[ii]) {
                    FileFlatField.adaptedFlatFieldTimes[ii] = System.currentTimeMillis();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return adaptedFlatFields[ii];
                }
                ++ii;
            }
            this.adaptedFlatFieldIndex = this.cacheStrategy.allocate(adaptedFlatFields, adaptedFlatFieldDirty, adaptedFlatFieldSizes, adaptedFlatFieldTimes);
            if (adaptedFlatFieldDirty[this.adaptedFlatFieldIndex]) {
                try {
                    adaptedFlatFieldOwner[this.adaptedFlatFieldIndex].flushCache();
                }
                catch (VisADException e2) {
                    System.out.println(e2.getMessage());
                }
            }
            try {
                FileFlatField.adaptedFlatFields[this.adaptedFlatFieldIndex] = this.fileAccessor.getFlatField();
            }
            catch (VisADException e1) {
                System.out.println(e1.getMessage());
            }
            catch (RemoteException e2) {
                System.out.println(e2.getMessage());
            }
            FileFlatField.adaptedFlatFieldOwner[this.adaptedFlatFieldIndex] = this;
            FileFlatField.adaptedFlatFieldTimes[this.adaptedFlatFieldIndex] = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return adaptedFlatFields[this.adaptedFlatFieldIndex];
        }
    }

    private void flushCache() throws VisADException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        if (this == adaptedFlatFieldOwner[this.adaptedFlatFieldIndex]) {
            // empty if block
        }
    }

    public Data getSample(int index) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.getSample(index);
    }

    public int getLength() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return 0;
        }
        return fld.getLength();
    }

    public Unit[] getDomainUnits() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getDomainUnits();
    }

    public CoordinateSystem getDomainCoordinateSystem() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getDomainCoordinateSystem();
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws TypeException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getRangeCoordinateSystem();
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int component) throws TypeException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getRangeCoordinateSystem(component);
    }

    public Unit[][] getRangeUnits() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getRangeUnits();
    }

    public Unit[] getDefaultRangeUnits() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getDefaultRangeUnits();
    }

    public double[][] getValues() throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.getValues();
    }

    public double[][] getValues(boolean copy) throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.getValues(copy);
    }

    public double[] getValues(int index) throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.getValues(index);
    }

    public float[][] getFloats(boolean copy) throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.getFloats(copy);
    }

    public Set getDomainSet() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.getDomainSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(int index, Data range) throws VisADException, RemoteException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (adaptedFlatFields) {
            FlatField fld = this.getAdaptedFlatField();
            if (fld == null) {
                throw new VisADException("Cannot get cached FlatField");
            }
            FileFlatField.adaptedFlatFieldDirty[this.adaptedFlatFieldIndex] = true;
            fld.setSample(index, range);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(RealTuple domain, Data range) throws VisADException, RemoteException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (adaptedFlatFields) {
            FlatField fld = this.getAdaptedFlatField();
            if (fld == null) {
                throw new VisADException("Cannot get cached FlatField");
            }
            FileFlatField.adaptedFlatFieldDirty[this.adaptedFlatFieldIndex] = true;
            fld.setSample(domain, range);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (adaptedFlatFields) {
            FlatField fld = this.getAdaptedFlatField();
            if (fld == null) {
                throw new VisADException("Cannot get cached FlatField");
            }
            FileFlatField.adaptedFlatFieldDirty[this.adaptedFlatFieldIndex] = true;
            fld.setSample(index, range, copy);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public boolean isMissing() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return true;
        }
        return fld.isMissing();
    }

    public Data binary(Data data, int op, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.binary(data, op, sampling_mode, error_mode);
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.binary(data, op, new_type, sampling_mode, error_mode);
    }

    public Data unary(int op, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.unary(op, sampling_mode, error_mode);
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.unary(op, new_type, sampling_mode, error_mode);
    }

    public double[][] unpackValues() throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.unpackValues();
    }

    public float[][] unpackFloats() throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.unpackFloats();
    }

    public Field extract(int component) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.extract(component);
    }

    public Field domainFactor(RealType factor) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.domainFactor(factor);
    }

    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.resample(set, sampling_mode, error_mode);
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.computeRanges(type, shadow);
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return fld.adjustSamplingError(error, error_mode);
    }

    public boolean isFlatField() {
        return true;
    }

    public Object clone() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.clone();
    }

    public String toString() {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return "Cannot get cached FlatField";
        }
        return fld.toString();
    }

    public String longString(String pre) {
        FlatField fld = this.getAdaptedFlatField();
        if (fld == null) {
            return pre + "Cannot get cached FlatField";
        }
        try {
            return fld.longString(pre);
        }
        catch (VisADException e2) {
            return pre + e2.getMessage();
        }
    }

    private void readObject(ObjectInputStream oos) throws ClassNotFoundException, IOException {
        throw new NotSerializableException("FileFlatField is not serializable");
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new NotSerializableException("FileFlatField is not serializable");
    }

    static {
        if (adaptedFlatFieldOwner != null && adaptedFlatFields != null && adaptedFlatFieldSizes != null && adaptedFlatFieldTimes != null && adaptedFlatFieldDirty != null) {
            int i = 0;
            while (i < 10) {
                FileFlatField.adaptedFlatFieldOwner[i] = null;
                FileFlatField.adaptedFlatFields[i] = null;
                FileFlatField.adaptedFlatFieldSizes[i] = 0L;
                FileFlatField.adaptedFlatFieldTimes[i] = System.currentTimeMillis();
                FileFlatField.adaptedFlatFieldDirty[i] = false;
                ++i;
            }
        }
    }
}

