/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.LinkedDataSource;

public class SocketDataSource
extends LinkedDataSource {
    protected Socket socket;
    protected ObjectOutputStream out;
    protected ObjectInputStream in;
    protected Runnable comm = new Runnable(){

        public void run() {
            while (true) {
                Object o = null;
                try {
                    o = SocketDataSource.this.in.readObject();
                }
                catch (ClassNotFoundException exc) {
                }
                catch (IOException exc) {
                    // empty catch block
                }
                if (o == null) break;
                if (!(o instanceof DataImpl)) continue;
                try {
                    SocketDataSource.this.dataChanged((Data)o);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {}
            }
            try {
                SocketDataSource.this.dataChanged(null);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
            try {
                SocketDataSource.this.in.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
            try {
                SocketDataSource.this.out.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
            try {
                SocketDataSource.this.socket.close();
            }
            catch (IOException exc) {}
        }
    };

    public SocketDataSource(String name) {
        super(name);
    }

    public synchronized void open(String id) throws IOException, VisADException, RemoteException {
        int index = id.indexOf(":");
        if (index < 0) {
            throw new VisADException("malformed socket URL: " + id);
        }
        String host = id.substring(0, index);
        String p = id.substring(index + 1);
        int port = -1;
        try {
            port = Integer.parseInt(p);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (port < 0) {
            throw new VisADException("invalid socket port: " + p);
        }
        this.socket = new Socket(host, port);
        this.out = new ObjectOutputStream(this.socket.getOutputStream());
        this.in = new ObjectInputStream(this.socket.getInputStream());
        Thread t2 = new Thread(this.comm);
        t2.start();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void writeObject(Object o) {
        try {
            this.out.writeObject(o);
        }
        catch (IOException exc) {}
    }
}

