/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.rmi.RemoteException;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTuple;
import visad.RealType;
import visad.VisADException;
import visad.data.amanda.EventList;
import visad.data.amanda.Hit;

public class Hits
extends EventList {
    public static FunctionType functionType;
    public static FunctionType timeSequenceType;
    public static FieldImpl missing;
    public static final RealType indexType;
    private static final int MIN_TIMESTEPS = 20;
    private static final int MAX_TIMESTEPS = 50;
    private static FunctionType indexTupleType;
    private float[] timeSteps = null;
    private Integer1DSet timeSubSet = null;
    private FlatField timeMissingFld = null;

    public final void add(Hit hit) {
        super.add(hit);
        this.timeSteps = null;
        this.timeSubSet = null;
        this.timeMissingFld = null;
    }

    private final boolean computeDataObjects() {
        int numHits = this.size();
        boolean rtnval = true;
        try {
            this.timeSubSet = new Integer1DSet((MathType)indexType, numHits);
            this.timeMissingFld = new FlatField(indexTupleType, this.timeSubSet);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            this.timeSubSet = null;
            this.timeMissingFld = null;
            rtnval = false;
        }
        return rtnval;
    }

    private final void computeTimeSteps() {
        int numHits = this.size();
        float startTime = Float.MAX_VALUE;
        float endTime = Float.MIN_VALUE;
        float minLen = Float.MAX_VALUE;
        int i = 0;
        while (i < numHits) {
            float et;
            float len;
            Hit hit = (Hit)this.internalGet(i);
            float st = hit.getLeadingEdgeTime();
            if (startTime > st) {
                startTime = st;
            }
            if ((len = hit.getTimeOverThreshold()) < minLen) {
                minLen = len;
            }
            if (endTime < (et = st + len)) {
                endTime = et;
            }
            ++i;
        }
        float totalTime = endTime - startTime;
        int steps = (int)(totalTime / minLen);
        if (steps < 20) {
            steps = 20;
        } else if (steps > 50) {
            steps = 50;
        }
        float stepLen = totalTime / (float)steps;
        this.timeSteps = new float[steps + 1];
        this.timeSteps[0] = startTime;
        int i2 = 0;
        while (i2 < steps) {
            this.timeSteps[i2 + 1] = this.timeSteps[i2] + stepLen;
            ++i2;
        }
    }

    public final Hit get(int i) {
        return (Hit)super.internalGet(i);
    }

    final FlatField getHitsBeforeTime(float time) {
        FlatField fld;
        if (!(this.timeSubSet != null && this.timeMissingFld != null || this.computeDataObjects())) {
            return null;
        }
        int numHits = this.size();
        Data[] rt = new RealTuple[numHits];
        int i = 0;
        while (i < numHits) {
            Hit hit = (Hit)this.internalGet(i);
            float leadTime = hit.getLeadingEdgeTime();
            rt[i] = time < leadTime ? Hit.missing : hit.makeData();
            ++i;
        }
        try {
            fld = new FlatField(indexTupleType, this.timeSubSet);
            fld.setSamples(rt, false);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            fld = this.timeMissingFld;
        }
        catch (RemoteException re) {
            re.printStackTrace();
            fld = this.timeMissingFld;
        }
        return fld;
    }

    final Gridded1DSet getTimeStepSet(RealType setType) {
        Gridded1DSet set;
        if (this.timeSteps == null) {
            this.computeTimeSteps();
        }
        try {
            set = new Gridded1DSet((MathType)setType, (float[][])new float[][]{this.timeSteps}, this.timeSteps.length);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            set = null;
        }
        return set;
    }

    final float[] getTimeSteps() {
        if (this.timeSteps == null) {
            this.computeTimeSteps();
        }
        return this.timeSteps;
    }

    final FieldImpl makeTimeSequence() {
        FieldImpl fld;
        if (this.timeSteps == null) {
            this.computeTimeSteps();
        }
        Data[] data = new FlatField[this.timeSteps.length];
        int a2 = 0;
        while (a2 < this.timeSteps.length) {
            data[a2] = this.getHitsBeforeTime(this.timeSteps[a2]);
            ++a2;
        }
        try {
            fld = new FieldImpl(timeSequenceType, this.getTimeStepSet(RealType.Time));
            fld.setSamples(data, false);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            fld = null;
        }
        catch (RemoteException re) {
            re.printStackTrace();
            fld = null;
        }
        return fld;
    }

    static {
        indexType = RealType.getRealType("Hits_Index");
        try {
            functionType = new FunctionType(Hit.indexType, Hit.tupleType);
            indexTupleType = new FunctionType(indexType, Hit.tupleType);
            timeSequenceType = new FunctionType(RealType.Time, indexTupleType);
            Gridded1DSet set = new Gridded1DSet((MathType)RealType.Time, new float[1][1], 1);
            missing = new FieldImpl(timeSequenceType, set);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            functionType = null;
            timeSequenceType = null;
            indexTupleType = null;
            missing = null;
        }
    }
}

