/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.in.Consolidator;
import visad.data.in.DataInputStream;
import visad.data.in.TimeFactorer;

public class DODSForm
extends Form
implements FormFileInformer {
    public static final String SUFFIX = "dods";
    private static final String periodSuffix = ".dods";
    private static final DODSForm instance = new DODSForm();
    private static final String sourceMessage = "DODS data-import capability is not available -- probably because the DODS package wasn't available when this package was compiled.  If you want DODS data-import capability, then you'll have to first obtain the DODS package (see <http://www.unidata.ucar.edu/packages/dods/index.html>) and then recompile this package.";
    private static final String contactMessage = ".  This exception should not have occurred.  Contact VisAD support.";
    static /* synthetic */ Class class$java$lang$String;

    protected DODSForm() {
        super("DODS");
    }

    public static DODSForm dodsForm() {
        return instance;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException(this.getClass().getName() + ".save(String,Data,boolean): " + "Can't save data to a DODS server");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException(this.getClass().getName() + ".add(String,Data,boolean): " + "Can't add data to a DODS server");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        DataImpl data;
        String header = this.getClass().getName() + ".open(String): ";
        try {
            Class<?> sourceClass = Class.forName(this.getClass().getPackage().getName() + ".DODSSource");
            DataInputStream source = (DataInputStream)sourceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            sourceClass.getMethod("open", class$java$lang$String == null ? (class$java$lang$String = DODSForm.class$("java.lang.String")) : class$java$lang$String).invoke((Object)source, id);
            data = new Consolidator(new TimeFactorer(source)).readData();
        }
        catch (ClassNotFoundException e2) {
            throw new VisADException(header + e2 + ".  " + sourceMessage);
        }
        catch (NoSuchMethodException e3) {
            throw new VisADException(header + e3 + contactMessage);
        }
        catch (SecurityException e4) {
            throw new VisADException(header + e4 + contactMessage);
        }
        catch (InstantiationException e5) {
            throw new VisADException(header + e5 + contactMessage);
        }
        catch (IllegalAccessException e6) {
            throw new VisADException(header + e6 + contactMessage);
        }
        catch (IllegalArgumentException e7) {
            throw new VisADException(header + e7 + contactMessage);
        }
        catch (InvocationTargetException e8) {
            throw new VisADException(e8.getTargetException().getMessage());
        }
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        return this.open(url.toString());
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public boolean isThisType(String spec) {
        int i = spec.lastIndexOf(63);
        if (i != -1) {
            spec = spec.substring(0, i);
        }
        return spec.toLowerCase().endsWith(periodSuffix);
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{SUFFIX};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

