/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.AttributeTable;
import java.rmi.RemoteException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.IntValuator;

public abstract class UIntValuator
extends IntValuator {
    private final float floatFold;
    private final double doubleFold;

    protected UIntValuator(AttributeTable table, long upper) throws BadFormException, VisADException, RemoteException {
        super(table, 0L, upper);
        this.floatFold = (upper + 1L) / 2L;
        this.doubleFold = (upper + 1L) / 2L;
    }

    public float process(float value) {
        return super.process(value < 0.0f ? value + this.floatFold : value);
    }

    public float[] process(float[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] < 0.0f) {
                int n = i;
                values[n] = values[n] + this.floatFold;
            }
            ++i;
        }
        return super.process(values);
    }

    public double process(double value) {
        return super.process(value < 0.0 ? value + this.doubleFold : value);
    }

    public double[] process(double[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] < 0.0) {
                int n = i;
                values[n] = values[n] + this.doubleFold;
            }
            ++i;
        }
        return super.process(values);
    }
}

