/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.ExtensionHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.TruncatedFileException;

public class DumpHeader {
    private static void dumpBasic(PrintStream ps, String indentStr, BasicHDU hdu) {
        double minValue;
        double maxValue;
        String reference;
        String author;
        double equinox;
        String object;
        String observer;
        String instrument;
        String telescope;
        String origin;
        Date observation;
        String bunit;
        double bscale;
        double bzero;
        int groupCount;
        int paramCount;
        int[] axes;
        try {
            String bpName;
            int bitpix = hdu.getBitPix();
            switch (bitpix) {
                case 8: {
                    bpName = "byte";
                    break;
                }
                case 16: {
                    bpName = "short";
                    break;
                }
                case 32: {
                    bpName = "int";
                    break;
                }
                case -32: {
                    bpName = "float";
                    break;
                }
                case -64: {
                    bpName = "double";
                    break;
                }
                default: {
                    bpName = "?" + bitpix + '?';
                }
            }
            ps.println(indentStr + "bitpix " + bpName);
        }
        catch (FitsException e2) {
            ps.println(indentStr + "bitpix *** " + e2.getMessage());
        }
        try {
            axes = hdu.getAxes();
        }
        catch (FitsException e3) {
            System.err.println("Bad axes: " + e3.getMessage());
            axes = null;
        }
        if (axes != null) {
            ps.print(indentStr + "axes ");
            int i = 0;
            while (i < axes.length) {
                ps.print((i == 0 ? "" : "x") + axes[i]);
                ++i;
            }
            ps.println("");
        }
        if ((paramCount = hdu.getParameterCount()) != 0) {
            ps.println(indentStr + "paramCount " + paramCount);
        }
        if ((groupCount = hdu.getGroupCount()) != 1) {
            ps.println(indentStr + "groupCount " + groupCount);
        }
        if ((bzero = hdu.getBZero()) != 0.0) {
            ps.println(indentStr + "bzero " + bzero);
        }
        if ((bscale = hdu.getBScale()) != 1.0) {
            ps.println(indentStr + "bscale " + bscale);
        }
        if ((bunit = hdu.getBUnit()) != null) {
            ps.println(indentStr + "bunit " + bunit);
        }
        try {
            int blankValue = hdu.getBlankValue();
            ps.println(indentStr + "blank " + blankValue);
        }
        catch (FitsException e4) {
            // empty catch block
        }
        Date creation = hdu.getCreationDate();
        if (creation != null) {
            ps.println(indentStr + "creation date " + creation);
        }
        if ((observation = hdu.getObservationDate()) != null) {
            ps.println(indentStr + "observation date " + observation);
        }
        if ((origin = hdu.getOrigin()) != null) {
            ps.println(indentStr + "origin " + origin);
        }
        if ((telescope = hdu.getTelescope()) != null) {
            ps.println(indentStr + "telescope " + telescope);
        }
        if ((instrument = hdu.getInstrument()) != null) {
            ps.println(indentStr + "instrument " + instrument);
        }
        if ((observer = hdu.getObserver()) != null) {
            ps.println(indentStr + "observer " + observer);
        }
        if ((object = hdu.getObject()) != null) {
            ps.println(indentStr + "object " + object);
        }
        if ((equinox = hdu.getEquinox()) != -1.0) {
            ps.println(indentStr + "equinox " + equinox);
        }
        if ((author = hdu.getAuthor()) != null) {
            ps.println(indentStr + "author " + author);
        }
        if ((reference = hdu.getReference()) != null) {
            ps.println(indentStr + "reference " + reference);
        }
        if ((maxValue = hdu.getMaximumValue()) != 0.0) {
            ps.println(indentStr + "maximum value " + maxValue);
        }
        if ((minValue = hdu.getMinimumValue()) != 0.0) {
            ps.println(indentStr + "minimum value " + minValue);
        }
    }

    private static void dumpPrimary(PrintStream ps, String indentStr, PrimaryHDU hdu) throws IOException {
        DumpHeader.dumpBasic(ps, indentStr, hdu);
        Data data = hdu.getData();
    }

    private static void dumpBinaryTable(PrintStream ps, String indentStr, BinaryTableHDU hdu) {
        int num = hdu.getNumColumns();
        if (num == 0) {
            ps.println(indentStr + "No columns");
            return;
        }
        int i = 0;
        while (i < num) {
            String type;
            String name;
            try {
                name = hdu.getColumnName(i);
                type = hdu.getColumnFITSType(i);
            }
            catch (FitsException e2) {
                break;
            }
            ps.println(indentStr + i + ": " + name + " = " + type);
            ++i;
        }
    }

    private static void dumpExtension(PrintStream ps, String indentStr, ExtensionHDU hdu) throws IOException {
        int level;
        int vers;
        DumpHeader.dumpBasic(ps, indentStr, hdu);
        String name = hdu.getExtensionName();
        if (name != null) {
            ps.println(indentStr + "name " + name);
        }
        if ((vers = hdu.getExtensionVersion()) != 1) {
            ps.println(indentStr + "version " + vers);
        }
        if ((level = hdu.getExtensionLevel()) != 1) {
            ps.println(indentStr + "level " + level);
        }
        if (hdu instanceof BinaryTableHDU) {
            ps.println(indentStr + "Binary Table:");
            DumpHeader.dumpBinaryTable(ps, indentStr + indentStr, (BinaryTableHDU)hdu);
        } else {
            try {
                String type = hdu.getExtensionType();
                if (type == null) {
                    ps.println(indentStr + "Null extension type");
                } else {
                    ps.println(indentStr + "type " + type);
                }
            }
            catch (FitsException e2) {
                ps.println(indentStr + indentStr + "Bad extension type: " + e2.getMessage());
            }
        }
        Data foo = hdu.getData();
    }

    private static void dumpImage(PrintStream ps, String indentStr, ImageHDU hdu) throws IOException {
        DumpHeader.dumpBasic(ps, indentStr, hdu);
        ps.println(indentStr + "...");
        Data data = hdu.getData();
    }

    private static void dumpRandomGroups(PrintStream ps, String indentStr, RandomGroupsHDU hdu) throws IOException {
        DumpHeader.dumpBasic(ps, indentStr, hdu);
        ps.println(indentStr + "...");
        Data data = hdu.getData();
    }

    public static void dump(PrintStream ps, String name) throws FitsException, IOException {
        Fits fits;
        try {
            fits = new Fits(name);
        }
        catch (FitsException e2) {
            System.err.println("Couldn't open \"" + name + "\": " + e2.getMessage());
            return;
        }
        ps.println(name + ':');
        int hduNum = 0;
        while (true) {
            block19: {
                BasicHDU hdu;
                try {
                    hdu = fits.readHDU();
                }
                catch (OutOfMemoryError e3) {
                    System.err.println("  *** Out of memory for HDU #" + hduNum);
                    e3.printStackTrace(System.err);
                    break;
                }
                catch (TruncatedFileException e4) {
                    System.err.println("  *** File truncated at HDU #" + hduNum + " (" + e4.getMessage() + ")");
                    break;
                }
                catch (IOException e5) {
                    System.err.println("  *** I/O error at HDU #" + hduNum + " (" + e5.getMessage() + ")");
                    break;
                }
                catch (BadHeaderException e6) {
                    System.err.println("  *** HDU #" + hduNum + " threw " + e6.getMessage());
                    break block19;
                }
                catch (FitsException e7) {
                    System.err.println("  *** HDU #" + hduNum + " threw " + e7.getMessage());
                    break block19;
                }
                if (hdu == null) break;
                String indentStr = "\t";
                if (hdu instanceof PrimaryHDU) {
                    if (hduNum == 0) {
                        ps.println(indentStr + "Primary:");
                    } else {
                        ps.println(indentStr + "Primary " + hduNum + ':');
                    }
                    ps.flush();
                    DumpHeader.dumpPrimary(ps, indentStr + indentStr, (PrimaryHDU)hdu);
                } else if (hdu instanceof ExtensionHDU) {
                    ps.println(indentStr + "Extension " + hduNum + ':');
                    ps.flush();
                    DumpHeader.dumpExtension(ps, indentStr + indentStr, (ExtensionHDU)hdu);
                } else if (hdu instanceof ImageHDU) {
                    ps.println(indentStr + "Image " + hduNum + ':');
                    ps.flush();
                    DumpHeader.dumpImage(ps, indentStr + indentStr, (ImageHDU)hdu);
                } else if (hdu instanceof RandomGroupsHDU) {
                    ps.println(indentStr + "RandomGroups " + hduNum + ':');
                    ps.flush();
                    DumpHeader.dumpRandomGroups(ps, indentStr + indentStr, (RandomGroupsHDU)hdu);
                } else {
                    throw new FitsException("Unknown header found: " + hdu);
                }
            }
            ++hduNum;
        }
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            try {
                DumpHeader.dump(System.out, args[i]);
            }
            catch (OutOfMemoryError e2) {
                e2.printStackTrace(System.out);
            }
            catch (FitsException e3) {
                e3.printStackTrace(System.out);
            }
            catch (IOException e4) {
                e4.printStackTrace(System.out);
            }
            ++i;
        }
    }
}

