/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataset;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;

public class HDF5Attribute
extends HDF5Dataset {
    public HDF5Attribute() {
        this.type = 5;
    }

    public HDF5Attribute(int loc_id, String attr_name, int type_id, int space_id, int create_plist) {
        super(attr_name);
        this.type = 5;
        try {
            this.id = H5.H5Acreate(loc_id, attr_name, type_id, space_id, create_plist);
        }
        catch (HDF5Exception e2) {
            System.err.println("HDF5Attribute: " + e2);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e3) {
            System.err.println("HDF5Attribute.init(): " + e3);
        }
    }

    public HDF5Attribute(int loc_id, String attr_name) {
        super(attr_name);
        this.type = 5;
        try {
            this.id = H5.H5Aopen_name(loc_id, attr_name);
        }
        catch (HDF5Exception e2) {
            System.err.println("HDF5Attribute: " + e2);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e3) {
            System.err.println("HDF5Attribute.init(): " + e3);
        }
    }

    public HDF5Attribute(int loc_id, int idx) {
        this.type = 5;
        try {
            this.id = H5.H5Aopen_idx(loc_id, idx);
            String[] n = new String[]{""};
            H5.H5Aget_name(this.id, 80L, n);
            this.name = n[0];
        }
        catch (Exception e2) {
            System.err.println("HDF5Attribute: " + e2);
            this.id = -1;
            this.name = null;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e3) {
            System.err.println("HDF5Attribute.init(): " + e3);
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.datatype = new HDF5Datatype();
        this.datatype.setID(H5.H5Aget_type(this.id));
        this.datatype.init();
        this.dataspace = new HDF5Dataspace();
        this.dataspace.setID(H5.H5Aget_space(this.id));
        this.dataspace.init();
        this.rank = this.dataspace.getRank();
        this.dims = this.dataspace.getDims();
        this.maxdims = this.dataspace.getMaxdims();
        this.count = this.dataspace.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            H5.H5Aclose(this.id);
            throw throwable;
        }
        H5.H5Aclose(this.id);
    }
}

