/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.lang.reflect.Array;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Dataset
extends HDF5Object {
    protected Object data;
    protected HDF5Datatype datatype;
    protected HDF5Dataspace dataspace;
    protected int rank;
    protected long[] dims;
    protected long[] maxdims;
    protected long[] count;
    protected Vector member_names;

    public HDF5Dataset() {
        this.type = 2;
    }

    public HDF5Dataset(String name) {
        super(name);
        this.type = 2;
    }

    public HDF5Dataset(int loc_id, String set_name, int type_id, int space_id, int create_plist_id) {
        super(set_name);
        this.type = 2;
        try {
            this.id = H5.H5Dcreate(loc_id, set_name, type_id, space_id, create_plist_id);
        }
        catch (HDF5Exception e2) {
            System.err.println("HDF5Dataset: " + e2);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e3) {
            System.err.println("HDF5Dataset: " + e3);
        }
    }

    public HDF5Dataset(int loc_id, String set_name) {
        super(set_name);
        this.type = 2;
        try {
            this.id = H5.H5Dopen(loc_id, set_name);
        }
        catch (HDF5Exception e2) {
            System.err.println("HDF5Dataset: " + e2);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e3) {
            System.err.println("HDF5Dataset.init(): " + e3);
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.datatype = new HDF5Datatype();
        this.datatype.setID(H5.H5Dget_type(this.id));
        this.dataspace = new HDF5Dataspace();
        this.dataspace.setID(H5.H5Dget_space(this.id));
        this.rank = this.dataspace.getRank();
        this.dims = this.dataspace.getDims();
        this.maxdims = this.dataspace.getMaxdims();
        this.count = this.dataspace.getCount();
    }

    public Object readData() throws HDF5Exception, NullPointerException {
        int space = -2;
        return this.readData(space, space);
    }

    public Object readData(int mspace, int fspace) throws HDF5Exception, NullPointerException {
        this.data = null;
        System.gc();
        if (H5.H5Tget_class(this.datatype.getID()) == 6) {
            this.data = this.readCompoundData(mspace, fspace);
            return this.data;
        }
        this.data = this.datatype.defineData(this.count);
        if (this.data == null) {
            return null;
        }
        if (this.data.getClass().getName().endsWith("Ljava.lang.String;")) {
            int no_lines = Array.getLength(this.data);
            long tsize = H5.H5Dget_storage_size(this.id);
            int max_length = (int)(tsize / (long)no_lines);
            byte[][] bdata = new byte[no_lines][max_length];
            H5.H5Dread(this.id, H5.H5Dget_type(this.id), mspace, fspace, -2, bdata);
            int i = 0;
            while (i < no_lines) {
                Array.set(this.data, i, new String(bdata[i]));
                ++i;
            }
        } else {
            H5.H5Dread(this.id, H5.H5Dget_type(this.id), mspace, fspace, -2, this.data);
            boolean isUnsigned = false;
            int tid = this.datatype.getID();
            int class_t = H5.H5Tget_class(tid);
            if (class_t == 0 && H5.H5Tget_sign(tid) == 0) {
                Object new_data;
                this.data = new_data = HDF5Dataset.convertUnsignedData(this.data);
            }
        }
        return this.data;
    }

    private Object readCompoundData(int mspace, int fspace) throws HDF5Exception, NullPointerException {
        String member_name = "";
        int member_tid = -1;
        int read_tid = -1;
        int member_class_t = -1;
        int member_class_s = -1;
        int member_sign = -1;
        int p = -2;
        Object[] member_data = null;
        int size = 0;
        long lsize = 1L;
        if (this.count == null) {
            return null;
        }
        int i = 0;
        while (i < this.count.length) {
            lsize *= this.count[i];
            ++i;
        }
        size = (int)lsize;
        int tid = this.datatype.getID();
        int num_members = H5.H5Tget_nmembers(tid);
        Vector<Object> theData = new Vector<Object>();
        this.member_names = new Vector();
        int i2 = 0;
        while (i2 < num_members) {
            member_data = null;
            member_sign = -1;
            member_name = H5.H5Tget_member_name(tid, i2);
            member_tid = H5.H5Tget_member_type(tid, i2);
            member_class_t = H5.H5Tget_class(member_tid);
            member_class_s = H5.H5Tget_size(member_tid);
            read_tid = H5.H5Tcreate(6, member_class_s);
            switch (member_class_t) {
                case 0: {
                    member_sign = H5.H5Tget_sign(member_tid);
                    if (member_class_s == 1) {
                        byte[] bdata = new byte[size];
                        H5.H5Tinsert(read_tid, member_name, 0L, H5.J2C(72));
                        H5.H5Dread(this.id, read_tid, mspace, fspace, p, bdata);
                        member_data = bdata;
                        break;
                    }
                    if (member_class_s == 2) {
                        short[] sdata = new short[size];
                        H5.H5Tinsert(read_tid, member_name, 0L, H5.J2C(69));
                        H5.H5Dread(this.id, read_tid, mspace, fspace, p, sdata);
                        member_data = sdata;
                        break;
                    }
                    if (member_class_s == 4) {
                        int[] idata = new int[size];
                        H5.H5Tinsert(read_tid, member_name, 0L, H5.J2C(70));
                        H5.H5Dread(this.id, read_tid, mspace, fspace, p, idata);
                        member_data = idata;
                        break;
                    }
                    if (member_class_s != 8) break;
                    long[] ldata = new long[size];
                    H5.H5Tinsert(read_tid, member_name, 0L, H5.J2C(71));
                    H5.H5Dread(this.id, read_tid, mspace, fspace, p, ldata);
                    member_data = ldata;
                    break;
                }
                case 1: {
                    if (member_class_s == 4) {
                        float[] fdata = new float[size];
                        H5.H5Tinsert(read_tid, member_name, 0L, H5.J2C(55));
                        H5.H5Dread(this.id, read_tid, mspace, fspace, p, fdata);
                        member_data = fdata;
                        break;
                    }
                    if (member_class_s != 8) break;
                    double[] ddata = new double[size];
                    H5.H5Tinsert(read_tid, member_name, 0L, H5.J2C(54));
                    H5.H5Dread(this.id, read_tid, mspace, fspace, p, ddata);
                    member_data = ddata;
                    break;
                }
                default: {
                    member_data = null;
                }
            }
            if (member_data != null) {
                this.member_names.add(member_name);
                if (member_sign == 0) {
                    theData.add(HDF5Dataset.convertUnsignedData(member_data));
                } else {
                    theData.add(member_data);
                }
            }
            ++i2;
        }
        return theData;
    }

    public static Object convertUnsignedData(Object data_in) throws HDF5Exception {
        Object data_out = null;
        String cname = data_in.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        int size = Array.getLength(data_in);
        if (dname == 'B') {
            short[] sdata = new short[size];
            short value = 0;
            int i = 0;
            while (i < size) {
                value = Array.getByte(data_in, i);
                if (value < 0) {
                    value = (short)(value + 256);
                }
                sdata[i] = value;
                ++i;
            }
            data_out = sdata;
            data_in = null;
        } else if (dname == 'S') {
            int[] idata = new int[size];
            int value = 0;
            int i = 0;
            while (i < size) {
                value = Array.getShort(data_in, i);
                if (value < 0) {
                    value += 65536;
                }
                idata[i] = value;
                ++i;
            }
            data_out = idata;
            data_in = null;
        } else if (dname == 'I') {
            long[] ldata = new long[size];
            long value = 0L;
            int i = 0;
            while (i < size) {
                value = Array.getInt(data_in, i);
                if (value < 0L) {
                    value += 0x100000000L;
                }
                ldata[i] = value;
                ++i;
            }
            data_out = ldata;
            data_in = null;
        } else {
            data_out = data_in;
        }
        return data_out;
    }

    public void writeData(Object buf) throws HDF5Exception, NullPointerException {
        int space = -2;
        this.writeData(space, space, buf);
    }

    public void writeData(int mspace, int fspace, Object buf) throws HDF5Exception, NullPointerException {
        int num_type = -1;
        int plist = -2;
        String cname = buf.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        num_type = dname == 'B' ? H5.J2C(72) : (dname == 'C' ? H5.J2C(53) : (dname == 'D' ? H5.J2C(54) : (dname == 'F' ? H5.J2C(55) : (dname == 'I' ? H5.J2C(70) : (dname == 'J' ? H5.J2C(71) : (dname == 'S' ? H5.J2C(69) : (dname == 'Z' ? H5.J2C(56) : H5.H5Dget_type(this.id))))))));
        int status = H5.H5Dwrite(this.id, num_type, mspace, fspace, plist, buf);
    }

    public Object getData() {
        return this.data;
    }

    public HDF5Datatype getDatatype() {
        return this.datatype;
    }

    public HDF5Dataspace getDataspace() {
        return this.dataspace;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDims() {
        return this.dims;
    }

    public long[] getMaxdims() {
        return this.maxdims;
    }

    public long[] getCount() {
        return this.count;
    }

    public String toString() {
        if (this.datatype == null || this.dataspace == null) {
            return super.toString();
        }
        String d_str = "";
        int i = 0;
        while (i < this.rank) {
            d_str = d_str + this.dims[i] + "x";
            ++i;
        }
        int l = d_str.length();
        if (l > 1) {
            d_str = d_str.substring(0, l - 1);
        }
        return this.getClass().getName() + "[name=" + this.name + ",type=" + this.datatype + ",dimensions=" + d_str + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            H5.H5Dclose(this.id);
            throw throwable;
        }
        H5.H5Dclose(this.id);
    }
}

