/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.hdfeosc.HdfeosLib;

public class HdfeosFile {
    private String filename;
    private int file_id;
    private int[] sd_id = new int[1];
    private int n_structs;
    private Vector Structs;
    static Vector openedFiles = new Vector();

    HdfeosFile(String filename) throws HdfeosException {
        String[] grid_list;
        int n_grids;
        this.filename = filename;
        String[] swath_list = new String[]{"empty"};
        int n_swaths = HdfeosLib.SWinqswath(filename, swath_list);
        this.n_structs = 0;
        this.Structs = new Vector();
        if (n_swaths > 0) {
            this.file_id = HdfeosLib.SWopen(filename, 1);
            if (this.file_id < 0) {
                throw new HdfeosException("SWopen:  " + this.file_id);
            }
            String struct_name = "Swath";
            int[] hdf_id = new int[1];
            byte[] access = new byte[1];
            int stat = HdfeosLib.EHchkfid(this.file_id, struct_name, hdf_id, this.sd_id, access);
            if (stat < 0) {
                throw new HdfeosException("---cannot obtain sdInterfaceId---");
            }
            StringTokenizer swaths = new StringTokenizer(swath_list[0], ",", false);
            while (swaths.hasMoreElements()) {
                String swath = (String)swaths.nextElement();
                EosSwath obj = new EosSwath(this.file_id, this.sd_id[0], swath);
                this.Structs.addElement(obj);
                ++this.n_structs;
            }
        }
        if ((n_grids = HdfeosLib.GDinqgrid(filename, grid_list = new String[]{"empty"})) > 0) {
            this.file_id = HdfeosLib.GDopen(filename, 1);
            if (this.file_id < 0) {
                throw new HdfeosException("GDopen: " + this.file_id);
            }
            StringTokenizer grids = new StringTokenizer(grid_list[0], ",", false);
            while (grids.hasMoreElements()) {
                String grid = (String)grids.nextElement();
                EosGrid g_obj = new EosGrid(this.file_id, this.sd_id[0], grid);
                this.Structs.addElement(g_obj);
                ++this.n_structs;
            }
        }
        if (this.n_structs == 0) {
            this.file_id = HdfeosLib.SWopen(filename, 1);
            if (this.file_id < 0) {
                throw new HdfeosException("can't open file: " + filename);
            }
        } else {
            openedFiles.addElement(this);
        }
    }

    public int getNumberOfStructs() {
        return this.n_structs;
    }

    public EosStruct getStruct(int ii) {
        return (EosStruct)this.Structs.elementAt(ii);
    }

    public String getFileName() {
        return this.filename;
    }

    public void close() throws HdfeosException {
        int status = HdfeosLib.EHclose(this.file_id);
        if (status < 0) {
            throw new HdfeosException("--closing file, " + this.filename + ", returned status: " + status + " --");
        }
    }

    public static void closeAll() throws HdfeosException {
        Enumeration e2 = openedFiles.elements();
        while (e2.hasMoreElements()) {
            ((HdfeosFile)e2.nextElement()).close();
        }
    }
}

