/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import ucar.netcdf.Dimension;
import ucar.netcdf.Netcdf;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.CommonUnit;
import visad.GriddedSet;
import visad.OffsetUnit;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.TextType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBImpl;
import visad.data.netcdf.in.View;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualReal;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualText;
import visad.data.netcdf.in.VirtualTuple;

final class CfView
extends View {
    private SortedSet auxCoordVars;
    private SortedSet boundaryVars;
    private Map varToRealType;
    private Map dimsToDomain;
    private Map varToAuxCoordVars;
    private Map varToUnitString;
    private static String[] CF_CONVENTIONS_STRINGS = new String[]{"CF-1.0", "COARDS/CF-1.0", "COARDS"};
    private static QuantityDBImpl cfQuantityDB;
    private static Variable[] nilVarArray;
    private static Comparator varComparator;

    CfView(Netcdf netcdf, QuantityDB quantDb) {
        this(netcdf, quantDb, false);
    }

    CfView(Netcdf netcdf, QuantityDB quantDb, boolean charToText) {
        super(netcdf, quantDb, charToText);
        String conventions = View.getConventionsString(netcdf);
        if (conventions == null) {
            throw new IllegalArgumentException("No \"Conventions\" attribute in netCDF dataset");
        }
        int i = 0;
        while (i < CF_CONVENTIONS_STRINGS.length) {
            if (conventions.equals(CF_CONVENTIONS_STRINGS[i])) break;
            ++i;
        }
        if (i >= CF_CONVENTIONS_STRINGS.length) {
            throw new IllegalArgumentException("Illegal \"Conventions\" attribute: \"" + conventions + "\"");
        }
        this.varToRealType = new WeakHashMap();
        this.varToUnitString = new WeakHashMap();
        this.dimsToDomain = new WeakHashMap();
        this.varToAuxCoordVars = new WeakHashMap();
        this.auxCoordVars = new TreeSet(varComparator);
        this.boundaryVars = new TreeSet();
        VariableIterator varIter = this.getNetcdf().iterator();
        while (varIter.hasNext()) {
            Variable var = varIter.next();
            Variable[] vars = this.getAuxCoordVars(var);
            int i2 = 0;
            while (i2 < vars.length) {
                this.auxCoordVars.add(vars[i2]);
                ++i2;
            }
            Variable boundVar = this.getBoundaryVar(var);
            if (boundVar == null) continue;
            this.boundaryVars.add(boundVar);
        }
    }

    private String getAuxCoordVarString(Variable var) {
        return this.getAttributeString(var, "coordinates");
    }

    private boolean isAuxCoordVar(Variable var) {
        return this.auxCoordVars.contains(var);
    }

    private boolean hasAuxCoordVars(Variable var) {
        return this.getAuxCoordVars(var).length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variable[] getAuxCoordVars(Variable var) {
        if (var == null) {
            throw new NullPointerException();
        }
        Map map = this.varToAuxCoordVars;
        synchronized (map) {
            Variable[] vars = (Variable[])this.varToAuxCoordVars.get(var);
            if (vars == null) {
                String attrStr = this.getAuxCoordVarString(var);
                if (attrStr == null) {
                    vars = nilVarArray;
                } else {
                    ArrayList<Variable> list = new ArrayList<Variable>(7);
                    StringTokenizer st = new StringTokenizer(attrStr);
                    while (st.hasMoreTokens()) {
                        String name = st.nextToken();
                        if (!this.isNumeric(name)) continue;
                        list.add(this.getVariable(name));
                    }
                    vars = list.toArray(nilVarArray);
                }
                this.varToAuxCoordVars.put(var, vars);
            }
            return (Variable[])vars.clone();
        }
    }

    private Variable getBoundaryVar(Variable var) {
        if (var == null) {
            throw new NullPointerException();
        }
        String attrStr = this.getAttributeString(var, "bounds");
        if (attrStr == null) {
            return null;
        }
        Variable boundVar = this.getVariable(attrStr);
        if (boundVar == null) {
            System.err.println("WARNING: The boundary variable of variable \"" + var.getName() + "\" doesn't exist");
        }
        return boundVar;
    }

    private boolean isBoundaryVar(Variable var) {
        return this.boundaryVars.contains(var);
    }

    private String getStandardName(Variable var) {
        return this.getAttributeString(var, "standard_name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUnitString(Variable var) {
        String str;
        Map map = this.varToUnitString;
        synchronized (map) {
            str = (String)this.varToUnitString.get(var);
            if (!this.varToUnitString.containsKey(var)) {
                str = super.getUnitString(var);
                if (str == null) {
                    System.err.println("WARNING: Variable \"" + var.getName() + "\" doesn't have a unit attribute.");
                }
                this.varToUnitString.put(var, str);
            }
        }
        return str;
    }

    protected Unit getUnitFromAttribute(Variable var) {
        String unitStr = this.getUnitString(var);
        if (unitStr == null) {
            return null;
        }
        if (unitStr.equals("level") || unitStr.equals("layer") || unitStr.equals("sigma_level")) {
            return CommonUnit.dimensionless;
        }
        return super.getUnitFromAttribute(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RealType getRealType(Variable var) throws TypeException {
        RealType type;
        Map map = this.varToRealType;
        synchronized (map) {
            type = (RealType)this.varToRealType.get(var);
            if (type == null) {
                String str;
                type = this.getRealTypeFromStandardName(var);
                if (type != null) {
                    this.varToRealType.put(var, type);
                } else {
                    type = super.getRealType(var);
                }
                Unit unit = type.getDefaultUnit();
                if (unit instanceof OffsetUnit && unit.getAbsoluteUnit().isConvertible(SI.second) && (str = this.getAttributeString(var, "calendar")) != null && !str.equals("gregorian") && !str.equals("standard")) {
                    String newName = this.newName(var);
                    System.err.println("WARNING: No support for \"" + str + "\" calendar of variable \"" + var + "\".  " + "Attempting to create new quantity \"" + newName + "\" with non-timescale unit.");
                    type = RealType.getRealType(newName, unit.getAbsoluteUnit());
                    this.varToRealType.put(var, type);
                }
            }
        }
        return type;
    }

    private RealType getRealTypeFromStandardName(Variable var) {
        RealType type;
        String name = this.getStandardName(var);
        if (name == null) {
            type = null;
        } else {
            Unit unit;
            type = cfQuantityDB.get(name);
            if (type != null && (unit = this.getUnitFromAttribute(var)) != null && !Unit.canConvert(unit, type.getDefaultUnit())) {
                String newName = this.newName(var);
                System.err.println("WARNING: The units attribute of variable " + var.getName() + " is incompatible with the unit of the quantity" + " referenced by the standard-name attribute.  " + "Attempting to create new quantity \"" + newName + "\".");
                type = RealType.getRealType(newName, unit);
            }
        }
        return type;
    }

    public VirtualDataIterator getVirtualDataIterator() {
        return new DataIterator();
    }

    protected boolean isIgnorable(Variable var) {
        return this.isCoordinateVariable(var) || this.isAuxCoordVar(var) || this.isBoundaryVar(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected View.Domain getDomain(Variable var) throws TypeException, IOException {
        DimensionList domain;
        ArrayList<CfDimension> list = new ArrayList<CfDimension>(7);
        ArrayList<Variable> vars = new ArrayList<Variable>(7);
        Variable[] auxVars = this.getAuxCoordVars(var);
        Dimension[] dims = this.getDimensions(var);
        list = new ArrayList(dims.length + auxVars.length);
        int i = 0;
        while (i < dims.length) {
            list.add(new SimpleDimension(dims[i]));
            ++i;
        }
        int iaux = 0;
        while (iaux < auxVars.length) {
            Variable auxVar = auxVars[iaux];
            Object[] dims2 = this.getDimensions(auxVar);
            vars.add(auxVar);
            boolean auxVarsHaveUnits = true;
            int j = iaux + 1;
            while (j < auxVars.length && Arrays.equals(dims2, this.getDimensions(auxVars[j]))) {
                vars.add(auxVars[j]);
                auxVarsHaveUnits &= this.getRealType(auxVars[j]).getDefaultUnit() != null;
                ++j;
            }
            boolean dimsHaveUnits = true;
            int j2 = 0;
            while (j2 < dims2.length) {
                dimsHaveUnits &= this.getRealType((Dimension)dims2[j2]).getDefaultUnit() != null;
                ++j2;
            }
            if (!dimsHaveUnits || auxVarsHaveUnits) {
                int index = list.indexOf(new SimpleDimension((Dimension)dims2[0]));
                try {
                    int j3 = 0;
                    while (j3 < dims2.length) {
                        list.remove(list.indexOf(new SimpleDimension((Dimension)dims2[j3])));
                        ++j3;
                    }
                }
                catch (IndexOutOfBoundsException e2) {
                    throw new IllegalArgumentException("Invalid dimensional structure: variable \"" + var.getName() + "\"");
                }
                list.add(index, new AuxCoordVarsDimension(vars.toArray(nilVarArray)));
            }
            iaux += vars.size();
            vars.clear();
        }
        Map map = this.dimsToDomain;
        synchronized (map) {
            domain = (DimensionList)this.dimsToDomain.get(list);
            if (domain == null) {
                domain = new DimensionList(var, list);
                this.dimsToDomain.put(list.clone(), domain);
            }
        }
        return domain;
    }

    static {
        nilVarArray = new Variable[0];
        cfQuantityDB = new QuantityDBImpl(null);
        varComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Variable)o1).getName().compareTo(((Variable)o2).getName());
            }
        };
        try {
            cfQuantityDB.add(new String[]{"pressure", "Pa", "stress", "Pa", "mass", "kg", "area", "m2", "volume", "m3", "temperature", "K", "thickness", "m", "height", "m", "altitude", "m", "depth", "m", "mass_fraction", "1", "mass_mixing_ratio", "1", "volume_fraction", "1", "area_fraction", "1", "heat_flux_density", "W m-2", "heat_flux", "W", "power", "W", "mass_flux_density", "kg m-2 s-1", "mass_flux", "kg s-1", "volume_flux_density", "m s-1", "volume_flux", "m3 s-1", "energy", "J", "energy_content", "J m-2", "energy_density", "J m-3", "content", "kg m-2", "amount", "kg m-2", "speed", "m s-1", "velocity", "m s-1", "mass", "kg", "time", "s", "period", "s", "density", "kg m-3", "longitude", "degrees_E", "latitude", "degrees_N", "binary_mask", "1", "data_mask", "1", "frequency", "s-1", "frequency_of_occurrence", "s-1", "probability", "1", "sigma", "1", "hybrid_sigma_pressure", "1", "sigma_term_in_hybrid_sigma_pressure", "1", "pressure_fraction_term_in_hybrid_sigma_pressure", "1", "pressure_term_in_hybrid_sigma_pressure", "Pa", "hybrid_height", "m", "height_term_in_hybrid_height", "1", "altitude_term_in_hybrid_height", "1", "model_level_number", "1", "forecast_reference_time", "s", "forecast_period", "s", "specific_eddy_kinetic_energy", "m2 s-2", "sea_floor_depth", "m", "partial_pressure", "Pa", "surface_air_pressure", "Pa", "air_pressure", "Pa", "air_pressure_anomaly", "Pa", "rate_of_change_of_air_pressure", "Pa s-1", "air_density", "kg m-3", "sea_water_density", "kg m-3", "sea_water_potential_density", "kg m-3", "wind_speed", "m s-1", "eastward_wind", "m s-1", "northward_wind", "m s-1", "wind_direction", "degree", "grid_eastward_wind", "m s-1", "grid_northward_wind", "m s-1", "air_potential_temperature", "K", "soil_water_content", "kg m-2", "specific_humidity", "1", "mass_fraction_of_water_in_air", "1", "cloud_area_fraction", "1", "convective_cloud_area_fraction", "1", "low_cloud_area_fraction", "1", "medium_cloud_area_fraction", "1", "high_cloud_area_fraction", "1", "altitude_at_cloud_base", "m", "air_pressure_at_cloud_base", "Pa", "altitude_at_cloud_top", "m", "air_pressure_at_cloud_top", "Pa", "cloud_condensed_water_content", "kg m-2", "atmosphere_water_content", "kg m-2", "soil_temperature", "K", "canopy_water_amount", "kg m-2", "LWE_thickness_of_canopy_water_amount", "m", "surface_snow_amount", "kg m-2", "surface_snow_thickness", "m", "LWE_thickness_of_surface_snow_amount", "m", "surface_snow_area_fraction", "1", "surface_temperature", "K", "atmosphere_boundary_layer_thickness", "m", "surface_roughness_length", "m", "eastward_sea_water_velocity", "m s-1", "northward_sea_water_velocity", "m s-1", "sea_water_speed", "m s-1", "direction_of_sea_water_velocity", "degree", "land_binary_mask", "1", "sea_ice_area_fraction", "1", "sea_ice_thickness", "m", "sea_ice_amount", "kg m-2", "sea_ice_mass", "kg", "sea_ice_area", "m2", "sea_ice_extent", "m2", "sea_ice_volume", "m3", "sea_ice_freeboard", "m", "sea_ice_draft", "m", "surface_altitude", "m", "surface_temperature_anomaly", "K", "LWE_thickness_of_soil_water_content", "m", "soil_water_content_at_field_capacity", "kg m-2", "ratio_of_soil_water_content_to_soil_water_content_at_field_capacity", "1", "vegetation_area_fraction", "1", "root_depth", "m", "surface_albedo", "1", "surface_albedo_assuming_no_snow", "1", "surface_albedo_assuming_deep_snow", "1", "mass_fraction_of_O3_in_air", "1", "molar_fraction_of_O3_in_air", "1", "upward_wind", "m s-1", "upward_wind_expressed_as_rate_of_change_of_sigma", "s-1", "atmosphere_SO4_content", "kg m-2", "land_area_fraction", "1", "sea_area_fraction", "1", "land_ice_area_fraction", "1", "leaf_area_index", "1", "canopy_height", "m", "mass_fraction_of_unfrozen_water_in_soil_water", "1", "mass_fraction_of_frozen_water_in_soil_water", "1", "soil_frozen_water_content", "kg m-2", "soil_albedo", "1", "snow_soot_content", "kg m-2", "atmosphere_energy_content", "J m-2", "soil_carbon_content", "kg m-2", "snow_grain_size", "m", "snow_temperature", "K", "air_temperature", "K", "air_temperature_anomaly", "K", "TOA_downward_radiative_heat_flux_density", "W m-2", "surface_downward_shortwave_heat_flux_density", "W m-2", "downward_shortwave_heat_flux_density", "W m-2", "downward_longwave_heat_flux_density", "W m-2", "TOA_downward_shortwave_heat_flux_density", "W m-2", "TOA_incoming_shortwave_heat_flux_density", "W m-2", "TOA_outgoing_shortwave_heat_flux_density", "W m-2", "TOA_outgoing_shortwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_incident_shortwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_reflected_shortwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_reflected_shortwave_heat_flux_density", "W m-2", "large_scale_cloud_area_fraction", "1", "rate_of_change_of_air_temperature_due_to_shortwave_heating", "K s-1", "rate_of_change_of_air_temperature_due_to_shortwave_heating_assuming_clear_sky", "K s-1", "surface_incident_shortwave_heat_flux_density", "W m-2", "tropopause_downward_shortwave_heat_flux_density", "W m-2", "tropopause_upward_shortwave_heat_flux_density_from_below", "W m-2", "surface_downward_longwave_heat_flux_density", "W m-2", "surface_emitted_longwave_heat_flux_density", "W m-2", "surface_emitted_longwave_heat_flux_density_assuming_clear_sky", "W m-2", "TOA_upward_longwave_heat_flux_density", "W m-2", "TOA_downward_longwave_heat_flux_density", "W m-2", "TOA_upward_longwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_incident_longwave_heat_flux_density", "W m-2", "surface_incident_longwave_heat_flux_density_assuming_clear_sky", "W m-2", "rate_of_change_of_air_temperature_due_to_longwave_heating", "K s-1", "rate_of_change_of_air_temperature_due_to_longwave_heating_assuming_clear_sky", "K s-1", "tropopause_downward_longwave_heat_flux_density", "W m-2", "tropopause_downward_longwave_heat_flux_density_from_above", "W m-2", "downward_heat_flux_density_in_sea_ice", "W m-2", "downward_heat_flux_density_in_soil", "W m-2", "drag_coefficient", "1", "derivative_of_wind_speed_wrt_altitude_in_constant_flux_layer", "s-1", "downward_stress_in_constant_flux_layer", "Pa", "bulk_Richardson_number", "1", "upward_sensible_heat_flux_density_in_air", "W m-2", "downward_eastward_stress_in_air", "Pa", "downward_northward_stress_in_air", "Pa", "upward_water_vapour_mass_flux_density_in_air", "kg m-2 s-1", "wind_mixing_energy_flux_density_into_sea", "W m-2", "surface_upward_sensible_heat_flux_density", "W m-2", "surface_downward_sensible_heat_flux_density", "W m-2", "surface_upward_sensible_heat_flux_density_from_sea", "W m-2", "surface_upward_water_vapour_mass_flux_density", "kg m-2 s-1", "surface_upward_latent_heat_flux_density", "W m-2", "surface_downward_latent_heat_flux_density", "W m-2", "mass_fraction_of_cloud_ice_in_air", "1", "atmosphere_cloud_ice_content", "kg m-2", "mass_fraction_of_cloud_liquid_water_in_air", "1", "atmosphere_cloud_liquid_water_content", "kg m-2", "visibility", "m", "dew_point_temperature", "K", "freezing_temperature_of_sea_water", "K", "surface_snow_melt_amount", "kg m-2", "surface_snow_melt_heat_flux_density", "W m-2", "transpiration_amount", "kg m-2", "transpiration_mass_flux_density", "kg m-2 s-1", "gross_primary_productivity_of_carbon_amount", "kg m-2 s-1", "net_primary_productivity_of_carbon_amount", "kg m-2 s-1", "plant_respiration_mass_flux_density", "kg m-2 s-1", "large_scale_rainfall_amount", "kg m-2", "large_scale_snowfall_amount", "kg m-2", "large_scale_rainfall_mass_flux_density", "kg m-2 s-1", "large_scale_snowfall_mass_flux_density", "kg m-2 s-1", "relative_humidity", "1", "convective_rainfall_amount", "kg m-2", "convective_snowfall_amount", "kg m-2", "rate_of_change_of_specific_humidity_due_to_convection", "s-1", "convective_rainfall_mass_flux_density", "kg m-2 s-1", "convective_snowfall_mass_flux_density", "kg m-2 s-1", "air_pressure_at_convective_cloud_base", "Pa", "air_pressure_at_convective_cloud_top", "Pa", "mass_fraction_of_convective_condensed_water_in_air", "1", "rainfall_mass_flux_density", "kg m-2 s-1", "snowfall_mass_flux_density", "kg m-2 s-1", "precipitation_mass_flux_density", "kg m-2 s-1", "specific_potential_energy", "J kg-1", "specific_convectively_available_potential_energy", "J kg-1", "precipitation_amount", "kg m-2", "large_scale_precipitation_amount", "kg m-2", "convective_precipitation_amount", "kg m-2", "convective_precipitation_mass_flux_density", "kg m-2 s-1", "rate_of_change_of_wind_due_to_convention", "m s-2", "rate_of_change_of_specific_humidity_due_to_diabatic_processes", "s-1", "rate_of_change_of_air_temperature_due_to_diabatic_processes", "s-1", "rate_of_change_of_air_temperature_due_to_large_scale_precipitation", "s-1", "rate_of_change_of_air_temperature_due_to_moist_convection", "s-1", "rate_of_change_of_air_temperature_due_to_dry_convection", "s-1", "surface_eastward_gravity_wave_stress", "Pa", "surface_northward_gravity_wave_stress", "Pa", "rate_of_change_of_wind_due_to_gravity_wave_drag", "m s-2", "rate_of_change_of_eastward_wind_due_to_gravity_wave_drag", "m s-2", "rate_of_change_of_northward_wind_due_to_gravity_wave_drag", "m s-2", "surface_runoff_amount", "kg m-2", "subsurface_runoff_amount", "kg m-2", "surface_runoff_mass_flux_density", "kg m-2 s-1", "subsurface_runoff_mass_flux_density", "kg m-2 s-1", "runoff_mass_flux_density", "kg m-2 s-1", "wet_bulb_temperature", "K", "omega", "Pa s-1", "Ertel_potential_vorticity", "K m2 kg-1 s-1", "product_of_eastward_wind_and_northward_wind", "m2 s-2", "product_of_air_temperature_and_eastwind_wind", "K m s-1", "product_of_air_temperature_and_northward_wind", "K m s-1", "square_of_air_temperature", "K2", "square_of_eastward_wind", "m2 s-2", "square_of_northward_wind", "m2 s-2", "product_of_eastward_wind_and_omega", "Pa m s-2", "product_of_northward_wind_and_omega", "Pa m s-2", "product_of_eastward_wind_and_specific_humidity", "m s-1", "product_of_northward_wind_and_specific_humidity", "m s-1", "product_of_air_temperature_and_omega", "K Pa s-1", "atmosphere_kinetic_energy_content", "J m-2", "geopotential_height", "m", "geopotential_height_anomaly", "m", "product_of_eastward_wind_and_geopotential_height", "m2 s-1", "product_of_northward_wind_and_geopotential_height", "m2 s-1", "freezing_level_altitude", "m", "freezing_level_air_pressure", "Pa", "tropopause_air_pressure", "Pa", "tropopause_air_temperature", "K", "tropopause_altitude", "m", "sea_level_air_pressure", "Pa", "vegetation_carbon_content", "kg m-2", "litter_carbon_mass_flux_density", "kg m-2 s-1", "sea_water_temperature", "K", "sea_water_potential_temperature", "K", "sea_water_salinity", "1", "baroclinic_eastward_sea_water_velocity", "m s-1", "baroclinic_northward_sea_water_velocity", "m s-1", "ocean_barotropic_streamfunction", "m3 s-1", "rate_of_change_of_ocean_barotropic_streamfunction", "m3 s-2", "sea_surface_elevation", "m", "sea_surface_elevation_anomaly", "m", "barotropic_eastward_sea_water_velocity", "m s-1", "barotropic_northward_sea_water_velocity", "m s-1", "ocean_mixed_layer_thickness", "m", "eastward_stress_of_sea_ice_on_ocean", "Pa", "northward_stress_of_sea_ice_on_ocean", "Pa", "surface_snow_thickness_on_sea_ice", "m", "upward_sensible_heat_flux_density_in_sea_water_at_sea_ice_base", "W m-2", "sea_ice_speed", "m s-1", "sea_ice_eastward_velocity", "m s-1", "sea_ice_northward_velocity", "m s-1", "direction_of_sea_ice_velocity", "degree", "divergence_of_sea_ice_velocity", "s-1", "rate_of_change_of_sea_ice_thickness_due_to_thermodynamics", "m s-1", "surface_downward_eastward_stress", "Pa", "surface_downward_northward_stress", "Pa", "heat_flux_correction", "W m-2", "water_flux_correction", "kg m-2 s-1", "ocean_isopycnal_layer_thickness_diffusivity", "m2 s-1", "sea_water_upward_velocity", "m s-1", "northward_heat_flux_in_ocean", "W", "northward_salt_mass_flux_in_ocean", "kg s-1", "northward_fresh_water_mass_flux_in_ocean", "kg s-1", "significant_height_of_wind_waves_and_swell_waves", "m", "direction_of_wind_wave_velocity", "degree", "significant_height_of_wind_waves", "m", "wind_wave_period", "s", "direction_of_swell_wave_velocity", "degree", "significant_height_of_swell_waves", "m", "swell_wave_period", "s"}, new String[0]);
        }
        catch (Exception e2) {
            System.err.println("ERROR: Couldn't initialize class visad.data.netcdf.in.CfView: " + e2);
            System.exit(1);
        }
    }

    private final class AuxCoordVarsDimension
    extends CfDimension {
        private final Variable[] vars;
        private volatile transient int hashCode;
        private volatile transient SampledSet domain;

        AuxCoordVarsDimension(Variable[] auxCoordVars) {
            if (auxCoordVars.length < 1) {
                throw new IllegalArgumentException();
            }
            this.vars = auxCoordVars;
        }

        Unit[] getUnits() throws TypeException {
            Unit[] units = new Unit[this.vars.length];
            int i = 0;
            while (i < units.length) {
                units[i] = CfView.this.getRealType(this.vars[i]).getDefaultUnit();
                ++i;
            }
            return units;
        }

        SampledSet getDomainSet() throws IOException, TypeException, VisADException {
            SampledSet set = this.domain;
            if (set == null) {
                Variable var0 = this.vars[0];
                int nDim = var0.getRank();
                int[] lengths = var0.getLengths();
                int i = 0;
                int j = nDim;
                while (i < nDim / 2) {
                    int n = lengths[--j];
                    lengths[j] = lengths[i];
                    lengths[i] = n;
                    ++i;
                }
                int nVar = this.vars.length;
                RealType[] types = new RealType[nVar];
                Unit[] units = new Unit[nVar];
                float[][] values = new float[nVar][];
                int i2 = 0;
                int j2 = nVar;
                while (i2 < nVar) {
                    Variable var = this.vars[--j2];
                    types[i2] = CfView.this.getRealType(var);
                    values[i2] = this.toFloat(var.toArray());
                    units[i2] = CfView.this.getUnitFromAttribute(var);
                    ++i2;
                }
                set = this.domain = GriddedSet.create(nVar == 1 ? types[0] : new RealTupleType(types), values, lengths, null, units, null);
            }
            return set;
        }

        private float[] toFloat(Object obj) {
            if (obj instanceof byte[]) {
                return this.toFloat((byte[])obj);
            }
            if (obj instanceof short[]) {
                return this.toFloat((short[])obj);
            }
            if (obj instanceof int[]) {
                return this.toFloat((int[])obj);
            }
            if (obj instanceof float[]) {
                return this.toFloat((float[])obj);
            }
            return this.toFloat((double[])obj);
        }

        private float[] toFloat(byte[] values) {
            float[] vals = new float[values.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = values[i];
                ++i;
            }
            return vals;
        }

        private float[] toFloat(short[] values) {
            float[] vals = new float[values.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = values[i];
                ++i;
            }
            return vals;
        }

        private float[] toFloat(int[] values) {
            float[] vals = new float[values.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = values[i];
                ++i;
            }
            return vals;
        }

        private float[] toFloat(float[] values) {
            return values;
        }

        private float[] toFloat(double[] values) {
            float[] vals = new float[values.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = (float)values[i];
                ++i;
            }
            return vals;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AuxCoordVarsDimension)) {
                return false;
            }
            AuxCoordVarsDimension that = (AuxCoordVarsDimension)obj;
            if (this.vars == that.vars) {
                return true;
            }
            if (this.vars.length != that.vars.length) {
                return false;
            }
            int i = 0;
            while (i < this.vars.length) {
                if (!this.vars[i].getName().equals(that.vars[i].getName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash == 0) {
                hash = 0;
                int i = 0;
                while (i < this.vars.length) {
                    hash ^= this.vars[i].getName().hashCode();
                    ++i;
                }
                this.hashCode = hash;
            }
            return hash;
        }
    }

    private final class SimpleDimension
    extends CfDimension {
        private final Dimension dim;
        private volatile transient SampledSet domain;

        SimpleDimension(Dimension dim) {
            this.dim = dim;
        }

        Unit[] getUnits() throws TypeException {
            return new Unit[]{CfView.this.getRealType(this.dim).getDefaultUnit()};
        }

        SampledSet getDomainSet() throws VisADException, IOException {
            SampledSet set = this.domain;
            if (set == null) {
                set = this.domain = CfView.this.getDomainSet(this.dim);
            }
            return set;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SimpleDimension)) {
                return false;
            }
            return this.dim.equals(((SimpleDimension)obj).dim);
        }

        public int hashCode() {
            return this.dim.hashCode();
        }
    }

    private abstract class CfDimension {
        private CfDimension() {
        }

        abstract Unit[] getUnits() throws TypeException;

        abstract SampledSet getDomainSet() throws VisADException, IOException;

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    private final class DimensionList
    extends View.Domain {
        private final ArrayList list;
        private volatile int hashCode;
        private volatile SampledSet domain;

        DimensionList(Variable var, ArrayList list) throws TypeException {
            super(CfView.this, var);
            this.list = list;
        }

        protected VirtualField getVirtualField(VirtualTuple range) throws VisADException, IOException {
            VirtualField field;
            int nCfDim = this.list.size();
            if (nCfDim == 1) {
                field = VirtualField.newVirtualField(this.getDomainSet(this.list), range);
            } else {
                CfDimension outerDim = (CfDimension)this.list.get(0);
                Unit[] units = outerDim.getUnits();
                field = nCfDim == 2 && range.getType() instanceof TextType ? VirtualField.newVirtualField(this.getDomainSet(this.list.subList(0, 1)), range) : (units.length > 1 || !CfView.this.isTime(units[0]) ? VirtualField.newVirtualField(this.getDomainSet(this.list), range) : VirtualField.newVirtualField(this.getDomainSet(this.list.subList(0, 1)), new VirtualTuple(VirtualField.newVirtualField(this.getDomainSet(this.list.subList(1, nCfDim)), range))));
            }
            return field;
        }

        private SampledSet getDomainSet(List cfDims) throws VisADException, IOException {
            SampledSet[] sets = new SampledSet[cfDims.size()];
            int i = 0;
            int j = sets.length;
            while (i < sets.length) {
                sets[i] = ((CfDimension)cfDims.get(--j)).getDomainSet();
                ++i;
            }
            return sets.length == 1 ? sets[0] : new ProductSet(sets).product();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DimensionList)) {
                return false;
            }
            return this.list.equals(((DimensionList)obj).list);
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash == 0) {
                hash = this.hashCode = this.list.hashCode();
            }
            return hash;
        }
    }

    final class DataIterator
    extends VirtualDataIterator {
        private final VariableIterator varIter;

        DataIterator() {
            super(CfView.this);
            this.varIter = CfView.this.getNetcdf().iterator();
        }

        protected VirtualData getData() throws TypeException, VisADException, IOException {
            while (this.varIter.hasNext()) {
                Variable var = this.varIter.next();
                if (!CfView.this.isNumeric(var) && (!CfView.this.isCharToText() || var.getRank() > 2) || CfView.this.isIgnorable(var)) continue;
                VirtualScalar scalar = CfView.this.isNumeric(var) ? new VirtualReal(CfView.this.getRealType(var), var, CfView.this.getRangeSet(var), CfView.this.getUnitFromAttribute(var), CfView.this.getVetter(var)) : new VirtualText(CfView.this.getTextType(var), var);
                return var.getRank() == 0 || !CfView.this.isNumeric(var) && var.getRank() == 1 ? scalar : CfView.this.getDomain(var).getVirtualField(new VirtualTuple(scalar));
            }
            return null;
        }
    }
}

