/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import ucar.multiarray.StringCharAdapter;
import ucar.netcdf.Variable;
import visad.Scalar;
import visad.ScalarType;
import visad.Text;
import visad.TextType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.VirtualScalar;

public class VirtualText
extends VirtualScalar {
    StringCharAdapter stringVar = null;

    public VirtualText(ScalarType type, Variable var) {
        super(type, var);
        this.stringVar = new StringCharAdapter(var, ' ');
    }

    protected Scalar getScalar(Context context) throws VisADException, InvalidContextException, IOException {
        String[] values = this.getStrings(context);
        if (values.length != 1) {
            System.out.println(this.getScalarType());
            throw new InvalidContextException(context);
        }
        return new Text((TextType)this.getScalarType(), values[0].trim());
    }

    private String[] getStrings(Context context) throws IOException, VisADException {
        int[] lengths = this.stringVar.getLengths();
        int rank = lengths.length;
        int[] ioOrigin = new int[rank];
        int[] ioShape = new int[rank];
        int[] ioContext = context.getContext();
        System.arraycopy(ioContext, 0, ioOrigin, 0, ioContext.length);
        int i = 0;
        while (i < ioContext.length) {
            ioShape[i] = 1;
            ++i;
        }
        int total = 1;
        int i2 = ioContext.length;
        while (i2 < rank) {
            ioOrigin[i2] = 0;
            ioShape[i2] = lengths[i2];
            total *= lengths[i2];
            ++i2;
        }
        String[] values = new String[total];
        return (String[])this.stringVar.toArray(values, ioOrigin, ioShape);
    }

    public Object clone() {
        return new VirtualText((TextType)this.getScalarType(), this.getVariable());
    }
}

