/*
 * Decompiled with CFR 0.152.
 */
package visad.data.qt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class QTForm
extends Form
implements FormFileInformer,
FormBlockReader,
FormProgressInformer {
    public static final int FRAME_RATE = 60;
    private static final String[] suffixes = new String[]{"mov"};
    private static final String noQTmsg = "You need to install QuickTime for Java from http://www.apple.com/quicktime/";
    private static int num = 0;
    private static boolean noQT = false;
    private static final ReflectedUniverse r = QTForm.constructUniverse();
    private String current_id;
    private int numImages;
    private int timeStep;
    private Image img;
    private boolean needsRedrawing;
    private boolean canUseImageJ;
    private double percent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReflectedUniverse constructUniverse() {
        boolean needClose = false;
        URL[] paths = null;
        try {
            paths = new URL[]{new URL("file:/WinNT/System32/QTJava.zip"), new URL("file:/Windows/System/QTJava.zip"), new URL("file:/System/Library/Java/Extensions/QTJava.zip")};
        }
        catch (MalformedURLException exc) {
            // empty catch block
        }
        ReflectedUniverse r = new ReflectedUniverse(paths);
        r.exec("import quicktime.QTSession");
        r.exec("QTSession.open()");
        needClose = true;
        r.exec("import quicktime.app.display.QTCanvas");
        r.exec("import quicktime.app.image.ImageDataSequence");
        r.exec("import quicktime.app.image.ImageUtil");
        r.exec("import quicktime.app.image.JImagePainter");
        r.exec("import quicktime.app.image.QTImageDrawer");
        r.exec("import quicktime.app.image.QTImageProducer");
        r.exec("import quicktime.app.image.Redrawable");
        r.exec("import quicktime.app.players.MoviePlayer");
        r.exec("import quicktime.io.OpenMovieFile");
        r.exec("import quicktime.io.QTFile");
        r.exec("import quicktime.qd.QDDimension");
        r.exec("import quicktime.qd.QDGraphics");
        r.exec("import quicktime.qd.QDRect");
        r.exec("import quicktime.std.StdQTConstants");
        r.exec("import quicktime.std.image.CodecComponent");
        r.exec("import quicktime.std.image.CompressedFrameInfo");
        r.exec("import quicktime.std.image.CSequence");
        r.exec("import quicktime.std.image.ImageDescription");
        r.exec("import quicktime.std.image.QTImage");
        r.exec("import quicktime.std.movies.Movie");
        r.exec("import quicktime.std.movies.Track");
        r.exec("import quicktime.std.movies.media.VideoMedia");
        r.exec("import quicktime.util.QTHandle");
        r.exec("import quicktime.util.RawEncodedImage");
        Object var5_4 = null;
        if (!needClose) return r;
        try {
            r.exec("QTSession.close()");
            return r;
        }
        catch (VisADException exc2) {}
        return r;
        {
            catch (VisADException exc) {
                noQT = true;
                Object var5_5 = null;
                if (!needClose) return r;
                try {
                    r.exec("QTSession.close()");
                    return r;
                }
                catch (VisADException exc2) {}
                return r;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!needClose) throw throwable;
            try {
                r.exec("QTSession.close()");
                throw throwable;
            }
            catch (VisADException exc2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public QTForm() {
        super("QTForm" + num++);
    }

    public boolean isThisType(String name) {
        if (noQT) {
            return false;
        }
        int i = 0;
        while (i < suffixes.length) {
            if (name.toLowerCase().endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s, 0, suffixes.length);
        return s;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        if (noQT) {
            throw new BadFormException(noQTmsg);
        }
        try {
            FlatField[] fields = DataUtility.getImageFields(data);
            int numFrames = fields.length;
            Gridded2DSet set = (Gridded2DSet)fields[0].getDomainSet();
            int[] lengths = set.getLengths();
            int kWidth = lengths[0];
            int kHeight = lengths[1];
            r.setVar("numFrames", new Integer(numFrames));
            r.setVar("kWidth", new Integer(kWidth));
            r.setVar("kHeight", new Integer(kHeight));
            r.exec("QTSession.open()");
            r.setVar("oneHalf", new Float(0.5f));
            Component canv = (Component)r.exec("canv = new QTCanvas(QTCanvas.kInitialSize, oneHalf, oneHalf)");
            JFrame frame = new JFrame();
            JPanel pane = new JPanel();
            frame.setContentPane(pane);
            pane.add("Center", canv);
            BufferedImage buffer = new BufferedImage(kWidth, kHeight, 1);
            r.setVar("buffer", buffer);
            r.exec("ip = new JImagePainter(buffer)");
            Dimension dim = new Dimension(kWidth, kHeight);
            r.setVar("dim", dim);
            r.exec("qid = new QTImageDrawer(ip, dim, Redrawable.kMultiFrame)");
            r.setVar("true", new Boolean(true));
            r.exec("qid.setRedrawing(true)");
            r.exec("canv.setClient(qid, true)");
            frame.pack();
            File file = new File(id);
            r.setVar("path", file.getAbsolutePath());
            r.exec("f = new QTFile(path)");
            Integer i1 = (Integer)r.getVar("StdQTConstants.createMovieFileDeleteCurFile");
            Integer i2 = (Integer)r.getVar("StdQTConstants.createMovieFileDontCreateResFile");
            r.setVar("flags", new Integer(i1 | i2));
            r.exec("theMovie = Movie.createMovieFile(f, StdQTConstants.kMoviePlayer, flags)");
            int kNoVolume = 0;
            r.setVar("kNoVolume", new Integer(kNoVolume));
            r.setVar("kVidTimeScale", new Integer(600));
            r.setVar("fkWidth", new Float(kWidth));
            r.setVar("fkHeight", new Float(kHeight));
            r.setVar("fkNoVolume", new Float(kNoVolume));
            r.exec("vidTrack = theMovie.addTrack(fkWidth, fkHeight, fkNoVolume)");
            r.exec("vidMedia = new VideoMedia(vidTrack, kVidTimeScale)");
            r.exec("vidMedia.beginEdits()");
            r.exec("rect = new QDRect(kWidth, kHeight)");
            r.exec("gw = new QDGraphics(rect)");
            r.exec("pixmap = gw.getPixMap()");
            r.exec("pixsize = pixmap.getPixelSize()");
            r.exec("size = QTImage.getMaxCompressionSize(gw, rect, pixsize, StdQTConstants.codecNormalQuality, StdQTConstants.kAnimationCodecType, CodecComponent.anyCodec)");
            r.exec("imageHandle = new QTHandle(size, true)");
            r.exec("imageHandle.lock()");
            r.exec("compressedImage = RawEncodedImage.fromQTHandle(imageHandle)");
            r.setVar("zero", new Integer(0));
            r.exec("seq = new CSequence(gw, rect, pixsize, StdQTConstants.kAnimationCodecType, CodecComponent.bestFidelityCodec, StdQTConstants.codecNormalQuality, StdQTConstants.codecNormalQuality, numFrames, null, zero)");
            r.exec("desc = seq.getDescription()");
            this.setCurrentFrame(0, buffer, fields);
            r.exec("qid.redraw(null)");
            r.exec("qid.setGWorld(gw)");
            r.exec("qid.setDisplayBounds(rect)");
            int curSample = 0;
            while (curSample < numFrames) {
                this.setCurrentFrame(curSample, buffer, fields);
                r.exec("qid.redraw(null)");
                r.exec("info = seq.compressFrame(gw, rect, StdQTConstants.codecFlagUpdatePrevious, compressedImage)");
                Integer sim = (Integer)r.exec("info.getSimilarity()");
                if (sim == 0) {
                    r.setVar("keyFrame", new Integer(0));
                } else {
                    r.setVar("keyFrame", r.getVar("StdQTConstants.mediaSampleNotSync"));
                }
                r.exec("dataSize = info.getDataSize()");
                r.setVar("one", new Integer(1));
                r.setVar("frameRate", new Integer(60));
                r.exec("vidMedia.addSample(imageHandle, zero, dataSize, frameRate, desc, one, keyFrame)");
                ++curSample;
            }
            r.exec("port = canv.getPort()");
            r.exec("qid.setGWorld(port)");
            r.exec("qid.redraw(null)");
            r.exec("vidMedia.endEdits()");
            r.setVar("kTrackStart", new Integer(0));
            r.setVar("kMediaTime", new Integer(0));
            r.setVar("kMediaRate", new Float(1.0f));
            r.exec("duration = vidMedia.getDuration()");
            r.exec("vidTrack.insertMedia(kTrackStart, kMediaTime, duration, kMediaRate)");
            r.exec("outStream = OpenMovieFile.asWrite(f)");
            r.exec("name = f.getName()");
            r.exec("theMovie.addResource(outStream, StdQTConstants.movieInDataForkResID, name)");
            r.exec("outStream.close()");
            r.exec("QTSession.close()");
        }
        catch (Exception exc) {
            r.exec("QTSession.close()");
            throw new BadFormException("Save movie failed: " + exc.getMessage());
        }
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("QTForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        if (noQT) {
            throw new BadFormException(noQTmsg);
        }
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType time = RealType.getRealType("time");
            FunctionType time_function = new FunctionType(time, fields[0].getType());
            Integer1DSet time_set = new Integer1DSet(nImages);
            FieldImpl time_field = new FieldImpl(time_function, time_set);
            time_field.setSamples(fields, false);
            data = time_field;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("QTForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initFile(id);
        }
        if (block_number < 0 || block_number >= this.numImages) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        if (noQT) {
            throw new BadFormException(noQTmsg);
        }
        r.setVar("time", new Integer(this.timeStep * block_number));
        r.exec("moviePlayer.setTime(time)");
        if (this.needsRedrawing) {
            r.exec("qtip.redraw(null)");
        }
        r.exec("qtip.updateConsumers(null)");
        return DataUtility.makeField(this.img);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initFile(id);
        }
        return this.numImages;
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.current_id == null) {
            return;
        }
        try {
            r.exec("openMovieFile.close()");
            r.exec("QTSession.close()");
        }
        catch (Exception e2) {
            r.exec("QTSession.close()");
            throw new BadFormException("Close movie failed: " + e2.getMessage());
        }
        this.current_id = null;
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private void setCurrentFrame(int frame, BufferedImage buffer, FlatField[] fields) {
        Image img = DataUtility.extractImage(fields[frame], false);
        if (img != null) {
            Graphics g = buffer.getGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
        }
    }

    private void initFile(String id) throws BadFormException, IOException, VisADException {
        if (noQT) {
            throw new BadFormException(noQTmsg);
        }
        this.close();
        try {
            Integer w;
            r.exec("QTSession.open()");
            File file = new File(id);
            r.setVar("path", file.getAbsolutePath());
            r.exec("qtf = new QTFile(path)");
            r.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
            r.exec("m = Movie.fromFile(openMovieFile)");
            int numTracks = (Integer)r.exec("m.getTrackCount()");
            int trackMostLikely = 0;
            int trackNum = 0;
            while (++trackNum <= numTracks && trackMostLikely == 0) {
                r.setVar("trackNum", new Integer(trackNum));
                r.exec("imageTrack = m.getTrack(trackNum)");
                r.exec("d = imageTrack.getSize()");
                w = (Integer)r.exec("d.getWidth()");
                if (w <= 0) continue;
                trackMostLikely = trackNum;
            }
            r.setVar("trackMostLikely", new Integer(trackMostLikely));
            r.exec("imageTrack = m.getTrack(trackMostLikely)");
            r.exec("d = imageTrack.getSize()");
            w = (Integer)r.exec("d.getWidth()");
            Integer h = (Integer)r.exec("d.getHeight()");
            r.exec("seq = ImageUtil.createSequence(imageTrack)");
            this.numImages = (Integer)r.exec("seq.size()");
            r.exec("moviePlayer = new MoviePlayer(m)");
            r.setVar("dim", new Dimension(w, h));
            ImageProducer qtip = (ImageProducer)r.exec("qtip = new QTImageProducer(moviePlayer, dim)");
            this.img = Toolkit.getDefaultToolkit().createImage(qtip);
            this.needsRedrawing = (Boolean)r.exec("qtip.isRedrawing()");
            int maxTime = (Integer)r.exec("m.getDuration()");
            this.timeStep = maxTime / this.numImages;
        }
        catch (Exception e2) {
            r.exec("QTSession.close()");
            throw new BadFormException("Open movie failed: " + e2.getMessage());
        }
        this.current_id = id;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to QuickTime, run:");
            System.out.println("  java visad.data.qt.QTForm in_file out_file");
            System.out.println("To test read a QuickTime file, run:");
            System.out.println("  java visad.data.qt.QTForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            QTForm form = new QTForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            QTForm form = new QTForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
    }
}

