/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.io.TiffDecoder;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class TiffForm
extends Form
implements FormFileInformer,
FormBlockReader,
FormProgressInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"tif", "tiff"};
    private static final String NO_JAI = "This feature requires JAI, available from Sun at http://java.sun.com/products/java-media/jai/";
    private ReflectedUniverse r;
    private boolean noJai = false;
    private String current_id;
    private int numImages;
    private boolean canUseImageJ;
    private double percent;

    public TiffForm() {
        super("TiffForm" + num++);
        try {
            this.r = new ReflectedUniverse();
            this.r.exec("import com.sun.media.jai.codec.ImageDecodeParam");
            this.r.exec("import com.sun.media.jai.codec.ImageDecoder");
            this.r.exec("import com.sun.media.jai.codec.ImageCodec");
        }
        catch (VisADException exc) {
            this.noJai = true;
        }
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < suffixes.length) {
            if (name.toLowerCase().endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s, 0, suffixes.length);
        return s;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        this.percent = 0.0;
        FlatField[] fields = DataUtility.getImageFields(data);
        if (fields == null) {
            throw new BadFormException("Data type must be image or time sequence of images");
        }
        if (fields.length > 1) {
            int len = fields.length;
            ImageProcessor[] ips = new ImageProcessor[len];
            ImageStack is = null;
            int i = 0;
            while (i < len) {
                ips[i] = TiffForm.extractImage(fields[i]);
                if (is == null) {
                    is = new ImageStack(ips[0].getWidth(), ips[0].getHeight(), ips[0].getColorModel());
                }
                is.addSlice("" + i, ips[i]);
                this.percent = (double)(i + 1) / (double)len;
                ++i;
            }
            ImagePlus image = new ImagePlus(id, is);
            FileSaver sav = new FileSaver(image);
            sav.saveAsTiffStack(id);
        } else {
            ImageProcessor ip = TiffForm.extractImage(fields[0]);
            ImagePlus image = new ImagePlus(id, ip);
            FileSaver sav = new FileSaver(image);
            sav.saveAsTiff(id);
        }
        this.percent = -1.0;
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("TiffForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType time = RealType.getRealType("time");
            FunctionType time_function = new FunctionType(time, fields[0].getType());
            Integer1DSet time_set = new Integer1DSet(nImages);
            FieldImpl time_field = new FieldImpl(time_function, time_set);
            time_field.setSamples(fields, false);
            data = time_field;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("TiffForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initFile(id);
        }
        if (block_number < 0 || block_number >= this.numImages) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        Image img = null;
        if (this.canUseImageJ) {
            ImagePlus image = new Opener().openImage(id);
            ImageStack stack = image.getStack();
            ImageProcessor ip = stack.getProcessor(block_number + 1);
            img = ip.createImage();
        } else {
            if (this.noJai) {
                throw new BadFormException(NO_JAI);
            }
            try {
                this.r.setVar("i", new Integer(block_number));
                RenderedImage ri = (RenderedImage)this.r.exec("id.decodeAsRenderedImage(i)");
                WritableRaster wr = ri.copyData(null);
                ColorModel cm = ri.getColorModel();
                img = new BufferedImage(cm, wr, false, null);
            }
            catch (VisADException exc) {
                throw new BadFormException(exc.getMessage());
            }
        }
        return DataUtility.makeField(img);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initFile(id);
        }
        return this.numImages;
    }

    public void close() throws BadFormException, IOException, VisADException {
    }

    public double getPercentComplete() {
        return this.percent;
    }

    public static ImageProcessor extractImage(FlatField field) throws VisADException {
        int i;
        Gridded2DSet set = (Gridded2DSet)field.getDomainSet();
        int[] wh = set.getLengths();
        int w = wh[0];
        int h = wh[1];
        double[][] samples = field.getValues();
        int[] pixels = new int[samples[0].length];
        if (samples.length == 3) {
            i = 0;
            while (i < samples[0].length) {
                int r = (int)samples[0][i] & 0xFF;
                int g = (int)samples[1][i] & 0xFF;
                int b2 = (int)samples[2][i] & 0xFF;
                pixels[i] = r << 16 | g << 8 | b2;
                ++i;
            }
        } else if (samples.length == 1) {
            i = 0;
            while (i < samples[0].length) {
                int v = (int)samples[0][i] & 0xFF;
                pixels[i] = v << 16 | v << 8 | v;
                ++i;
            }
        }
        ColorProcessor cp = new ColorProcessor(w, h, pixels);
        return cp;
    }

    private void initFile(String id) throws BadFormException, IOException, VisADException {
        this.close();
        TiffDecoder tdec = new TiffDecoder("", id);
        this.canUseImageJ = true;
        try {
            FileInfo[] info = tdec.getTiffInfo();
        }
        catch (IOException exc) {
            String msg = exc.getMessage();
            if (msg.startsWith("Unsupported BitsPerSample") || msg.startsWith("Unsupported SamplesPerPixel") || msg.startsWith("ImageJ cannot open compressed TIFF files")) {
                this.canUseImageJ = false;
            }
            throw exc;
        }
        if (this.canUseImageJ) {
            ImagePlus image = new Opener().openImage(id);
            this.numImages = image.getStackSize();
        } else {
            if (this.noJai) {
                throw new BadFormException(NO_JAI);
            }
            try {
                this.r.setVar("tiff", "tiff");
                this.r.setVar("file", new File(id));
                this.r.exec("id = ImageCodec.createImageDecoder(tiff, file, null)");
                Object ni = this.r.exec("id.getNumPages()");
                this.numImages = (Integer)ni;
            }
            catch (VisADException exc) {
                throw new BadFormException(exc.getMessage());
            }
        }
        this.current_id = id;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to TIFF, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file out_file");
            System.out.println("To test read a TIFF file, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            TiffForm form = new TiffForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            TiffForm form = new TiffForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }
}

