/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.Delaunay;
import visad.DelaunayCustom;
import visad.VisADException;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerMatrix;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryDelaunay
implements BinaryObject {
    static /* synthetic */ Class class$visad$DelaunayClarkson;
    static /* synthetic */ Class class$visad$DelaunayCustom;
    static /* synthetic */ Class class$visad$DelaunayFast;
    static /* synthetic */ Class class$visad$DelaunayOverlap;
    static /* synthetic */ Class class$visad$DelaunayWatson;

    public static final int computeBytes(Delaunay d2) {
        if (!BinaryDelaunay.isKnownClass(d2)) {
            return BinarySerializedObject.computeBytes(d2);
        }
        return 2 + BinaryIntegerMatrix.computeBytes(d2.Tri) + 1 + BinaryIntegerMatrix.computeBytes(d2.Vertices) + 1 + BinaryIntegerMatrix.computeBytes(d2.Walk) + 1 + BinaryIntegerMatrix.computeBytes(d2.Edges) + 6;
    }

    public static final Delaunay read(DataInput file) throws IOException, VisADException {
        int[][] tri = null;
        int[][] verts = null;
        int[][] walk = null;
        int[][] edges = null;
        int numEdges = -1;
        boolean reading = true;
        while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 61: {
                    tri = BinaryIntegerMatrix.read(file);
                    break;
                }
                case 62: {
                    verts = BinaryIntegerMatrix.read(file);
                    break;
                }
                case 63: {
                    walk = BinaryIntegerMatrix.read(file);
                    break;
                }
                case 64: {
                    edges = BinaryIntegerMatrix.read(file);
                    break;
                }
                case 65: {
                    numEdges = file.readInt();
                    break;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown Delaunay directive " + directive);
                }
            }
        }
        return new DelaunayCustom(null, tri, verts, walk, edges, numEdges);
    }

    private static final boolean isKnownClass(Delaunay delaunay) {
        Class<?> dClass = delaunay.getClass();
        return dClass.equals(class$visad$DelaunayClarkson == null ? (class$visad$DelaunayClarkson = BinaryDelaunay.class$("visad.DelaunayClarkson")) : class$visad$DelaunayClarkson) || dClass.equals(class$visad$DelaunayCustom == null ? (class$visad$DelaunayCustom = BinaryDelaunay.class$("visad.DelaunayCustom")) : class$visad$DelaunayCustom) || dClass.equals(class$visad$DelaunayFast == null ? (class$visad$DelaunayFast = BinaryDelaunay.class$("visad.DelaunayFast")) : class$visad$DelaunayFast) || dClass.equals(class$visad$DelaunayOverlap == null ? (class$visad$DelaunayOverlap = BinaryDelaunay.class$("visad.DelaunayOverlap")) : class$visad$DelaunayOverlap) || dClass.equals(class$visad$DelaunayWatson == null ? (class$visad$DelaunayWatson = BinaryDelaunay.class$("visad.DelaunayWatson")) : class$visad$DelaunayWatson);
    }

    public static final void write(BinaryWriter writer, Delaunay delaunay, Object token) throws IOException {
        if (!BinaryDelaunay.isKnownClass(delaunay)) {
            BinarySerializedObject.write(writer, (byte)21, delaunay, token);
            return;
        }
        DataOutput file = writer.getOutput();
        file.writeByte(60);
        file.writeByte(61);
        BinaryIntegerMatrix.write(file, delaunay.Tri);
        file.writeByte(62);
        BinaryIntegerMatrix.write(file, delaunay.Vertices);
        file.writeByte(63);
        BinaryIntegerMatrix.write(file, delaunay.Walk);
        file.writeByte(64);
        BinaryIntegerMatrix.write(file, delaunay.Edges);
        file.writeByte(65);
        file.writeInt(delaunay.NumEdges);
        file.writeByte(80);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

