/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryIntegerArray
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    public static final int computeBytes(int[] array) {
        return array == null ? 0 : 4 + array.length * 4;
    }

    public static final int computeBytes(Object[] array) {
        if (array != null) {
            boolean empty = true;
            int i = 0;
            while (i < array.length) {
                if (array[i] != null) {
                    empty = false;
                    break;
                }
                ++i;
            }
            if (empty) {
                array = null;
            }
        }
        return array == null ? 0 : 4 + array.length * 4;
    }

    public static final int[] read(BinaryReader reader) throws IOException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad double array length " + len + ")");
        }
        int[] array = new int[len];
        int i = 0;
        while (i < len) {
            array[i] = file.readInt();
            ++i;
        }
        return array;
    }

    public static final void write(BinaryWriter writer, int[] array, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        byte[] buf = new byte[BinaryIntegerArray.computeBytes(array)];
        int bufIdx = 0;
        int b2 = 3;
        int l = array.length;
        while (b2 >= 0) {
            buf[bufIdx + b2] = (byte)(l & 0xFF);
            l >>= 8;
            --b2;
        }
        bufIdx += 4;
        int i = 0;
        while (i < array.length) {
            int x = array[i];
            int b3 = 3;
            while (b3 >= 0) {
                buf[bufIdx + b3] = (byte)(x & 0xFF);
                x >>= 8;
                --b3;
            }
            bufIdx += 4;
            ++i;
        }
        if (bufIdx < buf.length) {
            System.err.println("BinaryIntegerArray: Missing " + (buf.length - bufIdx) + " bytes");
        }
        file.write(buf);
    }
}

