/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.Data;
import visad.Field;
import visad.FieldImpl;
import visad.Function;
import visad.Real;
import visad.RealType;
import visad.TupleIface;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaVar;
import visad.formula.VMethod;
import visad.formula.VRealType;

public class FormulaUtil {
    private static int linkNum = 0;

    public static FormulaManager createStandardManager() {
        FormulaManager f;
        String[] binOps = new String[]{".", "^", "*", "/", "%", "+", "-"};
        int[] binPrec = new int[]{200, 400, 600, 600, 600, 800, 800};
        String[] binMethods = new String[]{"visad.formula.FormulaUtil.dot(visad.TupleIface, visad.Real)", "visad.Data.pow(visad.Data)", "visad.Data.multiply(visad.Data)", "visad.Data.divide(visad.Data)", "visad.Data.remainder(visad.Data)", "visad.Data.add(visad.Data)", "visad.Data.subtract(visad.Data)"};
        String[] unaryOps = new String[]{"-"};
        int[] unaryPrec = new int[]{500};
        String[] unaryMethods = new String[]{"visad.Data.negate()"};
        String[] functions = new String[]{"abs", "acos", "acosDegrees", "asin", "asinDegrees", "atan", "atan2", "atanDegrees", "atan2Degrees", "ceil", "combine", "cos", "cosDegrees", "derive", "domainMultiply", "domainFactor", "exp", "extract", "floor", "getSample", "linkx", "log", "max", "min", "negate", "rint", "round", "sin", "sinDegrees", "sqrt", "tan", "tanDegrees"};
        String[] funcMethods = new String[]{"visad.Data.abs()", "visad.Data.acos()", "visad.Data.acosDegrees()", "visad.Data.asin()", "visad.Data.asinDegrees()", "visad.Data.atan()", "visad.Data.atan2(visad.Data)", "visad.Data.atanDegrees()", "visad.Data.atan2Degrees(visad.Data)", "visad.Data.ceil()", "visad.FieldImpl.combine(visad.Field[])", "visad.Data.cos()", "visad.Data.cosDegrees()", "visad.formula.FormulaUtil.derive(visad.Function, visad.formula.VRealType)", "visad.FieldImpl.domainMultiply()", "visad.formula.FormulaUtil.factor(visad.FieldImpl, visad.formula.VRealType)", "visad.Data.exp()", "visad.formula.FormulaUtil.extract(visad.Field, visad.Real)", "visad.Data.floor()", "visad.formula.FormulaUtil.brackets(visad.Field, visad.Real)", "visad.formula.FormulaUtil.link(visad.formula.VMethod, java.lang.Object[])", "visad.Data.log()", "visad.Data.max(visad.Data)", "visad.Data.min(visad.Data)", "visad.Data.negate()", "visad.Data.rint()", "visad.Data.round()", "visad.Data.sin()", "visad.Data.sinDegrees()", "visad.Data.sqrt()", "visad.Data.tan()", "visad.Data.tanDegrees()"};
        int implicitPrec = 200;
        String[] implicitMethods = new String[]{"visad.formula.FormulaUtil.implicit(visad.Function, visad.Real)", "visad.Function.evaluate(visad.RealTuple)"};
        String preParseMethod = "visad.formula.FormulaUtil.preParse(java.lang.String, visad.formula.FormulaManager)";
        try {
            f = new FormulaManager(binOps, binPrec, binMethods, unaryOps, unaryPrec, unaryMethods, functions, funcMethods, implicitPrec, implicitMethods, preParseMethod);
        }
        catch (FormulaException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            return null;
        }
        return f;
    }

    public static Data dot(TupleIface t2, Real r) {
        Data d2;
        block4: {
            d2 = null;
            try {
                d2 = t2.getComponent((int)r.getValue());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return d2;
    }

    public static Data derive(Function f, VRealType rt) {
        Function val;
        block4: {
            val = null;
            try {
                val = f.derivative(rt.getRealType(), 202);
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return val;
    }

    public static Field factor(FieldImpl f, VRealType rt) {
        Field val;
        block4: {
            val = null;
            try {
                val = f.domainFactor(rt.getRealType());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return val;
    }

    public static Data extract(Field f, Real r) {
        Field d2;
        block4: {
            d2 = null;
            try {
                d2 = f.extract((int)r.getValue());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return d2;
    }

    public static Data link(VMethod m, Object[] o) throws VisADException {
        Data ans = null;
        if (o != null) {
            int i = 0;
            while (i < o.length) {
                if (o[i] instanceof VRealType) {
                    o[i] = ((VRealType)o[i]).getRealType();
                }
                ++i;
            }
        }
        try {
            ans = (Data)FormulaUtil.invokeMethod(m.getMethod(), o);
        }
        catch (ClassCastException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            throw new VisADException("Link error: invalid linked method");
        }
        catch (IllegalAccessException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            throw new VisADException("Link error: cannot access linked method");
        }
        catch (IllegalArgumentException exc) {
            if (FormulaVar.DEBUG) {
                exc.printStackTrace();
            }
            throw new VisADException("Link error: bad method argument");
        }
        catch (InvocationTargetException exc) {
            if (FormulaVar.DEBUG) {
                exc.getTargetException().printStackTrace();
            }
            throw new VisADException("Link error: linked method threw an exception");
        }
        if (ans == null) {
            throw new VisADException("Link error: linked method returned null data");
        }
        return ans;
    }

    public static Data implicit(Function f, Real r) {
        Data value;
        block4: {
            value = null;
            try {
                value = f.evaluate(r);
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return value;
    }

    public static Data brackets(Field f, Real r) {
        Data value;
        block4: {
            value = null;
            try {
                RealType rt = (RealType)r.getType();
                value = f.getSample((int)r.getValue());
            }
            catch (VisADException exc) {
                if (FormulaVar.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!FormulaVar.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
        return value;
    }

    public static String preParse(String f, FormulaManager fm) {
        String os;
        StringTokenizer t2 = new StringTokenizer(f, " ", false);
        String s = "";
        while (t2.hasMoreTokens()) {
            s = s + t2.nextToken();
        }
        if (s.equals("")) {
            return s;
        }
        while (!(s = FormulaUtil.preParseOnce(os = s, fm)).equals(os)) {
        }
        return s;
    }

    private static String preParseOnce(String s, FormulaManager fm) {
        String l = s.toLowerCase();
        int len = l.length();
        boolean letter = false;
        String ns = "";
        int i = 0;
        while (i < len) {
            int paren;
            int s1;
            if (!letter && i < len - 1 && l.substring(i, i + 2).equals("d(")) {
                s1 = i += 2;
                int paren2 = 1;
                while (paren2 > 0) {
                    if (i >= len) {
                        return s;
                    }
                    char c2 = l.charAt(i);
                    if (c2 == '(') {
                        ++paren2;
                    }
                    if (c2 == ')') {
                        --paren2;
                    }
                    ++i;
                }
                int e1 = i - 1;
                if (i > len - 3 || !l.substring(i, i + 3).equals("/d(")) {
                    return s;
                }
                int s2 = i += 3;
                int paren3 = 1;
                while (paren3 > 0) {
                    if (i >= len) {
                        return s;
                    }
                    char c3 = l.charAt(i);
                    if (c3 == '(') {
                        ++paren3;
                    }
                    if (c3 == ')') {
                        --paren3;
                    }
                    ++i;
                }
                int e2 = i - 1;
                ns = ns + "derive(" + s.substring(s1, e1) + "," + s.substring(s2, e2) + ")";
                --i;
            } else if (!letter && i < len - 4 && l.substring(i, i + 5).equals("link(")) {
                String prestr;
                s1 = i += 5;
                try {
                    while (l.charAt(i) != '(') {
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    return s;
                }
                int e1 = ++i - 1;
                int s2 = i;
                paren = 2;
                while (paren > 1) {
                    if (i >= len) {
                        return s;
                    }
                    char c4 = l.charAt(i);
                    if (c4 == '(') {
                        ++paren;
                    }
                    if (c4 == ')') {
                        --paren;
                    }
                    ++i;
                }
                int e2 = i - 1;
                if (i >= len || l.charAt(i) != ')') {
                    return s;
                }
                String str = prestr = s.substring(s1, e1) + "(";
                String sub = s.substring(s2, e2);
                StringTokenizer st = new StringTokenizer(sub, ",", false);
                boolean first = true;
                Vector<String> v = new Vector<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (first) {
                        first = false;
                    } else {
                        str = str + ",";
                    }
                    RealType rt = RealType.getRealTypeByName(token);
                    String sv = rt == null ? "visad.Data" : "visad.RealType";
                    v.add(sv);
                    str = str + sv;
                }
                Method[] meths = FormulaUtil.stringsToMethods(new String[]{str = str + ")"});
                if (meths[0] == null) {
                    int vlen = v.size();
                    Vector<String> vstrs = new Vector<String>();
                    int iv = 0;
                    while (iv < vlen) {
                        String si = (String)v.elementAt(iv);
                        int lv = iv;
                        while (lv < vlen) {
                            String sl;
                            if (!(sl = (String)v.elementAt(lv++)).equals(si)) break;
                            str = prestr;
                            first = true;
                            int j = 0;
                            while (j < vlen) {
                                if (first) {
                                    first = false;
                                } else {
                                    str = str + ",";
                                }
                                String sj = (String)v.elementAt(j);
                                str = str + sj;
                                if (iv == j) {
                                    str = str + "[]";
                                    j = lv - 1;
                                }
                                ++j;
                            }
                            str = str + ")";
                            vstrs.add(str);
                        }
                        ++iv;
                    }
                    String[] strlist = new String[vstrs.size()];
                    vstrs.toArray(strlist);
                    meths = FormulaUtil.stringsToMethods(strlist);
                    int found = -1;
                    int j = 0;
                    while (j < meths.length && found < 0) {
                        if (meths[j] != null) {
                            found = j;
                        }
                        ++j;
                    }
                    if (found >= 0) {
                        meths[0] = meths[found];
                    } else {
                        return s;
                    }
                }
                String link = "link" + ++linkNum;
                try {
                    fm.setThing(link, new VMethod(meths[0]));
                }
                catch (FormulaException exc) {
                    return s;
                }
                catch (VisADException exc) {
                    return s;
                }
                catch (RemoteException exc) {
                    return s;
                }
                ns = ns + "linkx(" + link + "," + s.substring(s2, e2) + ")";
            } else if (!letter) {
                int j = i;
                char c5 = l.charAt(j++);
                while (j < len && (c5 >= 'a' && c5 <= 'z' || c5 >= '0' && c5 <= '9')) {
                    c5 = l.charAt(j++);
                }
                if (j == len) {
                    return ns + s.substring(i, len);
                }
                if (c5 == '[') {
                    int k = j;
                    paren = 1;
                    while (paren > 0) {
                        if (k >= len) {
                            return s;
                        }
                        c5 = l.charAt(k);
                        if (c5 == '[') {
                            ++paren;
                        }
                        if (c5 == ']') {
                            --paren;
                        }
                        ++k;
                    }
                    ns = ns + "getSample(" + s.substring(i, j - 1) + "," + s.substring(j, k - 1) + ")";
                    i = k - 1;
                } else {
                    ns = ns + s.charAt(i);
                }
            } else {
                ns = ns + s.charAt(i);
            }
            char c6 = i < len ? l.charAt(i) : (char)'\u0000';
            letter = c6 >= 'a' && c6 <= 'z';
            ++i;
        }
        return ns;
    }

    public static Method[] stringsToMethods(String[] strings) {
        int len = strings.length;
        Method[] methods = new Method[len];
        int j = 0;
        while (j < len) {
            block16: {
                StringTokenizer t2 = new StringTokenizer(strings[j], " ", false);
                String s = "";
                while (t2.hasMoreTokens()) {
                    s = s + t2.nextToken();
                }
                t2 = new StringTokenizer(s, "(", false);
                String pre = t2.nextToken();
                String post = t2.nextToken();
                t2 = new StringTokenizer(pre, ".", false);
                String c2 = t2.nextToken();
                int count = t2.countTokens();
                int i = 0;
                while (i < count - 1) {
                    c2 = c2 + "." + t2.nextToken();
                    ++i;
                }
                String m = t2.nextToken();
                t2 = new StringTokenizer(post, ",)", false);
                count = t2.countTokens();
                String[] a2 = count == 0 ? null : new String[count];
                int x = 0;
                while (t2.hasMoreTokens()) {
                    a2[x++] = t2.nextToken();
                }
                Class<?> clas = null;
                try {
                    clas = Class.forName(c2);
                }
                catch (ClassNotFoundException exc) {
                    if (FormulaVar.DEBUG) {
                        System.out.println("ERROR: Class " + c2 + " does not exist!");
                    }
                    methods[j] = null;
                    break block16;
                }
                Class[] param = a2 == null ? null : new Class[a2.length];
                int i2 = 0;
                while (i2 < count) {
                    if (a2[i2].endsWith("[]")) {
                        a2[i2] = "[L" + a2[i2].substring(0, a2[i2].length() - 2);
                        while (a2[i2].endsWith("[]")) {
                            a2[i2] = "[" + a2[i2].substring(0, a2[i2].length() - 2);
                        }
                        a2[i2] = a2[i2] + ";";
                    }
                    try {
                        param[i2] = Class.forName(a2[i2]);
                    }
                    catch (ClassNotFoundException exc) {
                        if (FormulaVar.DEBUG) {
                            System.out.println("ERROR: Class " + a2[i2] + " (" + i2 + ") does not exist!");
                        }
                        methods[j] = null;
                    }
                    ++i2;
                }
                Method method = null;
                try {
                    method = clas.getMethod(m, param);
                }
                catch (NoSuchMethodException exc) {
                    if (FormulaVar.DEBUG) {
                        System.out.println("ERROR: Method " + m + " does not exist!");
                    }
                    methods[j] = null;
                    break block16;
                }
                methods[j] = method;
            }
            ++j;
        }
        return methods;
    }

    public static Object invokeMethod(Method m, Object[] o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] args;
        Object obj;
        Class<?>[] c2 = m.getParameterTypes();
        int num = o == null ? 0 : o.length;
        int len = -1;
        int a2 = -1;
        if (c2 != null) {
            len = c2.length;
            int i = 0;
            while (i < len) {
                if (c2[i].isArray()) {
                    a2 = i;
                }
                ++i;
            }
        }
        if (Modifier.isStatic(m.getModifiers())) {
            obj = null;
            if (num > 0) {
                if (a2 < 0) {
                    args = new Object[num];
                    System.arraycopy(o, 0, args, 0, num);
                } else {
                    args = new Object[len];
                    if (a2 > 0) {
                        System.arraycopy(o, 0, args, 0, a2);
                    }
                    Object array = Array.newInstance(c2[a2].getComponentType(), num - len + 1);
                    System.arraycopy(o, a2, array, 0, num - len + 1);
                    args[a2] = array;
                    if (a2 < len - 1) {
                        System.arraycopy(o, num - len + a2 + 1, args, a2 + 1, len - a2 - 1);
                    }
                }
            } else {
                args = null;
            }
        } else {
            if (num <= 0) {
                return null;
            }
            obj = o[0];
            if (num > 1) {
                if (a2 < 0) {
                    args = new Object[num - 1];
                    System.arraycopy(o, 1, args, 0, num - 1);
                } else {
                    args = new Object[len];
                    if (a2 > 0) {
                        System.arraycopy(o, 1, args, 0, a2);
                    }
                    Object array = Array.newInstance(c2[a2].getComponentType(), num - len);
                    System.arraycopy(o, a2 + 1, array, 0, num - len);
                    args[a2 + 1] = array;
                    if (a2 < len - 1) {
                        System.arraycopy(o, num - len + a2 + 1, args, a2 + 1, len - a2 - 1);
                    }
                }
            } else {
                args = null;
            }
        }
        return m.invoke(obj, args);
    }
}

