/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.awt.geom.Rectangle2D;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;

public abstract class MapProjection
extends NavigatedCoordinateSystem {
    public MapProjection(RealTupleType reference, Unit[] units) throws VisADException {
        super(reference, units);
        if (!reference.equals(RealTupleType.LatitudeLongitudeTuple) && !reference.equals(RealTupleType.SpatialEarth2DTuple)) {
            throw new CoordinateSystemException("MapProjection: Reference must be LatitudeLongitudeTuple or SpatialEarth2DTuple");
        }
    }

    public abstract Rectangle2D getDefaultMapArea();

    public boolean isXYOrder() {
        return true;
    }

    public boolean isLatLonOrder() {
        return this.getLatitudeIndex() == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MapProjection: \n");
        buf.append("  Reference = ");
        buf.append(this.getReference());
        buf.append("\n");
        buf.append("  DefaultMapArea = ");
        buf.append(this.getDefaultMapArea());
        return buf.toString();
    }
}

