/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.Data;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.NamedLocation;

public class NamedLocationTuple
extends Tuple
implements NamedLocation {
    public static TextType IDENTIFIER_TYPE;

    public NamedLocationTuple() throws VisADException, RemoteException {
        this("", Double.NaN, Double.NaN, Double.NaN);
    }

    public NamedLocationTuple(Text id, Real lat, Real lon, Real alt) throws VisADException, RemoteException {
        this(id, (EarthLocation)new EarthLocationTuple(lat, lon, alt));
    }

    public NamedLocationTuple(Text identifier, EarthLocation location) throws VisADException, RemoteException {
        super(new TupleType(new MathType[]{IDENTIFIER_TYPE, RealTupleType.LatitudeLongitudeAltitude}), new Data[]{identifier, new EarthLocationTuple(location.getLatitude(), location.getLongitude(), location.getAltitude())});
    }

    public NamedLocationTuple(String id, double lat, double lon, double alt) throws VisADException, RemoteException {
        this(new Text(IDENTIFIER_TYPE, id), (EarthLocation)new EarthLocationTuple(lat, lon, alt));
    }

    public NamedLocationTuple(String id, EarthLocation location) throws VisADException, RemoteException {
        this(new Text(IDENTIFIER_TYPE, id), location);
    }

    public Real getLatitude() {
        return this.getEarthLocation().getLatitude();
    }

    public Real getLongitude() {
        return this.getEarthLocation().getLongitude();
    }

    public Real getAltitude() {
        return this.getEarthLocation().getAltitude();
    }

    public LatLonPoint getLatLonPoint() {
        return this.getEarthLocation().getLatLonPoint();
    }

    public EarthLocation getEarthLocation() {
        try {
            return (EarthLocationTuple)this.getComponent(1);
        }
        catch (Exception ex) {
            throw new RuntimeException("Assertion failure");
        }
    }

    public Text getIdentifier() {
        try {
            return (Text)this.getComponent(0);
        }
        catch (Exception ex) {
            throw new RuntimeException("Assertion failure");
        }
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Assertion failure");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name: ");
        buf.append(this.getIdentifier().toString());
        buf.append(" ");
        buf.append(this.getEarthLocation().toString());
        return buf.toString();
    }

    static {
        try {
            IDENTIFIER_TYPE = TextType.getTextType("Identifier");
        }
        catch (Exception e2) {
            System.err.println("NamedLocationTuple: Can't instatiate type");
        }
    }
}

