/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JPanel;
import visad.MouseHelper;
import visad.ProjectionControl;
import visad.VisADAppearance;
import visad.VisADError;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADSceneGraphObject;
import visad.VisADSwitch;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.java2d.AnimationControlJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java2d.MouseBehaviorJ2D;
import visad.util.Delay;

public class VisADCanvasJ2D
extends JPanel
implements Runnable {
    private float[][] LINE_PATTERN = new float[][]{null, {8.0f}, {1.0f, 7.0f}, {7.0f, 4.0f, 1.0f, 4.0f}};
    private DisplayRendererJ2D displayRenderer;
    private DisplayImplJ2D display;
    private Component component;
    Dimension prefSize = new Dimension(0, 0);
    private VisADGroup direct = null;
    private VisADGroup non_direct = null;
    private Rectangle2D.Float clip_rectangle = null;
    private transient Thread renderThread;
    private BufferedImage[] images;
    private boolean[] valid_images;
    private int width;
    private int height;
    private int length;
    private AffineTransform tgeometry;
    private Image aux_image;
    boolean captureFlag = false;
    BufferedImage captureImage = null;
    MouseHelper helper;
    boolean wakeup = false;
    boolean timeout = false;
    private boolean autoAspect = false;
    static /* synthetic */ Class class$visad$java2d$AnimationControlJ2D;

    public VisADCanvasJ2D(DisplayRendererJ2D renderer, Component c2) {
        this.displayRenderer = renderer;
        this.display = (DisplayImplJ2D)renderer.getDisplay();
        this.component = c2;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        if (this.width <= 0) {
            this.width = 1;
        }
        if (this.height <= 0) {
            this.height = 1;
        }
        this.length = 1;
        this.images = new BufferedImage[]{(BufferedImage)this.createImage(this.width, this.height)};
        this.aux_image = this.createImage(this.width, this.height);
        this.valid_images = new boolean[]{false};
        int w = this.width;
        int h = this.height;
        AffineTransform trans = this.displayRenderer.getTrans();
        this.tgeometry = new AffineTransform();
        this.tgeometry.setToTranslation(0.5 * (double)w, 0.5 * (double)h);
        AffineTransform s1 = new AffineTransform();
        int wh = w < h ? w : h;
        s1.setToScale(0.33 * (double)wh, 0.33 * (double)wh);
        this.tgeometry.concatenate(s1);
        this.tgeometry.concatenate(trans);
        ComponentAdapter cl = new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                VisADCanvasJ2D.this.createImages(-1);
            }
        };
        this.addComponentListener(cl);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        new Delay();
        if (this.images[0] == null) {
            this.images = new BufferedImage[]{(BufferedImage)this.createImage(this.width, this.height)};
            this.aux_image = this.createImage(this.width, this.height);
            this.valid_images = new boolean[]{false};
        }
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public VisADCanvasJ2D(DisplayRendererJ2D renderer, int w, int h) {
        this.displayRenderer = renderer;
        this.display = (DisplayImplJ2D)renderer.getDisplay();
        this.component = null;
        this.width = w;
        this.height = h;
        this.length = 1;
        this.images = new BufferedImage[]{new BufferedImage(this.width, this.height, 1)};
        this.aux_image = new BufferedImage(this.width, this.height, 1);
        this.valid_images = new boolean[]{false};
        AffineTransform trans = this.displayRenderer.getTrans();
        this.tgeometry = new AffineTransform();
        this.tgeometry.setToTranslation(0.5 * (double)w, 0.5 * (double)h);
        AffineTransform s1 = new AffineTransform();
        int wh = w < h ? w : h;
        s1.setToScale(0.33 * (double)wh, 0.33 * (double)wh);
        this.tgeometry.concatenate(s1);
        this.tgeometry.concatenate(trans);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public float[] getBackgroundColor() {
        Color color = this.getBackground();
        float[] list = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        return list;
    }

    public void setBackgroundColor(float r, float g, float b2) {
        this.setBackground(new Color(r, g, b2));
    }

    void setDirect(VisADGroup d2, VisADGroup nd) {
        this.direct = d2;
        this.non_direct = nd;
    }

    void setClip(float xlow, float xhi, float ylow, float yhi) {
        if (xhi > xlow && yhi > ylow) {
            this.clip_rectangle = new Rectangle2D.Float(xlow, ylow, xhi - xlow, yhi - ylow);
        }
    }

    void unsetClip() {
        this.clip_rectangle = null;
    }

    public void addMouseBehavior(MouseBehaviorJ2D mouse) {
        this.helper = mouse.getMouseHelper();
        MouseAdapter ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e2) {
                VisADCanvasJ2D.this.helper.processEvent(e2);
            }

            public void mouseExited(MouseEvent e2) {
                VisADCanvasJ2D.this.helper.processEvent(e2);
            }

            public void mousePressed(MouseEvent e2) {
                VisADCanvasJ2D.this.helper.processEvent(e2);
            }

            public void mouseReleased(MouseEvent e2) {
                VisADCanvasJ2D.this.helper.processEvent(e2);
            }

            public void mouseClicked(MouseEvent e2) {
                VisADCanvasJ2D.this.requestFocus();
            }
        };
        this.addMouseListener(ml);
        MouseMotionAdapter mml = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e2) {
                VisADCanvasJ2D.this.helper.processEvent(e2);
            }

            public void mouseMoved(MouseEvent e2) {
                VisADCanvasJ2D.this.helper.processEvent(e2);
            }
        };
        this.addMouseMotionListener(mml);
    }

    public void addKeyboardBehavior(final KeyboardBehaviorJ2D behavior) {
        KeyAdapter kl = new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                behavior.processKeyEvent(e2);
            }

            public void keyReleased(KeyEvent e2) {
                behavior.processKeyEvent(e2);
            }
        };
        this.addKeyListener(kl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createImages(int len) {
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (this.images) {
            int n = this.length = len < 0 ? this.images.length : len;
            if (this.component != null) {
                this.width = this.getSize().width;
                this.height = this.getSize().height;
            }
            if (this.width <= 0) {
                this.width = 1;
            }
            if (this.height <= 0) {
                this.height = 1;
            }
            BufferedImage[] new_images = new BufferedImage[this.length];
            boolean[] new_valid_images = new boolean[this.length];
            int i = 0;
            while (i < this.length) {
                new_images[i] = this.component != null ? (BufferedImage)this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 1);
                new_valid_images[i] = false;
                ++i;
            }
            if (this.aux_image != null) {
                this.aux_image.flush();
            }
            this.aux_image = this.component != null ? this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 1);
            this.valid_images = new_valid_images;
            if (this.images != null) {
                int i2 = 0;
                while (i2 < this.images.length) {
                    if (this.images[i2] != null) {
                        this.images[i2].flush();
                    }
                    ++i2;
                }
            }
            this.images = new_images;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.renderTrigger();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scratchImages() {
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (this.images) {
            int i = 0;
            while (i < this.length) {
                this.valid_images[i] = false;
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.renderTrigger();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTrigger() {
        VisADCanvasJ2D visADCanvasJ2D = this;
        synchronized (visADCanvasJ2D) {
            this.wakeup = true;
            this.notify();
        }
    }

    public void stop() {
        this.renderThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        while (this.renderThread == me) {
            Object g;
            this.timeout = false;
            if (this.component != null) {
                g = this.getGraphics();
                if (g != null) {
                    this.repaint();
                    ((Graphics)g).dispose();
                }
            } else {
                this.paintComponent(null);
            }
            try {
                g = this;
                synchronized (g) {
                    if (!this.wakeup) {
                        if (this.timeout) {
                            this.wait(1000L);
                        } else {
                            this.wait();
                        }
                    }
                }
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            VisADCanvasJ2D visADCanvasJ2D = this;
            synchronized (visADCanvasJ2D) {
                this.wakeup = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void paintComponent(Graphics g) {
        AnimationControlJ2D animate_control;
        block34: {
            block31: {
                block33: {
                    BufferedImage[] trans;
                    int h;
                    int w;
                    BufferedImage image;
                    AffineTransform tsave;
                    block32: {
                        int current_image;
                        boolean valid;
                        block30: {
                            tsave = null;
                            image = null;
                            valid = false;
                            w = 0;
                            h = 0;
                            current_image = 0;
                            animate_control = null;
                            try {
                                animate_control = (AnimationControlJ2D)this.display.getControl(class$visad$java2d$AnimationControlJ2D == null ? (class$visad$java2d$AnimationControlJ2D = VisADCanvasJ2D.class$("visad.java2d.AnimationControlJ2D")) : class$visad$java2d$AnimationControlJ2D);
                                if (animate_control != null) {
                                    animate_control.setNoTick(true);
                                    current_image = animate_control.getCurrent();
                                }
                            }
                            catch (Exception e2) {
                                if (animate_control == null) break block30;
                                animate_control.setNoTick(false);
                            }
                        }
                        BufferedImage[] bufferedImageArray = this.images;
                        // MONITORENTER : this.images
                        if (0 <= current_image && current_image < this.length) {
                            image = this.images[current_image];
                            if (image == null) {
                                this.createImages(-1);
                                image = this.images[current_image];
                            }
                            valid = this.valid_images[current_image];
                            w = this.width;
                            h = this.height;
                            AffineTransform affineTransform = tsave = this.tgeometry == null ? null : new AffineTransform(this.tgeometry);
                            if (image != null && !valid) {
                                this.valid_images[current_image] = true;
                            }
                        }
                        // MONITOREXIT : bufferedImageArray
                        this.timeout = false;
                        if (image == null) break block31;
                        if (!valid) {
                            VisADGroup root = this.displayRenderer.getRoot();
                            trans = this.displayRenderer.getTrans();
                            Graphics2D ggg = image.createGraphics();
                            Graphics2D g2 = image.createGraphics();
                            g2.setBackground(this.getBackground());
                            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                            g2.clearRect(0, 0, this.width, this.height);
                            BufferedImage[] bufferedImageArray2 = this.images;
                            // MONITORENTER : this.images
                            this.tgeometry = new AffineTransform();
                            this.tgeometry.setToTranslation(0.5 * (double)w, 0.5 * (double)h);
                            AffineTransform s1 = new AffineTransform();
                            int wh = w < h ? w : h;
                            s1.setToScale(0.33 * (double)wh, 0.33 * (double)wh);
                            this.tgeometry.concatenate(s1);
                            this.tgeometry.concatenate((AffineTransform)trans);
                            tsave = new AffineTransform(this.tgeometry);
                            g2.setTransform(this.tgeometry);
                            // MONITOREXIT : bufferedImageArray2
                            try {
                                if (animate_control != null) {
                                    animate_control.init();
                                }
                                this.render(g2, ggg, root, 0, null);
                                this.render(g2, ggg, root, 1, null);
                                String[] animation_string = this.displayRenderer.getAnimationString();
                                if (animation_string[0] != null) {
                                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    g2.setFont(new Font("Times New Roman", 0, 12));
                                    g2.setTransform(new AffineTransform());
                                    try {
                                        int nchars = animation_string[0].length();
                                        if (nchars < 12) {
                                            nchars = 12;
                                        }
                                        float x = w - 7 * nchars;
                                        float y = h - 12;
                                        g2.drawString(animation_string[0], x, y);
                                        g2.drawString(animation_string[1], x, y + 10.0f);
                                    }
                                    catch (NullPointerException e3) {}
                                }
                            }
                            catch (VisADException e4) {
                                // empty catch block
                            }
                            g2.dispose();
                            ggg.dispose();
                        }
                        if (tsave != null && this.displayRenderer.anyCursorStringVector()) break block32;
                        if (g != null) {
                            g.drawImage(image, 0, 0, this);
                        }
                        if (!this.captureFlag && !this.display.hasSlaves()) break block33;
                        this.captureFlag = false;
                        this.captureImage = this.component != null ? (BufferedImage)this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 1);
                        if (this.captureImage != null) {
                            Graphics gc = this.captureImage.getGraphics();
                            gc.drawImage(image, 0, 0, this);
                            gc.dispose();
                            this.captureImage.flush();
                            this.displayRenderer.notifyCapture();
                            if (this.display.hasSlaves()) {
                                this.display.updateSlaves(this.captureImage);
                            }
                        }
                        break block33;
                    }
                    Image aux_copy = null;
                    trans = this.images;
                    // MONITORENTER : this.images
                    if (this.aux_image == null) {
                        // MONITOREXIT : trans
                        return;
                    }
                    aux_copy = this.aux_image;
                    // MONITOREXIT : trans
                    Graphics ga = aux_copy.getGraphics();
                    ga.drawImage(image, 0, 0, this);
                    this.displayRenderer.drawCursorStringVector(ga, tsave, w, h);
                    ga.dispose();
                    if (g != null) {
                        g.drawImage(aux_copy, 0, 0, this);
                    }
                    if (this.captureFlag || this.display.hasSlaves()) {
                        this.captureFlag = false;
                        this.captureImage = this.component != null ? (BufferedImage)this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 1);
                        Graphics gc = this.captureImage.getGraphics();
                        gc.drawImage(aux_copy, 0, 0, this);
                        gc.dispose();
                        this.captureImage.flush();
                        this.displayRenderer.notifyCapture();
                        if (this.display.hasSlaves()) {
                            this.display.updateSlaves(this.captureImage);
                        }
                    }
                }
                try {
                    this.display.notifyListeners(3, 0, 0);
                }
                catch (VisADException e5) {
                }
                catch (RemoteException e6) {}
                break block34;
            }
            this.timeout = true;
        }
        if (animate_control == null) return;
        animate_control.setNoTick(false);
    }

    private void render(Graphics2D g2, Graphics ggg, VisADSceneGraphObject scene, int pass, Rectangle2D.Float clip) throws VisADException {
        if (scene == null) {
            return;
        }
        if (scene instanceof VisADSwitch) {
            VisADSceneGraphObject child = ((VisADSwitch)scene).getSelectedChild();
            if (child != null) {
                this.render(g2, ggg, child, pass, clip);
            }
        } else if (scene instanceof VisADGroup) {
            if (this.clip_rectangle != null && (scene.equals(this.direct) || scene.equals(this.non_direct))) {
                clip = this.clip_rectangle;
            }
            Vector children = ((VisADGroup)scene).getChildren();
            int i = children.size() - 1;
            while (i >= 0) {
                VisADSceneGraphObject child = (VisADSceneGraphObject)children.elementAt(i);
                if (child != null) {
                    this.render(g2, ggg, child, pass, clip);
                }
                --i;
            }
        } else {
            g2.setClip(clip);
            VisADAppearance appearance = (VisADAppearance)scene;
            VisADGeometryArray array = appearance.array;
            if (array == null) {
                return;
            }
            BufferedImage image = (BufferedImage)appearance.image;
            AffineTransform tg = g2.getTransform();
            if (image != null) {
                if (pass != 0) {
                    return;
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (!(array instanceof VisADQuadArray)) {
                    throw new VisADError("VisADCanvasJ2D.render: array must be quad");
                }
                float x00 = array.coordinates[0];
                float y00 = array.coordinates[1];
                float xw0 = array.coordinates[3];
                float yw0 = array.coordinates[4];
                float xwh = array.coordinates[6];
                float ywh = array.coordinates[7];
                float x0h = array.coordinates[9];
                float y0h = array.coordinates[10];
                int width = image.getWidth();
                int height = image.getHeight();
                float m02 = x00;
                float m12 = y00;
                float m00 = (xw0 - x00) / (float)width;
                float m10 = (yw0 - y00) / (float)width;
                float m01 = (x0h - x00) / (float)height;
                float m11 = (y0h - y00) / (float)height;
                float xerr = xwh - (m00 * (float)width + m01 * (float)height + m02);
                float yerr = ywh - (m10 * (float)width + m11 * (float)height + m12);
                AffineTransform timage = new AffineTransform(m00, m10, m01, m11, m02, m12);
                g2.transform(timage);
                try {
                    g2.drawImage((Image)image, 0, 0, this);
                }
                catch (ImagingOpException e2) {
                    // empty catch block
                }
                g2.setTransform(tg);
            } else {
                if (array instanceof VisADPointArray || array instanceof VisADLineArray || array instanceof VisADLineStripArray ? pass != 1 : pass != 0) {
                    return;
                }
                int count = array.vertexCount;
                if (count == 0) {
                    return;
                }
                float[] coordinates = array.coordinates;
                byte[] colors = array.colors;
                if (colors == null) {
                    if (appearance.color_flag) {
                        float red = Math.max(Math.min(appearance.red, 1.0f), 0.0f);
                        float green = Math.max(Math.min(appearance.green, 1.0f), 0.0f);
                        float blue = Math.max(Math.min(appearance.blue, 1.0f), 0.0f);
                        g2.setColor(new Color(red, green, blue));
                    } else {
                        g2.setColor(new Color(1.0f, 1.0f, 1.0f));
                    }
                }
                if (array instanceof VisADPointArray || array instanceof VisADLineArray || array instanceof VisADLineStripArray) {
                    int jinc;
                    float fsize = array instanceof VisADPointArray ? appearance.pointSize : appearance.lineWidth;
                    double dsize = fsize;
                    if (dsize < 1.05) {
                        dsize = 1.05;
                    }
                    double[] pts = new double[]{0.0, 0.0, 0.0, dsize, dsize, 0.0};
                    double[] newpts = new double[6];
                    double xx = 0.0;
                    double yy = 0.0;
                    try {
                        tg.inverseTransform(pts, 0, newpts, 0, 3);
                        xx = (newpts[2] - newpts[0]) * (newpts[2] - newpts[0]) + (newpts[3] - newpts[1]) * (newpts[3] - newpts[1]);
                        yy = (newpts[4] - newpts[0]) * (newpts[4] - newpts[0]) + (newpts[5] - newpts[1]) * (newpts[5] - newpts[1]);
                    }
                    catch (NoninvertibleTransformException e3) {
                        xx = 1.05;
                        yy = 1.05;
                    }
                    float size = (float)(0.5 * (Math.sqrt(xx) + Math.sqrt(yy)));
                    float hsize = 0.5f * size;
                    float[] style = this.LINE_PATTERN[appearance.lineStyle];
                    float[] pattern = null;
                    if (style != null) {
                        pattern = new float[style.length];
                        float scale = size / appearance.lineWidth;
                        int i = 0;
                        while (i < style.length) {
                            pattern[i] = scale * style[i];
                            ++i;
                        }
                    }
                    g2.setStroke(new BasicStroke(size, 2, 0, 10.0f, pattern, 0.0f));
                    if (array instanceof VisADPointArray) {
                        if (Math.abs(fsize - 1.0f) < 0.1f) {
                            VisADCanvasJ2D.drawAppearance(ggg, appearance, tg, clip);
                        } else {
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                            if (colors == null) {
                                int i = 0;
                                while (i < 3 * count) {
                                    if (coordinates[i] == coordinates[i] && coordinates[i + 1] == coordinates[i + 1]) {
                                        g2.fill(new Rectangle2D.Float(coordinates[i] - hsize, coordinates[i + 1] - hsize, size, size));
                                    }
                                    i += 3;
                                }
                            } else {
                                int j = 0;
                                jinc = colors.length == coordinates.length ? 3 : 4;
                                int i = 0;
                                while (i < 3 * count) {
                                    if (coordinates[i] == coordinates[i] && coordinates[i + 1] == coordinates[i + 1]) {
                                        g2.setColor(new Color(colors[j] < 0 ? colors[j] + 256 : colors[j], colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1], colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]));
                                        g2.fill(new Rectangle2D.Float(coordinates[i] - hsize, coordinates[i + 1] - hsize, size, size));
                                    }
                                    j += jinc;
                                    i += 3;
                                }
                            }
                        }
                    } else if (array instanceof VisADLineArray) {
                        if (Math.abs(fsize - 1.0f) < 0.1f) {
                            VisADCanvasJ2D.drawAppearance(ggg, appearance, tg, clip);
                        } else {
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            if (colors == null) {
                                int i = 0;
                                while (i < 3 * count) {
                                    g2.draw(new Line2D.Float(coordinates[i], coordinates[i + 1], coordinates[i + 3], coordinates[i + 4]));
                                    i += 6;
                                }
                            } else {
                                int j = 0;
                                jinc = colors.length == coordinates.length ? 3 : 4;
                                int i = 0;
                                while (i < 3 * count) {
                                    g2.setColor(new Color(((colors[j] < 0 ? colors[j] + 256 : colors[j]) + (colors[j + jinc] < 0 ? colors[j + jinc] + 256 : colors[j + jinc])) / 2, ((colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1]) + (colors[j + jinc + 1] < 0 ? colors[j + jinc + 1] + 256 : colors[j + jinc + 1])) / 2, ((colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]) + (colors[j + jinc + 2] < 0 ? colors[j + jinc + 2] + 256 : colors[j + jinc + 2])) / 2));
                                    j += 2 * jinc;
                                    g2.draw(new Line2D.Float(coordinates[i], coordinates[i + 1], coordinates[i + 3], coordinates[i + 4]));
                                    i += 6;
                                }
                            }
                        }
                    } else {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        int[] stripVertexCounts = ((VisADLineStripArray)array).stripVertexCounts;
                        int base = 0;
                        int basec = 0;
                        int jinc2 = 0;
                        if (colors != null) {
                            jinc2 = colors.length == coordinates.length ? 3 : 4;
                        }
                        int strip = 0;
                        while (strip < stripVertexCounts.length) {
                            count = stripVertexCounts[strip];
                            float lastx = coordinates[base];
                            float lasty = coordinates[base + 1];
                            int lastr = 0;
                            int lastg = 0;
                            int lastb = 0;
                            if (colors != null) {
                                lastr = colors[basec] < 0 ? colors[basec] + 256 : colors[basec];
                                lastg = colors[basec + 1] < 0 ? colors[basec + 1] + 256 : colors[basec + 1];
                                int n = lastb = colors[basec + 2] < 0 ? colors[basec + 2] + 256 : colors[basec + 2];
                            }
                            if (colors == null) {
                                int i = 3;
                                while (i < 3 * count) {
                                    g2.draw(new Line2D.Float(lastx, lasty, coordinates[base + i], coordinates[base + i + 1]));
                                    lastx = coordinates[base + i];
                                    lasty = coordinates[base + i + 1];
                                    i += 3;
                                }
                            } else {
                                int j = jinc2;
                                int i = 3;
                                while (i < 3 * count) {
                                    int thisr = colors[basec + j] < 0 ? colors[basec + j] + 256 : colors[basec + j];
                                    int thisg = colors[basec + j + 1] < 0 ? colors[basec + j + 1] + 256 : colors[basec + j + 1];
                                    int thisb = colors[basec + j + 2] < 0 ? colors[basec + j + 2] + 256 : colors[basec + j + 2];
                                    g2.setColor(new Color((lastr + thisr) / 2, (lastg + thisg) / 2, (lastb + thisb) / 2));
                                    lastr = thisr;
                                    lastg = thisg;
                                    lastb = thisb;
                                    j += jinc2;
                                    g2.draw(new Line2D.Float(lastx, lasty, coordinates[base + i], coordinates[base + i + 1]));
                                    lastx = coordinates[base + i];
                                    lasty = coordinates[base + i + 1];
                                    i += 3;
                                }
                            }
                            base += 3 * count;
                            basec += jinc2 * count;
                            ++strip;
                        }
                    }
                } else if (array instanceof VisADTriangleArray) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (colors == null) {
                        int i = 0;
                        while (i < 3 * count) {
                            GeneralPath path = new GeneralPath(0);
                            path.moveTo(coordinates[i], coordinates[i + 1]);
                            path.lineTo(coordinates[i + 3], coordinates[i + 4]);
                            path.lineTo(coordinates[i + 6], coordinates[i + 7]);
                            path.closePath();
                            g2.fill(path);
                            i += 9;
                        }
                    } else {
                        int j = 0;
                        int jinc = colors.length == coordinates.length ? 3 : 4;
                        int i = 0;
                        while (i < 3 * count) {
                            g2.setColor(new Color(((colors[j] < 0 ? colors[j] + 256 : colors[j]) + (colors[j + jinc] < 0 ? colors[j + jinc] + 256 : colors[j + jinc]) + (colors[j + 2 * jinc] < 0 ? colors[j + 2 * jinc] + 256 : colors[j + 2 * jinc])) / 3, ((colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1]) + (colors[j + jinc + 1] < 0 ? colors[j + jinc + 1] + 256 : colors[j + jinc + 1]) + (colors[j + 2 * jinc + 1] < 0 ? colors[j + 2 * jinc + 1] + 256 : colors[j + 2 * jinc + 1])) / 3, ((colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]) + (colors[j + jinc + 2] < 0 ? colors[j + jinc + 2] + 256 : colors[j + jinc + 2]) + (colors[j + 2 * jinc + 2] < 0 ? colors[j + 2 * jinc + 2] + 256 : colors[j + 2 * jinc + 2])) / 3));
                            j += 3 * jinc;
                            GeneralPath path = new GeneralPath(0);
                            path.moveTo(coordinates[i], coordinates[i + 1]);
                            path.lineTo(coordinates[i + 3], coordinates[i + 4]);
                            path.lineTo(coordinates[i + 6], coordinates[i + 7]);
                            path.closePath();
                            g2.fill(path);
                            i += 9;
                        }
                    }
                } else if (array instanceof VisADQuadArray) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (colors == null) {
                        int i = 0;
                        while (i < 3 * count) {
                            GeneralPath path = new GeneralPath(0);
                            path.moveTo(coordinates[i], coordinates[i + 1]);
                            path.lineTo(coordinates[i + 3], coordinates[i + 4]);
                            path.lineTo(coordinates[i + 6], coordinates[i + 7]);
                            path.lineTo(coordinates[i + 9], coordinates[i + 10]);
                            path.closePath();
                            g2.fill(path);
                            i += 12;
                        }
                    } else {
                        int j = 0;
                        int jinc = colors.length == coordinates.length ? 3 : 4;
                        int i = 0;
                        while (i < 3 * count) {
                            g2.setColor(new Color(((colors[j] < 0 ? colors[j] + 256 : colors[j]) + (colors[j + jinc] < 0 ? colors[j + jinc] + 256 : colors[j + jinc]) + (colors[j + 2 * jinc] < 0 ? colors[j + 2 * jinc] + 256 : colors[j + 2 * jinc]) + (colors[j + 3 * jinc] < 0 ? colors[j + 3 * jinc] + 256 : colors[j + 3 * jinc])) / 4, ((colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1]) + (colors[j + jinc + 1] < 0 ? colors[j + jinc + 1] + 256 : colors[j + jinc + 1]) + (colors[j + 2 * jinc + 1] < 0 ? colors[j + 2 * jinc + 1] + 256 : colors[j + 2 * jinc + 1]) + (colors[j + 3 * jinc + 1] < 0 ? colors[j + 3 * jinc + 1] + 256 : colors[j + 3 * jinc + 1])) / 4, ((colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]) + (colors[j + jinc + 2] < 0 ? colors[j + jinc + 2] + 256 : colors[j + jinc + 2]) + (colors[j + 2 * jinc + 2] < 0 ? colors[j + 2 * jinc + 2] + 256 : colors[j + 2 * jinc + 2]) + (colors[j + 3 * jinc + 2] < 0 ? colors[j + 3 * jinc + 2] + 256 : colors[j + 3 * jinc + 2])) / 4));
                            j += 4 * jinc;
                            GeneralPath path = new GeneralPath(0);
                            path.moveTo(coordinates[i], coordinates[i + 1]);
                            path.lineTo(coordinates[i + 3], coordinates[i + 4]);
                            path.lineTo(coordinates[i + 6], coordinates[i + 7]);
                            path.lineTo(coordinates[i + 9], coordinates[i + 10]);
                            path.closePath();
                            g2.fill(path);
                            i += 12;
                        }
                    }
                } else if (array instanceof VisADIndexedTriangleStripArray) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    int[] indices = ((VisADIndexedTriangleStripArray)array).indices;
                    int indexCount = ((VisADIndexedTriangleStripArray)array).indexCount;
                    int[] stripVertexCounts = ((VisADIndexedTriangleStripArray)array).stripVertexCounts;
                    int base = 0;
                    int strip = 0;
                    while (strip < stripVertexCounts.length) {
                        count = stripVertexCounts[strip];
                        int index0 = indices[base];
                        int index1 = indices[base + 1];
                        if (colors == null) {
                            int i = base + 2;
                            while (i < base + count) {
                                int index2 = indices[i];
                                GeneralPath path = new GeneralPath(0);
                                path.moveTo(coordinates[3 * index0], coordinates[3 * index0 + 1]);
                                path.lineTo(coordinates[3 * index1], coordinates[3 * index1 + 1]);
                                path.lineTo(coordinates[3 * index2], coordinates[3 * index2 + 1]);
                                path.closePath();
                                g2.fill(path);
                                index0 = index1;
                                index1 = index2;
                                ++i;
                            }
                        } else {
                            int jinc = colors.length == coordinates.length ? 3 : 4;
                            int i = base + 2;
                            while (i < base + count) {
                                int index2 = indices[i];
                                g2.setColor(new Color(((colors[jinc * index0] < 0 ? colors[jinc * index0] + 256 : colors[jinc * index0]) + (colors[jinc * index1] < 0 ? colors[jinc * index1] + 256 : colors[jinc * index1]) + (colors[jinc * index2] < 0 ? colors[jinc * index2] + 256 : colors[jinc * index2])) / 3, ((colors[jinc * index0 + 1] < 0 ? colors[jinc * index0 + 1] + 256 : colors[jinc * index0 + 1]) + (colors[jinc * index1 + 1] < 0 ? colors[jinc * index1 + 1] + 256 : colors[jinc * index1 + 1]) + (colors[jinc * index2 + 1] < 0 ? colors[jinc * index2 + 1] + 256 : colors[jinc * index2 + 1])) / 3, ((colors[jinc * index0 + 2] < 0 ? colors[jinc * index0 + 2] + 256 : colors[jinc * index0 + 2]) + (colors[jinc * index1 + 2] < 0 ? colors[jinc * index1 + 2] + 256 : colors[jinc * index1 + 2]) + (colors[jinc * index2 + 2] < 0 ? colors[jinc * index2 + 2] + 256 : colors[jinc * index2 + 2])) / 3));
                                GeneralPath path = new GeneralPath(0);
                                path.moveTo(coordinates[3 * index0], coordinates[3 * index0 + 1]);
                                path.lineTo(coordinates[3 * index1], coordinates[3 * index1 + 1]);
                                path.lineTo(coordinates[3 * index2], coordinates[3 * index2 + 1]);
                                path.closePath();
                                g2.fill(path);
                                index0 = index1;
                                index1 = index2;
                                ++i;
                            }
                        }
                        base += count;
                        ++strip;
                    }
                } else if (array instanceof VisADTriangleStripArray) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    int[] stripVertexCounts = ((VisADTriangleStripArray)array).stripVertexCounts;
                    int base = 0;
                    int basec = 0;
                    int jinc = 0;
                    if (colors != null) {
                        jinc = colors.length == coordinates.length ? 3 : 4;
                    }
                    int strip = 0;
                    while (strip < stripVertexCounts.length) {
                        count = stripVertexCounts[strip];
                        float oldx = coordinates[base];
                        float oldy = coordinates[base + 1];
                        float lastx = coordinates[base + 3];
                        float lasty = coordinates[base + 4];
                        int oldr = 0;
                        int oldg = 0;
                        int oldb = 0;
                        int lastr = 0;
                        int lastg = 0;
                        int lastb = 0;
                        if (colors != null) {
                            oldr = colors[basec] < 0 ? colors[basec] + 256 : colors[basec];
                            oldg = colors[basec + 1] < 0 ? colors[basec + 1] + 256 : colors[basec + 1];
                            oldb = colors[basec + 2] < 0 ? colors[basec + 2] + 256 : colors[basec + 2];
                            lastr = colors[basec + jinc] < 0 ? colors[basec + jinc] + 256 : colors[basec + jinc];
                            lastg = colors[basec + jinc + 1] < 0 ? colors[basec + jinc + 1] + 256 : colors[basec + jinc + 1];
                            int n = lastb = colors[basec + jinc + 2] < 0 ? colors[basec + jinc + 2] + 256 : colors[basec + jinc + 2];
                        }
                        if (colors == null) {
                            int i = 6;
                            while (i < 3 * count) {
                                GeneralPath path = new GeneralPath(0);
                                path.moveTo(oldx, oldy);
                                path.lineTo(lastx, lasty);
                                path.lineTo(coordinates[base + i], coordinates[base + i + 1]);
                                path.closePath();
                                g2.fill(path);
                                oldx = lastx;
                                oldy = lasty;
                                lastx = coordinates[base + i];
                                lasty = coordinates[base + i + 1];
                                i += 3;
                            }
                        } else {
                            int j = 2 * jinc;
                            int i = 6;
                            while (i < 3 * count) {
                                int thisr = colors[basec + j] < 0 ? colors[basec + j] + 256 : colors[basec + j];
                                int thisg = colors[basec + j + 1] < 0 ? colors[basec + j + 1] + 256 : colors[basec + j + 1];
                                int thisb = colors[basec + j + 2] < 0 ? colors[basec + j + 2] + 256 : colors[basec + j + 2];
                                g2.setColor(new Color((thisr + lastr + oldr) / 3, (thisg + lastg + oldg) / 3, (thisb + lastb + oldb) / 3));
                                oldr = lastr;
                                oldg = lastg;
                                oldb = lastb;
                                lastr = thisr;
                                lastg = thisg;
                                lastb = thisb;
                                j += jinc;
                                GeneralPath path = new GeneralPath(0);
                                path.moveTo(oldx, oldy);
                                path.lineTo(lastx, lasty);
                                path.lineTo(coordinates[base + i], coordinates[base + i + 1]);
                                path.closePath();
                                g2.fill(path);
                                oldx = lastx;
                                oldy = lasty;
                                lastx = coordinates[base + i];
                                lasty = coordinates[base + i + 1];
                                i += 3;
                            }
                        }
                        base += 3 * count;
                        basec += jinc * count;
                        ++strip;
                    }
                } else {
                    throw new VisADError("VisADCanvasJ2D.render: bad array class");
                }
            }
        }
    }

    public static void drawAppearance(Graphics graphics, VisADAppearance appearance, AffineTransform t2, Rectangle2D.Float clip) {
        VisADGeometryArray array = appearance.array;
        if (array == null) {
            return;
        }
        byte[] colors = array.colors;
        if (colors == null) {
            if (appearance.color_flag) {
                graphics.setColor(new Color(appearance.red, appearance.green, appearance.blue));
            } else {
                graphics.setColor(new Color(1.0f, 1.0f, 1.0f));
            }
        }
        int count = array.vertexCount;
        float[] coordinates = array.coordinates;
        float[] oldcoords = new float[2 * count];
        int j = 0;
        int i = 0;
        while (i < 3 * count) {
            oldcoords[j++] = coordinates[i];
            oldcoords[j++] = coordinates[i + 1];
            i += 3;
        }
        float[] newcoords = new float[2 * count];
        t2.transform(oldcoords, 0, newcoords, 0, count);
        if (clip == null) {
            graphics.setClip(null);
        } else {
            float x = (float)clip.getX();
            float y = (float)clip.getY();
            float width = (float)clip.getWidth();
            float height = (float)clip.getHeight();
            float[] oldclip = new float[]{x, y, x, y + height, x + width, y + height, x + width, y};
            float[] newclip = new float[8];
            t2.transform(oldclip, 0, newclip, 0, 4);
            GeneralPath path = new GeneralPath(0);
            path.moveTo(newclip[0], newclip[1]);
            path.lineTo(newclip[2], newclip[3]);
            path.lineTo(newclip[4], newclip[5]);
            path.lineTo(newclip[6], newclip[7]);
            path.closePath();
            graphics.setClip(path);
        }
        if (array instanceof VisADPointArray) {
            if (colors == null) {
                int i2 = 0;
                while (i2 < 2 * count) {
                    graphics.drawLine((int)newcoords[i2], (int)newcoords[i2 + 1], (int)newcoords[i2], (int)newcoords[i2 + 1]);
                    i2 += 2;
                }
            } else {
                int jinc = colors.length == coordinates.length ? 3 : 4;
                j = 0;
                int i3 = 0;
                while (i3 < 2 * count) {
                    graphics.setColor(new Color(colors[j] < 0 ? colors[j] + 256 : colors[j], colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1], colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]));
                    j += jinc;
                    graphics.drawLine((int)newcoords[i3], (int)newcoords[i3 + 1], (int)newcoords[i3], (int)newcoords[i3 + 1]);
                    i3 += 2;
                }
            }
        } else if (array instanceof VisADLineArray) {
            if (colors == null) {
                int i4 = 0;
                while (i4 < 2 * count) {
                    int width = (int)appearance.lineWidth;
                    int x1 = (int)newcoords[i4];
                    int y1 = (int)newcoords[i4 + 1];
                    int x2 = (int)newcoords[i4 + 2];
                    int y2 = (int)newcoords[i4 + 3];
                    if (width <= 1 || x1 != x2 && y1 != y2) {
                        graphics.drawLine(x1, y1, x2, y2);
                    } else {
                        int hw1 = width / 2;
                        int hw2 = width - hw1;
                        int[] xPoints = null;
                        int[] yPoints = null;
                        if (x1 == x2) {
                            xPoints = new int[]{x1 - hw1, x1 + hw2, x1 + hw2, x1 - hw1};
                            yPoints = new int[]{y1, y1, y2, y2};
                        } else {
                            xPoints = new int[]{x1, x1, x2, x2};
                            yPoints = new int[]{y1 - hw1, y1 + hw2, y1 + hw2, y1 - hw1};
                        }
                        graphics.fillPolygon(xPoints, yPoints, 4);
                    }
                    i4 += 4;
                }
            } else {
                int jinc = colors.length == coordinates.length ? 3 : 4;
                j = 0;
                int i5 = 0;
                while (i5 < 2 * count) {
                    graphics.setColor(new Color(((colors[j] < 0 ? colors[j] + 256 : colors[j]) + (colors[j + jinc] < 0 ? colors[j + jinc] + 256 : colors[j + jinc])) / 2, ((colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1]) + (colors[j + jinc + 1] < 0 ? colors[j + jinc + 1] + 256 : colors[j + jinc + 1])) / 2, ((colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]) + (colors[j + jinc + 2] < 0 ? colors[j + jinc + 2] + 256 : colors[j + jinc + 2])) / 2));
                    j += 2 * jinc;
                    int width = (int)appearance.lineWidth;
                    int x1 = (int)newcoords[i5];
                    int y1 = (int)newcoords[i5 + 1];
                    int x2 = (int)newcoords[i5 + 2];
                    int y2 = (int)newcoords[i5 + 3];
                    if (width <= 1 || x1 != x2 && y1 != y2) {
                        graphics.drawLine(x1, y1, x2, y2);
                    } else {
                        int hw1 = width / 2;
                        int hw2 = width - hw1;
                        int[] xPoints = null;
                        int[] yPoints = null;
                        if (x1 == x2) {
                            xPoints = new int[]{x1 - hw1, x1 + hw2, x1 + hw2, x1 - hw1};
                            yPoints = new int[]{y1, y1, y2, y2};
                        } else {
                            xPoints = new int[]{x1, x1, x2, x2};
                            yPoints = new int[]{y1 - hw1, y1 + hw2, y1 + hw2, y1 - hw1};
                        }
                        graphics.fillPolygon(xPoints, yPoints, 4);
                    }
                    i5 += 4;
                }
            }
        } else {
            throw new VisADError("DisplayRendererJ2D.drawAppearance: bad VisADGeometryArray type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AffineTransform getTransform() {
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (this.images) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.tgeometry;
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void setPreferredSize(Dimension size) {
        this.prefSize = size;
    }

    public boolean getAutoAspect() {
        return this.autoAspect;
    }

    public void setAutoAspect(boolean auto) {
        this.autoAspect = auto;
    }

    public void setBounds(int x, int y, int width, int height) {
        block6: {
            if (width < 1 || height < 1) {
                return;
            }
            super.setBounds(x, y, width, height);
            if (!this.autoAspect) break block6;
            ProjectionControl pc = this.display.getProjectionControl();
            try {
                double b2;
                double a2;
                if (height > width) {
                    a2 = 1.0;
                    b2 = (double)height / (double)width;
                } else {
                    a2 = (double)width / (double)height;
                    b2 = 1.0;
                }
                pc.setAspectCartesian(new double[]{a2, b2});
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

