/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.ContourControl;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Integer3DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShadowType;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowAnimationFunctionTypeJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.java3d.VisADBranchGroup;
import visad.util.Delay;

public class AnimationRendererJ3D
extends DefaultRendererJ3D {
    boolean animation1D;
    String nameMappedToAnimation = null;
    private boolean reUseFrames = false;
    private boolean setSetOnReUseFrames = true;
    private VisADBranchGroup vbranch = null;

    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowAnimationFunctionTypeJ3D(type, link, parent);
    }

    public void setReUseFrames(boolean reuse) {
        this.reUseFrames = reuse;
    }

    public void setReUseFrames() {
        this.setReUseFrames(true);
    }

    public boolean getReUseFrames() {
        return this.reUseFrames;
    }

    public void setSetSetOnReUseFrames(boolean ss) {
        this.setSetOnReUseFrames = ss;
    }

    public boolean getSetSetOnReUseFrames() {
        return this.setSetOnReUseFrames;
    }

    public void clearScene() {
        this.vbranch = null;
        super.clearScene();
    }

    void setVisADBranch(VisADBranchGroup branch) {
        this.vbranch = branch;
    }

    void markMissingVisADBranch() {
        if (this.vbranch != null) {
            this.vbranch.scratchTime();
        }
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        DataDisplayLink[] Links;
        BranchGroup branch = this.getBranch();
        if (branch == null) {
            branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(14);
            branch.setCapability(12);
            branch.setCapability(13);
        }
        if ((Links = this.getLinks()) == null || Links.length == 0) {
            return null;
        }
        DataDisplayLink link = Links[0];
        ShadowTypeJ3D type = (ShadowTypeJ3D)link.getShadow();
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            valueArray[i] = Float.NaN;
            ++i;
        }
        try {
            data = link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, link);
                this.removeLink(link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: AnimationRendererJ3D.doTransform"));
        } else {
            this.animation1D = false;
            MathType mtype = link.getType();
            if (mtype instanceof FunctionType) {
                FunctionType function = (FunctionType)mtype;
                RealTupleType functionD = function.getDomain();
                Vector scalarMaps = link.getSelectedMapVector();
                int kk = 0;
                while (kk < scalarMaps.size()) {
                    ScalarMap scalar_map = (ScalarMap)scalarMaps.elementAt(kk);
                    String scalar_name = scalar_map.getScalarName();
                    if (scalar_name.equals(((RealType)functionD.getComponent(0)).getName()) && scalar_map.getDisplayScalar().equals(Display.Animation) && functionD.getDimension() == 1) {
                        this.animation1D = true;
                        this.nameMappedToAnimation = scalar_name;
                    }
                    ++kk;
                }
            }
            link.start_time = System.currentTimeMillis();
            link.time_flag = false;
            this.vbranch = null;
            if (!this.animation1D) {
                branch = new BranchGroup();
                branch.setCapability(17);
                branch.setCapability(14);
                branch.setCapability(12);
                branch.setCapability(13);
            }
            try {
                type.doTransform(branch, data, valueArray, link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, link);
                    this.removeLink(link);
                    return null;
                }
                throw re;
            }
        }
        link.clearData();
        return branch;
    }

    public Object clone() {
        return new AnimationRendererJ3D();
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        int size;
        String test = "new";
        if (args.length > 0 && !(test = args[0]).equals("new") && !test.equals("old")) {
            System.out.println("arg must be 'old' or 'new'");
            System.exit(0);
        }
        int nr = size = 80;
        int nc = size;
        int nz = size;
        double ang = Math.PI * 2 / (double)nr;
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType radiance = new RealType("radiance", null, null);
        RealType index = new RealType("index", null, null);
        FunctionType image_type = new FunctionType(earth_location, radiance);
        Integer3DSet image_domain_set = new Integer3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, nr, nc, nz);
        FunctionType field_type = new FunctionType(index, image_type);
        Integer1DSet field_domain_set = new Integer1DSet((MathType)index, 6);
        FieldImpl field = new FieldImpl(field_type, field_domain_set);
        int tt = 0;
        while (tt < field_domain_set.getLength()) {
            float[][] values = new float[1][nr * nc * nz];
            int kk = 0;
            while (kk < nz) {
                int jj = 0;
                while (jj < nc) {
                    int ii = 0;
                    while (ii < nr) {
                        int idx = kk * nr * nc + jj * nr + ii;
                        values[0][idx] = (float)(tt + 1) * (2.0f * (float)Math.sin(2.0 * ang * (double)ii) + 2.0f * (float)Math.sin(2.0 * ang * (double)jj)) + (float)kk;
                        ++ii;
                    }
                    ++jj;
                }
                ++kk;
            }
            FlatField image = new FlatField(image_type, image_domain_set);
            image.setSamples(values);
            field.setSample(tt, (Data)image, false);
            ++tt;
        }
        DisplayImplJ3D dpys = new DisplayImplJ3D("AnimationRendererJ3D Test");
        JFrame jframe = new JFrame("AnimationRendererTest");
        jframe.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        jframe.setContentPane((JPanel)dpys.getComponent());
        jframe.pack();
        jframe.setVisible(true);
        ScalarMap xmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        dpys.addMap(xmap);
        ScalarMap ymap = new ScalarMap(RealType.Latitude, Display.YAxis);
        dpys.addMap(ymap);
        ScalarMap zmap = new ScalarMap(RealType.Altitude, Display.ZAxis);
        dpys.addMap(zmap);
        ScalarMap rgbaMap = new ScalarMap(radiance, Display.RGBA);
        dpys.addMap(rgbaMap);
        ScalarMap amap = new ScalarMap(index, Display.Animation);
        dpys.addMap(amap);
        ScalarMap map1contour = new ScalarMap(radiance, Display.IsoContour);
        dpys.addMap(map1contour);
        ContourControl ctr_cntrl = (ContourControl)map1contour.getControl();
        ctr_cntrl.setSurfaceValue(24.0f);
        AnimationControl acontrol = (AnimationControl)((Object)amap.getControl());
        acontrol.setOn(false);
        acontrol.setStep(1000);
        DataReferenceImpl ref = new DataReferenceImpl("field_ref");
        ref.setData(field);
        AnimationRendererJ3D renderer = new AnimationRendererJ3D();
        renderer.setReUseFrames(true);
        if (test.equals("old")) {
            dpys.addReference(ref);
        } else {
            dpys.addReferences((DataRenderer)renderer, new DataReferenceImpl[]{ref}, null);
        }
        System.out.println("replace test in 40 sec...");
        new Delay(50000);
        Linear1DSet new_set = new Linear1DSet((MathType)index, 1.0, 6.0, 6);
        FieldImpl new_field = new FieldImpl(field_type, new_set);
        int i = 0;
        while (i < field_domain_set.getLength()) {
            new_field.setSample(i, field.getSample((i + 1) % field_domain_set.getLength()));
            ++i;
        }
        if (test.equals("old")) {
            dpys.reAutoScale();
        }
        System.out.println("replace test start");
        ref.setData(new_field);
    }
}

