/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import visad.Control;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.MathType;
import visad.Set;
import visad.SetType;
import visad.ShadowFunctionOrSetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADQuadArray;
import visad.java3d.AVControlJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.ShadowRealTupleTypeJ3D;
import visad.java3d.ShadowTextTypeJ3D;
import visad.java3d.ShadowTupleTypeJ3D;
import visad.java3d.ShadowTypeJ3D;

public class ShadowFunctionOrSetTypeJ3D
extends ShadowTypeJ3D {
    ShadowRealTupleTypeJ3D Domain;
    ShadowTypeJ3D Range;
    private Vector AccumulationVector = new Vector();
    private static float EPS = 0.0f;

    public ShadowFunctionOrSetTypeJ3D(MathType t2, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t2, link, parent);
        if (this instanceof ShadowFunctionTypeJ3D) {
            this.Domain = (ShadowRealTupleTypeJ3D)((FunctionType)this.Type).getDomain().buildShadowType(link, this);
            this.Range = (ShadowTypeJ3D)((FunctionType)this.Type).getRange().buildShadowType(link, this);
            this.adaptedShadowType = new ShadowFunctionType(t2, link, ShadowTypeJ3D.getAdaptedParent(parent), (ShadowRealTupleType)this.Domain.getAdaptedShadowType(), this.Range.getAdaptedShadowType());
        } else {
            this.Domain = (ShadowRealTupleTypeJ3D)((SetType)this.Type).getDomain().buildShadowType(this.Link, this);
            this.Range = null;
            this.adaptedShadowType = new ShadowSetType(t2, link, ShadowTypeJ3D.getAdaptedParent(parent), (ShadowRealTupleType)this.Domain.getAdaptedShadowType());
        }
    }

    public ShadowRealTupleTypeJ3D getDomain() {
        return this.Domain;
    }

    public ShadowTypeJ3D getRange() {
        return this.Range;
    }

    public void preProcess() throws VisADException {
        this.AccumulationVector.removeAllElements();
        if (this instanceof ShadowFunctionTypeJ3D) {
            this.Range.preProcess();
        }
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        boolean post = ((ShadowFunctionOrSetType)this.adaptedShadowType).doTransform(group, data, value_array, default_values, renderer, this);
        this.ensureNotEmpty(group);
        return post;
    }

    public int textureWidth(int data_width) {
        int texture_width = 1;
        while (texture_width < data_width) {
            texture_width *= 2;
        }
        return texture_width;
    }

    public int textureHeight(int data_height) {
        int texture_height = 1;
        while (texture_height < data_height) {
            texture_height *= 2;
        }
        return texture_height;
    }

    public int textureDepth(int data_depth) {
        int texture_depth = 1;
        while (texture_depth < data_depth) {
            texture_depth *= 2;
        }
        return texture_depth;
    }

    public void adjustZ(float[] coordinates) {
        if (this.display.getDisplayRenderer().getMode2D()) {
            int i = 2;
            while (i < coordinates.length) {
                coordinates[i] = -0.01f;
                i += 3;
            }
        }
    }

    public void setTexCoords(float[] texCoords, float ratiow, float ratioh) {
        texCoords[0] = 0.0f;
        texCoords[1] = 1.0f;
        texCoords[2] = ratiow;
        texCoords[3] = 1.0f;
        texCoords[4] = ratiow;
        texCoords[5] = 1.0f - ratioh;
        texCoords[6] = 0.0f;
        texCoords[7] = 1.0f - ratioh;
    }

    public float[] setTex3DCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        float[] texCoords;
        block4: {
            block5: {
                block3: {
                    texCoords = new float[12 * length];
                    if (axis != 2) break block3;
                    int i = 0;
                    while (i < length) {
                        int i12 = i * 12;
                        float depth = 0.0f + (ratiod - 0.0f) * (float)i / ((float)length - 1.0f);
                        texCoords[i12] = 0.0f;
                        texCoords[i12 + 1] = 1.0f;
                        texCoords[i12 + 2] = depth;
                        texCoords[i12 + 3] = ratiow;
                        texCoords[i12 + 4] = 1.0f;
                        texCoords[i12 + 5] = depth;
                        texCoords[i12 + 6] = ratiow;
                        texCoords[i12 + 7] = 1.0f - ratioh;
                        texCoords[i12 + 8] = depth;
                        texCoords[i12 + 9] = 0.0f;
                        texCoords[i12 + 10] = 1.0f - ratioh;
                        texCoords[i12 + 11] = depth;
                        ++i;
                    }
                    break block4;
                }
                if (axis != 1) break block5;
                int i = 0;
                while (i < length) {
                    int i12 = i * 12;
                    float height = 1.0f - ratioh * (float)i / ((float)length - 1.0f);
                    texCoords[i12] = 0.0f;
                    texCoords[i12 + 1] = height;
                    texCoords[i12 + 2] = 0.0f;
                    texCoords[i12 + 3] = ratiow;
                    texCoords[i12 + 4] = height;
                    texCoords[i12 + 5] = 0.0f;
                    texCoords[i12 + 6] = ratiow;
                    texCoords[i12 + 7] = height;
                    texCoords[i12 + 8] = ratiod;
                    texCoords[i12 + 9] = 0.0f;
                    texCoords[i12 + 10] = height;
                    texCoords[i12 + 11] = ratiod;
                    ++i;
                }
                break block4;
            }
            if (axis != 0) break block4;
            int i = 0;
            while (i < length) {
                float width;
                int i12 = i * 12;
                texCoords[i12] = width = 0.0f + (ratiow - 0.0f) * (float)i / ((float)length - 1.0f);
                texCoords[i12 + 1] = 1.0f;
                texCoords[i12 + 2] = 0.0f;
                texCoords[i12 + 3] = width;
                texCoords[i12 + 4] = 1.0f - ratioh;
                texCoords[i12 + 5] = 0.0f;
                texCoords[i12 + 6] = width;
                texCoords[i12 + 7] = 1.0f - ratioh;
                texCoords[i12 + 8] = ratiod;
                texCoords[i12 + 9] = width;
                texCoords[i12 + 10] = 1.0f;
                texCoords[i12 + 11] = ratiod;
                ++i;
            }
        }
        return texCoords;
    }

    public float[] setTexStackCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        float[] texCoords;
        block4: {
            block5: {
                block3: {
                    texCoords = new float[8 * length];
                    if (axis != 2) break block3;
                    int i = 0;
                    while (i < length) {
                        int i8 = i * 8;
                        texCoords[i8] = 0.0f + EPS;
                        texCoords[i8 + 1] = 1.0f - EPS;
                        texCoords[i8 + 2] = ratiow - EPS;
                        texCoords[i8 + 3] = 1.0f - EPS;
                        texCoords[i8 + 4] = ratiow - EPS;
                        texCoords[i8 + 5] = 1.0f - ratioh + EPS;
                        texCoords[i8 + 6] = 0.0f + EPS;
                        texCoords[i8 + 7] = 1.0f - ratioh + EPS;
                        ++i;
                    }
                    break block4;
                }
                if (axis != 1) break block5;
                int i = 0;
                while (i < length) {
                    int i8 = i * 8;
                    texCoords[i8] = 0.0f + EPS;
                    texCoords[i8 + 1] = 1.0f - EPS;
                    texCoords[i8 + 2] = ratiow - EPS;
                    texCoords[i8 + 3] = 1.0f - EPS;
                    texCoords[i8 + 4] = ratiow - EPS;
                    texCoords[i8 + 5] = 1.0f - ratiod + EPS;
                    texCoords[i8 + 6] = 0.0f + EPS;
                    texCoords[i8 + 7] = 1.0f - ratiod + EPS;
                    ++i;
                }
                break block4;
            }
            if (axis != 0) break block4;
            int i = 0;
            while (i < length) {
                int i8 = i * 8;
                texCoords[i8] = 0.0f + EPS;
                texCoords[i8 + 1] = 1.0f - EPS;
                texCoords[i8 + 2] = ratioh - EPS;
                texCoords[i8 + 3] = 1.0f - EPS;
                texCoords[i8 + 4] = ratioh - EPS;
                texCoords[i8 + 5] = 1.0f - ratiod + EPS;
                texCoords[i8 + 6] = 0.0f + EPS;
                texCoords[i8 + 7] = 1.0f - ratiod + EPS;
                ++i;
            }
        }
        return texCoords;
    }

    public Vector getTextMaps(int i, int[] textIndices) {
        if (i < 0) {
            return ((ShadowTextTypeJ3D)this.Range).getSelectedMapVector();
        }
        ShadowTextTypeJ3D text = (ShadowTextTypeJ3D)((ShadowTupleTypeJ3D)this.Range).getComponent(textIndices[i]);
        return text.getSelectedMapVector();
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height) throws VisADException {
        GeometryArray geometry = this.display.makeGeometry(array);
        TransparencyAttributes c_alpha = null;
        if (constant_alpha == 1.0f) {
            c_alpha = null;
        } else if (constant_alpha == constant_alpha) {
            c_alpha = new TransparencyAttributes(2, constant_alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (constant_color != null && constant_color.length == 3) {
            c_color = new ColoringAttributes();
            c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
        }
        Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometry, false);
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(5);
        texture_attributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texture_attributes);
        Texture2D texture = new Texture2D(1, 6, texture_width, texture_height);
        texture.setCapability(4);
        ImageComponent2D image2d = new ImageComponent2D(2, image);
        image2d.setCapability(2);
        texture.setImage(0, (ImageComponent)image2d);
        texture.setMinFilter(2);
        texture.setMagFilter(2);
        texture.setEnable(true);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        shape.setCapability(14);
        appearance.setTexture((Texture)texture);
        appearance.setCapability(2);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild((Node)shape);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild((Node)branch, 0);
        } else {
            ((Group)group).addChild((Node)branch);
        }
    }

    public void texture3DToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] images, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
        GeometryArray geometryX = this.display.makeGeometry(arrayX);
        GeometryArray geometryY = this.display.makeGeometry(arrayY);
        GeometryArray geometryZ = this.display.makeGeometry(arrayZ);
        GeometryArray geometryXrev = this.display.makeGeometry(arrayXrev);
        GeometryArray geometryYrev = this.display.makeGeometry(arrayYrev);
        GeometryArray geometryZrev = this.display.makeGeometry(arrayZrev);
        TransparencyAttributes c_alpha = null;
        if (constant_alpha == 1.0f) {
            c_alpha = null;
        } else if (constant_alpha == constant_alpha) {
            c_alpha = new TransparencyAttributes(2, constant_alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (constant_color != null && constant_color.length == 3) {
            c_color = new ColoringAttributes();
            c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
        }
        Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryX, true);
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(2);
        texture_attributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texture_attributes);
        Texture3D texture = new Texture3D(1, 6, texture_width, texture_height, texture_depth);
        texture.setCapability(4);
        ImageComponent3D image3d = new ImageComponent3D(2, texture_width, texture_height, texture_depth);
        image3d.setCapability(2);
        int i = 0;
        while (i < texture_depth) {
            image3d.set(i, images[i]);
            images[i] = null;
            ++i;
        }
        texture.setImage(0, (ImageComponent)image3d);
        texture.setMinFilter(3);
        texture.setMagFilter(3);
        texture.setEnable(true);
        Shape3D shapeX = new Shape3D((Geometry)geometryX, appearance);
        shapeX.setCapability(14);
        Shape3D shapeY = new Shape3D((Geometry)geometryY, appearance);
        shapeY.setCapability(14);
        Shape3D shapeZ = new Shape3D((Geometry)geometryZ, appearance);
        shapeZ.setCapability(14);
        Shape3D shapeXrev = new Shape3D((Geometry)geometryXrev, appearance);
        Shape3D shapeYrev = new Shape3D((Geometry)geometryYrev, appearance);
        Shape3D shapeZrev = new Shape3D((Geometry)geometryZrev, appearance);
        appearance.setTexture((Texture)texture);
        appearance.setCapability(2);
        Switch swit = (Switch)this.makeSwitch();
        swit.addChild((Node)shapeX);
        swit.addChild((Node)shapeY);
        swit.addChild((Node)shapeZ);
        swit.addChild((Node)shapeXrev);
        swit.addChild((Node)shapeYrev);
        swit.addChild((Node)shapeZrev);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild((Node)swit);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild((Node)branch, 0);
        } else {
            ((Group)group).addChild((Node)branch);
        }
        ProjectionControlJ3D control = (ProjectionControlJ3D)this.display.getProjectionControl();
        control.addPair(swit, renderer);
    }

    public void textureStackToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] imagesX, BufferedImage[] imagesY, BufferedImage[] imagesZ, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
        GeometryArray[] geometryX = this.makeGeometrys(arrayX);
        GeometryArray[] geometryY = this.makeGeometrys(arrayY);
        GeometryArray[] geometryZ = this.makeGeometrys(arrayZ);
        int nx = arrayX.coordinates.length;
        boolean flipX = arrayX.coordinates[0] > arrayX.coordinates[nx - 3];
        int ny = arrayY.coordinates.length;
        boolean flipY = arrayY.coordinates[1] > arrayY.coordinates[ny - 2];
        int nz = arrayZ.coordinates.length;
        boolean flipZ = arrayZ.coordinates[2] > arrayZ.coordinates[nz - 1];
        TransparencyAttributes c_alpha = null;
        if (constant_alpha == 1.0f) {
            c_alpha = null;
        } else if (constant_alpha == constant_alpha) {
            c_alpha = new TransparencyAttributes(2, constant_alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (constant_color != null && constant_color.length == 3) {
            c_color = new ColoringAttributes();
            c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
        }
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(5);
        texture_attributes.setPerspectiveCorrectionMode(1);
        int transparencyMode = mode.getTransparencyMode();
        OrderedGroup branchX = new OrderedGroup();
        branchX.setCapability(12);
        int data_depth = geometryX.length;
        Shape3D[] shapeX = new Shape3D[data_depth];
        int ii = 0;
        while (ii < data_depth) {
            int i = flipX ? data_depth - 1 - ii : ii;
            int width = imagesX[i].getWidth();
            int height = imagesX[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesX[i]);
            image2d.setCapability(2);
            texture.setImage(0, (ImageComponent)image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryX[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(2);
            shapeX[i] = new Shape3D((Geometry)geometryX[i], appearance);
            shapeX[i].setCapability(14);
            branchX.addChild((Node)shapeX[i]);
            ++ii;
        }
        OrderedGroup branchXrev = new OrderedGroup();
        branchXrev.setCapability(12);
        int ii2 = data_depth - 1;
        while (ii2 >= 0) {
            int i = flipX ? data_depth - 1 - ii2 : ii2;
            int width = imagesX[i].getWidth();
            int height = imagesX[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesX[i]);
            image2d.setCapability(2);
            texture.setImage(0, (ImageComponent)image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryX[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(2);
            shapeX[i] = new Shape3D((Geometry)geometryX[i], appearance);
            shapeX[i].setCapability(14);
            branchXrev.addChild((Node)shapeX[i]);
            --ii2;
        }
        shapeX = null;
        OrderedGroup branchY = new OrderedGroup();
        branchY.setCapability(12);
        int data_height = geometryY.length;
        Shape3D[] shapeY = new Shape3D[data_height];
        int ii3 = 0;
        while (ii3 < data_height) {
            int i = flipY ? data_height - 1 - ii3 : ii3;
            int width = imagesY[i].getWidth();
            int height = imagesY[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesY[i]);
            image2d.setCapability(2);
            texture.setImage(0, (ImageComponent)image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryY[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(2);
            shapeY[i] = new Shape3D((Geometry)geometryY[i], appearance);
            shapeY[i].setCapability(14);
            branchY.addChild((Node)shapeY[i]);
            ++ii3;
        }
        OrderedGroup branchYrev = new OrderedGroup();
        branchYrev.setCapability(12);
        int ii4 = data_height - 1;
        while (ii4 >= 0) {
            int i = flipY ? data_height - 1 - ii4 : ii4;
            int width = imagesY[i].getWidth();
            int height = imagesY[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesY[i]);
            image2d.setCapability(2);
            texture.setImage(0, (ImageComponent)image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryY[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(2);
            shapeY[i] = new Shape3D((Geometry)geometryY[i], appearance);
            shapeY[i].setCapability(14);
            branchYrev.addChild((Node)shapeY[i]);
            --ii4;
        }
        shapeY = null;
        OrderedGroup branchZ = new OrderedGroup();
        branchZ.setCapability(12);
        int data_width = geometryZ.length;
        Shape3D[] shapeZ = new Shape3D[data_width];
        int ii5 = 0;
        while (ii5 < data_width) {
            int i = flipZ ? data_width - 1 - ii5 : ii5;
            int width = imagesZ[i].getWidth();
            int height = imagesZ[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesZ[i]);
            image2d.setCapability(2);
            texture.setImage(0, (ImageComponent)image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryZ[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(2);
            shapeZ[i] = new Shape3D((Geometry)geometryZ[i], appearance);
            shapeZ[i].setCapability(14);
            branchZ.addChild((Node)shapeZ[i]);
            ++ii5;
        }
        OrderedGroup branchZrev = new OrderedGroup();
        branchZrev.setCapability(12);
        int ii6 = data_width - 1;
        while (ii6 >= 0) {
            int i = flipZ ? data_width - 1 - ii6 : ii6;
            int width = imagesZ[i].getWidth();
            int height = imagesZ[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesZ[i]);
            image2d.setCapability(2);
            texture.setImage(0, (ImageComponent)image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryZ[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(2);
            shapeZ[i] = new Shape3D((Geometry)geometryZ[i], appearance);
            shapeZ[i].setCapability(14);
            branchZrev.addChild((Node)shapeZ[i]);
            --ii6;
        }
        shapeZ = null;
        Switch swit = (Switch)this.makeSwitch();
        swit.addChild((Node)branchX);
        swit.addChild((Node)branchY);
        swit.addChild((Node)branchZ);
        swit.addChild((Node)branchXrev);
        swit.addChild((Node)branchYrev);
        swit.addChild((Node)branchZrev);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild((Node)swit);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild((Node)branch, 0);
        } else {
            ((Group)group).addChild((Node)branch);
        }
        ProjectionControlJ3D control = (ProjectionControlJ3D)this.display.getProjectionControl();
        control.addPair(swit, renderer);
    }

    public GeometryArray[] makeGeometrys(VisADGeometryArray array) throws VisADException {
        int count = array.vertexCount;
        int depth = count / 4;
        VisADGeometryArray[] qarrays = this.makeVisADGeometrys(array);
        GeometryArray[] geometrys = new GeometryArray[depth];
        int d2 = 0;
        while (d2 < depth) {
            geometrys[d2] = this.display.makeGeometry(qarrays[d2]);
            ++d2;
        }
        return geometrys;
    }

    public VisADGeometryArray[] makeVisADGeometrys(VisADGeometryArray array) throws VisADException {
        int count = array.vertexCount;
        int depth = count / 4;
        int color_length = array.colors.length / count;
        int tex_length = array.texCoords.length / count;
        VisADGeometryArray[] geometrys = new VisADGeometryArray[depth];
        int d2 = 0;
        while (d2 < depth) {
            int i12 = d2 * 4 * 3;
            int i4c = d2 * 4 * color_length;
            int i4t = d2 * 4 * tex_length;
            VisADQuadArray qarray = new VisADQuadArray();
            qarray.vertexCount = 4;
            qarray.coordinates = new float[12];
            qarray.texCoords = new float[tex_length * 4];
            qarray.colors = new byte[color_length * 4];
            qarray.normals = new float[12];
            int i = 0;
            while (i < 12) {
                qarray.coordinates[i] = array.coordinates[i12 + i];
                qarray.normals[i] = array.normals[i12 + i];
                ++i;
            }
            int i2 = 0;
            while (i2 < 4 * color_length) {
                qarray.colors[i2] = array.colors[i4c + i2];
                ++i2;
            }
            int i3 = 0;
            while (i3 < 4 * tex_length) {
                qarray.texCoords[i3] = array.texCoords[i4t + i3];
                ++i3;
            }
            geometrys[d2] = qarray;
            ++d2;
        }
        return geometrys;
    }

    public Object makeSwitch() {
        Switch swit = new Switch();
        swit.setCapability(17);
        swit.setCapability(18);
        swit.setCapability(17);
        swit.setCapability(12);
        swit.setCapability(13);
        return swit;
    }

    public Object makeBranch() {
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        return branch;
    }

    public void addToGroup(Object group, Object branch) throws VisADException {
        this.ensureNotEmpty((BranchGroup)branch);
        ((BranchGroup)group).addChild((Node)((BranchGroup)branch));
    }

    public void addToSwitch(Object swit, Object branch) throws VisADException {
        this.ensureNotEmpty((BranchGroup)branch);
        ((Switch)swit).addChild((Node)((BranchGroup)branch));
    }

    public void addSwitch(Object group, Object swit, Control control, Set domain_set, DataRenderer renderer) throws VisADException {
        ((AVControlJ3D)control).addPair((Switch)swit, domain_set, renderer);
        ((AVControlJ3D)control).init();
        ((Group)group).addChild((Node)((Switch)swit));
    }

    public boolean recurseRange(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return this.Range.doTransform(group, data, value_array, default_values, renderer);
    }

    public boolean wantIndexed() {
        return false;
    }

    public void postProcess(Object group) throws VisADException {
        if (((ShadowFunctionOrSetType)this.adaptedShadowType).getFlat()) {
            int LevelOfDifficulty = this.getLevelOfDifficulty();
            if (LevelOfDifficulty == 1) {
                throw new UnimplementedException("terminal LEGAL unimplemented: ShadowFunctionOrSetTypeJ3D.postProcess");
            }
        } else if (this instanceof ShadowFunctionTypeJ3D) {
            this.Range.postProcess(group);
        }
        this.AccumulationVector.removeAllElements();
    }
}

