/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import visad.ContourControl;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.MathType;
import visad.ProjectionControl;
import visad.Set;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADTriangleArray;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.GraphicsModeControlJ3D;
import visad.java3d.LabelTransform;
import visad.java3d.ProjectionControlListener;

public abstract class ShadowTypeJ3D
extends ShadowType {
    MathType Type;
    transient DataDisplayLink Link;
    transient DisplayImplJ3D display;
    private transient Data data;
    private ShadowTypeJ3D Parent;
    String inheritedText = null;
    TextControl inheritedTextControl = null;
    ShadowType adaptedShadowType;
    ProjectionControlListener projListener = null;

    public ShadowTypeJ3D(MathType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(type, link, ShadowTypeJ3D.getAdaptedParent(parent));
        this.Type = type;
        this.Link = link;
        this.display = (DisplayImplJ3D)link.getDisplay();
        this.Parent = (ShadowTypeJ3D)parent;
        this.data = link.getData();
    }

    public static ShadowType getAdaptedParent(ShadowType parent) {
        if (parent == null) {
            return null;
        }
        return parent.getAdaptedShadowType();
    }

    public ShadowType getAdaptedShadowType() {
        return this.adaptedShadowType;
    }

    public ShadowRealType[] getComponents(ShadowType type, boolean doRef) throws VisADException {
        return this.adaptedShadowType.getComponents(type, doRef);
    }

    public String getParentText() {
        if (this.Parent != null && this.Parent.inheritedText != null && this.Parent.inheritedTextControl != null) {
            return this.Parent.inheritedText;
        }
        return null;
    }

    public TextControl getParentTextControl() {
        if (this.Parent != null && this.Parent.inheritedText != null && this.Parent.inheritedTextControl != null) {
            return this.Parent.inheritedTextControl;
        }
        return null;
    }

    public void setText(String text, TextControl control) {
        this.inheritedText = text;
        this.inheritedTextControl = control;
    }

    public Data getData() {
        return this.data;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public MathType getType() {
        return this.Type;
    }

    public int getLevelOfDifficulty() {
        return this.adaptedShadowType.getLevelOfDifficulty();
    }

    public boolean getMultipleDisplayScalar() {
        return this.adaptedShadowType.getMultipleDisplayScalar();
    }

    public boolean getMappedDisplayScalar() {
        return this.adaptedShadowType.getMappedDisplayScalar();
    }

    public int[] getDisplayIndices() {
        return this.adaptedShadowType.getDisplayIndices();
    }

    public int[] getValueIndices() {
        return this.adaptedShadowType.getValueIndices();
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        return this.adaptedShadowType.checkIndices(indices, display_indices, value_indices, isTransform, levelOfDifficulty);
    }

    public void preProcess() throws VisADException {
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return false;
    }

    public void postProcess(Object group) throws VisADException {
    }

    public static void mapValues(float[][] display_values, double[][] values, ShadowRealType[] reals) throws VisADException {
        ShadowType.mapValues(display_values, values, reals);
    }

    public static void mapValues(float[][] display_values, float[][] values, ShadowRealType[] reals) throws VisADException {
        ShadowType.mapValues(display_values, values, reals);
    }

    public static VisADGeometryArray makePointGeometry(float[][] spatial_values, byte[][] color_values) throws VisADException {
        return ShadowType.makePointGeometry(spatial_values, color_values);
    }

    public Appearance makeAppearance(GraphicsModeControl mode, TransparencyAttributes constant_alpha, ColoringAttributes constant_color, GeometryArray geometry, boolean no_material) {
        return ShadowTypeJ3D.staticMakeAppearance(mode, constant_alpha, constant_color, geometry, no_material);
    }

    public static Appearance staticMakeAppearance(GraphicsModeControl mode, TransparencyAttributes constant_alpha, ColoringAttributes constant_color, GeometryArray geometry, boolean no_material) {
        Appearance appearance = new Appearance();
        LineAttributes line = new LineAttributes();
        line.setLineWidth(mode.getLineWidth());
        int pattern = GraphicsModeControlJ3D.LINE_PATTERN[mode.getLineStyle()];
        line.setLinePattern(pattern);
        appearance.setLineAttributes(line);
        PointAttributes point = new PointAttributes();
        point.setPointSize(mode.getPointSize());
        appearance.setPointAttributes(point);
        PolygonAttributes polygon = new PolygonAttributes();
        polygon.setCullFace(0);
        polygon.setPolygonMode(mode.getPolygonMode());
        try {
            float polygonOffset = mode.getPolygonOffset();
            if (polygonOffset == polygonOffset) {
                polygon.setPolygonOffset(polygonOffset);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        appearance.setPolygonAttributes(polygon);
        RenderingAttributes rendering = new RenderingAttributes();
        rendering.setDepthBufferEnable(true);
        appearance.setRenderingAttributes(rendering);
        if (constant_color != null) {
            appearance.setColoringAttributes(constant_color);
        }
        if (!(geometry instanceof LineArray || geometry instanceof PointArray || geometry instanceof IndexedLineArray || geometry instanceof IndexedPointArray || geometry instanceof IndexedLineStripArray || geometry instanceof LineStripArray)) {
            if (!no_material) {
                Material material = new Material();
                material.setSpecularColor(0.0f, 0.0f, 0.0f);
                if (!mode.getMode2D()) {
                    material.setLightingEnable(true);
                }
                appearance.setMaterial(material);
            }
            if (constant_alpha != null) {
                appearance.setTransparencyAttributes(constant_alpha);
            }
        }
        return appearance;
    }

    public VisADGeometryArray[] assembleShape(float[][] display_values, int valueArrayLength, int[] valueToMap, Vector MapVector, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, int index, ShadowType shadow_api) throws VisADException, RemoteException {
        return this.adaptedShadowType.assembleShape(display_values, valueArrayLength, valueToMap, MapVector, valueToScalar, display, default_values, inherited_values, spatial_values, color_values, range_select, index, shadow_api);
    }

    public Set assembleSpatial(float[][] spatial_values, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, Set domain_set, boolean allSpatial, boolean set_for_shape, int[] spatialDimensions, boolean[][] range_select, float[][] flow1_values, float[][] flow2_values, float[] flowScale, boolean[] swap, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        return this.adaptedShadowType.assembleSpatial(spatial_values, display_values, valueArrayLength, valueToScalar, display, default_values, inherited_values, domain_set, allSpatial, set_for_shape, spatialDimensions, range_select, flow1_values, flow2_values, flowScale, swap, renderer, shadow_api);
    }

    public void assembleFlow(float[][] flow1_values, float[][] flow2_values, float[] flowScale, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        this.adaptedShadowType.assembleFlow(flow1_values, flow2_values, flowScale, display_values, valueArrayLength, valueToScalar, display, default_values, range_select, renderer, shadow_api);
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        return this.adaptedShadowType.makeFlow(which, flow_values, flowScale, spatial_values, color_values, range_select);
    }

    public VisADGeometryArray[] makeStreamline(int which, float[][] flow_values, float flowScale, float[][] spatial_values, Set spatial_set, int spatialManifoldDimension, byte[][] color_values, boolean[][] range_select) throws VisADException {
        return this.adaptedShadowType.makeStreamline(which, flow_values, flowScale, spatial_values, spatial_set, spatialManifoldDimension, color_values, range_select);
    }

    public boolean makeContour(int valueArrayLength, int[] valueToScalar, float[][] display_values, int[] inherited_values, Vector MapVector, int[] valueToMap, int domain_length, boolean[][] range_select, int spatialManifoldDimension, Set spatial_set, byte[][] color_values, boolean indexed, Object group, GraphicsModeControl mode, boolean[] swap, float constant_alpha, float[] constant_color, ShadowType shadow_api) throws VisADException {
        return this.adaptedShadowType.makeContour(valueArrayLength, valueToScalar, display_values, inherited_values, MapVector, valueToMap, domain_length, range_select, spatialManifoldDimension, spatial_set, color_values, indexed, group, mode, swap, constant_alpha, constant_color, shadow_api);
    }

    public void addLabelsToGroup(Object group, VisADGeometryArray[][] arrays, GraphicsModeControl mode, ContourControl control, ProjectionControl p_cntrl, int[] cnt_a, float constant_alpha, float[] constant_color, float[][][] f_array) throws VisADException {
        int cnt = cnt_a[0];
        if (cnt == 0) {
            this.projListener = new ProjectionControlListener(p_cntrl, control);
        }
        VisADGeometryArray[] lbl_arrays = new VisADGeometryArray[2];
        VisADGeometryArray[] seg_arrays = new VisADGeometryArray[4];
        int n_labels = arrays[2].length / 2;
        this.projListener.LT_array[cnt] = new LabelTransform[3][n_labels];
        int ii = 0;
        while (ii < n_labels) {
            lbl_arrays[0] = arrays[2][ii * 2];
            lbl_arrays[1] = arrays[2][ii * 2 + 1];
            seg_arrays[0] = arrays[3][ii * 4];
            seg_arrays[1] = arrays[3][ii * 4 + 1];
            seg_arrays[2] = arrays[3][ii * 4 + 2];
            seg_arrays[3] = arrays[3][ii * 4 + 3];
            TransformGroup lbl_trans_group = new TransformGroup();
            TransformGroup segL_trans_group = new TransformGroup();
            TransformGroup segR_trans_group = new TransformGroup();
            lbl_trans_group.setCapability(17);
            lbl_trans_group.setCapability(18);
            lbl_trans_group.setCapability(12);
            segL_trans_group.setCapability(17);
            segL_trans_group.setCapability(18);
            segL_trans_group.setCapability(12);
            segR_trans_group.setCapability(17);
            segR_trans_group.setCapability(18);
            segR_trans_group.setCapability(12);
            if (control.getAutoSizeLabels()) {
                LabelTransform lbl_trans;
                this.projListener.LT_array[cnt][0][ii] = lbl_trans = new LabelTransform(lbl_trans_group, p_cntrl, lbl_arrays, f_array[0][ii], 0);
                this.projListener.LT_array[cnt][1][ii] = lbl_trans = new LabelTransform(segL_trans_group, p_cntrl, new VisADGeometryArray[]{seg_arrays[0], seg_arrays[1]}, new float[]{f_array[0][ii][0], f_array[0][ii][1]}, 1);
                this.projListener.LT_array[cnt][2][ii] = lbl_trans = new LabelTransform(segR_trans_group, p_cntrl, new VisADGeometryArray[]{seg_arrays[2], seg_arrays[3]}, new float[]{f_array[0][ii][2], f_array[0][ii][3]}, 1);
            }
            ((Group)group).addChild((Node)lbl_trans_group);
            ((Group)group).addChild((Node)segL_trans_group);
            ((Group)group).addChild((Node)segR_trans_group);
            this.addToGroup(lbl_trans_group, lbl_arrays[0], mode, constant_alpha, constant_color);
            this.addToGroup(segL_trans_group, seg_arrays[0], mode, constant_alpha, constant_color);
            this.addToGroup(segR_trans_group, seg_arrays[2], mode, constant_alpha, constant_color);
            ++ii;
        }
        this.projListener.cnt = ++cnt;
        cnt_a[0] = cnt;
    }

    public VisADGeometryArray makeText(String[] text_values, TextControl text_control, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        return this.adaptedShadowType.makeText(text_values, text_control, spatial_values, color_values, range_select);
    }

    public byte[][] assembleColor(float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, boolean[] single_missing, ShadowType shadow_api) throws VisADException, RemoteException {
        return this.adaptedShadowType.assembleColor(display_values, valueArrayLength, valueToScalar, display, default_values, range_select, single_missing, shadow_api);
    }

    public boolean[][] assembleSelect(float[][] display_values, int domain_length, int valueArrayLength, int[] valueToScalar, DisplayImpl display, ShadowType shadow_api) throws VisADException {
        return this.adaptedShadowType.assembleSelect(display_values, domain_length, valueArrayLength, valueToScalar, display, shadow_api);
    }

    public boolean terminalTupleOrScalar(Object group, float[][] display_values, String text_value, TextControl text_control, int valueArrayLength, int[] valueToScalar, float[] default_values, int[] inherited_values, DataRenderer renderer) throws VisADException, RemoteException {
        boolean post = this.adaptedShadowType.terminalTupleOrScalar(group, display_values, text_value, text_control, valueArrayLength, valueToScalar, default_values, inherited_values, renderer, this);
        this.ensureNotEmpty(group);
        return post;
    }

    public void ensureNotEmpty(Object obj) {
        ShadowTypeJ3D.ensureNotEmpty(obj, this.display);
    }

    public static void ensureNotEmpty(Object obj, DisplayImpl display) {
        if (!(obj instanceof Group)) {
            return;
        }
        Group group = (Group)obj;
        if (group.numChildren() > 0) {
            return;
        }
        PointArray geometry = new PointArray(1, 5);
        float[] coordinates = new float[]{1000000.0f, 1000000.0f, 1000000.0f};
        geometry.setCoordinates(0, coordinates);
        float[] colors = new float[]{0.0f, 0.0f, 0.0f};
        geometry.setColors(0, colors);
        Appearance appearance = ShadowTypeJ3D.staticMakeAppearance(display.getGraphicsModeControl(), null, null, (GeometryArray)geometry, false);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        group.addChild((Node)shape);
    }

    public boolean addToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        if (array != null && array.vertexCount > 0) {
            float af = 0.0f;
            TransparencyAttributes c_alpha = null;
            if (constant_alpha == 1.0f) {
                c_alpha = new TransparencyAttributes(4, 0.0f);
            } else if (constant_alpha == constant_alpha) {
                c_alpha = new TransparencyAttributes(mode.getTransparencyMode(), constant_alpha);
                af = constant_alpha;
            } else {
                c_alpha = new TransparencyAttributes(mode.getTransparencyMode(), 0.0f);
            }
            ColoringAttributes c_color = null;
            if (constant_color != null && constant_color.length == 3) {
                c_color = new ColoringAttributes();
                c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
                if (!(array instanceof VisADLineArray || array instanceof VisADPointArray || array instanceof VisADLineStripArray || array.colors != null)) {
                    int color_len = 3;
                    if (af != 0.0f) {
                        color_len = 4;
                    }
                    byte r = ShadowType.floatToByte(constant_color[0]);
                    byte g = ShadowType.floatToByte(constant_color[1]);
                    byte b2 = ShadowType.floatToByte(constant_color[2]);
                    int len = array.vertexCount * color_len;
                    byte[] colors = new byte[len];
                    boolean k = false;
                    if (color_len == 3) {
                        int i = 0;
                        while (i < len) {
                            colors[i] = r;
                            colors[i + 1] = g;
                            colors[i + 2] = b2;
                            i += 3;
                        }
                    } else {
                        byte a2 = ShadowType.floatToByte(af);
                        int i = 0;
                        while (i < len) {
                            colors[i] = r;
                            colors[i + 1] = g;
                            colors[i + 2] = b2;
                            colors[i + 3] = a2;
                            i += 4;
                        }
                    }
                    array.colors = colors;
                }
            }
            GeometryArray geometry = this.display.makeGeometry(array);
            Appearance appearance = this.makeAppearance(mode, c_alpha, c_color, geometry, false);
            Shape3D shape = new Shape3D((Geometry)geometry, appearance);
            ((Group)group).addChild((Node)shape);
            return true;
        }
        return false;
    }

    public boolean addTextToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        if (array != null && array.vertexCount > 0) {
            float af = 0.0f;
            TransparencyAttributes c_alpha = null;
            if (constant_alpha == 1.0f) {
                c_alpha = new TransparencyAttributes(4, 0.0f);
            } else if (constant_alpha == constant_alpha) {
                c_alpha = new TransparencyAttributes(mode.getTransparencyMode(), constant_alpha);
                af = constant_alpha;
            } else {
                c_alpha = new TransparencyAttributes(mode.getTransparencyMode(), 0.0f);
            }
            ColoringAttributes c_color = null;
            if (constant_color != null && constant_color.length == 3) {
                c_color = new ColoringAttributes();
                c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
                if (!(array instanceof VisADLineArray || array instanceof VisADPointArray || array instanceof VisADLineStripArray || array.colors != null)) {
                    int color_len = 3;
                    if (af != 0.0f) {
                        color_len = 4;
                    }
                    byte r = ShadowType.floatToByte(constant_color[0]);
                    byte g = ShadowType.floatToByte(constant_color[1]);
                    byte b2 = ShadowType.floatToByte(constant_color[2]);
                    int len = array.vertexCount * color_len;
                    byte[] colors = new byte[len];
                    boolean k = false;
                    if (color_len == 3) {
                        int i = 0;
                        while (i < len) {
                            colors[i] = r;
                            colors[i + 1] = g;
                            colors[i + 2] = b2;
                            i += 3;
                        }
                    } else {
                        byte a2 = ShadowType.floatToByte(af);
                        int i = 0;
                        while (i < len) {
                            colors[i] = r;
                            colors[i + 1] = g;
                            colors[i + 2] = b2;
                            colors[i + 3] = a2;
                            i += 4;
                        }
                    }
                    array.colors = colors;
                }
            }
            GeometryArray geometry = this.display.makeGeometry(array);
            Appearance appearance = this.makeAppearance(mode, c_alpha, c_color, geometry, false);
            Shape3D shape = new Shape3D((Geometry)geometry, appearance);
            ((Group)group).addChild((Node)shape);
            if (array instanceof VisADTriangleArray) {
                GeometryArray geometry2 = this.display.makeGeometry(array);
                Appearance appearance2 = this.makeAppearance(mode, c_alpha, c_color, geometry2, false);
                PolygonAttributes pa = appearance2.getPolygonAttributes();
                pa.setPolygonMode(1);
                Shape3D shape2 = new Shape3D((Geometry)geometry2, appearance2);
                ((Group)group).addChild((Node)shape2);
            }
            return true;
        }
        return false;
    }

    public boolean allowConstantColorSurfaces() {
        return false;
    }

    public String toString() {
        return this.adaptedShadowType.toString();
    }
}

