/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import visad.Data;
import visad.DataImpl;
import visad.DoubleSet;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.data.DefaultFamily;

public class DumpType {
    private static boolean init = true;
    private static OutputStream os;

    public static void dumpDataType(Data d2) {
        DumpType.dumpDataType(d2, System.out);
    }

    public static void dumpDataType(Data d2, OutputStream uos) {
        os = uos;
        DumpType.dumpDT(d2, " ");
    }

    private static void dumpDT(Data d2, String prefix) {
        if (init) {
            System.out.println("VisAD Data analysis");
        }
        init = false;
        try {
            if (d2 instanceof FlatField) {
                int nr = ((FlatField)d2).getRangeDimension();
                int nd = ((FlatField)d2).getDomainDimension();
                Set ds = ((FlatField)d2).getDomainSet();
                prefix = prefix + "  ";
                System.out.println(prefix + " FlatField of length = " + ((FlatField)d2).getLength());
                System.out.println(prefix + " " + ((FlatField)d2).getType().prettyString());
                prefix = prefix + "  ";
                System.out.println(prefix + " Domain has " + nd + " components:");
                DumpType.dumpDT(ds, prefix + "  ");
                System.out.println(prefix + " Range has " + nr + " components:");
                Set[] dr = ((FlatField)d2).getRangeSets();
                float[][] samples = ((FlatField)d2).getFloats(false);
                int i = 0;
                while (i < dr.length) {
                    DumpType.dumpDT(dr[i], prefix + "   " + i + ".");
                    int nmiss = 0;
                    if (samples[i] == null) {
                        nmiss = ((FlatField)d2).getLength();
                    } else {
                        int j = 0;
                        while (j < samples[i].length) {
                            if (samples[i][j] != samples[i][j]) {
                                ++nmiss;
                            }
                            ++j;
                        }
                    }
                    System.out.println(prefix + "   " + i + ". number missing = " + nmiss);
                    ++i;
                }
            } else if (d2 instanceof FieldImpl) {
                int nd = ((FieldImpl)d2).getDomainDimension();
                Set ds = ((FieldImpl)d2).getDomainSet();
                System.out.println(prefix + " FieldImpl of length = " + ((FieldImpl)d2).getLength());
                System.out.println(prefix + " " + ((FieldImpl)d2).getType().prettyString());
                System.out.println(prefix + " Domain has " + nd + " components:");
                DumpType.dumpDT(ds, prefix + "  ");
                System.out.println(prefix + " first sample = ");
                DumpType.dumpDT(((FieldImpl)d2).getSample(0, false), prefix + "   " + 0 + ".");
            } else if (d2 instanceof Field) {
                System.out.println(prefix + " Field: ");
            } else if (d2 instanceof Function) {
                System.out.println(prefix + " Function: ");
                System.out.println(prefix + "    Domain dimension= " + ((Function)d2).getDomainDimension());
            } else if (d2 instanceof Irregular3DSet) {
                System.out.println(prefix + " Irregular3DSet " + DumpType.name(((Irregular3DSet)d2).getType().toString()) + " Length = " + ((Irregular3DSet)d2).getLength());
            } else if (d2 instanceof Irregular2DSet) {
                System.out.println(prefix + " Irregular2DSet " + DumpType.name(((Irregular2DSet)d2).getType().toString()) + " Length = " + ((Irregular2DSet)d2).getLength());
            } else if (d2 instanceof Irregular1DSet) {
                System.out.println(prefix + " Irregular1DSet " + DumpType.name(((Irregular1DSet)d2).getType().toString()) + " Length = " + ((Irregular1DSet)d2).getLength());
            } else if (d2 instanceof IrregularSet) {
                System.out.println(prefix + " IrregularSet " + DumpType.name(((IrregularSet)d2).getType().toString()) + " Length = " + ((IrregularSet)d2).getLength());
            } else if (d2 instanceof Integer3DSet) {
                System.out.println(prefix + " Integer3DSet: Length = " + ((Integer3DSet)d2).getLength());
                int i = 0;
                while (i < 3) {
                    DumpType.dumpDT(((Linear3DSet)d2).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof Linear3DSet) {
                System.out.println(prefix + " Linear3DSet: Length = " + ((Linear3DSet)d2).getLength());
                int i = 0;
                while (i < 3) {
                    DumpType.dumpDT(((Linear3DSet)d2).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof Gridded3DSet) {
                System.out.println(prefix + " Gridded3DSet " + DumpType.name(((Gridded3DSet)d2).getType().toString()) + " Length = " + ((Gridded3DSet)d2).getLength());
            } else if (d2 instanceof Integer2DSet) {
                System.out.println(prefix + " Integer2DSet: Length = " + ((Integer2DSet)d2).getLength());
                int i = 0;
                while (i < 2) {
                    DumpType.dumpDT(((Linear2DSet)d2).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof Linear2DSet) {
                System.out.println(prefix + " Linear2DSet: Length = " + ((Linear2DSet)d2).getLength());
                int i = 0;
                while (i < 2) {
                    DumpType.dumpDT(((Linear2DSet)d2).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof Gridded2DSet) {
                System.out.println(prefix + " Gridded2DSet " + DumpType.name(((Gridded2DSet)d2).getType().toString()) + " Length = " + ((Gridded2DSet)d2).getLength());
            } else if (d2 instanceof Integer1DSet) {
                System.out.println(prefix + " Integer1DSet " + DumpType.name(((Integer1DSet)d2).getType().toString()) + " Range = 0 to " + (((Integer1DSet)d2).getLength() - 1));
            } else if (d2 instanceof Linear1DSet) {
                System.out.println(prefix + " Linear1DSet " + DumpType.name(((Linear1DSet)d2).getType().toString()) + " Range = " + ((Linear1DSet)d2).getFirst() + " to " + ((Linear1DSet)d2).getLast() + " step " + ((Linear1DSet)d2).getStep());
            } else if (d2 instanceof Gridded1DSet) {
                System.out.println(prefix + " Gridded1DSet " + DumpType.name(((Gridded1DSet)d2).getType().toString()) + "  Length = " + ((Gridded1DSet)d2).getLength());
            } else if (d2 instanceof IntegerNDSet) {
                System.out.println(prefix + " IntegerNDSet: Dimension = " + ((IntegerNDSet)d2).getDimension());
                int i = 0;
                while (i < ((IntegerNDSet)d2).getDimension()) {
                    DumpType.dumpDT(((LinearNDSet)d2).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof LinearNDSet) {
                System.out.println(prefix + " LinearNDSet: Dimension = " + ((LinearNDSet)d2).getDimension());
                int i = 0;
                while (i < ((LinearNDSet)d2).getDimension()) {
                    DumpType.dumpDT(((LinearNDSet)d2).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof GriddedSet) {
                System.out.println(prefix + " GriddedSet " + DumpType.name(((GriddedSet)d2).getType().toString()) + "  Dimension = " + ((GriddedSet)d2).getDimension());
            } else if (d2 instanceof UnionSet) {
                System.out.println(prefix + " UnionSet " + DumpType.name(((UnionSet)d2).getType().toString()) + "  Dimension = " + ((UnionSet)d2).getDimension());
            } else if (d2 instanceof ProductSet) {
                System.out.println(prefix + " ProductSet " + DumpType.name(((ProductSet)d2).getType().toString()) + "  Dimension = " + ((ProductSet)d2).getDimension());
            } else if (d2 instanceof SampledSet) {
                System.out.println(prefix + " SampledSet " + DumpType.name(((SampledSet)d2).getType().toString()) + "  Dimension = " + ((SampledSet)d2).getDimension());
            } else if (d2 instanceof FloatSet) {
                System.out.println(prefix + " FloatSet " + DumpType.name(((FloatSet)d2).getType().toString()) + " Dimension = " + ((FloatSet)d2).getDimension());
            } else if (d2 instanceof DoubleSet) {
                System.out.println(prefix + " DoubleSet " + DumpType.name(((DoubleSet)d2).getType().toString()) + "  Dimension = " + ((DoubleSet)d2).getDimension());
            } else if (d2 instanceof SimpleSet) {
                System.out.println(prefix + " SimpleSet: ");
            } else if (d2 instanceof Set) {
                System.out.println(prefix + " Set: ");
            } else if (d2 instanceof RealTuple) {
                int n = ((RealTuple)d2).getDimension();
                System.out.println(prefix + " RealTuple has " + n + " components:");
                RealTuple df = (RealTuple)d2;
                int i = 0;
                while (i < n) {
                    DumpType.dumpDT(((RealTuple)d2).getComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof Tuple) {
                int n = ((Tuple)d2).getDimension();
                System.out.println(prefix + " Tuple has " + n + " components:");
                Tuple df = (Tuple)d2;
                int i = 0;
                while (i < n) {
                    System.out.println("  ");
                    DumpType.dumpDT(((Tuple)d2).getComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d2 instanceof Text) {
                System.out.println(prefix + " Text: " + d2);
            } else if (d2 instanceof Real) {
                System.out.println(prefix + " Real: " + d2);
            } else {
                System.out.println("Unknown type for " + d2);
            }
        }
        catch (Exception e2) {
            System.out.println("Exception:" + e2);
            return;
        }
    }

    private static String name(String n) {
        return n.substring(n.lastIndexOf("("));
    }

    public static void dumpMathType(MathType t2) {
        DumpType.dumpMathType(t2, System.out);
    }

    public static void dumpMathType(MathType t2, OutputStream uos) {
        os = uos;
        DumpType.dumpMT(t2, " ");
    }

    private static void dumpMT(MathType t2, String prefix) {
        if (init) {
            System.out.println("VisAD MathType analysis");
        }
        init = false;
        try {
            if (t2 instanceof FunctionType) {
                System.out.println(prefix + " FunctionType: ");
                RealTupleType domain = ((FunctionType)t2).getDomain();
                int num = domain.getDimension();
                System.out.println(prefix + " Domain has " + num + " components:");
                int i = 0;
                while (i < num) {
                    MathType comp = domain.getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                    ++i;
                }
                System.out.println(prefix + " Range:");
                MathType range = ((FunctionType)t2).getRange();
                DumpType.dumpMT(range, prefix + "  ");
            } else if (t2 instanceof SetType) {
                System.out.println(prefix + " SetType: " + t2);
            } else if (t2 instanceof RealTupleType) {
                int num = ((RealTupleType)t2).getDimension();
                System.out.println(prefix + " RealTupleType has " + num + " components:");
                int i = 0;
                while (i < num) {
                    MathType comp = ((RealTupleType)t2).getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                    ++i;
                }
            } else if (t2 instanceof TupleType) {
                int num = ((TupleType)t2).getDimension();
                System.out.println(prefix + " TupleType has " + num + " components:");
                int i = 0;
                while (i < num) {
                    MathType comp = ((TupleType)t2).getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                    ++i;
                }
            } else if (t2 instanceof TextType) {
                System.out.println(prefix + " TextType: " + t2);
            } else if (t2 instanceof RealType) {
                Set ds;
                System.out.println(prefix + " RealType: " + t2);
                prefix = prefix + "  ";
                System.out.println(prefix + " Name = " + ((RealType)t2).toString());
                Unit du = ((RealType)t2).getDefaultUnit();
                String s = null;
                if (du != null) {
                    s = du.toString();
                }
                if (s != null) {
                    System.out.println(prefix + " Unit: " + s);
                }
                if ((ds = ((RealType)t2).getDefaultSet()) != null) {
                    MathType dsmt = ds.getType();
                    System.out.println(prefix + " Set: " + dsmt);
                }
            } else if (t2 instanceof ScalarType) {
                System.out.println(prefix + " ScaleType: " + t2);
            } else {
                System.out.println("Unknown type for " + t2);
            }
        }
        catch (Exception e2) {
            System.out.println("Exception:" + e2);
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: visad.jmet.DumpType <infile> ");
            System.exit(1);
            return;
        }
        DefaultFamily fr = new DefaultFamily("sample");
        URL url = null;
        try {
            url = new URL(args[0]);
        }
        catch (MalformedURLException exc) {
            // empty catch block
        }
        try {
            if (url != null) {
                System.out.println("Trying URL " + url.toString());
            } else {
                System.out.println("Trying file " + args[0]);
            }
            DataImpl data = url == null ? fr.open(args[0]) : fr.open(url);
            System.out.println(args[0] + ": " + data.getType().prettyString());
            System.out.println("  ");
            if (data != null) {
                DumpType.dumpDataType(data, System.out);
                MathType t2 = data.getType();
                init = true;
                System.out.println("  ");
                DumpType.dumpMathType(t2, System.out);
            }
        }
        catch (Exception e2) {
            System.out.println(e2);
            System.exit(1);
        }
        System.exit(0);
    }
}

