/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.util.Date;
import visad.CoordinateSystem;
import visad.DataImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.jmet.MetGridDirectory;

public class MetGrid {
    protected MetGridDirectory dir;
    protected FlatField data;
    protected CoordinateSystem coordinateSystem;
    protected Date referenceTime;
    protected Date validTime;
    RealTupleType grid_domain;
    Integer2DSet dom_set;

    public MetGrid(MetGridDirectory d2, double[] gpData) {
        this.coordinateSystem = d2.getCoordinateSystem();
        this.dir = d2;
        try {
            RealType Nx = RealType.getRealType("Nx");
            RealType Ny = RealType.getRealType("Ny");
            String param = d2.getParamName().trim();
            RealType value_type = RealType.getRealType(param);
            RealType[] domain_components = new RealType[]{Nx, Ny};
            this.grid_domain = new RealTupleType(domain_components, this.coordinateSystem, null);
            this.dom_set = new Integer2DSet((MathType)this.grid_domain, this.dir.getColumns(), this.dir.getRows());
            FunctionType grid_type = new FunctionType(this.grid_domain, value_type);
            this.data = new FlatField(grid_type, this.dom_set);
            double[][] gdata = new double[][]{gpData};
            this.data.setSamples(gdata, false);
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }

    public Integer2DSet getDomainSet() {
        return this.dom_set;
    }

    public MetGridDirectory getGridDirectory() {
        return this.dir;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public DataImpl getData() {
        return this.data;
    }
}

