/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.Dimension;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import ucar.netcdf.Attribute;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Tuple;
import visad.Unit;
import visad.data.units.Parser;
import visad.jmet.GRIBCoordinateSystem;

public class NetcdfGrids {
    File filename;
    NetcdfFile nc = null;
    double[] pressureLevels;
    double[] valtime;
    double[][] times;
    Set time_set;
    int[] timeIndex;
    DateTime[] validDateTime;
    int num_levels;
    int num_records;
    int xval;
    int yval;
    RealType x;
    RealType y;
    RealType level;
    RealType time_type;
    RealType pres;
    RealTupleType grid_domain;
    Integer2DSet dom_set;
    CoordinateSystem gridCoord;
    int gridNumber;
    int gridTypeCode;

    public NetcdfGrids(String filename) {
        this(new File(filename));
    }

    public NetcdfGrids(File filename) {
        this.filename = filename;
        this.dom_set = null;
        this.gridCoord = null;
        try {
            this.nc = new NetcdfFile(filename, true);
            Object as = null;
            Object ds = null;
            int[] index = new int[1];
            Variable p = this.nc.get("level");
            if (p != null) {
                int[] temp = p.getLengths();
                this.num_levels = temp[0];
                this.pressureLevels = new double[this.num_levels];
                int i = 0;
                while (i < this.num_levels) {
                    index[0] = i;
                    this.pressureLevels[i] = p.getDouble(index);
                    ++i;
                }
            } else {
                this.num_levels = 1;
                this.pressureLevels = new double[this.num_levels];
                this.pressureLevels[0] = 1020.0;
            }
            this.num_records = this.nc.getDimensions().get("record").getLength();
            Variable t2 = this.nc.get("valtime");
            this.valtime = new double[this.num_records];
            this.validDateTime = new DateTime[this.num_records];
            this.timeIndex = new int[this.num_records];
            this.times = new double[1][this.num_records];
            TreeMap<Double, Integer> orderTimes = new TreeMap<Double, Integer>();
            if (t2 != null) {
                Unit baseTimeUnit = Parser.parse(t2.getAttribute("units").getStringValue());
                int[] temp = t2.getLengths();
                int i = 0;
                while (i < this.num_records) {
                    index[0] = i;
                    this.valtime[i] = t2.getDouble(index);
                    orderTimes.put(new Double(this.valtime[i]), new Integer(i));
                    this.validDateTime[i] = new DateTime(new Real(RealType.Time, this.valtime[i], baseTimeUnit));
                    ++i;
                }
                Iterator setIt = orderTimes.keySet().iterator();
                int i2 = 0;
                while (i2 < this.num_records) {
                    Double sv = (Double)setIt.next();
                    Integer isv = (Integer)orderTimes.get(sv);
                    this.timeIndex[i2] = isv;
                    this.times[0][i2] = this.validDateTime[this.timeIndex[i2]].getValue();
                    ++i2;
                }
            } else {
                System.out.println("cannot find valtime-s...using linear steps");
                this.valtime = null;
                int i = 0;
                while (i < this.num_records) {
                    this.timeIndex[i] = i;
                    this.times[0][i] = i;
                    ++i;
                }
            }
            p = this.nc.get("grid_number");
            int[] index2 = new int[p.getRank()];
            int i = 0;
            while (i < index2.length) {
                index2[i] = 0;
                ++i;
            }
            this.gridNumber = p.getInt(index2);
            System.out.println("grid number = " + this.gridNumber);
            p = this.nc.get("grid_type_code");
            index[0] = 0;
            this.gridTypeCode = p.getInt(index);
            System.out.println("grid type code = " + this.gridTypeCode);
        }
        catch (Exception ne) {
            ne.printStackTrace();
            System.exit(1);
        }
    }

    public void setRealTypes(RealType x, RealType y, RealType level, RealType time_type, RealType pres) {
        this.x = x;
        this.y = y;
        this.level = level;
        this.time_type = time_type;
        this.pres = pres;
        try {
            Variable p = this.nc.get("Nx");
            if (p == null) {
                p = this.nc.get("Ni");
            }
            int[] index = new int[]{0};
            this.xval = p.getInt(index);
            p = this.nc.get("Ny");
            if (p == null) {
                p = this.nc.get("Nj");
            }
            this.yval = p.getInt(index);
            System.out.println("x,y dimensions = " + this.xval + " " + this.yval);
            RealType[] domain_components = new RealType[]{x, y};
            if (GRIBCoordinateSystem.isGridNumberKnown(this.gridNumber)) {
                this.gridCoord = new GRIBCoordinateSystem(this.gridNumber);
            } else if (this.gridTypeCode == 0) {
                int[] inx = new int[]{0};
                p = this.nc.get("Ni");
                int Ni = p.getInt(inx);
                p = this.nc.get("Nj");
                int Nj = p.getInt(inx);
                p = this.nc.get("La1");
                double La1 = p.getDouble(inx);
                p = this.nc.get("Lo1");
                double Lo1 = p.getDouble(inx);
                p = this.nc.get("La2");
                double La2 = p.getDouble(inx);
                p = this.nc.get("Lo2");
                double Lo2 = p.getDouble(inx);
                p = this.nc.get("Di");
                double Di = p.getDouble(inx);
                p = this.nc.get("Dj");
                double Dj = p.getDouble(inx);
                this.gridCoord = new GRIBCoordinateSystem(0, Ni, Nj, La1, Lo1, La2, Lo2, Di, Dj);
            }
            this.grid_domain = new RealTupleType(domain_components, this.gridCoord, null);
            this.dom_set = new Integer2DSet((MathType)this.grid_domain, this.xval, this.yval);
            this.time_set = new Gridded1DDoubleSet((MathType)time_type, this.times, this.num_records);
        }
        catch (Exception et) {
            et.printStackTrace();
        }
    }

    public synchronized Vector get4dVariables() {
        Vector<String> retVec = new Vector<String>();
        VariableIterator vi = this.nc.iterator();
        int numVars = this.nc.size();
        int k = 0;
        while (k < numVars) {
            Variable v = vi.next();
            DimensionIterator di = v.getDimensionIterator();
            int numDims = v.getRank();
            if (numDims == 4) {
                int[] dims = v.getLengths();
                String[] dimNames = new String[numDims];
                int xDim = -1;
                int yDim = -1;
                int levelDim = -1;
                int recordDim = -1;
                int i = 0;
                while (i < numDims) {
                    dimNames[i] = di.next().getName().trim();
                    if (dimNames[i] == "x" || dimNames[i] == "lon") {
                        xDim = i;
                    }
                    if (dimNames[i] == "y" || dimNames[i] == "lat") {
                        yDim = i;
                    }
                    if (dimNames[i] == "level") {
                        levelDim = i;
                    }
                    if (dimNames[i] == "record") {
                        recordDim = i;
                    }
                    ++i;
                }
                if (xDim != -1 && yDim != -1 && levelDim != -1 && recordDim != -1) {
                    retVec.addElement(v.getName());
                    retVec.addElement(v.getAttribute("long_name").getStringValue());
                    retVec.addElement(v.getAttribute("units").getStringValue());
                }
            }
            ++k;
        }
        return retVec;
    }

    public synchronized Vector get3dVariables() {
        Vector<String> retVec = new Vector<String>();
        VariableIterator vi = this.nc.iterator();
        int numVars = this.nc.size();
        int k = 0;
        while (k < numVars) {
            Variable v = vi.next();
            DimensionIterator di = v.getDimensionIterator();
            int numDims = v.getRank();
            if (numDims == 3) {
                int[] dims = v.getLengths();
                String[] dimNames = new String[numDims];
                int xDim = -1;
                int yDim = -1;
                int recordDim = -1;
                int i = 0;
                while (i < numDims) {
                    dimNames[i] = di.next().getName().trim();
                    if (dimNames[i] == "x" || dimNames[i] == "lon") {
                        xDim = i;
                    }
                    if (dimNames[i] == "y" || dimNames[i] == "lat") {
                        yDim = i;
                    }
                    if (dimNames[i] == "record") {
                        recordDim = i;
                    }
                    ++i;
                }
                if (xDim != -1 && yDim != -1 && recordDim != -1) {
                    retVec.addElement(v.getName());
                    retVec.addElement(v.getAttribute("long_name").getStringValue());
                    Attribute uni = v.getAttribute("units");
                    if (uni != null) {
                        retVec.addElement(uni.getStringValue());
                    } else {
                        retVec.addElement("null");
                    }
                }
            }
            ++k;
        }
        return retVec;
    }

    public synchronized String[][] getVariableNames() {
        VariableIterator vi = this.nc.iterator();
        int numVars = this.nc.size();
        String[][] names = new String[3][numVars];
        int i = 0;
        while (i < numVars) {
            Variable v = vi.next();
            names[0][i] = v.getName();
            names[1][i] = v.getAttribute("long_name").getStringValue();
            names[2][i] = v.getAttribute("units").getStringValue();
            ++i;
        }
        return names;
    }

    public double getAspect() {
        if (this.gridCoord != null) {
            return ((GRIBCoordinateSystem)this.gridCoord).getAspectRatio();
        }
        return 1.0;
    }

    public int getNumberOfLevels() {
        return this.num_levels;
    }

    public double[] getPressureLevels() {
        return this.pressureLevels;
    }

    public int getNumberOfTimes() {
        return this.num_records;
    }

    public Dimension getDimension() {
        return new Dimension(this.xval, this.yval);
    }

    public Integer2DSet getDomainSet() {
        return this.dom_set;
    }

    public synchronized Tuple[] getGrids(String name, RealType values, double[][] range) {
        Variable v = this.nc.get(name);
        if (v == null) {
            System.out.println("could not find " + v + " in netCDF file");
            System.exit(1);
        }
        Attribute long_name = v.getAttribute("long_name");
        Attribute units = v.getAttribute("units");
        Attribute fillvalue = v.getAttribute("_FillValue");
        double fill = fillvalue.getNumericValue().doubleValue();
        DimensionIterator di = v.getDimensionIterator();
        int numDims = v.getRank();
        int[] dims = v.getLengths();
        String[] dimNames = new String[numDims];
        int xDim = -1;
        int yDim = -1;
        int levelDim = -1;
        int recordDim = -1;
        int i = 0;
        while (i < numDims) {
            dimNames[i] = di.next().getName().trim();
            if (dimNames[i] == "x" || dimNames[i] == "lon") {
                xDim = i;
            }
            if (dimNames[i] == "y" || dimNames[i] == "lat") {
                yDim = i;
            }
            if (dimNames[i] == "level") {
                levelDim = i;
            }
            if (dimNames[i] == "record") {
                recordDim = i;
            }
            ++i;
        }
        if (xDim == -1 || yDim == -1) {
            System.out.println("one or more x-y dimensions missing");
            System.exit(1);
        }
        int[] index = new int[numDims];
        Tuple[] tup = null;
        try {
            FunctionType grid_type = new FunctionType(this.grid_domain, values);
            FunctionType withTime_type = new FunctionType(this.time_type, grid_type);
            tup = new Tuple[this.num_levels];
            int gridDim = dims[xDim] * dims[yDim];
            double[][] grids = new double[1][gridDim];
            Data[] griddata = new Data[2];
            if (levelDim != -1 && recordDim != -1) {
                int p = 0;
                while (p < this.num_levels) {
                    index[levelDim] = p;
                    range[p][0] = Double.MAX_VALUE;
                    range[p][1] = -1.7976931348623157E308;
                    FieldImpl withTime = new FieldImpl(withTime_type, this.time_set);
                    int t2 = 0;
                    while (t2 < this.num_records) {
                        index[recordDim] = this.timeIndex[t2];
                        int i2 = 0;
                        while (i2 < dims[yDim]) {
                            index[yDim] = i2;
                            int j = 0;
                            while (j < dims[xDim]) {
                                index[xDim] = j;
                                double value = v.getDouble(index);
                                if (value == fill) {
                                    value = Double.NaN;
                                } else {
                                    if (value < range[p][0]) {
                                        range[p][0] = value;
                                    }
                                    if (value > range[p][1]) {
                                        range[p][1] = value;
                                    }
                                }
                                grids[0][i2 * dims[xDim] + j] = value;
                                ++j;
                            }
                            ++i2;
                        }
                        FlatField nffg = new FlatField(grid_type, this.dom_set);
                        nffg.setSamples(grids, false);
                        withTime.setSample(t2, (Data)nffg);
                        ++t2;
                    }
                    griddata[0] = new Real(this.pres, this.pressureLevels[p]);
                    griddata[1] = withTime;
                    tup[p] = new Tuple(griddata);
                    ++p;
                }
            } else if (recordDim != -1) {
                range[0][0] = Double.MAX_VALUE;
                range[0][1] = -1.7976931348623157E308;
                FieldImpl withTime = new FieldImpl(withTime_type, this.time_set);
                int t3 = 0;
                while (t3 < this.num_records) {
                    index[recordDim] = this.timeIndex[t3];
                    int i3 = 0;
                    while (i3 < dims[yDim]) {
                        index[yDim] = i3;
                        int j = 0;
                        while (j < dims[xDim]) {
                            index[xDim] = j;
                            double value = v.getDouble(index);
                            if (value == fill) {
                                value = Double.NaN;
                            } else {
                                if (value < range[0][0]) {
                                    range[0][0] = value;
                                }
                                if (value > range[0][1]) {
                                    range[0][1] = value;
                                }
                            }
                            grids[0][i3 * dims[xDim] + j] = value;
                            ++j;
                        }
                        ++i3;
                    }
                    FlatField nffg = new FlatField(grid_type, this.dom_set);
                    nffg.setSamples(grids, false);
                    withTime.setSample(t3, (Data)nffg);
                    ++t3;
                }
                griddata[0] = new Real(this.pres, 1020.0);
                griddata[1] = withTime;
                tup[0] = new Tuple(griddata);
            } else {
                int i4 = 0;
                while (i4 < dims[yDim]) {
                    index[yDim] = i4;
                    int j = 0;
                    while (j < dims[xDim]) {
                        index[xDim] = j;
                        double value = v.getDouble(index);
                        if (value == fill) {
                            value = Double.NaN;
                        } else {
                            if (value < range[0][0]) {
                                range[0][0] = value;
                            }
                            if (value > range[0][1]) {
                                range[0][1] = value;
                            }
                        }
                        grids[0][i4 * dims[xDim] + j] = value;
                        ++j;
                    }
                    ++i4;
                }
                FlatField nffg = new FlatField(grid_type, this.dom_set);
                nffg.setSamples(grids, false);
                griddata[0] = new Real(this.pres, 1020.0);
                griddata[1] = nffg;
                tup[0] = new Tuple(griddata);
            }
        }
        catch (Exception ve) {
            ve.printStackTrace();
            System.exit(1);
        }
        return tup;
    }

    public static void main(String[] args) {
        try {
            NetcdfGrids ng = new NetcdfGrids("97032712_eta.nc");
            RealType x = RealType.getRealType("x");
            RealType y = RealType.getRealType("y");
            RealType level = RealType.getRealType("level");
            RealType time_type = RealType.Time;
            RealType pres = RealType.getRealType("pres");
            RealType Z = RealType.getRealType("Z");
            int num_levels = ng.getNumberOfLevels();
            double[][] range = new double[num_levels][2];
            ng.setRealTypes(x, y, level, time_type, pres);
            Tuple[] d2 = ng.getGrids("Z", Z, range);
            System.out.println("range = " + range[0][0] + " - " + range[0][1]);
        }
        catch (Exception me) {
            me.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized Tuple[][] getGridsWithTime(String name, RealType values, double[][] range) {
        Variable v = this.nc.get(name);
        if (v == null) {
            System.out.println("could not find " + v + " in netCDF file");
            System.exit(1);
        }
        Attribute long_name = v.getAttribute("long_name");
        Attribute units = v.getAttribute("units");
        Attribute fillvalue = v.getAttribute("_FillValue");
        DimensionIterator di = v.getDimensionIterator();
        int numDims = v.getRank();
        int[] dims = v.getLengths();
        String[] dimNames = new String[numDims];
        int xDim = -1;
        int yDim = -1;
        int levelDim = -1;
        int recordDim = -1;
        int i = 0;
        while (i < numDims) {
            dimNames[i] = di.next().getName().trim();
            if (dimNames[i] == "x") {
                xDim = i;
            }
            if (dimNames[i] == "y") {
                yDim = i;
            }
            if (dimNames[i] == "level") {
                levelDim = i;
            }
            if (dimNames[i] == "record") {
                recordDim = i;
            }
            ++i;
        }
        if (xDim == -1 || yDim == -1) {
            System.out.println("one or more x-y dimensions missing");
            System.exit(1);
        }
        int[] index = new int[numDims];
        Tuple[][] tup = null;
        try {
            RealType[] domain_components = new RealType[]{this.x, this.y};
            this.gridCoord = new GRIBCoordinateSystem(this.gridNumber);
            RealTupleType grid_domain = new RealTupleType(domain_components, this.gridCoord, null);
            this.dom_set = new Integer2DSet((MathType)grid_domain, dims[xDim], dims[yDim]);
            FunctionType grid_type = new FunctionType(grid_domain, values);
            tup = new Tuple[this.num_levels][this.num_records];
            int gridDim = dims[xDim] * dims[yDim];
            double[][] grids = new double[1][gridDim];
            Data[] griddata = new Data[2];
            if (levelDim != -1 && recordDim != -1) {
                int p = 0;
                while (p < this.num_levels) {
                    index[levelDim] = p;
                    int t2 = 0;
                    while (t2 < this.num_records) {
                        index[recordDim] = this.timeIndex[t2];
                        int i2 = 0;
                        while (i2 < dims[yDim]) {
                            index[yDim] = i2;
                            int j = 0;
                            while (j < dims[xDim]) {
                                index[xDim] = j;
                                grids[0][i2 * dims[xDim] + j] = v.getDouble(index);
                                ++j;
                            }
                            ++i2;
                        }
                        FlatField nffg = new FlatField(grid_type, this.dom_set);
                        nffg.setSamples(grids, false);
                        griddata[0] = new Real(this.pres, this.pressureLevels[p]);
                        griddata[1] = nffg;
                        tup[p][t2] = new Tuple(griddata);
                        ++t2;
                    }
                    ++p;
                }
            } else if (recordDim != -1) {
                int t3 = 0;
                while (t3 < this.num_records) {
                    index[recordDim] = this.timeIndex[t3];
                    int i3 = 0;
                    while (i3 < dims[yDim]) {
                        index[yDim] = i3;
                        int j = 0;
                        while (j < dims[xDim]) {
                            index[xDim] = j;
                            grids[0][i3 * dims[xDim] + j] = v.getDouble(index);
                            ++j;
                        }
                        ++i3;
                    }
                    FlatField nffg = new FlatField(grid_type, this.dom_set);
                    nffg.setSamples(grids, false);
                    griddata[0] = new Real(this.pres, 1020.0);
                    griddata[1] = nffg;
                    tup[0][t3] = new Tuple(griddata);
                    ++t3;
                }
            } else {
                int i4 = 0;
                while (i4 < dims[yDim]) {
                    index[yDim] = i4;
                    int j = 0;
                    while (j < dims[xDim]) {
                        index[xDim] = j;
                        grids[0][i4 * dims[xDim] + j] = v.getDouble(index);
                        ++j;
                    }
                    ++i4;
                }
                FlatField nffg = new FlatField(grid_type, this.dom_set);
                nffg.setSamples(grids, false);
                griddata[0] = new Real(this.pres, 1020.0);
                griddata[1] = nffg;
                int t4 = 0;
                while (t4 < this.num_records) {
                    tup[0][t4] = new Tuple(griddata);
                    ++t4;
                }
            }
        }
        catch (Exception ve) {
            ve.printStackTrace();
            System.exit(1);
        }
        return tup;
    }
}

