/*
 * Decompiled with CFR 0.152.
 */
package visad.math;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DoubleSet;
import visad.Field;
import visad.FieldException;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public class FFT {
    public static FlatField forwardFT(Data[] datums) {
        FlatField result = null;
        try {
            result = FFT.fourierTransform((Field)datums[0], true);
        }
        catch (VisADException e2) {
            e2.printStackTrace();
        }
        catch (RemoteException e3) {
            e3.printStackTrace();
        }
        if (result == null) {
            System.out.println("result == null");
        }
        return result;
    }

    public static FlatField backwardFT(Data[] datums) {
        FlatField result = null;
        try {
            result = FFT.fourierTransform((Field)datums[0], false);
        }
        catch (VisADException e2) {
            e2.printStackTrace();
        }
        catch (RemoteException e3) {
            e3.printStackTrace();
        }
        if (result == null) {
            System.out.println("result == null");
        }
        return result;
    }

    public static FlatField fourierTransform(Field field, boolean forward) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, forward, null, null, null, null, null);
    }

    public static FlatField fourierTransform(Field field, boolean forward, FunctionType ftype, GriddedSet domain_set, CoordinateSystem range_coord_sys, Set[] range_sets, Unit[] units) throws VisADException, RemoteException {
        int i;
        MathType rftype;
        if (field == null) {
            return null;
        }
        FunctionType type = (FunctionType)field.getType();
        RealTupleType dtype = type.getDomain();
        int ddim = dtype.getDimension();
        MathType rtype = type.getRange();
        RealType[] realComponents = null;
        int rdim = 0;
        if (rtype instanceof RealType) {
            realComponents = new RealType[]{(RealType)rtype};
            rdim = 1;
        } else if (rtype instanceof RealTupleType) {
            realComponents = ((RealTupleType)rtype).getRealComponents();
            rdim = realComponents.length;
        } else {
            throw new FieldException("bad range type " + rtype);
        }
        if (ddim != 1 && ddim != 2) {
            throw new FieldException("bad domain dimension " + dtype);
        }
        if (rdim != 1 && rdim != 2) {
            throw new FieldException("bad range dimension " + rtype);
        }
        if (units == null || units.length == 0) {
            units = new Unit[]{null, null};
        } else if (units.length == 1) {
            units = new Unit[]{units[0], null};
        }
        if (ftype == null) {
            String name;
            RealType[] newReals = new RealType[2];
            if (rdim == 2) {
                if (forward) {
                    name = realComponents[0].getName() + "_FT";
                    newReals[0] = RealType.getRealType(name, units[0], null);
                    name = realComponents[1].getName() + "_FT";
                    newReals[1] = RealType.getRealType(name, units[1], null);
                } else {
                    name = realComponents[0].getName();
                    if (name.endsWith("_FT")) {
                        name = name.substring(0, name.length() - 3);
                    } else if (name.endsWith("_FT_real")) {
                        name = name.substring(0, name.length() - 8);
                    } else if (name.endsWith("_RFT_real")) {
                        name = name.substring(0, name.length() - 9);
                    }
                    newReals[0] = RealType.getRealType(name, units[0], null);
                    name = realComponents[1].getName();
                    if (name.endsWith("_FT")) {
                        name = name.substring(0, name.length() - 3);
                    } else if (name.endsWith("_FT_imag")) {
                        name = name.substring(0, name.length() - 8) + "_imag";
                    } else if (name.endsWith("_RFT_imag")) {
                        name = name.substring(0, name.length() - 9) + "_imag";
                    }
                    newReals[1] = RealType.getRealType(name, units[1], null);
                }
            } else if (forward) {
                name = realComponents[0].getName() + "_FT";
                newReals[0] = RealType.getRealType(name + "_real", units[0], null);
                newReals[1] = RealType.getRealType(name + "_imag", units[1], null);
            } else {
                name = realComponents[0].getName() + "_RFT";
                newReals[0] = RealType.getRealType(name + "_real", units[0], null);
                newReals[1] = RealType.getRealType(name + "_imag", units[1], null);
            }
            rftype = new RealTupleType(newReals, range_coord_sys, null);
            ftype = new FunctionType(dtype, rftype);
        } else {
            RealTupleType dftype = ftype.getDomain();
            if (dftype.getDimension() != ddim) {
                throw new FieldException("bad domain dimension " + dftype);
            }
            rftype = ftype.getRange();
            if (!(rftype instanceof RealTupleType) || ((RealTupleType)rftype).getDimension() != 2) {
                throw new FieldException("bad range type " + rftype);
            }
        }
        Set field_set = field.getDomainSet();
        if (!(field_set instanceof GriddedSet)) {
            throw new FieldException("field domain set must be Gridded2DSet " + field_set);
        }
        int[] field_lens = ((GriddedSet)field_set).getLengths();
        if (domain_set == null) {
            domain_set = (GriddedSet)field_set;
        } else {
            if (domain_set.getDimension() != ddim) {
                throw new FieldException("domain_set bad dimension " + domain_set);
            }
            int[] domain_lens = domain_set.getLengths();
            int i2 = 0;
            while (i2 < ddim) {
                if (field_lens[i2] != domain_lens[i2]) {
                    throw new FieldException("domain_set size must match field domain set " + domain_set + "\n" + field_set);
                }
                ++i2;
            }
        }
        boolean use_double = true;
        if (field instanceof FlatField) {
            use_double = false;
            Set[] fsets = ((FlatField)field).getRangeSets();
            i = 0;
            while (i < fsets.length) {
                if (fsets[i] instanceof DoubleSet) {
                    use_double = true;
                }
                ++i;
            }
        }
        boolean doub = false;
        if (range_sets != null) {
            if (range_sets.length != 2) {
                throw new FieldException("bad range_sets length" + range_sets.length);
            }
            i = 0;
            while (i < 2) {
                if (range_sets[i] instanceof DoubleSet) {
                    doub = true;
                }
                ++i;
            }
        }
        use_double = use_double && doub;
        FlatField new_field = new FlatField(ftype, domain_set, range_coord_sys, null, range_sets, units);
        if (use_double) {
            double[][] values = field.getValues(false);
            if (values.length == 1) {
                int n = values[0].length;
                double[][] new_values = new double[2][n];
                System.arraycopy(values[0], 0, new_values[0], 0, n);
                int i3 = 0;
                while (i3 < n) {
                    new_values[1][i3] = 0.0;
                    ++i3;
                }
                values = new_values;
            }
            values = ddim == 1 ? FFT.FT1D(values, forward) : FFT.FT2D(field_lens[0], field_lens[1], values, forward);
            new_field.setSamples(values, false);
        } else {
            float[][] values = field.getFloats(false);
            if (values.length == 1) {
                int n = values[0].length;
                float[][] new_values = new float[2][n];
                System.arraycopy(values[0], 0, new_values[0], 0, n);
                int i4 = 0;
                while (i4 < n) {
                    new_values[1][i4] = 0.0f;
                    ++i4;
                }
                values = new_values;
            }
            values = ddim == 1 ? FFT.FT1D(values, forward) : FFT.FT2D(field_lens[0], field_lens[1], values, forward);
            new_field.setSamples(values, false);
        }
        return new_field;
    }

    public static float[][] FT2D(int rows, int cols, float[][] x, boolean forward) throws VisADException {
        int r;
        if (x == null) {
            return null;
        }
        if (x.length != 2 || x[0].length != x[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = x[0].length;
        if (rows * cols != n) {
            throw new FieldException(rows + " * " + cols + " must equal " + n);
        }
        float[][] y = new float[2][n];
        float[][] z = new float[2][rows];
        int c2 = 0;
        while (c2 < cols) {
            int i = c2 * rows;
            int r2 = 0;
            while (r2 < rows) {
                z[0][r2] = x[0][i + r2];
                z[1][r2] = x[1][i + r2];
                ++r2;
            }
            z = FFT.FT1D(z, forward);
            r = 0;
            while (r < rows) {
                y[0][i + r] = z[0][r];
                y[1][i + r] = z[1][r];
                ++r;
            }
            ++c2;
        }
        float[][] u = new float[2][n];
        float[][] v = new float[2][cols];
        r = 0;
        while (r < rows) {
            int i = r;
            int c3 = 0;
            while (c3 < cols) {
                v[0][c3] = y[0][i + c3 * rows];
                v[1][c3] = y[1][i + c3 * rows];
                ++c3;
            }
            v = FFT.FT1D(v, forward);
            int c4 = 0;
            while (c4 < cols) {
                u[0][i + c4 * rows] = v[0][c4];
                u[1][i + c4 * rows] = v[1][c4];
                ++c4;
            }
            ++r;
        }
        return u;
    }

    public static double[][] FT2D(int rows, int cols, double[][] x, boolean forward) throws VisADException {
        int r;
        if (x == null) {
            return null;
        }
        if (x.length != 2 || x[0].length != x[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = x[0].length;
        if (rows * cols != n) {
            throw new FieldException(rows + " * " + cols + " must equal " + n);
        }
        double[][] y = new double[2][n];
        double[][] z = new double[2][rows];
        int c2 = 0;
        while (c2 < cols) {
            int i = c2 * rows;
            int r2 = 0;
            while (r2 < rows) {
                z[0][r2] = x[0][i + r2];
                z[1][r2] = x[1][i + r2];
                ++r2;
            }
            z = FFT.FT1D(z, forward);
            r = 0;
            while (r < rows) {
                y[0][i + r] = z[0][r];
                y[1][i + r] = z[1][r];
                ++r;
            }
            ++c2;
        }
        double[][] u = new double[2][n];
        double[][] v = new double[2][cols];
        r = 0;
        while (r < rows) {
            int i = r;
            int c3 = 0;
            while (c3 < cols) {
                v[0][c3] = y[0][i + c3 * rows];
                v[1][c3] = y[1][i + c3 * rows];
                ++c3;
            }
            v = FFT.FT1D(v, forward);
            int c4 = 0;
            while (c4 < cols) {
                u[0][i + c4 * rows] = v[0][c4];
                u[1][i + c4 * rows] = v[1][c4];
                ++c4;
            }
            ++r;
        }
        return u;
    }

    public static float[][] FT1D(float[][] x, boolean forward) throws VisADException {
        if (x == null) {
            return null;
        }
        if (x.length != 2 || x[0].length != x[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = x[0].length;
        int n2 = 1;
        boolean fft = true;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            fft = false;
        }
        if (fft) {
            return FFT.FFT1D(x, forward);
        }
        float[][] temp = new float[2][n];
        float angle = (float)(Math.PI * -2 / (double)n);
        if (!forward) {
            angle = -angle;
        }
        int i = 0;
        while (i < n) {
            temp[0][i] = (float)Math.cos((float)i * angle);
            temp[1][i] = (float)Math.sin((float)i * angle);
            ++i;
        }
        float[][] y = new float[2][n];
        int i2 = 0;
        while (i2 < n) {
            float re = 0.0f;
            float im = 0.0f;
            int j = 0;
            while (j < n) {
                int m = i2 * j % n;
                re += x[0][j] * temp[0][m] - x[1][j] * temp[1][m];
                im += x[0][j] * temp[1][m] + x[1][j] * temp[0][m];
                ++j;
            }
            y[0][i2] = re;
            y[1][i2] = im;
            ++i2;
        }
        if (!forward) {
            int i3 = 0;
            while (i3 < n) {
                float[] fArray = y[0];
                int n3 = i3;
                fArray[n3] = fArray[n3] / (float)n;
                float[] fArray2 = y[1];
                int n4 = i3++;
                fArray2[n4] = fArray2[n4] / (float)n;
            }
        }
        return y;
    }

    public static float[][] FFT1D(float[][] x, boolean forward) throws VisADException {
        if (x == null) {
            return null;
        }
        if (x.length != 2 || x[0].length != x[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = x[0].length;
        int n2 = 1;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            throw new FieldException("x length must be power of 2");
        }
        n2 = n / 2;
        float[][] temp = new float[2][n2];
        float angle = (float)(Math.PI * -2 / (double)n);
        if (!forward) {
            angle = -angle;
        }
        int i = 0;
        while (i < n2) {
            temp[0][i] = (float)Math.cos((float)i * angle);
            temp[1][i] = (float)Math.sin((float)i * angle);
            ++i;
        }
        float[][] y = FFT.FFT1D(x, temp);
        if (!forward) {
            int i2 = 0;
            while (i2 < n) {
                float[] fArray = y[0];
                int n3 = i2;
                fArray[n3] = fArray[n3] / (float)n;
                float[] fArray2 = y[1];
                int n4 = i2++;
                fArray2[n4] = fArray2[n4] / (float)n;
            }
        }
        return y;
    }

    private static float[][] FFT1D(float[][] x, float[][] temp) {
        int n = x[0].length;
        int n2 = n / 2;
        int k = 0;
        int buttered = 0;
        if (n == 1) {
            float[][] z1 = new float[][]{{x[0][0]}, {x[1][0]}};
            return z1;
        }
        int butterfly = temp[0].length / n2;
        float[][] z = new float[2][n2];
        float[][] w = new float[2][n2];
        k = 0;
        while (k < n / 2) {
            int k2 = 2 * k;
            z[0][k] = x[0][k2];
            z[1][k] = x[1][k2];
            w[0][k] = x[0][k2 + 1];
            w[1][k] = x[1][k2 + 1];
            ++k;
        }
        z = FFT.FFT1D(z, temp);
        w = FFT.FFT1D(w, temp);
        float[][] y = new float[2][n];
        k = 0;
        while (k < n2) {
            y[0][k] = z[0][k];
            y[1][k] = z[1][k];
            float re = w[0][k] * temp[0][buttered] - w[1][k] * temp[1][buttered];
            float im = w[0][k] * temp[1][buttered] + w[1][k] * temp[0][buttered];
            w[0][k] = re;
            w[1][k] = im;
            float[] fArray = y[0];
            int n3 = k;
            fArray[n3] = fArray[n3] + w[0][k];
            float[] fArray2 = y[1];
            int n4 = k;
            fArray2[n4] = fArray2[n4] + w[1][k];
            y[0][k + n2] = z[0][k] - w[0][k];
            y[1][k + n2] = z[1][k] - w[1][k];
            buttered += butterfly;
            ++k;
        }
        return y;
    }

    public static double[][] FT1D(double[][] x, boolean forward) throws VisADException {
        if (x == null) {
            return null;
        }
        if (x.length != 2 || x[0].length != x[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = x[0].length;
        int n2 = 1;
        boolean fft = true;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            fft = false;
        }
        if (fft) {
            return FFT.FFT1D(x, forward);
        }
        double[][] temp = new double[2][n];
        double angle = Math.PI * -2 / (double)n;
        if (!forward) {
            angle = -angle;
        }
        int i = 0;
        while (i < n) {
            temp[0][i] = Math.cos((double)i * angle);
            temp[1][i] = Math.sin((double)i * angle);
            ++i;
        }
        double[][] y = new double[2][n];
        int i2 = 0;
        while (i2 < n) {
            double re = 0.0;
            double im = 0.0;
            int j = 0;
            while (j < n) {
                int m = i2 * j % n;
                re += x[0][j] * temp[0][m] - x[1][j] * temp[1][m];
                im += x[0][j] * temp[1][m] + x[1][j] * temp[0][m];
                ++j;
            }
            y[0][i2] = re;
            y[1][i2] = im;
            ++i2;
        }
        if (!forward) {
            int i3 = 0;
            while (i3 < n) {
                double[] dArray = y[0];
                int n3 = i3;
                dArray[n3] = dArray[n3] / (double)n;
                double[] dArray2 = y[1];
                int n4 = i3++;
                dArray2[n4] = dArray2[n4] / (double)n;
            }
        }
        return y;
    }

    public static double[][] FFT1D(double[][] x, boolean forward) throws VisADException {
        if (x == null) {
            return null;
        }
        if (x.length != 2 || x[0].length != x[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = x[0].length;
        int n2 = 1;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            throw new FieldException("x length must be power of 2");
        }
        n2 = n / 2;
        double[][] temp = new double[2][n2];
        double angle = Math.PI * -2 / (double)n;
        if (!forward) {
            angle = -angle;
        }
        int i = 0;
        while (i < n2) {
            temp[0][i] = Math.cos((double)i * angle);
            temp[1][i] = Math.sin((double)i * angle);
            ++i;
        }
        double[][] y = FFT.FFT1D(x, temp);
        if (!forward) {
            int i2 = 0;
            while (i2 < n) {
                double[] dArray = y[0];
                int n3 = i2;
                dArray[n3] = dArray[n3] / (double)n;
                double[] dArray2 = y[1];
                int n4 = i2++;
                dArray2[n4] = dArray2[n4] / (double)n;
            }
        }
        return y;
    }

    private static double[][] FFT1D(double[][] x, double[][] temp) {
        int n = x[0].length;
        int n2 = n / 2;
        int k = 0;
        int buttered = 0;
        if (n == 1) {
            double[][] z1 = new double[][]{{x[0][0]}, {x[1][0]}};
            return z1;
        }
        int butterfly = temp[0].length / n2;
        double[][] z = new double[2][n2];
        double[][] w = new double[2][n2];
        k = 0;
        while (k < n2) {
            int k2 = 2 * k;
            z[0][k] = x[0][k2];
            z[1][k] = x[1][k2];
            w[0][k] = x[0][k2 + 1];
            w[1][k] = x[1][k2 + 1];
            ++k;
        }
        z = FFT.FFT1D(z, temp);
        w = FFT.FFT1D(w, temp);
        double[][] y = new double[2][n];
        k = 0;
        while (k < n2) {
            y[0][k] = z[0][k];
            y[1][k] = z[1][k];
            double re = w[0][k] * temp[0][buttered] - w[1][k] * temp[1][buttered];
            double im = w[0][k] * temp[1][buttered] + w[1][k] * temp[0][buttered];
            w[0][k] = re;
            w[1][k] = im;
            double[] dArray = y[0];
            int n3 = k;
            dArray[n3] = dArray[n3] + w[0][k];
            double[] dArray2 = y[1];
            int n4 = k;
            dArray2[n4] = dArray2[n4] + w[1][k];
            y[0][k + n2] = z[0][k] - w[0][k];
            y[1][k + n2] = z[1][k] - w[1][k];
            buttered += butterfly;
            ++k;
        }
        return y;
    }

    public static void main(String[] args) throws VisADException {
        int r;
        int c2;
        int i;
        int n = 16;
        int rows = 1;
        int cols = 1;
        boolean twod = false;
        if (args.length > 0) {
            n = Integer.valueOf(args[0]);
        }
        if (args.length > 1) {
            rows = Integer.valueOf(args[0]);
            cols = Integer.valueOf(args[1]);
            n = rows * cols;
            twod = true;
        }
        float[][] x = new float[2][n];
        System.out.println("  initial values");
        if (twod) {
            i = 0;
            c2 = 0;
            while (c2 < cols) {
                r = 0;
                while (r < rows) {
                    x[0][i] = (float)(Math.sin(Math.PI * 2 * (double)r / (double)rows) * Math.sin(Math.PI * 2 * (double)c2 / (double)cols));
                    x[1][i] = 0.0f;
                    System.out.println("x[" + r + "][" + c2 + "] = " + PlotText.shortString(x[0][i]) + " " + PlotText.shortString(x[1][i]));
                    ++i;
                    ++r;
                }
                ++c2;
            }
        } else {
            i = 0;
            while (i < n) {
                x[0][i] = (float)Math.sin(Math.PI * 2 * (double)i / (double)n);
                x[1][i] = 0.0f;
                System.out.println("x[" + i + "] = " + PlotText.shortString(x[0][i]) + " " + PlotText.shortString(x[1][i]));
                ++i;
            }
        }
        x = twod ? FFT.FT2D(rows, cols, x, true) : FFT.FT1D(x, true);
        System.out.println("\n  fft");
        if (twod) {
            i = 0;
            c2 = 0;
            while (c2 < cols) {
                r = 0;
                while (r < rows) {
                    System.out.println("x[" + r + "][" + c2 + "] = " + PlotText.shortString(x[0][i]) + " " + PlotText.shortString(x[1][i]));
                    ++i;
                    ++r;
                }
                ++c2;
            }
        } else {
            i = 0;
            while (i < n) {
                System.out.println("x[" + i + "] = " + PlotText.shortString(x[0][i]) + " " + PlotText.shortString(x[1][i]));
                ++i;
            }
        }
        x = twod ? FFT.FT2D(rows, cols, x, false) : FFT.FT1D(x, false);
        System.out.println("\n  back fft");
        if (twod) {
            i = 0;
            c2 = 0;
            while (c2 < cols) {
                r = 0;
                while (r < rows) {
                    System.out.println("x[" + r + "][" + c2 + "] = " + PlotText.shortString(x[0][i]) + " " + PlotText.shortString(x[1][i]));
                    ++i;
                    ++r;
                }
                ++c2;
            }
        } else {
            i = 0;
            while (i < n) {
                System.out.println("x[" + i + "] = " + PlotText.shortString(x[0][i]) + " " + PlotText.shortString(x[1][i]));
                ++i;
            }
        }
    }
}

