/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.netcdf.NetcdfFile;
import visad.AxisScale;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.data.mcidas.PointDataAdapter;
import visad.data.netcdf.Plain;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.in.DefaultView;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.DumpType;
import visad.math.FFT;
import visad.math.Histogram;
import visad.matrix.JamaCholeskyDecomposition;
import visad.matrix.JamaEigenvalueDecomposition;
import visad.matrix.JamaLUDecomposition;
import visad.matrix.JamaMatrix;
import visad.matrix.JamaQRDecomposition;
import visad.matrix.JamaSingularValueDecomposition;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.util.Util;

public abstract class JPythonMethods {
    private static final String DEFAULT_NAME = "Jython";
    private static final String ID = (class$visad$python$JPythonMethods == null ? (class$visad$python$JPythonMethods = JPythonMethods.class$("visad.python.JPythonMethods")) : class$visad$python$JPythonMethods).getName();
    private static DefaultFamily form = new DefaultFamily(ID);
    private static final String[] ops = new String[]{"gt", "ge", "lt", "le", "eq", "ne", "ne"};
    private static final String[] ops_sym = new String[]{">", ">=", "<", "<=", "==", "!=", "<>"};
    private static Hashtable frames = new Hashtable();
    static /* synthetic */ Class class$visad$python$JPythonMethods;

    public static DataImpl load(String location) throws VisADException {
        return form.open(location);
    }

    public static void plot(float[] data) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(float[][] data) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(DataImpl data) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, false, 1.0, 1.0, 1.0);
    }

    public static void plot(float[] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(float[][] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(DataImpl data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(float[] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(float[][] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(DataImpl data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[] data) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[][] data) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, DataImpl data) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, false, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(String name, float[][] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(String name, DataImpl data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(String name, float[] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[][] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, DataImpl data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(float[] data, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, red, green, blue);
    }

    public static void plot(float[][] data, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, red, green, blue);
    }

    public static void plot(DataImpl data, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, false, red, green, blue);
    }

    public static void plot(String namxe, float[] data, boolean editMaps, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(namxe, JPythonMethods.field(data), editMaps, red, green, blue, null);
    }

    public static void plot(String namxe, float[][] data, boolean editMaps, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(namxe, JPythonMethods.field(data), editMaps, red, green, blue, null);
    }

    public static void plot(String namxe, DataImpl data, boolean editMaps, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(namxe, data, editMaps, red, green, blue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void plot(String namxe, DataImpl data, boolean editMaps, double red, double green, double blue, ScalarMap[] maps) throws VisADException, RemoteException {
        BasicSSCell display;
        if (data == null) {
            throw new VisADException("Data cannot be null");
        }
        if (namxe == null) {
            namxe = DEFAULT_NAME;
        }
        final String name = namxe;
        Hashtable hashtable = frames;
        synchronized (hashtable) {
            JFrame frame;
            display = BasicSSCell.getSSCellByName(name);
            if (display == null) {
                display = new FancySSCell(name);
                display.setDimension(1);
                display.setPreferredSize(new Dimension(256, 256));
                frame = new JFrame("VisAD Display Plot (" + name + ")");
                frames.put(name, frame);
                JPanel pane = new JPanel();
                pane.setLayout(new BoxLayout(pane, 1));
                frame.setContentPane(pane);
                pane.add(display);
                JButton mapping = new JButton("Mappings");
                JButton controls = new JButton("Controls");
                JButton clear = new JButton("Clear");
                JButton close = new JButton("Close");
                JPanel buttons = new JPanel();
                buttons.setLayout(new BoxLayout(buttons, 0));
                buttons.add(mapping);
                buttons.add(controls);
                buttons.add(clear);
                buttons.add(close);
                pane.add(buttons);
                final FancySSCell fdisp = (FancySSCell)display;
                fdisp.setAutoShowControls(false);
                if (maps != null) {
                    display.setMaps(maps);
                    fdisp.setAutoDetect(false);
                } else {
                    fdisp.setAutoDetect(!editMaps);
                }
                mapping.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        fdisp.addMapDialog();
                    }
                });
                controls.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        fdisp.showWidgetFrame();
                    }
                });
                close.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        try {
                            fdisp.smartClear();
                            JPythonMethods.clearplot(name);
                        }
                        catch (Exception ec) {}
                    }
                });
                clear.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        try {
                            fdisp.smartClear();
                        }
                        catch (VisADException exc) {
                        }
                        catch (RemoteException exc) {}
                    }
                });
                frame.pack();
            } else {
                frame = (JFrame)frames.get(name);
            }
            frame.setVisible(true);
            frame.toFront();
        }
        ConstantMap[] cmaps = new ConstantMap[]{new ConstantMap(red, Display.Red), new ConstantMap(green, Display.Green), new ConstantMap(blue, Display.Blue)};
        display.addData(data, cmaps);
        if (editMaps) {
            ((FancySSCell)display).addMapDialog();
        }
    }

    public static void clearplot() throws VisADException, RemoteException {
        JPythonMethods.clearplot(null);
    }

    public static void clearplot(String name) throws VisADException, RemoteException {
        BasicSSCell display;
        if (name == null) {
            name = DEFAULT_NAME;
        }
        if ((display = BasicSSCell.getSSCellByName(name)) != null) {
            JFrame frame = (JFrame)frames.get(name);
            display.clearCell();
            display.clearMaps();
            frame.setVisible(false);
            frame.dispose();
            frame = null;
            display.destroyCell();
            Object var1_1 = null;
        }
    }

    public static void saveNetcdf(String fn, Data d2) throws VisADException, RemoteException, IOException {
        new Plain().save(fn, d2, false);
    }

    public static void saveplot(DisplayImpl disp, String filename) throws VisADException, RemoteException, IOException {
        Util.captureDisplay(disp, filename);
    }

    public static void saveplot(String filename) throws VisADException, RemoteException, IOException {
        JPythonMethods.saveplot((String)null, filename);
    }

    public static void saveplot(String name, String filename) throws VisADException, RemoteException, IOException {
        if (name == null) {
            name = DEFAULT_NAME;
        }
        final BasicSSCell sscell = BasicSSCell.getSSCellByName(name);
        final String fn = filename;
        if (sscell != null) {
            Runnable captureDisp = new Runnable(){

                public void run() {
                    try {
                        sscell.captureImage(new File(fn));
                    }
                    catch (Exception se) {
                        System.out.println("Error saving plot = " + se);
                    }
                }
            };
            Thread ts = new Thread(captureDisp);
            ts.start();
        }
    }

    public static Data abs_data(Data data) throws VisADException, RemoteException {
        return data.abs();
    }

    public static Data abs(Data data) throws VisADException, RemoteException {
        return data.abs();
    }

    public static double abs(double value) {
        return Math.abs(value);
    }

    public static int abs(int value) {
        return Math.abs(value);
    }

    public static long abs(long value) {
        return Math.abs(value);
    }

    public static Data acos(Data data) throws VisADException, RemoteException {
        return data.acos();
    }

    public static Data acosDegrees(Data data) throws VisADException, RemoteException {
        return data.acosDegrees();
    }

    public static Data asin(Data data) throws VisADException, RemoteException {
        return data.asin();
    }

    public static Data asinDegrees(Data data) throws VisADException, RemoteException {
        return data.asinDegrees();
    }

    public static Data atan(Data data) throws VisADException, RemoteException {
        return data.atan();
    }

    public static Data atanDegrees(Data data) throws VisADException, RemoteException {
        return data.atanDegrees();
    }

    public static Data ceil(Data data) throws VisADException, RemoteException {
        return data.ceil();
    }

    public static Data cos(Data data) throws VisADException, RemoteException {
        return data.cos();
    }

    public static Data cosDegrees(Data data) throws VisADException, RemoteException {
        return data.cosDegrees();
    }

    public static Data exp(Data data) throws VisADException, RemoteException {
        return data.exp();
    }

    public static Data floor(Data data) throws VisADException, RemoteException {
        return data.floor();
    }

    public static Data log(Data data) throws VisADException, RemoteException {
        return data.log();
    }

    public static Data rint(Data data) throws VisADException, RemoteException {
        return data.rint();
    }

    public static Data round(Data data) throws VisADException, RemoteException {
        return data.round();
    }

    public static double round(double value, int digits) {
        boolean neg = value < 0.0;
        double multiple = Math.pow(10.0, digits);
        if (neg) {
            value = -value;
        }
        double tmp = Math.floor(value * multiple + 0.5);
        if (neg) {
            tmp = -tmp;
        }
        return tmp / multiple;
    }

    public static double round(double value) {
        return JPythonMethods.round(value, 0);
    }

    public static Data sin(Data data) throws VisADException, RemoteException {
        return data.sin();
    }

    public static Data sinDegrees(Data data) throws VisADException, RemoteException {
        return data.sinDegrees();
    }

    public static Data sqrt(Data data) throws VisADException, RemoteException {
        return data.sqrt();
    }

    public static Data tan(Data data) throws VisADException, RemoteException {
        return data.tan();
    }

    public static Data tanDegrees(Data data) throws VisADException, RemoteException {
        return data.tanDegrees();
    }

    public static Data atan2(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.atan2(data2);
    }

    public static Data atan2Degrees(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.atan2Degrees(data2);
    }

    public static Data atan2(Data data1, double data2) throws VisADException, RemoteException {
        return data1.atan2(new Real(data2));
    }

    public static Data atan2Degrees(Data data1, double data2) throws VisADException, RemoteException {
        return data1.atan2Degrees(new Real(data2));
    }

    public static Data max_data(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.max(data2);
    }

    public static Data max_data(Data data1, double data2) throws VisADException, RemoteException {
        return data1.max(new Real(data2));
    }

    public static Data max_data(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).max(data2);
    }

    public static Data min_data(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.min(data2);
    }

    public static Data min_data(Data data1, double data2) throws VisADException, RemoteException {
        return data1.min(new Real(data2));
    }

    public static Data min_data(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).min(data2);
    }

    public static Data atan2(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).atan2(data2);
    }

    public static Data atan2Degrees(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).atan2Degrees(data2);
    }

    public static FlatField fft(Field field) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, true);
    }

    public static FlatField ifft(Field field) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, false);
    }

    public static JamaMatrix matrixMultiply(FlatField data1, FlatField data2) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix1 = JamaMatrix.convertToMatrix(data1);
        JamaMatrix matrix2 = JamaMatrix.convertToMatrix(data2);
        return matrix1.times(matrix2);
    }

    public static JamaMatrix solve(FlatField data1, FlatField data2) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix1 = JamaMatrix.convertToMatrix(data1);
        JamaMatrix matrix2 = JamaMatrix.convertToMatrix(data2);
        return matrix1.solve(matrix2);
    }

    public static JamaMatrix inverse(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.inverse();
    }

    public static JamaMatrix transpose(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.transpose();
    }

    public static double det(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.det();
    }

    public static double norm1(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.norm1();
    }

    public static double norm2(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.norm2();
    }

    public static double normInf(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.normInf();
    }

    public static double normF(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.normF();
    }

    public static double rank(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.rank();
    }

    public static double cond(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.cond();
    }

    public static double trace(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.trace();
    }

    public static JamaCholeskyDecomposition chol(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.chol();
    }

    public static JamaEigenvalueDecomposition eig(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.eig();
    }

    public static JamaLUDecomposition lu(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.lu();
    }

    public static JamaQRDecomposition qr(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.qr();
    }

    public static JamaSingularValueDecomposition svd(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.svd();
    }

    public static FlatField hist(Field field, Set set) throws VisADException, RemoteException {
        return Histogram.makeHistogram(field, set);
    }

    public static FlatField hist(Field field, int[] ranges) throws VisADException, RemoteException {
        if (ranges == null || ranges.length == 0) {
            throw new VisADException("bad ranges");
        }
        int dim = ranges.length;
        int[] sizes = new int[dim];
        int i = 0;
        while (i < dim) {
            sizes[i] = 64;
            ++i;
        }
        return JPythonMethods.hist(field, ranges, sizes);
    }

    public static FlatField hist(Field field, int[] ranges, int[] sizes) throws VisADException, RemoteException {
        if (ranges == null || ranges.length == 0) {
            throw new VisADException("bad ranges");
        }
        if (sizes == null || sizes.length != ranges.length) {
            throw new VisADException("bad sizes");
        }
        if (field == null) {
            throw new VisADException("bad field");
        }
        FunctionType ftype = (FunctionType)field.getType();
        RealType[] frealComponents = ftype.getRealComponents();
        int n = frealComponents.length;
        int dim = ranges.length;
        RealType[] srealComponents = new RealType[dim];
        int i = 0;
        while (i < dim) {
            if (0 > ranges[i] || ranges[i] >= n) {
                throw new VisADException("range index out of range " + ranges[i]);
            }
            srealComponents[i] = frealComponents[ranges[i]];
            ++i;
        }
        RealTupleType rtt = new RealTupleType(srealComponents);
        float[][] values = field.getFloats(false);
        int nn = values.length;
        double[][] data_ranges = new double[dim][2];
        int i2 = 0;
        while (i2 < dim) {
            if (0 <= ranges[i2] && ranges[i2] < nn) {
                data_ranges[i2][0] = Double.MAX_VALUE;
                data_ranges[i2][1] = -1.7976931348623157E308;
                float[] v = values[ranges[i2]];
                int j = 0;
                while (j < v.length) {
                    if ((double)v[j] < data_ranges[i2][0]) {
                        data_ranges[i2][0] = v[j];
                    }
                    if ((double)v[j] > data_ranges[i2][1]) {
                        data_ranges[i2][1] = v[j];
                    }
                    ++j;
                }
            } else {
                throw new VisADException("range index out of range " + ranges[i2]);
            }
            ++i2;
        }
        GriddedSet set = null;
        if (dim == 1) {
            set = new Linear1DSet((MathType)rtt, data_ranges[0][0], data_ranges[0][1], sizes[0]);
        } else if (dim == 2) {
            set = new Linear2DSet((MathType)rtt, data_ranges[0][0], data_ranges[0][1], sizes[0], data_ranges[1][0], data_ranges[1][1], sizes[1]);
        } else if (dim == 3) {
            set = new Linear3DSet((MathType)rtt, data_ranges[0][0], data_ranges[0][1], sizes[0], data_ranges[1][0], data_ranges[1][1], sizes[1], data_ranges[2][0], data_ranges[2][1], sizes[2]);
        } else {
            double[] firsts = new double[dim];
            double[] lasts = new double[dim];
            int i3 = 0;
            while (i3 < dim) {
                firsts[i3] = data_ranges[i3][0];
                lasts[i3] = data_ranges[i3][1];
                ++i3;
            }
            set = new LinearNDSet((MathType)rtt, firsts, lasts, sizes);
        }
        FlatField result = Histogram.makeHistogram(field, set);
        return result;
    }

    public static FlatField field(float[] values) throws VisADException, RemoteException {
        return JPythonMethods.field("value", values);
    }

    public static FlatField field(String name, float[] values) throws VisADException, RemoteException {
        return JPythonMethods.field("domain", name, values);
    }

    public static FlatField field(String dom0, String name, float[] values) throws VisADException, RemoteException {
        if (values == null || values.length == 0) {
            throw new VisADException("bad values");
        }
        RealType domain = RealType.getRealType(dom0);
        return JPythonMethods.field((Set)new Integer1DSet((MathType)domain, values.length), name, values);
    }

    public static FlatField field(Set set, String name, float[] values) throws VisADException, RemoteException {
        if (values == null) {
            throw new VisADException("bad values");
        }
        if (set == null || set.getLength() < values.length) {
            throw new VisADException("bad set " + set);
        }
        if (name == null) {
            throw new VisADException("bad name");
        }
        MathType domain = ((SetType)set.getType()).getDomain();
        if (domain.getDimension() == 1) {
            domain = domain.getComponent(0);
        }
        RealType range = RealType.getRealType(name);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, set);
        int len = set.getLength();
        boolean copy = true;
        if (values.length < len) {
            float[] new_values = new float[len];
            System.arraycopy(values, 0, new_values, 0, len);
            int i = values.length;
            while (i < len) {
                new_values[i] = Float.NaN;
                ++i;
            }
            values = new_values;
            copy = false;
        }
        float[][] field_values = new float[][]{values};
        field.setSamples(field_values, copy);
        return field;
    }

    public static FlatField field(float[][] values) throws VisADException, RemoteException {
        return JPythonMethods.field("value", values);
    }

    public static FlatField field(String name, float[][] values) throws VisADException, RemoteException {
        return JPythonMethods.field("ImageLine", "ImageElement", name, values);
    }

    public static FlatField field(String dom0, String dom1, String rng, float[][] values) throws VisADException, RemoteException {
        int[] temps = JPythonMethods.getValuesLengths(values);
        int values_len = temps[0];
        int min = temps[1];
        int max = temps[2];
        RealType first = RealType.getRealType(dom0);
        RealType second = RealType.getRealType(dom1);
        RealTupleType domain = new RealTupleType(first, second);
        return JPythonMethods.field((Set)new Integer2DSet((MathType)domain, max, values_len), rng, values);
    }

    public static FlatField field(Set set, String name, float[][] values) throws VisADException, RemoteException {
        int i;
        int[] temps = JPythonMethods.getValuesLengths(values);
        int values_len = temps[0];
        int min = temps[1];
        int max = temps[2];
        if (set == null || !(set instanceof GriddedSet) || set.getManifoldDimension() != 2) {
            throw new VisADException("bad set " + set);
        }
        int len0 = ((GriddedSet)set).getLength(0);
        int len1 = ((GriddedSet)set).getLength(1);
        if (len0 < max || len1 < values_len) {
            throw new VisADException("bad set length " + len0 + " " + len1);
        }
        if (name == null) {
            throw new VisADException("bad name");
        }
        MathType domain = ((SetType)set.getType()).getDomain();
        if (domain.getDimension() == 1) {
            domain = domain.getComponent(0);
        }
        RealType range = RealType.getRealType(name);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, set);
        int len = len0 * len1;
        float[] new_values = new float[len];
        int j = 0;
        while (j < values_len) {
            int m = j * len0;
            int n = values[j].length;
            if (n > 0) {
                System.arraycopy(values[j], 0, new_values, m, n);
            }
            i = m + n;
            while (i < m + len0) {
                new_values[i] = Float.NaN;
                ++i;
            }
            ++j;
        }
        int j2 = values_len;
        while (j2 < len1) {
            int m;
            i = m = j2 * len0;
            while (i < m + len0) {
                new_values[i] = Float.NaN;
                ++i;
            }
            ++j2;
        }
        float[][] field_values = new float[][]{new_values};
        field.setSamples(field_values, false);
        return field;
    }

    private static int[] getValuesLengths(float[][] values) throws VisADException {
        if (values == null) {
            throw new VisADException("bad values");
        }
        int values_len = values.length;
        int min = Integer.MAX_VALUE;
        int max = 0;
        int j = 0;
        while (j < values_len) {
            if (values[j] == null) {
                throw new VisADException("bad values");
            }
            int n = values[j].length;
            if (n > max) {
                max = n;
            }
            if (n < min) {
                min = n;
            }
            ++j;
        }
        if (max < min) {
            min = 0;
        }
        return new int[]{values_len, min, max};
    }

    public static int getDomainDimension(Data data) throws VisADException, RemoteException {
        return JPythonMethods.domainDimension(data);
    }

    public static int domainDimension(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain().getDimension();
    }

    public static int getRangeDimension(Data data) throws VisADException, RemoteException {
        return JPythonMethods.rangeDimension(data);
    }

    public static int rangeDimension(Data data) throws VisADException, RemoteException {
        int nr = 1;
        if (data instanceof FlatField) {
            nr = ((FlatField)data).getRangeDimension();
        }
        return nr;
    }

    public static RealTupleType getDomainType(Data data) throws VisADException, RemoteException {
        return JPythonMethods.domainType(data);
    }

    public static RealTupleType domainType(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain();
    }

    public static RealTupleType getDomainType(FunctionType type) throws VisADException, RemoteException {
        return type.getDomain();
    }

    public static MathType getRangeType(Data data) throws VisADException, RemoteException {
        return JPythonMethods.rangeType(data);
    }

    public static MathType rangeType(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getRange();
    }

    public static MathType getRangeType(FunctionType type) throws VisADException, RemoteException {
        return type.getRange();
    }

    public static String domainType(Data data, int comp) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain().getComponent(comp).toString();
    }

    public static String rangeType(Data data, int comp) throws VisADException, RemoteException {
        MathType rt = JPythonMethods.rangeType(data);
        int rd = JPythonMethods.rangeDimension(data);
        String dt = rt.toString();
        if (rd > 1) {
            dt = ((TupleType)rt).getComponent(comp).toString();
        }
        return dt;
    }

    public static Unit makeUnit(String name) throws NoSuchUnitException, ParseException {
        return Parser.parse(name);
    }

    public static Integer1DSet makeDomain(int length) throws VisADException {
        return new Integer1DSet(length);
    }

    public static Integer1DSet makeDomain(MathType type, int length) throws VisADException {
        return new Integer1DSet(type, length);
    }

    public static Integer1DSet makeDomain(String name, int length) throws VisADException {
        return new Integer1DSet((MathType)RealType.getRealType(name), length);
    }

    public static Integer2DSet makeDomain(int lengthX, int lengthY) throws VisADException {
        return new Integer2DSet(lengthX, lengthY);
    }

    public static Integer2DSet makeDomain(MathType type, int lengthX, int lengthY) throws VisADException {
        return new Integer2DSet(type, lengthX, lengthY);
    }

    public static Integer2DSet makeDomain(String name, int lengthX, int lengthY) throws VisADException, RemoteException {
        return new Integer2DSet((MathType)((RealTupleType)JPythonMethods.makeType(name)), lengthX, lengthY);
    }

    public static Linear1DSet makeDomain(double first, double last, int length) throws VisADException {
        return new Linear1DSet(first, last, length);
    }

    public static Linear1DSet makeDomain(MathType type, double first, double last, int length) throws VisADException {
        return new Linear1DSet(type, first, last, length);
    }

    public static Linear1DSet makeDomain(String name, double first, double last, int length) throws VisADException {
        return new Linear1DSet((MathType)RealType.getRealType(name), first, last, length);
    }

    public static Linear2DSet makeDomain(double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        return new Linear2DSet(first1, last1, length1, first2, last2, length2);
    }

    public static Linear2DSet makeDomain(MathType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        return new Linear2DSet(type, first1, last1, length1, first2, last2, length2);
    }

    public static Linear2DSet makeDomain(String name, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        return new Linear2DSet((MathType)((RealTupleType)JPythonMethods.makeType(name)), first1, last1, length1, first2, last2, length2);
    }

    public static Linear3DSet makeDomain(double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException {
        return new Linear3DSet(first1, last1, length1, first2, last2, length2, first3, last3, length3);
    }

    public static Linear3DSet makeDomain(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException {
        return new Linear3DSet(type, first1, last1, length1, first2, last2, length2, first3, last3, length3);
    }

    public static Linear3DSet makeDomain(String name, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException, RemoteException {
        return new Linear3DSet((MathType)((RealTupleType)JPythonMethods.makeType(name)), first1, last1, length1, first2, last2, length2, first3, last3, length3);
    }

    public static Set getDomainSet(Data data) throws VisADException, RemoteException {
        return ((Field)data).getDomainSet();
    }

    public static Set getDomain(Data data) throws VisADException, RemoteException {
        return ((Field)data).getDomainSet();
    }

    public static int[] getDomainSizes(Data data) throws VisADException, RemoteException {
        return ((GriddedSet)((Field)data).getDomainSet()).getLengths();
    }

    public static FlatField replace(FlatField f, int[] list, Real v) throws VisADException, RemoteException {
        return JPythonMethods.replace(f, list, v.getValue());
    }

    public static FlatField replace(FlatField f, int[] list, double v) throws VisADException, RemoteException {
        double[][] dv = f.getValues(false);
        int i = 0;
        while (i < list.length) {
            dv[0][list[i]] = v;
            ++i;
        }
        f.setSamples(dv);
        return f;
    }

    public static FlatField mask(FlatField f, String op, double v) throws VisADException, RemoteException {
        return JPythonMethods.mask((Data)f, op, new Real(v));
    }

    public static FlatField mask(Data f, String op, Data v) throws VisADException, RemoteException {
        FlatField fv = (FlatField)f.subtract(v);
        double[][] dv = fv.getValues(false);
        int oper = -1;
        int i = 0;
        while (i < ops.length) {
            if (ops[i].equalsIgnoreCase(op)) {
                oper = i;
            }
            if (ops_sym[i].equalsIgnoreCase(op)) {
                oper = i;
            }
            ++i;
        }
        if (oper < 0) {
            throw new VisADException("Invalid operator: " + op);
        }
        int i2 = 0;
        while (i2 < dv.length) {
            int k = 0;
            while (k < dv[i2].length) {
                dv[i2][k] = oper == 0 ? (dv[i2][k] > 0.0 ? 1.0 : 0.0) : (oper == 1 ? (dv[i2][k] >= 0.0 ? 1.0 : 0.0) : (oper == 2 ? (dv[i2][k] < 0.0 ? 1.0 : 0.0) : (oper == 3 ? (dv[i2][k] <= 0.0 ? 1.0 : 0.0) : (oper == 4 ? (dv[i2][k] == 0.0 ? 1.0 : 0.0) : (oper == 5 ? (dv[i2][k] != 0.0 ? 1.0 : 0.0) : (dv[i2][k] != 0.0 ? 1.0 : 0.0))))));
                ++k;
            }
            ++i2;
        }
        fv.setSamples(dv);
        return fv;
    }

    public static int[] find(FlatField f, String op, double v) throws VisADException, RemoteException {
        return JPythonMethods.find((Data)f, op, new Real(v));
    }

    public static int[] find(Data f, String op, Data v) throws VisADException, RemoteException {
        FlatField fv = (FlatField)f.subtract(v);
        double[][] dv = fv.getValues(false);
        Vector<Integer> z = new Vector<Integer>();
        int oper = -1;
        int i = 0;
        while (i < ops.length) {
            if (ops[i].equalsIgnoreCase(op)) {
                oper = i;
            }
            if (ops_sym[i].equalsIgnoreCase(op)) {
                oper = i;
            }
            ++i;
        }
        if (oper < 0) {
            throw new VisADException("Invalid operator: " + op);
        }
        int i2 = 0;
        while (i2 < 1) {
            int k = 0;
            while (k < dv[i2].length) {
                if (oper == 0) {
                    if (dv[i2][k] > 0.0) {
                        z.addElement(new Integer(k));
                    }
                } else if (oper == 1) {
                    if (dv[i2][k] >= 0.0) {
                        z.addElement(new Integer(k));
                    }
                } else if (oper == 2) {
                    if (dv[i2][k] < 0.0) {
                        z.addElement(new Integer(k));
                    }
                } else if (oper == 3) {
                    if (dv[i2][k] <= 0.0) {
                        z.addElement(new Integer(k));
                    }
                } else if (oper == 4) {
                    if (dv[i2][k] == 0.0) {
                        z.addElement(new Integer(k));
                    }
                } else if (oper == 5) {
                    if (dv[i2][k] != 0.0) {
                        z.addElement(new Integer(k));
                    }
                } else if (dv[i2][k] != 0.0) {
                    z.addElement(new Integer(k));
                }
                ++k;
            }
            ++i2;
        }
        int m = z.size();
        int[] rv = new int[m];
        int i3 = 0;
        while (i3 < m) {
            rv[i3] = (Integer)z.elementAt(i3);
            ++i3;
        }
        return rv;
    }

    public static Field resample(Field data, Set s) throws VisADException, RemoteException {
        return data.resample(s, 0, 0);
    }

    public static double getValue(Real r) {
        return r.getValue();
    }

    public static double[][] getValues(Field data) throws VisADException, RemoteException {
        return data.getValues();
    }

    public static Field combine(Field[] fields) throws VisADException, RemoteException {
        return FieldImpl.combine(fields);
    }

    public static Field extract(Field data, MathType t2) throws VisADException, RemoteException {
        return ((FieldImpl)data).extract(t2);
    }

    public static Field extract(Field data, String s) throws VisADException, RemoteException {
        return ((FieldImpl)data).extract(s);
    }

    public static Field extract(Field data, int comp) throws VisADException, RemoteException {
        return ((FieldImpl)data).extract(comp);
    }

    public static Field domainFactor(Field data, RealType factor) throws VisADException, RemoteException {
        return ((FieldImpl)data).domainFactor(factor);
    }

    public static Field domainFactor(Field data, int comp) throws VisADException, RemoteException {
        RealType mt = (RealType)((FunctionType)data.getType()).getDomain().getComponent(comp);
        return ((FieldImpl)data).domainFactor(mt);
    }

    public static Data evaluate(Field data, Real domain) throws VisADException, RemoteException {
        return data.evaluate(domain);
    }

    public static Data evaluate(Field data, double domain) throws VisADException, RemoteException {
        return data.evaluate(new Real(domain));
    }

    public static MathType makeType(String s) throws VisADException, RemoteException {
        String ss = s.trim();
        if (!(ss.indexOf(",") == -1 && ss.indexOf(">") == -1 || ss.startsWith("(") && ss.endsWith(")"))) {
            ss = "(" + s.trim() + ")";
        }
        return MathType.stringToType(ss);
    }

    public static RealTupleType makeType(String[] s, CoordinateSystem c2) throws VisADException, RemoteException {
        RealType[] rt = new RealType[s.length];
        int i = 0;
        while (i < s.length) {
            rt[i] = RealType.getRealType(s[i]);
            ++i;
        }
        return new RealTupleType(rt, c2, null);
    }

    public static RealType makeRealType(String name) {
        return RealType.getRealType(name);
    }

    public static RealType getRealType(String name) {
        return RealType.getRealType(name);
    }

    public static RealType makeRealType(String name, Unit u) {
        return RealType.getRealType(name, u);
    }

    public static RealType getRealType(String name, Unit u) {
        return RealType.getRealType(name, u);
    }

    public static MathType getType(Data data) throws VisADException, RemoteException {
        return data.getType();
    }

    public static void showAxesScales(DisplayImpl d2, boolean on) throws VisADException, RemoteException {
        d2.getGraphicsModeControl().setScaleEnable(on);
    }

    public static void setAxesScalesLabel(ScalarMap[] sm, String[] labels) throws VisADException, RemoteException {
        if (sm.length != labels.length) {
            throw new VisADException("number of ScalarMaps must match number of labels");
        }
        int i = 0;
        while (i < sm.length) {
            AxisScale scale = sm[i].getAxisScale();
            if (scale != null) {
                scale.setLabel(labels[i]);
            }
            ++i;
        }
    }

    public static void setAxesScalesFont(ScalarMap[] sm, Font f) throws VisADException, RemoteException {
        int i = 0;
        while (i < sm.length) {
            AxisScale scale = sm[i].getAxisScale();
            if (scale != null) {
                scale.setFont(f);
            }
            ++i;
        }
    }

    public static UnionSet makePairedLines(MathType mt, double[][] points) throws VisADException, RemoteException {
        int dim = points.length;
        int len = points[0].length;
        UnionSet us = null;
        if (dim == 2) {
            float[][] samples = new float[2][2];
            SampledSet[] gs2 = new Gridded2DSet[len / 2];
            int k = 0;
            while (k < len) {
                samples[0][0] = (float)points[0][k];
                samples[0][1] = (float)points[0][k + 1];
                samples[1][0] = (float)points[1][k];
                samples[1][1] = (float)points[1][k + 1];
                gs2[k / 2] = new Gridded2DSet(mt, samples, 2);
                k += 2;
            }
            us = new UnionSet(gs2);
        } else if (dim == 3) {
            float[][] samples = new float[3][2];
            SampledSet[] gs3 = new Gridded3DSet[len / 2];
            int k = 0;
            while (k < len) {
                samples[0][0] = (float)points[0][k];
                samples[0][1] = (float)points[0][k + 1];
                samples[1][0] = (float)points[1][k];
                samples[1][1] = (float)points[1][k + 1];
                samples[2][0] = (float)points[2][k];
                samples[2][1] = (float)points[2][k + 1];
                gs3[k / 2] = new Gridded3DSet(mt, samples, 3);
                k += 2;
            }
            us = new UnionSet(gs3);
        }
        return us;
    }

    public static void dumpTypes(Data d2) throws VisADException, RemoteException {
        MathType t2 = d2.getType();
        DumpType.dumpMathType(t2);
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - ");
        System.out.println("DataType analysis...");
        DumpType.dumpDataType(d2);
    }

    public static void dumpType(Data d2) throws VisADException, RemoteException {
        MathType t2 = d2.getType();
        DumpType.dumpMathType(t2);
    }

    public static PointDataAdapter getPointDataAdapter(String request) throws VisADException, RemoteException {
        return new PointDataAdapter(request);
    }

    public static Data getNetcdfData(String filename) throws VisADException, RemoteException, IOException {
        return JPythonMethods.getNetcdfData(filename, null);
    }

    public static Data getNetcdfData(String filename, String factor) throws VisADException, RemoteException, IOException {
        NetcdfFile nf = new NetcdfFile(filename, true);
        DefaultView dv = new DefaultView(nf, QuantityDBManager.instance(), true);
        if (factor != null) {
            TreeSet<String> ts = new TreeSet<String>();
            ts.add(factor);
            dv.setOuterDimensionNameSet(ts);
        }
        NetcdfAdapter na = new NetcdfAdapter(dv);
        return na.getData();
    }

    public static double[][] getScale(ScalarMap smap) {
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        smap.getScale(so, data, display);
        return new double[][]{so, data, display};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

