/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import visad.VisADException;
import visad.formula.FormulaUtil;

public class RunJPython {
    private static final boolean DEBUG = false;
    private static final String interp = "org.python.util.PythonInterpreter";
    private static final Class interpClass = RunJPython.constructInterpClass();
    private static final String[] methodNames = new String[]{"org.python.util.PythonInterpreter.eval(java.lang.String)", "org.python.util.PythonInterpreter.exec(java.lang.String)", "org.python.util.PythonInterpreter.execfile(java.lang.String)", "org.python.util.PythonInterpreter.set(java.lang.String, org.python.core.PyObject)", "org.python.util.PythonInterpreter.get(java.lang.String)"};
    private static final Method[] methods = FormulaUtil.stringsToMethods(methodNames);
    private static final Method eval = methods[0];
    private static final Method exec = methods[1];
    private static final Method execfile = methods[2];
    private static final Method set = methods[3];
    private static final Method get = methods[4];
    protected Object python = null;

    private static Class constructInterpClass() {
        Class<?> c2 = null;
        try {
            c2 = Class.forName(interp);
        }
        catch (ClassNotFoundException exc) {}
        return c2;
    }

    public RunJPython() throws VisADException {
        try {
            this.python = interpClass.newInstance();
        }
        catch (NullPointerException exc) {
        }
        catch (IllegalAccessException exc) {
        }
        catch (InstantiationException exc) {
            // empty catch block
        }
        if (this.python == null) {
            throw new VisADException("JPython library not found - install Jython from http://jython.sourceforge.net/");
        }
    }

    public Object eval(String line) throws VisADException {
        try {
            return eval.invoke(this.python, line);
        }
        catch (IllegalAccessException exc) {
            throw new VisADException(exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new VisADException(exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new VisADException(exc.getTargetException().toString());
        }
    }

    public void exec(String line) throws VisADException {
        try {
            exec.invoke(this.python, line);
        }
        catch (IllegalAccessException exc) {
            throw new VisADException(exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new VisADException(exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new VisADException(exc.getTargetException().toString());
        }
    }

    public void execfile(String filename) throws VisADException {
        try {
            execfile.invoke(this.python, filename);
        }
        catch (IllegalAccessException exc) {
            throw new VisADException(exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new VisADException(exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new VisADException(exc.getTargetException().toString());
        }
    }

    public void set(String name, Object value) throws VisADException {
        try {
            set.invoke(this.python, name, value);
        }
        catch (IllegalAccessException exc) {
            throw new VisADException(exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new VisADException(exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new VisADException(exc.getTargetException().toString());
        }
    }

    public Object get(String name) throws VisADException {
        try {
            return get.invoke(this.python, name);
        }
        catch (IllegalAccessException exc) {
            throw new VisADException(exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new VisADException(exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new VisADException(exc.getTargetException().toString());
        }
    }

    public static void main(String[] args) throws VisADException {
        if (args.length < 1) {
            return;
        }
        try {
            new RunJPython().execfile(args[0]);
        }
        catch (VisADException exc) {
            exc.printStackTrace(System.out);
        }
    }
}

