/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.Display;
import visad.DisplayRealType;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.ss.BasicSSCell;
import visad.util.DataUtility;
import visad.util.Util;

public class MappingDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    private boolean Confirm;
    private ScalarMap[] ScalarMaps;
    private JComponent MathCanvas;
    private JScrollPane MathCanvasView;
    private JComponent CoordCanvas;
    private JScrollPane CoordCanvasView;
    private boolean CoordRefs;
    private JList MathList;
    private JComponent DisplayCanvas;
    private DefaultListModel CurMaps;
    private JList CurrentMaps;
    private JScrollPane CurrentMapsView;
    private JLabel description;
    private ScalarType[] MathTypes;
    private String[] Scalars;
    private int[] ScW;
    private Vector[] ScP;
    private int ScH;
    private Dimension StrSize;
    private Dimension CoordSize;
    private boolean[][][] Maps;
    private String[][][] CurMapLabel;
    private static final Font Mono = new Font("Monospaced", 0, 11);
    private static final String[][] MapNames = new String[][]{{"X Axis", "Y Axis", "Z Axis", "X Offset", "Y Offset", "Z Offset"}, {"Latitude", "Longitude", "Radius", "Cyl Radius", "Cyl Azimuth", "Cyl Z Axis"}, {"Flow1 X", "Flow1 Y", "Flow1 Z", "Flow2 X", "Flow2 Y", "Flow2 Z"}, {"Flow1 Elevation", "Flow1 Azimuth", "Flow1 Radial", "Flow2 Elevation", "Flow2 Azimuth", "Flow2 Radial"}, {"Red", "Green", "Blue", "RGB", "RGBA", "Alpha"}, {"Cyan", "Magenta", "Yellow", "CMY", "Animation", "Iso-contour"}, {"Hue", "Saturation", "Value", "HSV", "Select Value", "Select Range"}, {"", "Text", "", "", "Shape", ""}};
    private static final DisplayRealType[][] MapTypes = new DisplayRealType[][]{{Display.XAxis, Display.YAxis, Display.ZAxis, Display.XAxisOffset, Display.YAxisOffset, Display.ZAxisOffset}, {Display.Latitude, Display.Longitude, Display.Radius, Display.CylRadius, Display.CylAzimuth, Display.CylZAxis}, {Display.Flow1X, Display.Flow1Y, Display.Flow1Z, Display.Flow2X, Display.Flow2Y, Display.Flow2Z}, {Display.Flow1Elevation, Display.Flow1Azimuth, Display.Flow1Radial, Display.Flow2Elevation, Display.Flow2Azimuth, Display.Flow2Radial}, {Display.Red, Display.Green, Display.Blue, Display.RGB, Display.RGBA, Display.Alpha}, {Display.Cyan, Display.Magenta, Display.Yellow, Display.CMY, Display.Animation, Display.IsoContour}, {Display.Hue, Display.Saturation, Display.Value, Display.HSV, Display.SelectValue, Display.SelectRange}, {null, Display.Text, null, null, Display.Shape, null}};
    private static final Point[] AlphaMaps = new Point[]{new Point(4, 4), new Point(4, 5)};
    private static final Point[] ThreeDMaps = new Point[]{new Point(0, 2), new Point(0, 5), new Point(1, 0), new Point(1, 5), new Point(2, 2), new Point(2, 5), new Point(3, 0), new Point(3, 3)};
    private static final int MapWidth = MapTypes[0].length;
    private static final int MapHeight = MapTypes.length;
    private static Image DRT = null;
    private static boolean Inited = false;
    private Object Lock;
    private boolean[][] Illegal;
    private Image MapTo;
    private MathType[] Types;
    private boolean AllowAlpha;
    private boolean Allow3D;
    static /* synthetic */ Class class$visad$ss$MappingDialog;

    public static void initDialog() {
        if (DRT == null) {
            URL url = (class$visad$ss$MappingDialog == null ? (class$visad$ss$MappingDialog = MappingDialog.class$("visad.ss.MappingDialog")) : class$visad$ss$MappingDialog).getResource("display.gif");
            DRT = Toolkit.getDefaultToolkit().getImage(url);
        }
        Inited = true;
    }

    private static String prettyCoordSys(MathType type) {
        String s = "";
        if (type instanceof FunctionType) {
            s = s + MappingDialog.pcsFunction((FunctionType)type);
        } else if (type instanceof SetType) {
            s = s + MappingDialog.pcsSet((SetType)type);
        } else if (type instanceof TupleType) {
            s = s + MappingDialog.pcsTuple((TupleType)type);
        }
        return s;
    }

    private static String pcsFunction(FunctionType mathType) {
        String s = "";
        RealTupleType domain = mathType.getDomain();
        s = s + MappingDialog.pcsTuple(domain);
        MathType range = mathType.getRange();
        s = s + MappingDialog.prettyCoordSys(range);
        return s;
    }

    private static String pcsSet(SetType mathType) {
        RealTupleType domain = mathType.getDomain();
        return MappingDialog.pcsTuple(domain);
    }

    private static String pcsTuple(TupleType mathType) {
        String s = "";
        if (mathType instanceof RealTupleType) {
            RealTupleType ref;
            RealTupleType rtt = (RealTupleType)mathType;
            CoordinateSystem cs = rtt.getCoordinateSystem();
            if (cs != null && (ref = cs.getReference()) != null) {
                s = s + rtt.prettyString() + " ==> " + ref.prettyString() + "\n";
            }
        } else {
            int j = 0;
            while (j < mathType.getDimension()) {
                MathType cType = null;
                try {
                    cType = mathType.getComponent(j);
                }
                catch (VisADException exc) {
                    // empty catch block
                }
                if (cType != null) {
                    s = s + MappingDialog.prettyCoordSys(cType);
                }
                ++j;
            }
        }
        return s;
    }

    private static Point indexToPoint(int ndx, int[] lines, int w, int h) {
        int i = 0;
        while (i < lines.length && lines[i] <= ndx) {
            ++i;
        }
        int surplus = ndx - lines[i - 1];
        return new Point(w * surplus + 5, (h + 2) * (i - 1) + 6);
    }

    public MappingDialog(Frame parent, Data data, ScalarMap[] startMaps, boolean allowAlpha, boolean allow3D) {
        this(parent, new Data[]{data}, startMaps, allowAlpha, allow3D);
    }

    public MappingDialog(Frame parent, Data[] data, ScalarMap[] startMaps, boolean allowAlpha, boolean allow3D) {
        Point p;
        int i;
        int maxMCHeight;
        int dupl;
        Vector v;
        String coordString;
        String typeString;
        JPanel contentPane;
        block51: {
            super(parent, "Set up data mappings", true);
            this.Confirm = false;
            this.Lock = new Object();
            this.Illegal = new boolean[MapHeight][MapWidth];
            this.Types = null;
            this.AllowAlpha = allowAlpha;
            this.Allow3D = allow3D;
            this.setBackground(Color.white);
            contentPane = new JPanel();
            this.setContentPane(contentPane);
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
            int numData = data.length;
            this.Types = new MathType[numData];
            typeString = "";
            coordString = "";
            int i2 = 0;
            while (i2 < numData) {
                block50: {
                    try {
                        Data d2 = data[i2];
                        if (d2 == null) {
                            this.Types[i2] = null;
                        } else {
                            this.Types[i2] = d2.getType();
                            typeString = typeString + this.Types[i2].prettyString() + "\n";
                            coordString = coordString + MappingDialog.prettyCoordSys(this.Types[i2]);
                        }
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!BasicSSCell.DEBUG) break block50;
                        exc.printStackTrace();
                    }
                }
                ++i2;
            }
            v = new Vector();
            dupl = 0;
            try {
                dupl = DataUtility.getScalarTypes(data, v, true, true);
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!BasicSSCell.DEBUG) break block51;
                exc.printStackTrace();
            }
        }
        FontMetrics fm = this.getFontMetrics(Mono);
        this.ScH = fm.getHeight();
        int charWidth = fm.stringWidth(" ");
        int width = 1;
        int pos = -1;
        int numLines = 0;
        do {
            int w;
            int nextPos;
            if ((nextPos = typeString.indexOf("\n", pos + 1)) < 0) {
                nextPos = typeString.length();
            }
            if ((w = charWidth * (nextPos - pos)) > width) {
                width = w;
            }
            pos = nextPos;
            ++numLines;
        } while (pos < typeString.length());
        this.StrSize = new Dimension(width, (this.ScH + 2) * numLines + 10);
        int[] mathLines = new int[numLines];
        pos = -1;
        int i3 = 0;
        while (i3 < numLines) {
            mathLines[i3] = pos + 1;
            pos = typeString.indexOf("\n", pos + 1);
            ++i3;
        }
        width = 1;
        pos = -1;
        numLines = 0;
        do {
            int nextPos;
            int w;
            if ((w = charWidth * ((nextPos = coordString.indexOf("\n", pos + 1)) - pos)) > width) {
                width = w;
            }
            pos = nextPos;
            ++numLines;
        } while (pos < coordString.length() - 1);
        this.CoordSize = new Dimension(width, (this.ScH + 2) * numLines + 10);
        int[] coordLines = new int[numLines];
        pos = -1;
        int i4 = 0;
        while (i4 < numLines) {
            coordLines[i4] = pos + 1;
            pos = coordString.indexOf("\n", pos + 1);
            ++i4;
        }
        int len = v.size();
        int unique = len - dupl;
        this.MathTypes = new ScalarType[unique];
        this.Scalars = new String[unique];
        this.ScW = new int[unique];
        this.ScP = new Vector[unique];
        Hashtable<String, Integer> nameToIndex = new Hashtable<String, Integer>();
        int s = 0;
        boolean inCoord = false;
        pos = -1;
        int i5 = 0;
        while (i5 < len) {
            Point p2;
            ScalarType type = (ScalarType)v.elementAt(i5);
            String name = type.getName();
            if (v.indexOf(type) == i5) {
                this.MathTypes[s] = type;
                this.Scalars[s] = name;
                this.ScW[s] = charWidth * name.length();
                this.ScP[s] = new Vector();
                nameToIndex.put(name, new Integer(s));
                ++s;
            }
            int index = (Integer)nameToIndex.get(name);
            MDTuple tuple = null;
            if (!inCoord) {
                if ((pos = typeString.indexOf(name, pos + 1)) == -1) {
                    inCoord = true;
                } else {
                    p2 = MappingDialog.indexToPoint(pos, mathLines, charWidth, this.ScH);
                    tuple = new MDTuple(p2.x, p2.y, false);
                }
            }
            if (inCoord) {
                pos = coordString.indexOf(name, pos + 1);
                p2 = MappingDialog.indexToPoint(pos, coordLines, charWidth, this.ScH);
                tuple = new MDTuple(p2.x, p2.y, true);
            }
            this.ScP[index].add(tuple);
            ++i5;
        }
        this.sort(0, unique - 1);
        this.CoordRefs = !coordString.equals("");
        JLabel l0 = new JLabel("MathType:");
        l0.setAlignmentX(0.5f);
        contentPane.add(l0);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        contentPane.add(topPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        if (this.CoordRefs) {
            JLabel l1 = new JLabel("CoordinateSystem references:");
            l1.setAlignmentX(0.5f);
            contentPane.add(l1);
        }
        JPanel topPanel2 = new JPanel();
        topPanel2.setLayout(new BoxLayout(topPanel2, 0));
        contentPane.add(topPanel2);
        final BufferedImage ppImg = new BufferedImage(this.StrSize.width, this.StrSize.height, 1);
        Graphics g = ppImg.getGraphics();
        g.setFont(Mono);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.StrSize.width, this.StrSize.height);
        g.setColor(Color.black);
        int i6 = 0;
        while (i6 < mathLines.length) {
            int start = mathLines[i6];
            int end = i6 < mathLines.length - 1 ? mathLines[i6 + 1] - 1 : typeString.length();
            String line = typeString.substring(start, end);
            g.drawString(line, 5, (this.ScH + 2) * (i6 + 1));
            ++i6;
        }
        g.dispose();
        this.MathCanvas = new JComponent(){

            public void paint(Graphics g2) {
                g2.drawImage(ppImg, 0, 0, this);
                int ndx = MappingDialog.this.MathList.getSelectedIndex();
                if (ndx >= 0) {
                    int i = 0;
                    while (i < MappingDialog.this.ScP[ndx].size()) {
                        MDTuple tuple = (MDTuple)MappingDialog.this.ScP[ndx].elementAt(i);
                        if (!tuple.b) {
                            g2.setFont(Mono);
                            String ss = MappingDialog.this.Scalars[ndx];
                            int x = tuple.x;
                            int y = tuple.y;
                            g2.setColor(Color.blue);
                            g2.fillRect(tuple.x, tuple.y, MappingDialog.this.ScW[ndx], MappingDialog.this.ScH);
                            g2.setColor(Color.white);
                            g2.drawString(ss, tuple.x, tuple.y + MappingDialog.this.ScH - 4);
                        }
                        ++i;
                    }
                }
                Dimension d2 = MappingDialog.this.MathCanvas.getSize();
                g2.setColor(Color.white);
                g2.fillRect(((MappingDialog)MappingDialog.this).StrSize.width, 0, d2.width, d2.height);
                g2.fillRect(0, ((MappingDialog)MappingDialog.this).StrSize.height, ((MappingDialog)MappingDialog.this).StrSize.width, d2.height);
            }
        };
        this.MathCanvas.setMinimumSize(this.StrSize);
        this.MathCanvas.setPreferredSize(this.StrSize);
        this.MathCanvas.addMouseListener(this);
        this.MathCanvas.setBackground(Color.white);
        this.MathCanvasView = new JScrollPane(this.MathCanvas);
        this.MathCanvasView.setMinimumSize(new Dimension(0, 0));
        int prefMCHeight = this.StrSize.height + 10;
        if (prefMCHeight < 70) {
            prefMCHeight = 70;
        }
        if (prefMCHeight > (maxMCHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2)) {
            prefMCHeight = maxMCHeight;
        }
        this.MathCanvasView.setPreferredSize(new Dimension(0, prefMCHeight));
        this.MathCanvasView.setBackground(Color.white);
        JScrollBar horiz = this.MathCanvasView.getHorizontalScrollBar();
        JScrollBar verti = this.MathCanvasView.getVerticalScrollBar();
        horiz.setBlockIncrement(5 * this.ScH + 10);
        horiz.setUnitIncrement(this.ScH + 2);
        verti.setBlockIncrement(5 * this.ScH + 10);
        verti.setUnitIncrement(this.ScH + 2);
        topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel whitePanel = new JPanel();
        whitePanel.setBackground(Color.white);
        whitePanel.setLayout(new BoxLayout(whitePanel, 0));
        whitePanel.add(this.MathCanvasView);
        topPanel.add(whitePanel);
        topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.description = new JLabel(" ");
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        contentPane.add(descPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 15)));
        descPanel.add(this.description);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 0));
        contentPane.add(lowerPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel flsPanel = new JPanel();
        flsPanel.setLayout(new BoxLayout(flsPanel, 1));
        lowerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        lowerPanel.add(flsPanel);
        if (this.CoordRefs) {
            int maxCCHeight;
            final BufferedImage csImg = new BufferedImage(this.CoordSize.width, this.CoordSize.height, 1);
            g = csImg.getGraphics();
            g.setFont(Mono);
            g.setColor(Color.white);
            g.fillRect(0, 0, this.CoordSize.width, this.CoordSize.height);
            g.setColor(Color.black);
            int i7 = 0;
            while (i7 < coordLines.length) {
                int start = coordLines[i7];
                int end = i7 < coordLines.length - 1 ? coordLines[i7 + 1] - 1 : coordString.length() - 1;
                String line = coordString.substring(start, end);
                g.drawString(line, 5, (this.ScH + 2) * (i7 + 1));
                ++i7;
            }
            g.dispose();
            this.CoordCanvas = new JComponent(){

                public void paint(Graphics g2) {
                    g2.drawImage(csImg, 0, 0, this);
                    int ndx = MappingDialog.this.MathList.getSelectedIndex();
                    if (ndx >= 0) {
                        int i = 0;
                        while (i < MappingDialog.this.ScP[ndx].size()) {
                            MDTuple tuple = (MDTuple)MappingDialog.this.ScP[ndx].elementAt(i);
                            if (tuple.b) {
                                g2.setFont(Mono);
                                String ss = MappingDialog.this.Scalars[ndx];
                                int x = tuple.x;
                                int y = tuple.y;
                                g2.setColor(Color.blue);
                                g2.fillRect(tuple.x, tuple.y, MappingDialog.this.ScW[ndx], MappingDialog.this.ScH);
                                g2.setColor(Color.white);
                                g2.drawString(ss, tuple.x, tuple.y + MappingDialog.this.ScH - 4);
                            }
                            ++i;
                        }
                    }
                    Dimension d2 = MappingDialog.this.CoordCanvas.getSize();
                    g2.setColor(Color.white);
                    g2.fillRect(((MappingDialog)MappingDialog.this).CoordSize.width, 0, d2.width, d2.height);
                    g2.fillRect(0, ((MappingDialog)MappingDialog.this).CoordSize.height, ((MappingDialog)MappingDialog.this).CoordSize.width, d2.height);
                }
            };
            this.CoordCanvas.setMinimumSize(this.CoordSize);
            this.CoordCanvas.setPreferredSize(this.CoordSize);
            this.CoordCanvas.addMouseListener(this);
            this.CoordCanvas.setBackground(Color.white);
            this.CoordCanvasView = new JScrollPane(this.CoordCanvas);
            this.CoordCanvasView.setMinimumSize(new Dimension(0, 0));
            this.CoordCanvasView.setPreferredSize(new Dimension(0, this.CoordSize.height));
            int prefCCHeight = this.CoordSize.height + 10;
            if (prefCCHeight < 70) {
                prefCCHeight = 70;
            }
            if (prefCCHeight > (maxCCHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2)) {
                prefCCHeight = maxCCHeight;
            }
            this.CoordCanvasView.setPreferredSize(new Dimension(0, prefCCHeight));
            this.CoordCanvasView.setBackground(Color.white);
            horiz = this.CoordCanvasView.getHorizontalScrollBar();
            verti = this.CoordCanvasView.getVerticalScrollBar();
            horiz.setBlockIncrement(5 * this.ScH + 10);
            horiz.setUnitIncrement(this.ScH + 2);
            verti.setBlockIncrement(5 * this.ScH + 10);
            verti.setUnitIncrement(this.ScH + 2);
            topPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel whitePanel2 = new JPanel();
            whitePanel2.setBackground(Color.white);
            whitePanel2.setLayout(new BoxLayout(whitePanel2, 0));
            whitePanel2.add(this.CoordCanvasView);
            topPanel2.add(whitePanel2);
            topPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        JPanel lsPanel = new JPanel();
        lsPanel.setLayout(new BoxLayout(lsPanel, 1));
        lowerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        lowerPanel.add(lsPanel);
        this.CurMaps = new DefaultListModel();
        int num = this.MathTypes.length;
        this.CurMaps.ensureCapacity(num * MapWidth * MapHeight);
        this.CurrentMaps = new JList(this.CurMaps);
        this.Maps = new boolean[num][MapHeight][MapWidth];
        this.CurMapLabel = new String[num][MapHeight][MapWidth];
        int i8 = 0;
        while (i8 < num) {
            int j = 0;
            while (j < MapHeight) {
                int k = 0;
                while (k < MapWidth) {
                    this.Maps[i8][j][k] = false;
                    this.CurMapLabel[i8][j][k] = this.Scalars[i8] + " -> " + MapNames[j][k];
                    if (startMaps != null) {
                        int m = 0;
                        while (m < startMaps.length) {
                            if (startMaps[m].getScalar().equals(this.MathTypes[i8]) && startMaps[m].getDisplayScalar().equals(MapTypes[j][k])) {
                                this.Maps[i8][j][k] = true;
                                this.CurMaps.addElement(this.CurMapLabel[i8][j][k]);
                            }
                            ++m;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i8;
        }
        this.MathList = new JList<String>(this.Scalars);
        this.MathList.addListSelectionListener(this);
        this.MathList.setSelectionMode(0);
        JScrollPane mathListView = new JScrollPane(this.MathList){

            public Dimension getMinimumSize() {
                return new Dimension(0, 40 * MapHeight + 64);
            }

            public Dimension getPreferredSize() {
                return new Dimension(200, 40 * MapHeight + 64);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 40 * MapHeight + 64);
            }
        };
        JLabel l2 = new JLabel("Map from:");
        l2.setAlignmentX(0.5f);
        lsPanel.add(l2);
        lsPanel.add(mathListView);
        lowerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        lowerPanel.add(centerPanel);
        lowerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel l3 = new JLabel("Map to:");
        l3.setAlignmentX(0.5f);
        centerPanel.add(l3);
        if (!Inited) {
            MappingDialog.initDialog();
        }
        MediaTracker mtracker = new MediaTracker(this);
        mtracker.addImage(DRT, 0);
        try {
            mtracker.waitForID(0);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        int i9 = 0;
        while (i9 < MapHeight) {
            int j = 0;
            while (j < MapWidth) {
                this.Illegal[i9][j] = MapTypes[i9][j] == null;
                ++j;
            }
            ++i9;
        }
        if (!this.AllowAlpha) {
            i = 0;
            while (i < AlphaMaps.length) {
                p = AlphaMaps[i];
                this.Illegal[p.x][p.y] = true;
                ++i;
            }
        }
        if (!this.Allow3D) {
            i = 0;
            while (i < ThreeDMaps.length) {
                p = ThreeDMaps[i];
                this.Illegal[p.x][p.y] = true;
                ++i;
            }
        }
        this.MapTo = new BufferedImage(40 * MapWidth, 40 * MapHeight, 1);
        Graphics gr = this.MapTo.getGraphics();
        gr.drawImage(DRT, 0, 0, this);
        int i10 = 0;
        while (i10 < MapHeight) {
            int j = 0;
            while (j < MapWidth) {
                if (this.Illegal[i10][j]) {
                    this.eraseBox(j, i10, gr);
                }
                ++j;
            }
            ++i10;
        }
        gr.dispose();
        this.DisplayCanvas = new JComponent(){

            public void paint(Graphics g2) {
                g2.drawImage(MappingDialog.this.MapTo, 0, 0, this);
                int ndx = MappingDialog.this.MathList.getSelectedIndex();
                if (ndx >= 0) {
                    int col = 0;
                    while (col < MapWidth) {
                        int row = 0;
                        while (row < MapHeight) {
                            if (MappingDialog.this.Maps[ndx][row][col]) {
                                MappingDialog.this.highlightBox(col, row, g2);
                            }
                            ++row;
                        }
                        ++col;
                    }
                }
            }

            public Dimension getMinimumSize() {
                return new Dimension(40 * MapWidth, 40 * MapHeight);
            }

            public Dimension getPreferredSize() {
                return new Dimension(40 * MapWidth, 40 * MapHeight);
            }

            public Dimension getMaximumSize() {
                return new Dimension(40 * MapWidth, 40 * MapHeight);
            }
        };
        this.DisplayCanvas.addMouseListener(this);
        centerPanel.add(this.DisplayCanvas);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel b1Panel = new JPanel();
        b1Panel.setLayout(new BoxLayout(b1Panel, 0));
        centerPanel.add(b1Panel);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        b1Panel.add(Box.createHorizontalGlue());
        JButton clearAll = new JButton("Clear all");
        clearAll.setAlignmentX(0.5f);
        clearAll.setToolTipText("Clear all mappings from mappings box");
        clearAll.setActionCommand("all");
        clearAll.addActionListener(this);
        b1Panel.add(clearAll);
        b1Panel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton clearSel = new JButton("Clear selected");
        clearSel.setAlignmentX(0.5f);
        clearSel.setToolTipText("Clear selected mappings from mappings box");
        clearSel.setActionCommand("sel");
        clearSel.addActionListener(this);
        b1Panel.add(clearSel);
        b1Panel.add(Box.createHorizontalGlue());
        JPanel b2Panel = new JPanel();
        b2Panel.setLayout(new BoxLayout(b2Panel, 0));
        centerPanel.add(b2Panel);
        b2Panel.add(Box.createHorizontalGlue());
        JButton done = new JButton("Done");
        done.setAlignmentX(0.5f);
        done.setToolTipText("Apply selected mappings");
        done.setActionCommand("done");
        done.addActionListener(this);
        b2Panel.add(done);
        b2Panel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancel = new JButton("Cancel");
        cancel.setAlignmentX(0.5f);
        cancel.setToolTipText("Close dialog box without applying mappings");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        b2Panel.add(cancel);
        b2Panel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton detect = new JButton("Detect");
        detect.setAlignmentX(0.5f);
        detect.setToolTipText("Automatically identify some good mappings");
        detect.setActionCommand("detect");
        detect.addActionListener(this);
        b2Panel.add(detect);
        b2Panel.add(Box.createHorizontalGlue());
        JPanel rsPanel = new JPanel();
        rsPanel.setLayout(new BoxLayout(rsPanel, 1));
        lowerPanel.add(rsPanel);
        lowerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.CurrentMaps.addListSelectionListener(this);
        this.CurrentMapsView = new JScrollPane(this.CurrentMaps){

            public Dimension getMinimumSize() {
                return new Dimension(0, 40 * MapHeight + 64);
            }

            public Dimension getPreferredSize() {
                return new Dimension(200, 40 * MapHeight + 64);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 40 * MapHeight + 64);
            }
        };
        JLabel l4 = new JLabel("Current maps:");
        l4.setAlignmentX(0.5f);
        rsPanel.add(l4);
        rsPanel.add(this.CurrentMapsView);
    }

    public Dimension getPreferredSize() {
        Dimension max = super.getPreferredSize();
        String os = System.getProperty("os.name");
        int pad = os.startsWith("Windows") ? 60 : 20;
        int w = max.width;
        int h = max.height;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (w > screen.width - pad) {
            w = screen.width - pad;
        }
        if (h > screen.height - pad) {
            h = screen.height - pad;
        }
        return new Dimension(w, h);
    }

    public void display() {
        this.pack();
        Util.centerWindow(this);
        this.setVisible(true);
    }

    public ScalarMap[] getMaps() {
        return this.ScalarMaps;
    }

    public boolean okPressed() {
        return this.Confirm;
    }

    /*
     * Unable to fully structure code
     */
    private void sort(int lo0, int hi0) {
        if (hi0 < lo0) {
            return;
        }
        lo = lo0;
        hi = hi0;
        mid = this.Scalars[(lo0 + hi0) / 2].toLowerCase();
        ** GOTO lbl28
        {
            ++lo;
            do {
                if (lo < hi0 && this.Scalars[lo].toLowerCase().compareTo(mid) < 0) continue block0;
                while (hi > lo0 && this.Scalars[hi].toLowerCase().compareTo(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                st = this.MathTypes[lo];
                this.MathTypes[lo] = this.MathTypes[hi];
                this.MathTypes[hi] = st;
                s = this.Scalars[lo];
                this.Scalars[lo] = this.Scalars[hi];
                this.Scalars[hi] = s;
                i = this.ScW[lo];
                this.ScW[lo] = this.ScW[hi];
                this.ScW[hi] = i;
                v = this.ScP[lo];
                this.ScP[lo] = this.ScP[hi];
                this.ScP[hi] = v;
                ++lo;
                --hi;
lbl28:
                // 3 sources

            } while (lo <= hi);
        }
        if (lo0 < hi) {
            this.sort(lo0, hi);
        }
        if (lo < hi0) {
            this.sort(lo, hi0);
        }
    }

    void eraseBox(int col, int row, Graphics g) {
        int x = 40 * col;
        int y = 40 * row;
        g.setColor(Color.black);
        int i = 0;
        while (i < 40) {
            g.drawLine(x, y + i, x + i, y);
            g.drawLine(x + i, y + 38, x + 38, y + i);
            i += 2;
        }
    }

    void highlightBox(int col, int row, Graphics g) {
        int x = 40 * col;
        int y = 40 * row;
        int n1 = 11;
        int n2 = 29;
        g.setColor(Color.blue);
        g.drawRect(x, y, 39, 39);
        g.drawLine(x, y + 11, x + 11, y);
        g.drawLine(x, y + 29, x + 29, y);
        g.drawLine(x + 11, y + 39, x + 39, y + 11);
        g.drawLine(x + 29, y + 39, x + 39, y + 29);
        g.drawLine(x + 29, y, x + 39, y + 11);
        g.drawLine(x + 11, y, x + 39, y + 29);
        g.drawLine(x, y + 11, x + 29, y + 39);
        g.drawLine(x, y + 29, x + 11, y + 39);
    }

    private void clearAll() {
        this.CurrentMaps.clearSelection();
        this.CurMaps.removeAllElements();
        int i = 0;
        while (i < this.CurMapLabel.length) {
            int j = 0;
            while (j < MapHeight) {
                int k = 0;
                while (k < MapWidth) {
                    this.Maps[i][j][k] = false;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateDescriptionLabel(int i) {
        ScalarType st = this.MathTypes[i];
        String desc = "     " + this.Scalars[i];
        if (st instanceof RealType) {
            String s;
            String u;
            RealType r = (RealType)st;
            Unit unit = r.getDefaultUnit();
            Set set = r.getDefaultSet();
            String string = u = unit == null ? "none" : unit.toString();
            if (set == null) {
                s = "none";
            } else {
                String setType = set.getClass().getName();
                int index = setType.lastIndexOf(".");
                if (index >= 0) {
                    setType = setType.substring(index + 1);
                }
                int dim = set.getDimension();
                s = setType + "(" + dim + ")";
            }
            desc = desc + ": Unit=" + u + "; Set=" + s;
        } else {
            desc = desc + " (text)";
        }
        this.description.setText(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        Object object = this.Lock;
        synchronized (object) {
            if (cmd.equals("all")) {
                if (this.CurMaps.getSize() > 0) {
                    this.clearAll();
                    Graphics g = this.DisplayCanvas.getGraphics();
                    this.DisplayCanvas.paint(g);
                    g.dispose();
                    this.CurrentMaps.repaint();
                    this.CurrentMapsView.validate();
                }
            } else if (cmd.equals("sel")) {
                int[] ndx = this.CurrentMaps.getSelectedIndices();
                int len = ndx.length;
                int x = len - 1;
                while (x >= 0) {
                    String s = (String)this.CurMaps.getElementAt(ndx[x]);
                    boolean looking = true;
                    int i = 0;
                    while (i < this.CurMapLabel.length && looking) {
                        int j = 0;
                        while (j < MapHeight && looking) {
                            int k = 0;
                            while (k < MapWidth && looking) {
                                if (this.CurMapLabel[i][j][k] == s) {
                                    this.Maps[i][j][k] = false;
                                    looking = false;
                                }
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.CurMaps.removeElementAt(ndx[x]);
                    --x;
                }
                if (len > 0) {
                    Graphics g = this.DisplayCanvas.getGraphics();
                    this.DisplayCanvas.paint(g);
                    g.dispose();
                    this.CurrentMaps.repaint();
                    this.CurrentMapsView.validate();
                }
            } else if (cmd.equals("detect")) {
                ScalarMap[] maps = DataUtility.guessMaps(this.Types, this.Allow3D);
                if (this.CurMaps.getSize() > 0) {
                    this.clearAll();
                }
                if (maps != null) {
                    int i = 0;
                    while (i < this.MathTypes.length) {
                        int j = 0;
                        while (j < MapHeight) {
                            int k = 0;
                            while (k < MapWidth) {
                                int m = 0;
                                while (m < maps.length) {
                                    if (maps[m].getScalar() == this.MathTypes[i] && maps[m].getDisplayScalar() == MapTypes[j][k]) {
                                        this.Maps[i][j][k] = true;
                                        this.CurMaps.addElement(this.CurMapLabel[i][j][k]);
                                    }
                                    ++m;
                                }
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                Graphics g = this.DisplayCanvas.getGraphics();
                this.DisplayCanvas.paint(g);
                g.dispose();
                this.CurrentMaps.repaint();
                this.CurrentMapsView.validate();
            } else if (cmd.equals("done")) {
                boolean okay = true;
                int size = this.CurMaps.getSize();
                this.ScalarMaps = new ScalarMap[size];
                int s = 0;
                int i = 0;
                while (i < this.CurMapLabel.length) {
                    int j = 0;
                    while (j < MapHeight) {
                        int k = 0;
                        while (k < MapWidth) {
                            if (this.Maps[i][j][k]) {
                                try {
                                    this.ScalarMaps[s++] = new ScalarMap(this.MathTypes[i], MapTypes[j][k]);
                                }
                                catch (VisADException exc) {
                                    okay = false;
                                    JOptionPane.showMessageDialog(this, "The mapping (" + this.Scalars[i] + " -> " + MapNames[j][k] + ") is not valid.", "Illegal mapping", 0);
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (okay) {
                    this.Confirm = true;
                    this.setVisible(false);
                }
            } else if (cmd.equals("cancel")) {
                this.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(ListSelectionEvent e2) {
        Object object = this.Lock;
        synchronized (object) {
            if (!e2.getValueIsAdjusting() && (JList)e2.getSource() == this.MathList) {
                Graphics g = this.DisplayCanvas.getGraphics();
                this.DisplayCanvas.paint(g);
                g.dispose();
                int i = this.MathList.getSelectedIndex();
                MDTuple tuple = (MDTuple)this.ScP[i].elementAt(0);
                Rectangle r = new Rectangle(tuple.x, tuple.y, this.ScW[i], this.ScH);
                this.MathList.ensureIndexIsVisible(i);
                if (tuple.b) {
                    this.CoordCanvas.scrollRectToVisible(r);
                } else {
                    this.MathCanvas.scrollRectToVisible(r);
                }
                this.MathCanvas.repaint();
                if (this.CoordRefs) {
                    this.CoordCanvas.repaint();
                }
                this.updateDescriptionLabel(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e2) {
        Object object = this.Lock;
        synchronized (object) {
            Component c2 = e2.getComponent();
            if (c2 == this.MathCanvas) {
                Point p = e2.getPoint();
                int i = 0;
                while (i < this.Scalars.length) {
                    int j = 0;
                    while (j < this.ScP[i].size()) {
                        Rectangle r;
                        MDTuple tuple = (MDTuple)this.ScP[i].elementAt(j);
                        if (!tuple.b && (r = new Rectangle(tuple.x, tuple.y, this.ScW[i], this.ScH)).contains(p)) {
                            this.MathList.setSelectedIndex(i);
                            this.MathList.ensureIndexIsVisible(i);
                            this.MathCanvas.scrollRectToVisible(r);
                            this.updateDescriptionLabel(i);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (c2 == this.DisplayCanvas) {
                int col = e2.getX() / 40;
                int row = e2.getY() / 40;
                int ndx = this.MathList.getSelectedIndex();
                if (ndx >= 0 && row >= 0 && col >= 0 && row < MapHeight && col < MapWidth && !this.Illegal[row][col]) {
                    boolean bl = this.Maps[ndx][row][col] = !this.Maps[ndx][row][col];
                    if (this.Maps[ndx][row][col]) {
                        this.CurMaps.addElement(this.CurMapLabel[ndx][row][col]);
                    } else {
                        this.CurrentMaps.clearSelection();
                        this.CurMaps.removeElement(this.CurMapLabel[ndx][row][col]);
                    }
                    Graphics g = this.DisplayCanvas.getGraphics();
                    g.setClip(40 * col, 40 * row, 41, 41);
                    this.DisplayCanvas.paint(g);
                    g.dispose();
                    this.CurrentMaps.repaint();
                    this.CurrentMapsView.validate();
                }
            } else if (c2 == this.CoordCanvas) {
                Point p = e2.getPoint();
                int i = 0;
                while (i < this.Scalars.length) {
                    int j = 0;
                    while (j < this.ScP[i].size()) {
                        Rectangle r;
                        MDTuple tuple = (MDTuple)this.ScP[i].elementAt(j);
                        if (tuple.b && (r = new Rectangle(tuple.x, tuple.y, this.ScW[i], this.ScH)).contains(p)) {
                            this.MathList.setSelectedIndex(i);
                            this.MathList.ensureIndexIsVisible(i);
                            this.CoordCanvas.scrollRectToVisible(r);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MDTuple {
        int x;
        int y;
        boolean b;

        MDTuple(int x, int y, boolean b2) {
            this.x = x;
            this.y = y;
            this.b = b2;
        }
    }
}

