/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import visad.DataReference;
import visad.DisplayImpl;
import visad.LocalDisplay;
import visad.RemoteDisplay;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.VisADException;

public class ClientServer {
    private static final int maximumWaitTime = 60;
    static /* synthetic */ Class class$visad$RemoteDisplay;

    public static RemoteServer connectToServer(String hostName, String serviceName) throws RemoteException, VisADException {
        return ClientServer.connectToServer(hostName, serviceName, false);
    }

    public static RemoteServer connectToServer(String hostName, String serviceName, boolean verbose) throws RemoteException, VisADException {
        RemoteServer client = null;
        String domain = "//" + hostName + "/" + serviceName;
        int loops = 0;
        while (client == null && loops < 60) {
            if (loops > 0) {
                try {
                    client = (RemoteServer)Naming.lookup(domain);
                }
                catch (NotBoundException nbe) {
                    client = null;
                }
                catch (ConnectException ce) {
                    client = null;
                }
                catch (Exception e2) {
                    throw new VisADException("Cannot connect to server on \"" + hostName + "\" (" + e2.getClass().getName() + ": " + e2.getMessage() + ")");
                }
            }
            try {
                if (client != null) {
                    RemoteDisplay rmtDpy = client.getDisplay(0);
                }
            }
            catch (ConnectException ce) {
                client = null;
            }
            if (client != null) continue;
            if (verbose) {
                if (loops == 0) {
                    System.err.print("Client waiting for server ");
                } else {
                    System.err.print(".");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++loops;
        }
        if (loops == 60) {
            if (verbose) {
                System.err.println(" giving up!");
            }
            throw new VisADException("Cannot connect to " + hostName + ":" + serviceName);
        }
        if (loops > 0 && verbose) {
            System.err.println(" connected");
        }
        return client;
    }

    private static LocalDisplay wrapRemoteDisplay(RemoteDisplay rmtDpy) throws RemoteException, VisADException {
        DisplayImpl dpy;
        Constructor<?> cons;
        Class<?> dpyClass;
        String className = rmtDpy.getDisplayClassName();
        try {
            dpyClass = Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new VisADException("Couldn't create " + className);
        }
        try {
            cons = dpyClass.getConstructor(class$visad$RemoteDisplay == null ? (class$visad$RemoteDisplay = ClientServer.class$("visad.RemoteDisplay")) : class$visad$RemoteDisplay);
        }
        catch (NoSuchMethodException e3) {
            throw new VisADException(className + " has no RemoteDisplay" + " constructor");
        }
        Object[] cargs = new Object[]{rmtDpy};
        try {
            dpy = (DisplayImpl)cons.newInstance(cargs);
        }
        catch (InvocationTargetException ite) {
            Throwable t2 = ite.getTargetException();
            if (t2 instanceof VisADException) {
                throw (VisADException)t2;
            }
            if (t2 instanceof ConnectException) {
                throw new VisADException("Couldn't create local shadow for " + rmtDpy + ": Connection refused");
            }
            throw new VisADException("Couldn't create local shadow for " + rmtDpy + ": " + t2.getClass().getName() + ": " + t2.getMessage());
        }
        catch (Exception e4) {
            throw new VisADException("Couldn't create local shadow for " + rmtDpy + ": " + e4.getClass().getName() + ": " + e4.getMessage());
        }
        return dpy;
    }

    public static LocalDisplay getClientDisplay(RemoteServer client, int index) throws RemoteException, VisADException {
        return ClientServer.getClientDisplay(client, index, null);
    }

    public static LocalDisplay getClientDisplay(RemoteServer client, int index, DataReference[] refs) throws RemoteException, VisADException {
        if (client == null) {
            return null;
        }
        RemoteDisplay rmtDpy = null;
        int loops = 0;
        while (rmtDpy == null && loops < 60) {
            try {
                rmtDpy = client.getDisplay(index);
            }
            catch (ConnectException ce) {
                ce.printStackTrace();
            }
            if (rmtDpy != null) continue;
            if (loops == 0) {
                System.err.print("Client waiting for server display #" + index + " ");
            } else {
                System.err.print(".");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++loops;
        }
        if (rmtDpy == null && loops == 60) {
            System.err.println(" giving up!");
            System.exit(1);
        } else if (loops > 0) {
            System.err.println(". ready");
        }
        if (rmtDpy == null) {
            return null;
        }
        LocalDisplay dpy = ClientServer.wrapRemoteDisplay(rmtDpy);
        if (dpy != null && refs != null) {
            dpy.replaceReferences(rmtDpy, null, refs, null);
        }
        return dpy;
    }

    public static LocalDisplay[] getClientDisplays(RemoteServer client) throws RemoteException, VisADException {
        return ClientServer.getClientDisplays(client, null);
    }

    public static LocalDisplay[] getClientDisplays(RemoteServer client, DataReference[] refs) throws RemoteException, VisADException {
        if (client == null) {
            return null;
        }
        RemoteDisplay[] rmtDpys = null;
        int loops = 0;
        while (rmtDpys == null && loops < 60) {
            try {
                rmtDpys = client.getDisplays();
            }
            catch (ConnectException ce) {
                // empty catch block
            }
            if (rmtDpys != null) continue;
            if (loops == 0) {
                System.err.print("Client waiting for server displays ");
            } else {
                System.err.print(".");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++loops;
        }
        if (rmtDpys == null && loops == 60) {
            System.err.println(" giving up!");
            System.exit(1);
        } else if (loops > 0) {
            System.err.println(". ready");
        }
        if (rmtDpys == null) {
            return null;
        }
        LocalDisplay[] dpys = new LocalDisplay[rmtDpys.length];
        int i = 0;
        while (i < dpys.length) {
            dpys[i] = ClientServer.wrapRemoteDisplay(rmtDpys[i]);
            if (dpys[i] != null && refs != null) {
                dpys[i].replaceReferences(rmtDpys[i], null, refs, null);
            }
            ++i;
        }
        return dpys;
    }

    public static RemoteServerImpl startServer(String serviceName) throws RemoteException, VisADException {
        RemoteServerImpl server;
        block5: {
            boolean success;
            boolean registryStarted = false;
            do {
                success = true;
                try {
                    server = new RemoteServerImpl();
                    String domain = "///" + serviceName;
                    Naming.rebind(domain, server);
                    break block5;
                }
                catch (ConnectException ce) {
                    if (!registryStarted) {
                        LocateRegistry.createRegistry(1099);
                        registryStarted = true;
                        continue;
                    }
                    success = false;
                }
                catch (Exception e2) {
                    success = false;
                }
            } while (success);
            throw new VisADException("Cannot set up server (rmiregistry may not be running)");
        }
        return server;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

