/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.ArrayList;
import visad.util.CmdlineConsumer;

public class CmdlineParser {
    private String mainName;
    private ArrayList list;

    public CmdlineParser(Object mainClass) {
        String className = mainClass.getClass().getName();
        int pt = className.lastIndexOf(46);
        int ds = className.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        this.mainName = className.substring(pt == -1 ? 0 : pt + 1);
        this.list = null;
        if (mainClass instanceof CmdlineConsumer) {
            this.addConsumer((CmdlineConsumer)mainClass);
        }
    }

    public void addConsumer(CmdlineConsumer consumer) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(consumer);
    }

    public String getMainClassName() {
        return this.mainName;
    }

    public boolean processArgs(String[] args) {
        boolean usage = false;
        if (this.list == null || args == null) {
            return true;
        }
        CmdlineConsumer[] consumers = new CmdlineConsumer[this.list.size()];
        int c2 = 0;
        while (c2 < consumers.length) {
            consumers[c2] = (CmdlineConsumer)this.list.get(consumers.length - (c2 + 1));
            ++c2;
        }
        int c3 = 0;
        while (c3 < consumers.length) {
            consumers[c3].initializeArgs();
            ++c3;
        }
        int i = 0;
        while (!usage && i < args.length) {
            if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                String str;
                char ch = args[i].charAt(1);
                boolean strInOption = false;
                if (args[i].length() > 2) {
                    str = args[i].substring(2);
                    strInOption = true;
                } else {
                    str = i + 1 < args.length ? args[i + 1] : null;
                }
                int c4 = 0;
                while (c4 < consumers.length) {
                    int handled = consumers[c4].checkOption(this.mainName, ch, str);
                    if (handled > 0) {
                        if (handled > 1) {
                            handled = strInOption ? 1 : 2;
                        }
                        i += handled - 1;
                        break;
                    }
                    if (handled == 0) {
                        System.err.println(this.mainName + ": Unknown option \"-" + ch + "\"");
                    }
                    usage = true;
                    ++c4;
                }
            } else {
                int c5 = 0;
                while (c5 < consumers.length) {
                    int handled = consumers[c5].checkKeyword(this.mainName, i, args);
                    if (handled > 0) {
                        i += handled - 1;
                        break;
                    }
                    if (handled == 0) {
                        System.err.println(this.mainName + ": Unknown keyword \"" + args[i] + "\"");
                    }
                    usage = true;
                    ++c5;
                }
            }
            ++i;
        }
        int c6 = 0;
        while (!usage && c6 < consumers.length) {
            usage |= !consumers[c6].finalizeArgs(this.mainName);
            ++c6;
        }
        if (usage) {
            StringBuffer buf = new StringBuffer("Usage: " + this.mainName);
            int c7 = 0;
            while (c7 < consumers.length) {
                buf.append(consumers[c7].optionUsage());
                ++c7;
            }
            int c8 = 0;
            while (c8 < consumers.length) {
                buf.append(consumers[c8].keywordUsage());
                ++c8;
            }
            System.err.println(buf.toString());
        }
        return !usage;
    }
}

