/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.util.Vector;
import javax.swing.JPanel;
import visad.util.ColorChangeEvent;
import visad.util.ColorChangeListener;

public abstract class ColorMap
extends JPanel {
    private Vector listeners = new Vector();

    public Color getColor(float value) {
        if (value < 0.0f || value > 1.0f) {
            return Color.black;
        }
        float[] rgb = this.getRGBTuple(value);
        if (rgb[0] < 0.0f) {
            rgb[0] = 0.0f;
        }
        if (rgb[1] < 0.0f) {
            rgb[1] = 0.0f;
        }
        if (rgb[2] < 0.0f) {
            rgb[2] = 0.0f;
        }
        if (rgb[0] > 1.0f) {
            rgb[0] = 1.0f;
        }
        if (rgb[1] > 1.0f) {
            rgb[1] = 1.0f;
        }
        if (rgb[2] > 1.0f) {
            rgb[2] = 1.0f;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color[] getColors(float start, float end, int num) {
        float[][] rgb = this.getMapDimension() < 3 ? this.getRGBTuples(start, end, num) : this.getTuples(start, end, num);
        if (rgb == null) {
            return null;
        }
        Color[] colors = new Color[rgb.length];
        int i = rgb.length - 1;
        while (i >= 0) {
            if (rgb[i][0] < 0.0f) {
                rgb[i][0] = 0.0f;
            } else if (rgb[i][0] > 1.0f) {
                rgb[i][0] = 1.0f;
            }
            if (rgb[i][1] < 0.0f) {
                rgb[i][1] = 0.0f;
            } else if (rgb[i][1] > 1.0f) {
                rgb[i][1] = 1.0f;
            }
            if (rgb[i][2] < 0.0f) {
                rgb[i][2] = 0.0f;
            } else if (rgb[i][2] > 1.0f) {
                rgb[i][2] = 1.0f;
            }
            colors[i] = new Color(rgb[i][0], rgb[i][1], rgb[i][2]);
            --i;
        }
        return colors;
    }

    public abstract float[] getRGBTuple(float var1);

    public abstract float[][] getRGBTuples(float var1, float var2, int var3);

    public abstract float[] getTuple(float var1);

    public abstract float[][] getTuples(float var1, float var2, int var3);

    public abstract int getMapResolution();

    public abstract int getMapDimension();

    public abstract float[][] getColorMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColorChangeListener(ColorChangeListener c2) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(c2)) {
                this.listeners.addElement(c2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColorChangeListener(ColorChangeListener c2) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(c2)) {
                this.listeners.removeElement(c2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(ColorChangeEvent e2) {
        Vector cl = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            cl = (Vector)this.listeners.clone();
        }
        int i = 0;
        while (i < cl.size()) {
            ColorChangeListener c2 = (ColorChangeListener)cl.elementAt(i);
            c2.colorChanged(e2);
            ++i;
        }
    }
}

