/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.ControlEvent;
import visad.ControlListener;
import visad.GraphicsModeControl;
import visad.PlotText;
import visad.VisADException;
import visad.util.Util;

public class GMCWidget
extends JPanel
implements ActionListener,
ItemListener,
ControlListener {
    GraphicsModeControl control;
    JCheckBox scale;
    JCheckBox point;
    JCheckBox texture;
    JTextField lineWidth;
    JTextField pointSize;
    float gmcLineWidth;
    float gmcPointSize;

    public GMCWidget(GraphicsModeControl gmc) {
        this.control = gmc;
        JPanel top = new JPanel();
        JPanel bot = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        top.setLayout(new BoxLayout(top, 0));
        bot.setLayout(new BoxLayout(bot, 0));
        boolean s = false;
        boolean p = false;
        boolean t2 = false;
        if (this.control != null) {
            s = this.control.getScaleEnable();
            p = this.control.getPointMode();
            t2 = this.control.getTextureEnable();
        }
        this.gmcLineWidth = 1.0f;
        this.gmcPointSize = 1.0f;
        if (this.control != null) {
            this.gmcLineWidth = this.control.getLineWidth();
            this.gmcPointSize = this.control.getPointSize();
        }
        this.scale = new JCheckBox("Enable scale", s);
        this.point = new JCheckBox("Point mode", p);
        this.texture = new JCheckBox("Texture mapping", t2);
        this.lineWidth = new JTextField(PlotText.shortString(this.gmcLineWidth));
        Dimension msize = this.lineWidth.getMaximumSize();
        Dimension psize = this.lineWidth.getPreferredSize();
        msize.height = psize.height;
        this.lineWidth.setMaximumSize(msize);
        this.pointSize = new JTextField(PlotText.shortString(this.gmcPointSize));
        msize = this.pointSize.getMaximumSize();
        psize = this.pointSize.getPreferredSize();
        msize.height = psize.height;
        this.pointSize.setMaximumSize(msize);
        JLabel lwLabel = new JLabel("Line width:");
        JLabel psLabel = new JLabel("Point size:");
        lwLabel.setForeground(Color.black);
        psLabel.setForeground(Color.black);
        this.scale.addItemListener(this);
        this.point.addItemListener(this);
        this.texture.addItemListener(this);
        this.lineWidth.addActionListener(this);
        this.lineWidth.setActionCommand("line");
        this.pointSize.addActionListener(this);
        this.pointSize.setActionCommand("point");
        this.control.addControlListener(this);
        top.add(this.scale);
        top.add(this.point);
        top.add(this.texture);
        bot.add(lwLabel);
        bot.add(this.lineWidth);
        bot.add(psLabel);
        bot.add(this.pointSize);
        this.add(top);
        this.add(bot);
    }

    public void actionPerformed(ActionEvent e2) {
        block12: {
            String cmd;
            block11: {
                cmd = e2.getActionCommand();
                if (!cmd.equals("line")) break block11;
                float lw = Float.NaN;
                try {
                    lw = Float.valueOf(this.lineWidth.getText()).floatValue();
                }
                catch (NumberFormatException exc) {
                    this.lineWidth.setText(PlotText.shortString(this.gmcLineWidth));
                }
                if (lw != lw || this.control == null) break block12;
                try {
                    this.control.setLineWidth(lw);
                    this.gmcLineWidth = lw;
                    this.scale.requestFocus();
                }
                catch (VisADException exc) {
                    this.lineWidth.setText(PlotText.shortString(this.gmcLineWidth));
                }
                catch (RemoteException exc) {
                    this.lineWidth.setText(PlotText.shortString(this.gmcLineWidth));
                }
                break block12;
            }
            if (!cmd.equals("point")) break block12;
            float ps = Float.NaN;
            try {
                ps = Float.valueOf(this.pointSize.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.pointSize.setText(PlotText.shortString(this.gmcPointSize));
            }
            if (ps == ps && this.control != null) {
                try {
                    this.control.setPointSize(ps);
                    this.gmcPointSize = ps;
                    this.scale.requestFocus();
                }
                catch (VisADException exc) {
                    this.pointSize.setText(PlotText.shortString(this.gmcPointSize));
                }
                catch (RemoteException exc) {
                    this.pointSize.setText(PlotText.shortString(this.gmcPointSize));
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        block8: {
            if (this.control == null) break block8;
            ItemSelectable o = e2.getItemSelectable();
            boolean on = e2.getStateChange() == 1;
            try {
                if (o == this.scale) {
                    this.control.setScaleEnable(on);
                } else if (o == this.point) {
                    this.control.setPointMode(on);
                } else if (o == this.texture) {
                    this.control.setTextureEnable(on);
                }
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {}
        }
    }

    public void controlChanged(ControlEvent e2) {
        float val;
        if (this.control == null) {
            return;
        }
        if (this.control.getScaleEnable() != this.scale.isSelected()) {
            this.scale.setSelected(this.control.getScaleEnable());
        }
        if (this.control.getPointMode() != this.point.isSelected()) {
            this.point.setSelected(this.control.getPointMode());
        }
        if (this.control.getTextureEnable() != this.texture.isSelected()) {
            this.texture.setSelected(this.control.getTextureEnable());
        }
        if (!Util.isApproximatelyEqual(val = this.control.getLineWidth(), this.gmcLineWidth)) {
            this.lineWidth.setText(PlotText.shortString(val));
            this.gmcLineWidth = val;
        }
        if (!Util.isApproximatelyEqual(val = this.control.getPointSize(), this.gmcPointSize)) {
            this.pointSize.setText(PlotText.shortString(val));
            this.gmcPointSize = val;
        }
    }
}

