/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class HersheyFont {
    private static final int MAX_CHARACTERS = 256;
    private static final int MAX_POINTS = 300;
    protected static final int X = 0;
    protected static final int Y = 1;
    private String copyright = "Copyright (c) James P. Buzbee Mar 30, 1996";
    protected String name;
    protected char[][][] characterVectors = new char[256][2][300];
    protected int[] numberOfPoints = new int[256];
    protected int[] characterMinX;
    protected int[] characterMaxX;
    protected int characterSetMinY;
    protected int characterSetMaxY;
    protected int characterSetMinX;
    protected int characterSetMaxX;
    protected int charactersInSet;
    protected boolean fixedWidth = false;
    static /* synthetic */ Class class$visad$util$HersheyFont;

    public HersheyFont() {
        this("futural");
    }

    public HersheyFont(String fontName) {
        this.name = fontName;
        try {
            String fn = fontName + ".jhf";
            InputStream fontStream = (class$visad$util$HersheyFont == null ? (class$visad$util$HersheyFont = HersheyFont.class$("visad.util.HersheyFont")) : class$visad$util$HersheyFont).getResourceAsStream(fn);
            this.LoadHersheyFont(fontName, fontStream);
            fontStream.close();
        }
        catch (Exception e2) {
            System.out.println("Error processing HersheyFont named " + fontName + ": " + e2);
        }
    }

    public HersheyFont(URL base, String fontName) {
        this.name = fontName;
        try {
            InputStream fontStream = new URL(base, fontName).openStream();
            this.LoadHersheyFont(fontName, fontStream);
            fontStream.close();
        }
        catch (Exception e2) {
            System.out.println("Error processing font " + fontName + ": " + e2);
        }
    }

    public HersheyFont(URL base) {
        this.name = base.toString();
        try {
            InputStream fontStream = base.openStream();
            this.LoadHersheyFont(this.name, fontStream);
            fontStream.close();
        }
        catch (Exception e2) {
            System.out.println("Error processing font " + this.name + ": " + e2);
        }
    }

    public int getMaxPoints() {
        return 300;
    }

    public int[] getCharacterMinX() {
        return this.characterMinX;
    }

    public int[] getCharacterMaxX() {
        return this.characterMaxX;
    }

    public int getCharacterSetMinY() {
        return this.characterSetMinY;
    }

    public int getCharacterSetMaxY() {
        return this.characterSetMaxY;
    }

    public int getCharacterSetMinX() {
        return this.characterSetMinX;
    }

    public int getCharacterSetMaxX() {
        return this.characterSetMaxX;
    }

    public int getCharactersInSet() {
        return this.charactersInSet;
    }

    public int getNumberOfPoints(int i) {
        if (i < this.characterVectors.length) {
            return this.numberOfPoints[i];
        }
        return 0;
    }

    public char[][] getCharacterVector(int i) {
        if (i < this.characterVectors.length) {
            return this.characterVectors[i];
        }
        return null;
    }

    public void setFixedWidth(boolean fw) {
        this.fixedWidth = fw;
    }

    public boolean getFixedWidth() {
        this.fixedWidth = false;
        if (this.name.toLowerCase().startsWith("wmo")) {
            this.fixedWidth = true;
        }
        return this.fixedWidth;
    }

    public boolean getIsCursive() {
        return this.name.toLowerCase().indexOf("cursive") != -1;
    }

    private int getInt(InputStream file, int n) throws IOException {
        if (file == null) {
            return -1;
        }
        int j = 0;
        char[] buf = new char[n];
        int i = 0;
        while (i < n) {
            int c2 = file.read();
            while (c2 == 10 || c2 == 13) {
                c2 = file.read();
            }
            if (c2 == -1) {
                return c2;
            }
            if ((char)c2 != ' ') {
                buf[j++] = (char)c2;
            }
            ++i;
        }
        return Integer.parseInt(String.copyValueOf(buf, 0, j));
    }

    private int fontAdjustment(String fontname) {
        int xadjust = 0;
        if (fontname.indexOf("scri") < 0) {
            xadjust = fontname.indexOf("goth") >= 0 ? 2 : 3;
        }
        return xadjust;
    }

    private void LoadHersheyFont(String fontname, InputStream fontStream) {
        block9: {
            if (fontStream == null) {
                return;
            }
            int xadjust = this.fontAdjustment(fontname);
            try {
                int character = 0;
                while (true) {
                    int n;
                    if (this.getInt(fontStream, 5) < 1) break;
                    this.numberOfPoints[character] = n = this.getInt(fontStream, 3);
                    int i = 0;
                    while (i < n) {
                        int c2;
                        if (i == 32 || i == 68 || i == 104 || i == 140) {
                            fontStream.read();
                        }
                        if ((c2 = fontStream.read()) == 10) {
                            c2 = fontStream.read();
                        }
                        this.characterVectors[character][0][i] = (char)c2;
                        this.characterVectors[character][1][i] = (char)fontStream.read();
                        ++i;
                    }
                    fontStream.read();
                    ++character;
                }
                this.charactersInSet = character;
                this.characterMinX = new int[this.charactersInSet];
                this.characterMaxX = new int[this.charactersInSet];
                this.characterSetMinY = 1000;
                this.characterSetMaxY = -1000;
                this.characterSetMinX = 1000;
                this.characterSetMaxX = -1000;
                int j = 1;
                while (j < this.charactersInSet) {
                    this.calculateCharacterSize(j, xadjust);
                    ++j;
                }
                if (65 <= this.charactersInSet) {
                    this.characterMinX[0] = this.characterMinX[65];
                    this.characterMaxX[0] = this.characterMaxX[65];
                    break block9;
                }
                this.characterMinX[0] = this.characterMinX[this.charactersInSet - 1];
                this.characterMaxX[0] = this.characterMaxX[this.charactersInSet - 1];
            }
            catch (IOException e2) {
                System.out.println(e2);
            }
        }
    }

    protected void calculateCharacterSize(int j, int xadj) {
        this.characterMinX[j] = 1000;
        this.characterMaxX[j] = -1000;
        int i = 1;
        while (i < this.numberOfPoints[j]) {
            int cx = this.characterVectors[j][0][i];
            int cy = this.characterVectors[j][1][i];
            if (cx != 32) {
                if (cx < this.characterMinX[j]) {
                    this.characterMinX[j] = cx;
                }
                if (cx < this.characterSetMinX) {
                    this.characterSetMinX = cx;
                }
                if (cx > this.characterMaxX[j]) {
                    this.characterMaxX[j] = cx;
                }
                if (cx > this.characterSetMaxX) {
                    this.characterSetMaxX = cx;
                }
                if (cy < this.characterSetMinY) {
                    this.characterSetMinY = cy;
                }
                if (cy > this.characterSetMaxY) {
                    this.characterSetMaxY = cy;
                }
            }
            ++i;
        }
        int n = j;
        this.characterMinX[n] = this.characterMinX[n] - xadj;
        int n2 = j;
        this.characterMaxX[n2] = this.characterMaxX[n2] + xadj;
    }

    public String toString() {
        return "HersheyFont: " + this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

