/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.PlotText;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;

public class RangeWidget
extends JPanel
implements ActionListener,
ScalarMapListener {
    private JTextField data_low;
    private JTextField data_hi;
    private ScalarMap map;

    public RangeWidget(ScalarMap smap) throws VisADException {
        this.map = smap;
        if (this.map == null) {
            throw new VisADException("RangeWidget: ScalarMap cannot be null");
        }
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        boolean scale = this.map.getScale(so, data, display);
        if (!scale) {
            throw new VisADException("RangeWidget: ScalarMap must have linearly scalable range");
        }
        this.data_low = new JTextField();
        this.data_hi = new JTextField();
        this.updateTextFields(data);
        Dimension msize = this.data_low.getMaximumSize();
        Dimension psize = this.data_low.getPreferredSize();
        msize.height = psize.height;
        this.data_low.setMaximumSize(msize);
        this.data_hi.setMaximumSize(msize);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("low: "));
        p.add(this.data_low);
        p.add(new JLabel(" hi: "));
        p.add(this.data_hi);
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("Range of " + this.map.getScalarName() + " mapped to " + this.map.getDisplayScalar().getName().substring(7)));
        this.add(p);
        this.map.addScalarMapListener(this);
        this.data_low.addActionListener(this);
        this.data_hi.addActionListener(this);
    }

    private void updateTextFields(double[] data) {
        this.data_low.setText(PlotText.shortString(data[0]));
        this.data_hi.setText(PlotText.shortString(data[1]));
    }

    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        double[] data = new double[]{Double.parseDouble(this.data_low.getText()), Double.parseDouble(this.data_hi.getText())};
        try {
            this.map.setRange(data[0], data[1]);
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {}
    }

    public void mapChanged(ScalarMapEvent e2) {
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        this.map.getScale(so, data, display);
        this.updateTextFields(data);
    }

    public void controlChanged(ScalarMapControlEvent evt) {
    }
}

