/*
 * Decompiled with CFR 0.152.
 */
package csplugins.expressionData;

import csplugins.expressionData.ExpressionRatioValues;
import csplugins.vectormath.MathVector;
import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyMathVector;
import cytoscape.data.ExpressionData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExpressionCorrelation {
    private ExpressionData a;
    private Map if = new HashMap();

    public ExpressionCorrelation() {
    }

    public ExpressionCorrelation(ExpressionData expressionData) {
        this.setExpressionData(expressionData);
    }

    public void setExpressionData(ExpressionData expressionData) {
        this.a = expressionData;
    }

    public Map buildCorrelationTable(String string) {
        this.if.clear();
        if (this.a == null) {
            return this.if;
        }
        ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(this.a, string);
        if (expressionRatioValues.size() == 0) {
            return this.if;
        }
        ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(expressionRatioValues);
        return this.buildCorrelationTable(readOnlyMathVector);
    }

    public Map buildCorrelationTable(String[] stringArray) {
        this.if.clear();
        if (this.a == null || stringArray == null || stringArray.length == 0) {
            return this.if;
        }
        int n = this.a.getNumberOfConditions();
        double[] dArray = new double[n];
        Arrays.fill(dArray, 0.0);
        MathVector mathVector = MathVectorFactory.makeVector(dArray);
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(this.a, stringArray[i]);
            if (expressionRatioValues.size() == 0) continue;
            ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(expressionRatioValues);
            mathVector.add(readOnlyMathVector.copy().normalize());
            ++n2;
        }
        if (n2 == 0) {
            return this.if;
        }
        mathVector.times(1.0 / (double)n2);
        return this.buildCorrelationTable(mathVector);
    }

    public Map buildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.if.clear();
        int n = this.a.getNumberOfConditions();
        if (readOnlyMathVector.size() != n) {
            return this.if;
        }
        String[] stringArray = this.a.getGeneNames();
        for (int i = 0; i < stringArray.length; ++i) {
            ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(this.a, stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(expressionRatioValues);
            this.if.put(stringArray[i], new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2)));
        }
        return this.if;
    }

    public Map getCorrelationTable() {
        return this.if;
    }
}

