/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.Attribute;
import dods.dap.AttributeBadValueException;
import dods.dap.AttributeExistsException;
import dods.dap.NoSuchAttributeException;
import dods.util.SortedTable;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class AttributeTable
implements Cloneable {
    private static final boolean _Debug = false;
    private SortedTable attr;
    private String name;

    public AttributeTable() {
        this.attr = new SortedTable();
    }

    public AttributeTable(String name) {
        this.name = name;
        this.attr = new SortedTable();
    }

    public Object clone() {
        try {
            AttributeTable at = (AttributeTable)super.clone();
            at.name = this.name;
            at.attr = new SortedTable();
            int i = 0;
            while (i < this.attr.size()) {
                String key = (String)this.attr.getKey(i);
                Attribute element = (Attribute)this.attr.elementAt(i);
                at.attr.put(key, element.clone());
                ++i;
            }
            return at;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Enumeration getNames() {
        return this.attr.keys();
    }

    public final Attribute getAttribute(String name) {
        return (Attribute)this.attr.get(name);
    }

    public final void appendAttribute(String name, int type, String value, boolean check) throws AttributeExistsException, AttributeBadValueException {
        Attribute a2 = (Attribute)this.attr.get(name);
        if (a2 != null && type != a2.getType()) {
            throw new AttributeExistsException("`" + name + "' previously defined with a different type.");
        }
        if (a2 != null) {
            a2.appendValue(value, check);
        } else {
            a2 = new Attribute(type, name, value, check);
            this.attr.put(name, a2);
        }
    }

    public final void appendAttribute(String name, int type, String value) throws AttributeExistsException, AttributeBadValueException {
        this.appendAttribute(name, type, value, true);
    }

    public final AttributeTable appendContainer(String name) {
        if (this.attr.get(name) != null) {
            return null;
        }
        AttributeTable at = new AttributeTable(name);
        Attribute a2 = new Attribute(name, at);
        this.attr.put(name, a2);
        return at;
    }

    public final void addAlias(String alias, String name) throws NoSuchAttributeException, AttributeExistsException {
        if (this.attr.get(alias) != null) {
            throw new AttributeExistsException("Could not alias `" + name + "' and `" + alias + "'.");
        }
        Attribute a2 = (Attribute)this.attr.get(name);
        if (a2 == null) {
            throw new NoSuchAttributeException("Could not alias `" + name + "' and `" + alias + "'.");
        }
        Attribute newAttr = new Attribute(name, a2);
        this.attr.put(alias, newAttr);
    }

    public final void delAttribute(String name) {
        this.attr.remove(name);
    }

    public final void delAttribute(String name, int i) {
        if (i == -1) {
            this.attr.remove(name);
        } else {
            Attribute a2 = (Attribute)this.attr.get(name);
            if (a2 != null) {
                if (a2.isContainer()) {
                    this.attr.remove(name);
                } else {
                    a2.deleteValueAt(i);
                }
            }
        }
    }

    public void print(PrintWriter os, String pad) {
        Enumeration e2 = this.getNames();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            Attribute a2 = this.getAttribute(name);
            if (a2.isAlias()) {
                os.println(pad + "Alias " + name + " " + a2.getAliasedTo() + ";");
                continue;
            }
            if (a2.isContainer()) {
                os.println(pad + name + " {");
                a2.getContainer().print(os, pad + "    ");
                os.println(pad + "}");
                continue;
            }
            os.print(pad + a2.getTypeString() + " " + name + " ");
            Enumeration es = a2.getValues();
            String val = (String)es.nextElement();
            while (es.hasMoreElements()) {
                os.print(val + ", ");
                val = (String)es.nextElement();
            }
            os.println(val + ";");
        }
        os.flush();
    }

    public final void print(OutputStream os, String pad) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))), pad);
    }

    public final void print(PrintWriter os) {
        this.print(os, "    ");
    }

    public final void print(OutputStream os) {
        this.print(os, "    ");
    }
}

