/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.PrimitiveVector;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public abstract class BaseType
implements Cloneable {
    private String _name;
    private BaseType _myParent;

    public BaseType() {
        this("");
    }

    public BaseType(String n) {
        this._name = n;
        this._myParent = null;
    }

    public Object clone() {
        try {
            BaseType bt = (BaseType)super.clone();
            return bt;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String n) {
        this._name = n;
    }

    public abstract String getTypeName();

    public int elementCount(boolean leaves) {
        return 1;
    }

    public final int elementCount() {
        return this.elementCount(false);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.print(space + this.getTypeName() + " " + this.getName());
        if (print_semi) {
            os.println(";");
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi) {
        this.printDecl(os, space, print_semi, false);
    }

    public final void printDecl(PrintWriter os, String space) {
        this.printDecl(os, space, true, false);
    }

    public final void printDecl(PrintWriter os) {
        this.printDecl(os, "    ", true, false);
    }

    public final void printDecl(OutputStream os, String space, boolean print_semi, boolean constrained) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDecl(pw, space, print_semi, constrained);
        pw.flush();
    }

    public final void printDecl(OutputStream os, String space, boolean print_semi) {
        this.printDecl(os, space, print_semi, false);
    }

    public final void printDecl(OutputStream os, String space) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDecl(pw, space);
        pw.flush();
    }

    public final void printDecl(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDecl(pw);
        pw.flush();
    }

    public abstract void printVal(PrintWriter var1, String var2, boolean var3);

    public final void printVal(PrintWriter os, String space) {
        this.printVal(os, space, true);
    }

    public final void printVal(OutputStream os, String space, boolean print_decl_p) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printVal(pw, space, print_decl_p);
        pw.flush();
    }

    public final void printVal(OutputStream os, String space) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printVal(pw, space);
        pw.flush();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        if (this._name == null) {
            throw new BadSemanticsException("BaseType.checkSemantics(): Every variable must have a name");
        }
    }

    public final void checkSemantics() throws BadSemanticsException {
        this.checkSemantics(false);
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BaseTypePrimitiveVector(this);
    }

    public void setParent(BaseType bt) {
        this._myParent = bt;
    }

    public BaseType getParent() {
        return this._myParent;
    }

    public String getLongName() {
        boolean done = false;
        BaseType parent = this._myParent;
        String longName = this._name;
        while (parent != null) {
            longName = parent.getName() + "." + longName;
            parent = parent.getParent();
        }
        return longName;
    }
}

