/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class HeaderInputStream
extends FilterInputStream {
    private byte[] lineBuf;
    private int bytesRemaining = 0;
    private int currentOffset = 0;
    private byte[] endSequence = new byte[]{10, 68, 97, 116, 97, 58, 10};
    private boolean endFound = false;

    public HeaderInputStream(InputStream in) {
        super(in);
        this.lineBuf = new byte[4096];
    }

    public int available() {
        return this.bytesRemaining;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.bytesRemaining == 0 && !this.endFound) {
            this.getMoreBytes();
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        --this.bytesRemaining;
        return this.lineBuf[this.currentOffset++];
    }

    private void getMoreBytes() throws IOException {
        this.currentOffset = 0;
        int bytesRead = 0;
        int lookingFor = 0;
        while (bytesRead < this.lineBuf.length) {
            int c2 = this.in.read();
            if (c2 == -1) break;
            this.lineBuf[bytesRead] = (byte)c2;
            if (this.lineBuf[bytesRead] == this.endSequence[lookingFor]) {
                if (++lookingFor == this.endSequence.length) {
                    this.endFound = true;
                    break;
                }
            } else {
                lookingFor = this.lineBuf[bytesRead] == this.endSequence[0] ? 1 : 0;
            }
            ++bytesRead;
        }
        this.bytesRemaining = bytesRead;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int c2 = this.read();
        if (c2 == -1) {
            return -1;
        }
        b2[off] = (byte)c2;
        int i = 1;
        try {
            while (i < len) {
                c2 = this.read();
                if (c2 != -1) {
                    b2[off + i] = (byte)c2;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {}
        return i;
    }

    public long skip(long n) {
        if ((long)this.bytesRemaining >= n) {
            this.bytesRemaining = (int)((long)this.bytesRemaining - n);
            return n;
        }
        int oldBytesRemaining = this.bytesRemaining;
        this.bytesRemaining = 0;
        return oldBytesRemaining;
    }
}

