/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DGrid;
import dods.dap.NoSuchVariableException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.InvalidParameterException;
import dods.dap.Server.RegExpException;
import dods.dap.Server.RelOps;
import dods.dap.Server.SBHException;
import dods.dap.Server.SDArray;
import dods.dap.Server.SDODSException;
import dods.dap.Server.ServerArrayMethods;
import dods.dap.Server.ServerMethods;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SDGrid
extends DGrid
implements ServerArrayMethods,
RelOps {
    private boolean Project = false;
    private boolean Synthesized = false;
    private boolean ReadMe = false;
    Vector AP;

    public SDGrid() {
    }

    public SDGrid(String n) {
        super(n);
    }

    public boolean projectionYieldsGrid() {
        boolean valid = true;
        if (!((SDArray)this.arrayVar).isProject()) {
            return false;
        }
        Enumeration aDims = this.arrayVar.getDimensions();
        Enumeration e2 = this.mapVars.elements();
        while (valid && e2.hasMoreElements() && aDims.hasMoreElements()) {
            DArrayDimension thisDim = (DArrayDimension)aDims.nextElement();
            SDArray mapArray = (SDArray)e2.nextElement();
            DArrayDimension thisMap = mapArray.getFirstDimension();
            if (thisDim.getSize() > 0) {
                if (mapArray.isProject()) {
                    valid = thisMap.getStart() == thisDim.getStart() && thisMap.getStop() == thisDim.getStop() && thisMap.getStride() == thisDim.getStride();
                    continue;
                }
                valid = false;
                continue;
            }
            boolean bl = valid = !mapArray.isProject();
        }
        if (e2.hasMoreElements() != aDims.hasMoreElements()) {
            valid = false;
        }
        return valid;
    }

    public int projectedComponents(boolean constrained) {
        int comp;
        if (constrained) {
            comp = ((SDArray)this.arrayVar).isProject() ? 1 : 0;
            Enumeration e2 = this.mapVars.elements();
            while (e2.hasMoreElements()) {
                if (!((SDArray)e2.nextElement()).isProject()) continue;
                ++comp;
            }
        } else {
            comp = 1 + this.mapVars.size();
        }
        return comp;
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        boolean isSingle = false;
        boolean isStructure = false;
        boolean isGrid = false;
        boolean psemi = true;
        if (constrained && this.projectedComponents(true) == 0) {
            return;
        }
        if (constrained && this.projectedComponents(true) == 1) {
            isSingle = true;
            psemi = print_semi;
        } else if (constrained && !this.projectionYieldsGrid()) {
            isStructure = true;
        } else {
            isGrid = true;
        }
        if (isGrid) {
            os.println(space + this.getTypeName() + " {");
        }
        if (isGrid) {
            os.println(space + " ARRAY:");
        }
        if (isStructure) {
            os.println(space + "Structure {");
        }
        ((SDArray)this.arrayVar).printDecl(os, space + (isSingle ? "" : "    "), psemi, constrained);
        if (isGrid) {
            os.println(space + " MAPS:");
        }
        Enumeration e2 = this.mapVars.elements();
        while (e2.hasMoreElements()) {
            SDArray sda = (SDArray)e2.nextElement();
            sda.printDecl(os, space + (isSingle ? "" : "    "), psemi, constrained);
        }
        if (isStructure || isGrid) {
            os.print(space + "} " + this.getName());
            if (print_semi) {
                os.println(";");
            }
        }
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.isProject()) {
            return;
        }
        if (print_decl_p) {
            this.printDecl(os, space, false, true);
            os.print(" = ");
        }
        boolean isStillGrid = this.projectionYieldsGrid();
        os.print("{ ");
        if (isStillGrid) {
            os.print("ARRAY: ");
        }
        if (((SDArray)this.arrayVar).isProject()) {
            this.arrayVar.printVal(os, "", false);
        }
        if (isStillGrid) {
            os.print(" MAPS: ");
        }
        boolean firstPass = true;
        Enumeration e2 = this.mapVars.elements();
        while (e2.hasMoreElements()) {
            SDArray sda = (SDArray)e2.nextElement();
            if (!sda.isProject()) continue;
            if (!firstPass) {
                os.print(", ");
            }
            sda.printVal(os, "", false);
            firstPass = false;
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public void addVariable(BaseType v, int part) {
        super.addVariable(v, part);
    }

    public void setProject(boolean state, boolean all) {
        this.Project = state;
        if (all) {
            ((SDArray)this.arrayVar).setProject(state);
            Enumeration e2 = this.mapVars.elements();
            while (e2.hasMoreElements()) {
                ServerMethods sm = (ServerMethods)e2.nextElement();
                sm.setProject(state);
            }
        }
    }

    public void setProject(boolean state) {
        this.setProject(state, true);
    }

    public boolean isProject() {
        return this.Project;
    }

    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDGrid!");
    }

    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDGrid!");
    }

    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDGrid!");
    }

    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDGrid!");
    }

    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDGrid!");
    }

    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDGrid!");
    }

    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDGrid!");
    }

    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    public boolean isSynthesized() {
        return this.Synthesized;
    }

    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    public boolean isRead() {
        return this.ReadMe;
    }

    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, SDODSException, IOException {
        if (!this.isRead()) {
            this.read(dataset, specialO);
        }
        if (ce.evalClauses(specialO)) {
            if (((ServerMethods)((Object)this.arrayVar)).isProject()) {
                ((ServerMethods)((Object)this.arrayVar)).serialize(dataset, sink, ce, specialO);
            }
            Enumeration e2 = this.mapVars.elements();
            while (e2.hasMoreElements()) {
                ServerMethods sm = (ServerMethods)e2.nextElement();
                if (!sm.isProject()) continue;
                sm.serialize(dataset, sink, ce, specialO);
            }
        }
    }

    public void setProjection(int dimension, int start, int stride, int stop) throws InvalidParameterException, SBHException {
        try {
            DArray a2 = (DArray)this.getVar(0);
            DArrayDimension d2 = a2.getDimension(dimension);
            d2.setProjection(start, stride, stop);
            DArray map = (DArray)this.getVar(dimension + 1);
            DArrayDimension mapD = map.getDimension(0);
            mapD.setProjection(start, stride, stop);
        }
        catch (NoSuchVariableException e2) {
            throw new InvalidParameterException("SDGrid.setProjection(): Bad Value for dimension!: " + e2.getMessage());
        }
    }

    public int getStart(int dimension) throws InvalidParameterException {
        try {
            DArray a2 = (DArray)this.getVar(0);
            DArrayDimension d2 = a2.getDimension(dimension);
            return d2.getStart();
        }
        catch (NoSuchVariableException e2) {
            throw new InvalidParameterException("SDGrid.getStart(): Bad Value for dimension!: " + e2.getMessage());
        }
    }

    public int getStride(int dimension) throws InvalidParameterException {
        try {
            DArray a2 = (DArray)this.getVar(0);
            DArrayDimension d2 = a2.getDimension(dimension);
            return d2.getStride();
        }
        catch (NoSuchVariableException e2) {
            throw new InvalidParameterException("SDGrid.getStride(): Bad Value for dimension!: " + e2.getMessage());
        }
    }

    public int getStop(int dimension) throws InvalidParameterException {
        try {
            DArray a2 = (DArray)this.getVar(0);
            DArrayDimension d2 = a2.getDimension(dimension);
            return d2.getStop();
        }
        catch (NoSuchVariableException e2) {
            throw new InvalidParameterException("SDGrid.getStop(): Bad Value for dimension!: " + e2.getMessage());
        }
    }
}

