/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.McIDASException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;

public class EnhancementTable {
    private int[][] rgbValues = null;
    private DataInputStream dataStream;

    public EnhancementTable() {
        this.rgbValues = new int[3][256];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 256) {
                this.rgbValues[i][j] = j;
                ++j;
            }
            ++i;
        }
    }

    public EnhancementTable(String source) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
        }
        catch (Exception e2) {
            try {
                this.dataStream = new DataInputStream(new BufferedInputStream(new URL(source).openStream()));
            }
            catch (Exception e22) {
                throw new McIDASException("Unable to open enhancement table " + source);
            }
        }
        this.readRGBValues();
    }

    public EnhancementTable(File file) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (Exception e2) {
            throw new McIDASException("Unable to open enhancement table " + file);
        }
        this.readRGBValues();
    }

    public EnhancementTable(URL url) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (Exception e2) {
            throw new McIDASException("Unable to open enhancement table at URL" + url);
        }
        this.readRGBValues();
    }

    private void readRGBValues() throws McIDASException {
        this.rgbValues = new int[3][256];
        try {
            int reservedWord = this.dataStream.readInt();
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 256) {
                    this.rgbValues[i][j] = this.dataStream.readInt();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e2) {
            throw new McIDASException("Invalid enhancement table");
        }
    }

    public int[][] getRGBValues() {
        return this.rgbValues;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Brightness  Red       Green      Blue ");
        sb.append("\n");
        sb.append("  min max   min max   min max   min max");
        sb.append("\n");
        sb.append("  --- ---   --- ---   --- ---   --- ---");
        sb.append("\n");
        int i = 0;
        while (i < 256) {
            sb.append(" " + i + "  " + this.rgbValues[0][i] + " " + this.rgbValues[1][i] + " " + this.rgbValues[2][i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            EnhancementTable et = args.length == 0 ? new EnhancementTable() : new EnhancementTable(args[0]);
            System.out.println(et.toString());
        }
        catch (McIDASException e2) {
            System.out.println(e2.toString());
        }
    }
}

