/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class AddePointDataReader {
    public static final int PARAM_ORDER = 0;
    public static final int OB_ORDER = 1;
    private int status = 0;
    private String[] params;
    private int[] ScalingFactors;
    private String[] units;
    private int[][] iData = null;
    private int[][] oData = null;
    private Vector data = null;
    private int numParams = 0;
    private boolean debug = false;

    public AddePointDataReader(String request) throws AddeException {
        int i;
        DataInputStream dataInputStream;
        URLConnection urlc;
        try {
            URL url = new URL(request);
            urlc = url.openConnection();
            dataInputStream = new DataInputStream(new BufferedInputStream(urlc.getInputStream()));
        }
        catch (AddeURLException ae) {
            throw new AddeException("No datasets found " + ae);
        }
        catch (Exception e2) {
            throw new AddeException("Error opening connection: " + e2);
        }
        int numParamBytes = ((AddeURLConnection)urlc).getInitialRecordSize();
        if (this.debug) {
            System.out.println("numParamBytes = " + numParamBytes);
        }
        if (numParamBytes == 0) {
            this.status = -1;
            throw new AddeException("No data found");
        }
        byte[] bParamNames = new byte[numParamBytes];
        this.numParams = numParamBytes / 4;
        this.params = new String[this.numParams];
        try {
            dataInputStream.readFully(bParamNames, 0, numParamBytes);
            String sParamNames = new String(bParamNames);
            if (this.debug) {
                System.out.println(" sParamNames = " + sParamNames);
            }
            int i2 = 0;
            while (i2 < this.numParams) {
                this.params[i2] = sParamNames.substring(i2 * 4, (i2 + 1) * 4).trim();
                ++i2;
            }
        }
        catch (IOException e3) {
            this.status = -1;
            throw new AddeException("Error reading parameters:" + e3);
        }
        try {
            int numUnitBytes = dataInputStream.readInt();
            this.units = new String[numUnitBytes / 4];
            if (this.debug) {
                System.out.println("numUnitBytes = " + numUnitBytes);
            }
            byte[] bUnitNames = new byte[numUnitBytes];
            dataInputStream.readFully(bUnitNames, 0, numUnitBytes);
            String sUnitNames = new String(bUnitNames);
            if (this.debug) {
                System.out.println("sUnitNames = " + sUnitNames);
            }
            i = 0;
            while (i < numUnitBytes / 4) {
                this.units[i] = sUnitNames.substring(i * 4, (i + 1) * 4).trim();
                ++i;
            }
        }
        catch (IOException e4) {
            this.status = -1;
            throw new AddeException("Error reading units:" + e4);
        }
        try {
            int numScalingBytes = dataInputStream.readInt();
            if (this.debug) {
                System.out.println("numScalingBytes = " + numScalingBytes);
            }
            this.ScalingFactors = new int[numScalingBytes / 4];
            int i3 = 0;
            while (i3 < numScalingBytes / 4) {
                this.ScalingFactors[i3] = dataInputStream.readInt();
                ++i3;
            }
        }
        catch (IOException e5) {
            this.status = -1;
            throw new AddeException("Error reading scaling factors:" + e5);
        }
        this.data = new Vector();
        byte[] bThisUnitName = new byte[4];
        try {
            int numDataBytes = dataInputStream.readInt();
            while (numDataBytes != 0) {
                if (this.debug) {
                    System.out.println(" i, Param, Unit, Value ");
                }
                int[] dataArray = new int[this.numParams];
                i = 0;
                while (i < numDataBytes / 4) {
                    dataArray[i] = dataInputStream.readInt();
                    ++i;
                }
                this.data.addElement(dataArray);
                numDataBytes = dataInputStream.readInt();
                if (!this.debug) continue;
                System.out.println("numDataBytes = " + numDataBytes);
            }
        }
        catch (IOException e6) {
            this.status = -1;
            throw new AddeException("Error reading data:" + e6);
        }
    }

    public int[][] getData() throws AddeException {
        return this.getData(0);
    }

    public int[][] getData(int order) throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return order == 0 ? this.getParamOrderData() : this.getObOrderData();
    }

    public String[] getParams() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.params;
    }

    public String[] getUnits() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.units;
    }

    public int[] getScales() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.ScalingFactors;
    }

    public int getNumParams() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.numParams;
    }

    public Object[] getData(String parameter) throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        int i = 0;
        while (i < this.numParams) {
            if (parameter.equalsIgnoreCase(this.params[i])) {
                this.iData = this.getParamOrderData();
                if (this.units[i].equalsIgnoreCase("CHAR")) {
                    Object[] vals = new String[this.iData[i].length];
                    int j = 0;
                    while (j < this.iData[i].length) {
                        vals[j] = McIDASUtil.intBitsToString(this.iData[i][j]);
                        ++j;
                    }
                    return vals;
                }
                if (this.ScalingFactors[i] != 0) {
                    double[][] vals = new double[1][this.iData[i].length];
                    int j = 0;
                    while (j < this.iData[i].length) {
                        vals[0][j] = (double)this.iData[i][j] / Math.pow(10.0, this.ScalingFactors[i]);
                        ++j;
                    }
                    return vals;
                }
                float[][] vals = new float[1][this.iData[i].length];
                int j = 0;
                while (j < this.iData[i].length) {
                    vals[0][j] = this.iData[i][j];
                    ++j;
                }
                return vals;
            }
            ++i;
        }
        return null;
    }

    private int[][] getParamOrderData() {
        if (this.iData == null) {
            this.iData = new int[this.numParams][this.data.size()];
            if (this.debug) {
                System.out.println("number of data records = " + this.data.size());
            }
            int i = 0;
            while (i < this.data.size()) {
                int[] values = (int[])this.data.get(i);
                int j = 0;
                while (j < this.numParams) {
                    this.iData[j][i] = values[j];
                    ++j;
                }
                ++i;
            }
        }
        return this.iData;
    }

    private int[][] getObOrderData() {
        if (this.oData == null) {
            this.oData = new int[this.data.size()][this.numParams];
            if (this.debug) {
                System.out.println("number of data records = " + this.data.size());
            }
            int i = 0;
            while (i < this.data.size()) {
                this.oData[i] = (int[])this.data.get(i);
                ++i;
            }
        }
        return this.oData;
    }

    public String toString() {
        if (this.status < 0) {
            return new String("No data Available");
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.numParams) {
            buf.append(this.params[i]);
            buf.append("[");
            buf.append(this.units[i]);
            buf.append("] ");
            buf.append("\t");
            ++i;
        }
        buf.append("\n");
        this.iData = this.getParamOrderData();
        int i2 = 0;
        while (i2 < this.iData[0].length) {
            int j = 0;
            while (j < this.numParams) {
                if (this.units[j].equalsIgnoreCase("CHAR")) {
                    buf.append(McIDASUtil.intBitsToString(this.iData[j][i2]));
                } else if (this.ScalingFactors[j] != 0) {
                    buf.append(this.iData[j][i2] == -2139062144 ? "     " : Double.toString((double)this.iData[j][i2] / Math.pow(10.0, this.ScalingFactors[j])));
                } else {
                    buf.append(this.iData[j][i2] == -2139062144 ? "     " : Integer.toString(this.iData[j][i2]));
                }
                buf.append("\t");
                ++j;
            }
            buf.append("\n");
            ++i2;
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\nData Requested:");
        String request = args.length == 0 ? "adde://adde.ucar.edu/point?group=rtptsrc&descr=sfchourly&num=2&select='id ypph'&parm=id dir spd t[c] td[c] psl&pos=0&version=1&trace=1" : args[0];
        AddePointDataReader ptlist = new AddePointDataReader(request);
        System.out.println(ptlist.toString());
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e2) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

