/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.io.FilterInputStream;
import java.io.InputStream;

public class REFilterInputStream
extends FilterInputStream {
    private RE m_expr;
    private String m_replace;
    private String m_buffer;
    private int m_bufpos;
    private int m_offset;
    private CharIndexedInputStream m_stream;

    public REFilterInputStream(InputStream f_stream, RE f_expr, String f_replace) {
        super(f_stream);
        this.m_stream = new CharIndexedInputStream(f_stream, 0);
        this.m_expr = f_expr;
        this.m_replace = f_replace;
    }

    public int read() {
        if (this.m_buffer != null && this.m_bufpos < this.m_buffer.length()) {
            return this.m_buffer.charAt(this.m_bufpos++);
        }
        if (!this.m_stream.isValid()) {
            return -1;
        }
        REMatch mymatch = new REMatch(this.m_expr.getNumSubs(), this.m_offset);
        int[] result = this.m_expr.match(this.m_stream, 0, 0, mymatch);
        if (result != null) {
            mymatch.end[0] = result[0];
            mymatch.finish(this.m_stream);
            this.m_stream.move(mymatch.toString().length());
            this.m_offset += mymatch.toString().length();
            this.m_buffer = mymatch.substituteInto(this.m_replace);
            this.m_bufpos = 1;
            return this.m_buffer.charAt(0);
        }
        char ch = this.m_stream.charAt(0);
        if (ch == '\uffff') {
            return -1;
        }
        this.m_stream.move(1);
        ++this.m_offset;
        return ch;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b2, int off, int len) {
        int ok = 0;
        while (len-- > 0) {
            int i = this.read();
            if (i == -1) {
                return ok == 0 ? -1 : ok;
            }
            b2[off++] = (byte)i;
            ++ok;
        }
        return ok;
    }

    public int read(byte[] b2) {
        return this.read(b2, 0, b2.length);
    }
}

