/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.MessageDialog;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProgressBar;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class IJ {
    public static boolean debugMode;
    public static boolean hideProcessStackDialog;
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static String osname;
    private static boolean isMac;
    private static boolean isWin;
    private static boolean isJava2;
    private static boolean altDown;
    private static boolean spaceDown;
    private static boolean macroRunning;
    private static Thread previousThread;
    private static TextPanel logPanel;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat df;
    private static int dfDigits;

    static void init(ImageJ imagej, Applet theApplet) {
        ij = imagej;
        applet = theApplet;
        progressBar = ij.getProgressBar();
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static Object runPlugIn(String className, String arg) {
        return IJ.runPlugIn("", className, arg);
    }

    static Object runPlugIn(String commandName, String className, String arg) {
        Object thePlugIn;
        block8: {
            if (debugMode) {
                IJ.log("runPlugin: " + className + " " + arg);
            }
            if (!className.startsWith("ij") && applet == null) {
                boolean createNewClassLoader = IJ.altKeyDown();
                return ij.runUserPlugIn(commandName, className, arg, createNewClassLoader);
            }
            thePlugIn = null;
            try {
                Class<?> c2 = Class.forName(className);
                thePlugIn = c2.newInstance();
                if (thePlugIn instanceof PlugIn) {
                    ((PlugIn)thePlugIn).run(arg);
                    break block8;
                }
                ij.runFilterPlugIn(thePlugIn, commandName, arg);
            }
            catch (ClassNotFoundException e2) {
                if (IJ.getApplet() == null) {
                    IJ.log("Plugin not found: " + className);
                }
            }
            catch (InstantiationException e3) {
                IJ.log("Unable to load plugin (ins)");
            }
            catch (IllegalAccessException e4) {
                IJ.log("Unable to load plugin (acc)");
            }
        }
        return thePlugIn;
    }

    public static void doCommand(String command) {
        if (ij != null) {
            ij.doCommand(command);
        }
    }

    public static void run(String command) {
        Macro.abort = false;
        Macro.setOptions(null);
        macroRunning = true;
        Executer e2 = new Executer(command);
        e2.run();
        macroRunning = false;
        IJ.testAbort();
    }

    public static void run(String command, String options) {
        String name;
        Macro.abort = false;
        Macro.setOptions(options);
        Thread thread = Thread.currentThread();
        if ((previousThread == null || thread != previousThread) && (name = thread.getName()).indexOf("-macro") < 0) {
            thread.setName(name + "-macro");
        }
        previousThread = thread;
        macroRunning = true;
        Executer e2 = new Executer(command);
        e2.run();
        macroRunning = false;
        Macro.setOptions(null);
        IJ.testAbort();
    }

    private static void testAbort() {
        if (Macro.abort) {
            throw new RuntimeException("Macro canceled");
        }
    }

    public static boolean macroRunning() {
        return macroRunning;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String s) {
        if (ij != null) {
            ij.showStatus(s);
        }
    }

    public static void write(String s) {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        if (textPanel != null) {
            textPanel.append(s);
        } else {
            System.out.println(s);
        }
    }

    public static void log(String s) {
        if (logPanel == null && ij != null) {
            TextWindow logWindow = new TextWindow("Log", "", 300, 200);
            logPanel = logWindow.getTextPanel();
        }
        if (logPanel != null) {
            if (s.equals("$Closed")) {
                logPanel = null;
            } else {
                logPanel.append(s);
            }
        } else {
            System.out.println(s);
        }
    }

    public static void setColumnHeadings(String headings) {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        if (textPanel != null) {
            textPanel.setColumnHeadings(headings);
        }
    }

    public static boolean isResultsWindow() {
        return textPanel != null;
    }

    public static TextPanel getTextPanel() {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        return textPanel;
    }

    public static void setTextPanel(TextPanel tp) {
        textPanel = tp;
    }

    public static void noImage() {
        IJ.showMessage("No Image", "There are no images open.");
        Macro.abort();
    }

    public static void outOfMemory(String name) {
        IJ.write("<<" + name + ": out of memory>>");
        Macro.abort();
    }

    public static void showProgress(double progress) {
        if (progressBar != null) {
            progressBar.show(progress);
        }
    }

    public static void showMessage(String title, String msg) {
        if (ij != null) {
            new MessageDialog((Frame)ij, title, msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void showMessage(String msg) {
        IJ.showMessage("Message", msg);
    }

    public static void error(String msg) {
        if (ij != null) {
            new MessageDialog((Frame)ij, "ImageJ", msg);
        } else {
            System.out.println(msg);
        }
        Macro.abort();
    }

    public static boolean showMessageWithCancel(String title, String msg) {
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public static double getNumber(String prompt, double defaultNumber) {
        Frame win = WindowManager.getCurrentWindow();
        if (win == null) {
            win = ij;
        }
        GenericDialog gd = new GenericDialog("Enter a Number", win);
        gd.addNumericField(prompt, defaultNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -2.147483648E9;
        }
        return gd.getNextNumber();
    }

    public static String getString(String prompt, String defaultString) {
        Frame win = WindowManager.getCurrentWindow();
        if (win == null) {
            win = ij;
        }
        GenericDialog gd = new GenericDialog("Enter a String", win);
        gd.addStringField(prompt, defaultString, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return "";
        }
        return gd.getNextString();
    }

    public static synchronized void wait(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException e2) {}
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        System.gc();
        long freeMem = Runtime.getRuntime().freeMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        return "Memory: " + (totMem - freeMem) / 1024L + "K";
    }

    public static void showTime(ImagePlus imp, long start, String str) {
        IJ.showTime(imp, start, str, 1);
    }

    static void showTime(ImagePlus imp, long start, String str, int nslices) {
        long elapsedTime = System.currentTimeMillis() - start;
        double seconds = (double)elapsedTime / 1000.0;
        long pixels = imp.getWidth() * imp.getHeight();
        int rate = (int)((double)pixels * (double)nslices / seconds);
        String str2 = rate > 1000000000 ? "" : (rate < 1000000 ? ", " + rate + " pixels/second" : ", " + IJ.d2s((double)rate / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(str + seconds + " seconds" + str2);
    }

    public static String d2s(double n) {
        return IJ.d2s(n, 2);
    }

    public static String d2s(double n, int precision) {
        boolean negative;
        if (n == 3.4028234663852886E38) {
            return "3.4e38";
        }
        boolean bl = negative = n < 0.0;
        if (negative) {
            n = -n;
        }
        double whole = Math.round(n * Math.pow(10.0, precision));
        double rounded = whole / Math.pow(10.0, precision);
        if (negative) {
            rounded = -rounded;
        }
        if (precision != dfDigits) {
            switch (precision) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                }
            }
        }
        String s = df.format(rounded);
        return s;
    }

    public static void register(Class c2) {
        if (ij != null) {
            ij.register(c2);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    public static void setKeyDown(int key) {
        switch (key) {
            case 18: {
                altDown = true;
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow win = WindowManager.getCurrentWindow();
                if (win == null) break;
                win.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    public static void setKeyUp(int key) {
        switch (key) {
            case 18: {
                altDown = false;
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow win = WindowManager.getCurrentWindow();
                if (win == null) break;
                win.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return IJ.isMacintosh() && IJ.isJava2();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isJava2() {
        return isJava2;
    }

    public static boolean versionLessThan(String version) {
        boolean lessThan;
        boolean bl = lessThan = "1.28u".compareTo(version) < 0;
        if (lessThan) {
            IJ.error("This plugin requires ImageJ " + version + " or later.");
        }
        return lessThan;
    }

    public static int setupDialog(ImagePlus imp, int flags) {
        if (imp == null || IJ.ij.hotkey || hideProcessStackDialog) {
            return flags;
        }
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                if (macroOptions.indexOf("stack ") >= 0) {
                    return flags + 32;
                }
                return flags;
            }
            YesNoCancelDialog d2 = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + stackSize + " slices?  There is\n" + "no Undo if you select \"Yes\".");
            if (d2.cancelPressed()) {
                return 4096;
            }
            if (d2.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return flags + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return flags;
    }

    public static void makeRectangle(int x, int y, int width, int height) {
        IJ.getImage().setRoi(x, y, width, height);
    }

    public static void makeOval(int x, int y, int width, int height) {
        IJ.getImage().setRoi(new OvalRoi(x, y, width, height));
    }

    public static void makeLine(int x1, int y1, int x2, int y2) {
        IJ.getImage().setRoi(new Line(x1, y1, x2, y2));
    }

    public static void setMinAndMax(double min, double max) {
        ImagePlus img = IJ.getImage();
        img.getProcessor().setMinAndMax(min, max);
        img.updateAndDraw();
    }

    public static void resetMinAndMax() {
        ImagePlus img = IJ.getImage();
        img.getProcessor().resetMinAndMax();
        img.updateAndDraw();
    }

    public static void setThreshold(double lowerThreshold, double upperThresold) {
        ImagePlus img = IJ.getImage();
        img.getProcessor().setThreshold(lowerThreshold, upperThresold, 0);
        img.updateAndDraw();
    }

    public static void resetThreshold() {
        ImagePlus img = IJ.getImage();
        img.getProcessor().resetThreshold();
        img.updateAndDraw();
    }

    public static void selectWindow(String title) {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            return;
        }
        String[] titles = new String[wList.length];
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp != null && imp.getTitle().equals(title)) {
                ImageWindow win = imp.getWindow();
                if (win != null) {
                    win.toFront();
                    IJ.wait(50);
                    WindowManager.setCurrentWindow(win);
                }
                return;
            }
            ++i;
        }
    }

    public static void setForegroundColor(int red, int green, int blue) {
        Toolbar.setForegroundColor(new Color(red, green, blue));
    }

    public static void setBackgroundColor(int red, int green, int blue) {
        Toolbar.setBackgroundColor(new Color(red, green, blue));
    }

    public static void setTool(int id) {
        Toolbar.getInstance().setTool(id);
    }

    public static int doWand(int x, int y) {
        ImagePlus img = IJ.getImage();
        ImageProcessor ip = img.getProcessor();
        Wand w = new Wand(ip);
        double t1 = ip.getMinThreshold();
        if (t1 == -808080.0) {
            w.autoOutline(x, y);
        } else {
            w.autoOutline(x, y, (int)t1, (int)ip.getMaxThreshold());
        }
        if (w.npoints > 0) {
            PolygonRoi roi = new PolygonRoi(w.xpoints, w.ypoints, w.npoints, 4);
            img.setRoi(roi);
        }
        return w.npoints;
    }

    private static ImagePlus getImage() {
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            IJ.noImage();
            throw new RuntimeException("Macro canceled");
        }
        return img;
    }

    static {
        osname = System.getProperty("os.name");
        isWin = osname.startsWith("Windows");
        isMac = !isWin && osname.startsWith("Mac");
        isJava2 = !System.getProperty("java.version").startsWith("1.1");
        df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        dfDigits = 2;
    }
}

