/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.io.Opener;
import java.util.Locale;

public class Macro {
    private static String currentOptions;
    static boolean abort;

    public static boolean open(String path) {
        if (path == null || path.equals("")) {
            Opener o = new Opener();
            return true;
        }
        Opener o = new Opener();
        ImagePlus img = o.openImage(path);
        if (img == null) {
            return false;
        }
        img.show();
        return true;
    }

    public static boolean saveAs(String path) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return false;
        }
        FileSaver fs = new FileSaver(imp);
        if (path == null || path.equals("")) {
            return fs.saveAsTiff();
        }
        if (imp.getStackSize() > 1) {
            return fs.saveAsTiffStack(path);
        }
        return fs.saveAsTiff(path);
    }

    public static String getName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(i + 1);
        }
        return path;
    }

    public static String getDir(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(0, i + 1);
        }
        return "";
    }

    public static void abort() {
        abort = true;
    }

    public static String getOptions() {
        if (currentOptions != null && Thread.currentThread().getName().indexOf("-macro") > -1) {
            return currentOptions + " ";
        }
        return null;
    }

    public static void setOptions(String options) {
        currentOptions = options;
    }

    public static String getValue(String options, String key, String defaultValue) {
        int index = options.indexOf(key = Macro.trimKey(key));
        if (index < 0) {
            return defaultValue;
        }
        if ((options = options.substring(index + key.length() + 1, options.length())).startsWith("'")) {
            index = options.indexOf("'", 1);
            if (index < 0) {
                return defaultValue;
            }
            return options.substring(1, index);
        }
        index = options.indexOf(" ");
        if (index < 0) {
            return defaultValue;
        }
        return options.substring(0, index);
    }

    public static String trimKey(String key) {
        int index = key.indexOf(" ");
        if (index > -1) {
            key = key.substring(0, index);
        }
        if ((index = key.indexOf(":")) > -1) {
            key = key.substring(0, index);
        }
        key = key.toLowerCase(Locale.US);
        return key;
    }
}

