/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import java.util.Vector;

public class GenericDialog
extends Dialog
implements ActionListener,
TextListener,
FocusListener,
ItemListener,
KeyListener {
    protected Vector defaultValues;
    protected Vector defaultText;
    protected Vector numberField;
    protected Vector stringField;
    protected Vector checkbox;
    protected Vector choice;
    protected Component theLabel;
    protected TextArea textArea1;
    protected TextArea textArea2;
    private Button cancel;
    private Button okay;
    private boolean wasCanceled;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean firstNumericField = true;
    private boolean invalidNumber;
    private boolean firstPaint = true;
    private Hashtable labels;
    private boolean macro;
    private String macroOptions;

    public GenericDialog(String title) {
        this(title, WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : IJ.getInstance());
    }

    public GenericDialog(String title, Frame parent) {
        super(parent, title, true);
        this.setLayout(this.grid);
        this.macroOptions = Macro.getOptions();
        this.macro = this.macroOptions != null;
        this.addKeyListener(this);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        Label theLabel = this.makeLabel(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? new Insets(5, 0, 3, 0) : new Insets(0, 0, 3, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        TextField tf = new TextField(IJ.d2s(defaultValue, digits), 6);
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.defaultValues.addElement(new Double(defaultValue));
        this.defaultText.addElement(tf.getText());
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(tf, this.c);
        tf.setEditable(true);
        if (this.firstNumericField) {
            tf.selectAll();
        }
        this.firstNumericField = false;
        this.add(tf);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
        ++this.y;
    }

    private Label makeLabel(String label) {
        if (IJ.isMacintosh()) {
            label = label + " ";
        }
        return new Label(label);
    }

    private void saveLabel(Component component, String label) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        this.labels.put(component, label);
    }

    public void addStringField(String label, String defaultText) {
        this.addStringField(label, defaultText, 8);
    }

    public void addStringField(String label, String defaultText, int columns) {
        Label theLabel = this.makeLabel(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.stringField == null) {
            this.stringField = new Vector(4);
            this.c.insets = new Insets(5, 0, 5, 0);
        } else {
            this.c.insets = new Insets(0, 0, 5, 0);
        }
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        TextField tf = new TextField(defaultText, columns);
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(tf, this.c);
        tf.setEditable(true);
        this.add(tf);
        this.stringField.addElement(tf);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
        ++this.y;
    }

    public void addCheckbox(String label, boolean defaultValue) {
        if (this.checkbox == null) {
            this.checkbox = new Vector(4);
            this.c.insets = new Insets(15, 20, 0, 0);
        } else {
            this.c.insets = new Insets(0, 20, 0, 0);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        Checkbox cb = new Checkbox(label);
        this.grid.setConstraints(cb, this.c);
        cb.setState(defaultValue);
        cb.addItemListener(this);
        cb.addKeyListener(this);
        this.add(cb);
        this.checkbox.addElement(cb);
        if (Recorder.record || this.macro) {
            this.saveLabel(cb, label);
        }
        ++this.y;
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(rows, columns, 10, 0));
        int startCBIndex = this.cbIndex;
        int i1 = 0;
        int[] index = new int[labels.length];
        if (this.checkbox == null) {
            this.checkbox = new Vector(12);
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < columns) {
                int i2 = col * rows + row;
                if (i2 >= labels.length) break;
                index[i1] = i2;
                Checkbox cb = new Checkbox(labels[i1]);
                this.checkbox.addElement(cb);
                cb.setState(defaultValues[i1]);
                if (Recorder.record || this.macro) {
                    this.saveLabel(cb, labels[i1]);
                }
                panel.add(cb);
                ++i1;
                ++col;
            }
            ++row;
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        Label theLabel = this.makeLabel(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.choice == null) {
            this.choice = new Vector(4);
            this.c.insets = new Insets(5, 0, 5, 0);
        } else {
            this.c.insets = new Insets(0, 0, 5, 0);
        }
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        Choice thisChoice = new Choice();
        thisChoice.addKeyListener(this);
        thisChoice.addItemListener(this);
        int i = 0;
        while (i < items.length) {
            thisChoice.addItem(items[i]);
            ++i;
        }
        thisChoice.select(defaultItem);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(thisChoice, this.c);
        this.add(thisChoice);
        this.choice.addElement(thisChoice);
        if (Recorder.record || this.macro) {
            this.saveLabel(thisChoice, label);
        }
        ++this.y;
    }

    public void addMessage(String text) {
        this.theLabel = text.indexOf(10) >= 0 ? new MultiLineLabel(text) : new Label(text);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(text.equals("") ? 0 : 10, 20, 0, 0);
        this.grid.setConstraints(this.theLabel, this.c);
        this.add(this.theLabel);
        ++this.y;
    }

    public void addTextAreas(String text1, String text2, int rows, int columns) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(text1, rows, columns, 3);
        panel.add(this.textArea1);
        if (text2 != null) {
            this.textArea2 = new TextArea(text2, rows, columns, 3);
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public boolean wasCanceled() {
        if (this.wasCanceled) {
            Macro.abort();
        }
        return this.wasCanceled;
    }

    public double getNextNumber() {
        double value;
        if (this.numberField == null) {
            return -1.0;
        }
        TextField tf = (TextField)this.numberField.elementAt(this.nfIndex);
        String theText = tf.getText();
        if (this.macro) {
            String label = (String)this.labels.get(tf);
            theText = Macro.getValue(this.macroOptions, label, theText);
        }
        String originalText = (String)this.defaultText.elementAt(this.nfIndex);
        double defaultValue = (Double)this.defaultValues.elementAt(this.nfIndex);
        if (theText.equals(originalText)) {
            value = defaultValue;
        } else {
            Double d2 = this.getValue(theText);
            if (d2 != null) {
                value = d2;
            } else {
                this.invalidNumber = true;
                value = 0.0;
            }
        }
        if (Recorder.record) {
            this.recordOption(tf, this.trim(theText));
        }
        ++this.nfIndex;
        return value;
    }

    private String trim(String value) {
        if (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.endsWith(".00")) {
            value = value.substring(0, value.length() - 3);
        }
        return value;
    }

    private void recordOption(Component component, String value) {
        String label = (String)this.labels.get(component);
        Recorder.recordOption(label, value);
    }

    private void recordCheckboxOption(Checkbox cb) {
        String label = (String)this.labels.get(cb);
        if (cb.getState() && label != null) {
            Recorder.recordOption(label);
        }
    }

    protected Double getValue(String theText) {
        Double d2;
        try {
            d2 = new Double(theText);
        }
        catch (NumberFormatException e2) {
            d2 = null;
        }
        return d2;
    }

    public boolean invalidNumber() {
        boolean wasInvalid = this.invalidNumber;
        this.invalidNumber = false;
        return wasInvalid;
    }

    public String getNextString() {
        if (this.stringField == null) {
            return "";
        }
        TextField tf = (TextField)this.stringField.elementAt(this.sfIndex);
        String theText = tf.getText();
        if (this.macro) {
            String label = (String)this.labels.get(tf);
            theText = Macro.getValue(this.macroOptions, label, theText);
        }
        if (Recorder.record) {
            this.recordOption(tf, theText);
        }
        ++this.sfIndex;
        return theText;
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null) {
            return false;
        }
        Checkbox cb = (Checkbox)this.checkbox.elementAt(this.cbIndex);
        if (Recorder.record) {
            this.recordCheckboxOption(cb);
        }
        boolean state = cb.getState();
        if (this.macro) {
            String label = (String)this.labels.get(cb);
            String key = Macro.trimKey(label);
            state = this.macroOptions.indexOf(key + " ") >= 0;
        }
        ++this.cbIndex;
        return state;
    }

    public String getNextChoice() {
        if (this.choice == null) {
            return "";
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        String item = thisChoice.getSelectedItem();
        if (this.macro) {
            String label = (String)this.labels.get(thisChoice);
            item = Macro.getValue(this.macroOptions, label, item);
        }
        if (Recorder.record) {
            this.recordOption(thisChoice, item);
        }
        ++this.choiceIndex;
        return item;
    }

    public int getNextChoiceIndex() {
        if (this.choice == null) {
            return -1;
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        int index = thisChoice.getSelectedIndex();
        if (this.macro) {
            String label = (String)this.labels.get(thisChoice);
            String oldItem = thisChoice.getSelectedItem();
            int oldIndex = thisChoice.getSelectedIndex();
            String item = Macro.getValue(this.macroOptions, label, oldItem);
            thisChoice.select(item);
            index = thisChoice.getSelectedIndex();
            if (index == oldIndex && !item.equals(oldItem)) {
                IJ.showMessage(this.getTitle(), "\"" + item + "\" is not a vaid choice for \"" + label + "\"");
                Macro.abort();
            }
        }
        if (Recorder.record) {
            this.recordOption(thisChoice, thisChoice.getSelectedItem());
        }
        ++this.choiceIndex;
        return index;
    }

    public String getNextText() {
        String text;
        if (this.textArea1 != null) {
            this.textArea1.selectAll();
            text = this.textArea1.getText();
            this.textArea1 = null;
        } else if (this.textArea2 != null) {
            this.textArea2.selectAll();
            text = this.textArea2.getText();
            this.textArea2 = null;
        } else {
            text = null;
        }
        return text;
    }

    public void showDialog() {
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        if (this.macro) {
            this.dispose();
            return;
        }
        if (this.stringField != null && this.numberField == null) {
            TextField tf = (TextField)this.stringField.elementAt(0);
            tf.selectAll();
        }
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        this.okay = new Button("  OK  ");
        this.okay.addActionListener(this);
        if (IJ.isMacintosh()) {
            buttons.add(this.cancel);
            buttons.add(this.okay);
        } else {
            buttons.add(this.okay);
            buttons.add(this.cancel);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 2;
        this.c.insets = new Insets(15, 0, 0, 0);
        this.grid.setConstraints(buttons, this.c);
        this.add(buttons);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        this.setup();
        GUI.center(this);
        this.show();
        IJ.wait(250);
    }

    protected void setup() {
    }

    public void actionPerformed(ActionEvent e2) {
        this.wasCanceled = e2.getSource() == this.cancel;
        this.setVisible(false);
        this.dispose();
    }

    public void textValueChanged(TextEvent e2) {
    }

    public void itemStateChanged(ItemEvent e2) {
    }

    public void focusGained(FocusEvent e2) {
        Component c2 = e2.getComponent();
        if (c2 instanceof TextField) {
            ((TextField)c2).selectAll();
        }
    }

    public void focusLost(FocusEvent e2) {
        Component c2 = e2.getComponent();
        if (c2 instanceof TextField) {
            ((TextField)c2).select(0, 0);
        }
    }

    public void keyPressed(KeyEvent e2) {
        int keyCode = e2.getKeyCode();
        IJ.setKeyDown(keyCode);
    }

    public void keyReleased(KeyEvent e2) {
        IJ.setKeyUp(e2.getKeyCode());
    }

    public void keyTyped(KeyEvent e2) {
    }

    public Insets getInsets() {
        Insets i = super.getInsets();
        return new Insets(i.top + 10, i.left + 10, i.bottom + 10, i.right + 10);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint && this.numberField != null) {
            TextField tf = (TextField)this.numberField.elementAt(0);
            tf.requestFocus();
            this.firstPaint = false;
        }
    }
}

