/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PolygonRoi
extends Roi {
    protected int maxPoints = 1000;
    protected int[] xp;
    protected int[] yp;
    protected int[] xp2;
    protected int[] yp2;
    protected int nPoints;
    protected Graphics g;
    private int lastX;
    private int lastY;
    private double angle1 = -1.0;
    private double degrees = -1.0;
    long mouseUpTime = 0L;

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, int type) {
        super(0, 0, null);
        if (type == 2) {
            this.type = 2;
        } else if (type == 3) {
            this.type = 3;
        } else if (type == 4) {
            this.type = 4;
        } else if (type == 6) {
            this.type = 6;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
        this.maxPoints = xPoints.length;
        this.xp = xPoints;
        this.yp = yPoints;
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = nPoints;
        this.finishPolygon();
    }

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, ImagePlus imp, int type) {
        this(xPoints, yPoints, nPoints, type);
        this.setImage(imp);
    }

    public PolygonRoi(int ox, int oy, ImagePlus imp) {
        super(ox, oy, imp);
        int tool = Toolbar.getToolId();
        this.type = tool == 2 ? 2 : 6;
        this.xp = new int[this.maxPoints];
        this.yp = new int[this.maxPoints];
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = 1;
        this.xp[0] = ox;
        this.yp[0] = oy;
        this.x = ox;
        this.y = oy;
        this.width = 1;
        this.height = 1;
        this.clipX = ox;
        this.clipY = oy;
        this.clipWidth = 1;
        this.clipHeight = 1;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            this.g = this.ic.getGraphics();
        }
        if (tool == 2 || tool == 5) {
            this.g.setColor(Roi.ROIColor);
            this.lastX = this.x;
            this.lastY = this.y;
            this.drawStartBox();
        }
        this.state = 0;
    }

    private void drawStartBox() {
        this.g.drawRect(this.ic.screenX(this.startX) - 4, this.ic.screenY(this.startY) - 4, 8, 8);
    }

    public void draw(Graphics g) {
        if (this.state != 0) {
            this.updatePolygon();
            g.setColor(Roi.ROIColor);
            if (this.type == 6 || this.type == 7) {
                g.drawPolyline(this.xp2, this.yp2, this.nPoints);
            } else {
                g.drawPolygon(this.xp2, this.yp2, this.nPoints);
            }
            this.showStatus();
            if (this.updateFullWindow) {
                this.updateFullWindow = false;
                this.imp.draw();
            }
        }
    }

    public void drawPixels() {
        ImageProcessor ip = this.imp.getProcessor();
        ip.moveTo(this.x + this.xp[0], this.y + this.yp[0]);
        int i = 1;
        while (i < this.nPoints) {
            ip.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
            ++i;
        }
        if (this.type == 2 || this.type == 3 || this.type == 4) {
            ip.lineTo(this.x + this.xp[0], this.y + this.yp[0]);
        }
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    protected void grow(int x, int y) {
    }

    protected void updatePolygon() {
        Rectangle srcRect = this.ic.getSrcRect();
        if (this.ic.getMagnification() == 1.0 && srcRect.x == 0 && srcRect.y == 0) {
            int i = 0;
            while (i < this.nPoints) {
                this.xp2[i] = this.xp[i] + this.x;
                this.yp2[i] = this.yp[i] + this.y;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nPoints) {
                this.xp2[i] = this.ic.screenX(this.xp[i] + this.x);
                this.yp2[i] = this.ic.screenY(this.yp[i] + this.y);
                ++i;
            }
        }
    }

    void handleMouseMove(int ox, int oy) {
        int tool = Toolbar.getToolId();
        if (tool != 2 && tool != 5) {
            this.imp.killRoi();
            this.imp.draw();
            return;
        }
        this.g.setXORMode(Color.black);
        this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(this.lastX), this.ic.screenY(this.lastY));
        this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(ox), this.ic.screenY(oy));
        this.lastX = ox;
        this.lastY = oy;
        String angle = "";
        if (tool == 5) {
            if (this.nPoints == 1) {
                this.angle1 = this.degrees = this.getAngle(this.xp[0], this.yp[0], ox, oy);
            } else if (this.nPoints == 2) {
                double angle2 = this.getAngle(this.xp[1], this.yp[1], ox, oy);
                this.degrees = Math.abs(180.0 - Math.abs(this.angle1 - angle2));
                if (this.degrees > 180.0) {
                    this.degrees = 360.0 - this.degrees;
                }
            } else {
                this.angle1 = -1.0;
            }
            if (this.angle1 > 0.0) {
                angle = ", angle=" + IJ.d2s(this.degrees);
            }
        }
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + angle);
    }

    void finishPolygon() {
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        if (this.nPoints < 2 || this.type != 7 && (this.nPoints < 3 || this.width == 0 || this.height == 0)) {
            this.imp.killRoi();
            return;
        }
        int i = 0;
        while (i < this.nPoints) {
            this.xp[i] = this.xp[i] - this.x;
            this.yp[i] = this.yp[i] - this.y;
            ++i;
        }
        this.state = 3;
        if (this.imp != null && this.type != 4) {
            this.imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void drawLineSegments() {
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        this.g.setPaintMode();
        this.g.setColor(Roi.ROIColor);
        this.drawStartBox();
        int i = 0;
        while (i < this.nPoints - 1) {
            this.g.drawLine(this.ic.screenX(this.xp[i]), this.ic.screenY(this.yp[i]), this.ic.screenX(this.xp[i + 1]), this.ic.screenY(this.yp[i + 1]));
            ++i;
        }
    }

    protected void handleMouseUp(int sx, int sy) {
        if (this.state != 0) {
            return;
        }
        boolean samePoint = this.xp[this.nPoints - 1] == this.lastX && this.yp[this.nPoints - 1] == this.lastY;
        Rectangle biggerStartBox = new Rectangle(this.ic.screenX(this.startX) - 5, this.ic.screenY(this.startY) - 5, 10, 10);
        if (this.nPoints > 2 && (biggerStartBox.contains(sx, sy) || this.ic.offScreenX(sx) == this.startX && this.ic.offScreenY(sy) == this.startY || samePoint && System.currentTimeMillis() - this.mouseUpTime <= 500L)) {
            this.finishPolygon();
            return;
        }
        if (!samePoint) {
            this.xp[this.nPoints] = this.lastX;
            this.yp[this.nPoints] = this.lastY;
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
            this.drawLineSegments();
            this.mouseUpTime = System.currentTimeMillis();
        }
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        Polygon poly = new Polygon(this.xp2, this.yp2, this.nPoints);
        return poly.contains(this.ic.screenX(x), this.ic.screenY(y));
    }

    public int[] getMask() {
        if (this.type == 6 || this.type == 7 || this.width == 0 || this.height == 0) {
            return null;
        }
        Image img = GUI.createBlankImage(this.width, this.height);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        g.fillPolygon(this.xp, this.yp, this.nPoints);
        ColorProcessor cp = new ColorProcessor(img);
        img.flush();
        img = null;
        g.dispose();
        return (int[])cp.getPixels();
    }

    double getSmoothedLineLength() {
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double x2 = this.xp[0];
        double x3 = this.xp[0];
        double x4 = this.xp[1];
        double y2 = this.yp[0];
        double y3 = this.yp[0];
        double y4 = this.yp[1];
        int i = 0;
        while (i < this.nPoints - 1) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            double y1 = y2;
            y2 = y3;
            y3 = y4;
            if (i + 2 < this.nPoints) {
                x4 = this.xp[i + 2];
                y4 = this.yp[i + 2];
            }
            double dx = (x4 - x1) / 3.0;
            double dy = (y4 - y1) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
            ++i;
        }
        return length;
    }

    double getSmoothedPerimeter() {
        double dy;
        double dx;
        double y1;
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double x2 = this.xp[this.nPoints - 1];
        double x3 = this.xp[0];
        double x4 = this.xp[1];
        double y2 = this.yp[this.nPoints - 1];
        double y3 = this.yp[0];
        double y4 = this.yp[1];
        int i = 0;
        while (i < this.nPoints - 1) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            y1 = y2;
            y2 = y3;
            y3 = y4;
            if (i + 2 < this.nPoints) {
                x4 = this.xp[i + 2];
                y4 = this.yp[i + 2];
            } else {
                x4 = this.xp[0];
                y4 = this.yp[0];
            }
            dx = (x4 - x1) / 3.0;
            dy = (y4 - y1) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
            ++i;
        }
        double x1 = x2;
        x2 = x3;
        x3 = x4;
        x4 = this.xp[1];
        y1 = y2;
        y2 = y3;
        y3 = y4;
        y4 = this.yp[1];
        dx = (x4 - x1) / 3.0;
        dy = (y4 - y1) / 3.0;
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getTracedPerimeter() {
        int sumdx = 0;
        int sumdy = 0;
        int nCorners = 0;
        int dx1 = this.xp[0] - this.xp[this.nPoints - 1];
        int dy1 = this.yp[0] - this.yp[this.nPoints - 1];
        int side1 = Math.abs(dx1) + Math.abs(dy1);
        boolean corner = false;
        int i = 0;
        while (i < this.nPoints) {
            int nexti = i + 1;
            if (nexti == this.nPoints) {
                nexti = 0;
            }
            int dx2 = this.xp[nexti] - this.xp[i];
            int dy2 = this.yp[nexti] - this.yp[i];
            sumdx += Math.abs(dx1);
            sumdy += Math.abs(dy1);
            int side2 = Math.abs(dx2) + Math.abs(dy2);
            if (side1 > 1 || !corner) {
                corner = true;
                ++nCorners;
            } else {
                corner = false;
            }
            dx1 = dx2;
            dy1 = dy2;
            side1 = side2;
            ++i;
        }
        double w = 1.0;
        double h = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w = cal.pixelWidth;
            h = cal.pixelHeight;
        }
        return (double)sumdx * w + (double)sumdy * h - (double)nCorners * (w + h - Math.sqrt(w * w + h * h));
    }

    public double getLength() {
        int dy;
        int dx;
        if (this.type == 4) {
            return this.getTracedPerimeter();
        }
        if (this.nPoints > 2) {
            if (this.type == 3) {
                return this.getSmoothedPerimeter();
            }
            if (this.type == 7 && this.width != 0 && this.height != 0) {
                return this.getSmoothedLineLength();
            }
        }
        double length = 0.0;
        Calibration cal = this.imp.getCalibration();
        double w2 = cal.pixelWidth * cal.pixelWidth;
        double h2 = cal.pixelHeight * cal.pixelHeight;
        int i = 0;
        while (i < this.nPoints - 1) {
            dx = this.xp[i + 1] - this.xp[i];
            dy = this.yp[i + 1] - this.yp[i];
            length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            ++i;
        }
        if (this.type == 2) {
            dx = this.xp[0] - this.xp[this.nPoints - 1];
            dy = this.yp[0] - this.yp[this.nPoints - 1];
            length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
        }
        return length;
    }

    public double getAngle() {
        return this.degrees;
    }

    public int getNCoordinates() {
        return this.nPoints;
    }

    public int[] getXCoordinates() {
        return this.xp;
    }

    public int[] getYCoordinates() {
        return this.yp;
    }

    void enlargeArrays() {
        int[] xptemp = new int[this.maxPoints * 2];
        int[] yptemp = new int[this.maxPoints * 2];
        int[] xp2temp = new int[this.maxPoints * 2];
        int[] yp2temp = new int[this.maxPoints * 2];
        System.arraycopy(this.xp, 0, xptemp, 0, this.maxPoints);
        System.arraycopy(this.yp, 0, yptemp, 0, this.maxPoints);
        System.arraycopy(this.xp2, 0, xp2temp, 0, this.maxPoints);
        System.arraycopy(this.yp2, 0, yp2temp, 0, this.maxPoints);
        this.xp = xptemp;
        this.yp = yptemp;
        this.xp2 = xp2temp;
        this.yp2 = yp2temp;
        if (IJ.debugMode) {
            IJ.log("PolygonRoi: " + this.maxPoints + " points");
        }
        this.maxPoints *= 2;
    }
}

