/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.ProgressBar;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;

    public FileOpener(FileInfo fi) {
        this.fi = fi;
        if (fi != null) {
            this.width = fi.width;
            this.height = fi.height;
        }
        if (IJ.debugMode) {
            IJ.log("FileOpener: " + fi);
        }
    }

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean show) {
        ImagePlus imp = null;
        Object pb = null;
        ColorModel cm = FileOpener.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(cm, show);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 1: 
            case 2: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 3: 
            case 4: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ColorProcessor ip = new ColorProcessor(this.width, this.height, (int[])pixels);
                imp = new ImagePlus(this.fi.fileName, ip);
            }
        }
        imp.setFileInfo(this.fi);
        this.setCalibration(imp);
        if (show) {
            imp.show();
        }
        IJ.showProgress(1.0);
        return imp;
    }

    ImagePlus openStack(ColorModel cm, boolean show) {
        ImageStack stack = new ImageStack(this.fi.width, this.fi.height, cm);
        int skip = this.fi.offset;
        try {
            ImageReader reader = new ImageReader(this.fi);
            InputStream is = FileOpener.createInputStream(this.fi);
            if (is == null) {
                return null;
            }
            int i = 1;
            while (i <= this.fi.nImages) {
                IJ.showStatus("Reading: " + i + "/" + this.fi.nImages);
                Object pixels = reader.readPixels(is, skip);
                if (pixels == null) break;
                stack.addSlice(null, pixels);
                skip = this.fi.gapBetweenImages;
                IJ.showProgress((double)i / (double)this.fi.nImages);
                ++i;
            }
            is.close();
        }
        catch (Exception e2) {
            IJ.write("" + e2);
        }
        catch (OutOfMemoryError e3) {
            IJ.outOfMemory(this.fi.fileName);
            stack.trim();
        }
        IJ.showProgress(1.0);
        if (stack.getSize() == 0) {
            return null;
        }
        ImagePlus imp = new ImagePlus(this.fi.fileName, stack);
        if (show) {
            imp.show();
        }
        imp.setFileInfo(this.fi);
        this.setCalibration(imp);
        IJ.showProgress(1.0);
        return imp;
    }

    public void revertToSaved(ImagePlus imp) {
        ProgressBar pb = IJ.getInstance().getProgressBar();
        if (this.fi.fileFormat == 3) {
            Image img = Toolkit.getDefaultToolkit().getImage(this.fi.directory + this.fi.fileName);
            imp.setImage(img);
            if (imp.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imp);
            }
            return;
        }
        if (this.fi.fileFormat == 6) {
            ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", this.fi.directory + this.fi.fileName);
            if (imp2 != null) {
                imp.setProcessor(null, imp2.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 5) {
            ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP", this.fi.directory + this.fi.fileName);
            if (imp2 != null) {
                imp.setProcessor(null, imp2.getProcessor());
            }
            return;
        }
        if (this.fi.nImages > 1) {
            return;
        }
        if (this.fi.url == null || this.fi.url.equals("")) {
            IJ.showStatus("Loading: " + this.fi.directory + this.fi.fileName);
        } else {
            IJ.showStatus("Loading: " + this.fi.url + this.fi.fileName);
        }
        Object pixels = this.readPixels(this.fi);
        if (pixels == null) {
            return;
        }
        ColorModel cm = FileOpener.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 1: 
            case 2: {
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 3: 
            case 4: {
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])pixels, 0, this.width));
                imp.setImage(img);
            }
        }
    }

    void setCalibration(ImagePlus imp) {
        int f;
        Calibration cal = imp.getCalibration();
        if (this.fi.fileType == 1) {
            if (IJ.debugMode) {
                IJ.log("16-bit signed");
            }
            double[] coeff = new double[]{-32768.0, 1.0};
            cal.setFunction(0, coeff, "gray value");
        }
        Properties props = this.decodeDescriptionString();
        if (this.fi.pixelWidth > 0.0 && this.fi.unit != null) {
            cal.pixelWidth = this.fi.pixelWidth;
            cal.pixelHeight = this.fi.pixelHeight;
            cal.pixelDepth = this.fi.pixelDepth;
            cal.setUnit(this.fi.unit);
        }
        if (this.fi.valueUnit != null && ((f = this.fi.calibrationFunction) >= 0 && f <= 8 && this.fi.coefficients != null || f == 21)) {
            cal.setFunction(f, this.fi.coefficients, this.fi.valueUnit);
        }
        if (this.fi.frameInterval != 0.0) {
            cal.frameInterval = this.fi.frameInterval;
        }
        if (props == null) {
            return;
        }
        cal.xOrigin = this.getDouble(props, "xorigin");
        cal.yOrigin = this.getDouble(props, "yorigin");
        cal.zOrigin = this.getDouble(props, "zorigin");
        cal.info = props.getProperty("info");
        double displayMin = this.getDouble(props, "min");
        double displayMax = this.getDouble(props, "max");
        if (displayMin != 0.0 || displayMax != 0.0) {
            int type = imp.getType();
            ImageProcessor ip = imp.getProcessor();
            if (type == 0 || type == 3) {
                ip.setMinAndMax(displayMin, displayMax);
            } else if (!(type != 1 && type != 2 || ip.getMin() == displayMin && ip.getMax() == displayMax)) {
                ip.setMinAndMax(displayMin, displayMax);
            }
        }
    }

    public static ColorModel createColorModel(FileInfo fi) {
        if (fi.fileType == 5 && fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    public static InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        if (fi.inputStream != null) {
            return fi.inputStream;
        }
        if (fi.url != null && !fi.url.equals("")) {
            return new URL(fi.url + fi.fileName).openStream();
        }
        File f = new File(fi.directory + fi.fileName);
        if (f == null || f.isDirectory()) {
            return null;
        }
        return new FileInputStream(f);
    }

    Object readPixels(FileInfo fi) {
        Object pixels = null;
        try {
            InputStream is = FileOpener.createInputStream(fi);
            if (is == null) {
                return null;
            }
            ImageReader reader = new ImageReader(fi);
            pixels = reader.readPixels(is);
            is.close();
        }
        catch (Exception e2) {
            IJ.log("FileOpener.readPixels(): " + e2);
        }
        return pixels;
    }

    public Properties decodeDescriptionString() {
        if (this.fi.description == null || this.fi.description.length() < 7) {
            return null;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(this.fi.description).replace('\n', ' '));
        }
        if (!this.fi.description.startsWith("ImageJ")) {
            return null;
        }
        Properties props = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(this.fi.description.getBytes());
        try {
            props.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e2) {
            return null;
        }
        this.fi.unit = props.getProperty("unit", "");
        Double n = this.getNumber(props, "cf");
        if (n != null) {
            this.fi.calibrationFunction = n.intValue();
        }
        double[] c2 = new double[5];
        int count = 0;
        int i = 0;
        while (i < 5) {
            n = this.getNumber(props, "c" + i);
            if (n == null) break;
            c2[i] = n;
            ++count;
            ++i;
        }
        if (count >= 2) {
            this.fi.coefficients = new double[count];
            int i2 = 0;
            while (i2 < count) {
                this.fi.coefficients[i2] = c2[i2];
                ++i2;
            }
        }
        this.fi.valueUnit = props.getProperty("vunit");
        n = this.getNumber(props, "images");
        if (n != null && n > 1.0) {
            this.fi.nImages = (int)n.doubleValue();
        }
        if (this.fi.nImages > 1) {
            double spacing = this.getDouble(props, "spacing");
            if (spacing != 0.0) {
                this.fi.pixelDepth = spacing;
            }
            n = this.getNumber(props, "fps");
            double fps = this.getDouble(props, "fps");
            if (fps != 0.0) {
                this.fi.frameInterval = 1.0 / fps;
            }
        }
        return props;
    }

    private Double getNumber(Properties props, String key) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e2) {
            }
        }
        return null;
    }

    private double getDouble(Properties props, String key) {
        Double n = this.getNumber(props, key);
        return n != null ? n : 0.0;
    }
}

